/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.validator;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleValidator
implements Validator<String> {
    @Nullable
    private Project myProject;
    @NotNull
    private PathValidator myPathValidator;
    @NotNull
    private StringProperty myProjectPath;

    public ModuleValidator(@NotNull Project project) {
        if (project == null) {
            ModuleValidator.$$$reportNull$$$0(0);
        }
        this(new StringValueProperty(project.getBasePath()));
        this.myProject = project;
    }

    public ModuleValidator(@NotNull StringProperty projectPath) {
        if (projectPath == null) {
            ModuleValidator.$$$reportNull$$$0(1);
        }
        this.myProjectPath = projectPath;
        this.myPathValidator = PathValidator.createDefault("module location");
    }

    @NotNull
    public Validator.Result validate(@NotNull String name) {
        if (name == null) {
            ModuleValidator.$$$reportNull$$$0(2);
        }
        if (name.isEmpty()) {
            Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.module.name", new Object[0]));
            if (result == null) {
                ModuleValidator.$$$reportNull$$$0(3);
            }
            return result;
        }
        if (this.myProject != null && ModuleManager.getInstance((Project)this.myProject).findModuleByName(name) != null) {
            Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.module.already.exists", name));
            if (result == null) {
                ModuleValidator.$$$reportNull$$$0(4);
            }
            return result;
        }
        Validator.Result result = this.myPathValidator.validate(new File((String)this.myProjectPath.get(), name));
        if (result == null) {
            ModuleValidator.$$$reportNull$$$0(5);
        }
        return result;
    }

    @NotNull
    PathValidator getPathValidator() {
        PathValidator pathValidator = this.myPathValidator;
        if (pathValidator == null) {
            ModuleValidator.$$$reportNull$$$0(6);
        }
        return pathValidator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/validator/ModuleValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/validator/ModuleValidator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

