/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.ResourceRepositories;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectResourceRepository
extends MultiResourceRepository {
    private AndroidFacet myFacet;

    @Nullable
    public static ProjectResourceRepository getOrCreateInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ProjectResourceRepository.$$$reportNull$$$0(0);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ProjectResourceRepository.getOrCreateInstance(facet) : null;
    }

    @NotNull
    public static ProjectResourceRepository getOrCreateInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(1);
        }
        ProjectResourceRepository projectResourceRepository = ProjectResourceRepository.findProjectResources(facet, true);
        if (projectResourceRepository == null) {
            ProjectResourceRepository.$$$reportNull$$$0(2);
        }
        return projectResourceRepository;
    }

    @Nullable
    public static ProjectResourceRepository findExistingInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(3);
        }
        return ProjectResourceRepository.findProjectResources(facet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static ProjectResourceRepository findProjectResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(4);
        }
        ResourceRepositories repositories = ResourceRepositories.getOrCreateInstance(facet);
        return repositories.getProjectResources(createIfNecessary);
    }

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(5);
        }
        if (delegates == null) {
            ProjectResourceRepository.$$$reportNull$$$0(6);
        }
        super(facet.getModule().getName() + " with modules", delegates);
        this.myFacet = facet;
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(7);
        }
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        ProjectResourceRepository projectResourceRepository = repository;
        if (projectResourceRepository == null) {
            ProjectResourceRepository.$$$reportNull$$$0(8);
        }
        return projectResourceRepository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(9);
        }
        LocalResourceRepository main = ModuleResourceRepository.getOrCreateInstance(facet);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)dependentFacets.size());
        for (AndroidFacet f : dependentFacets) {
            LocalResourceRepository r = ModuleResourceRepository.getOrCreateInstance(f);
            resources.add(r);
        }
        resources.add(main);
        return resources;
    }

    @VisibleForTesting
    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    private void updateRoots(List<LocalResourceRepository> resourceDirectories) {
        this.invalidateResourceDirs();
        if (!resourceDirectories.equals(this.getChildren())) {
            this.setChildren(resourceDirectories);
        }
    }

    @Override
    public void dispose() {
        this.myFacet = null;
        super.dispose();
    }

    @VisibleForTesting
    @NotNull
    static ProjectResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules) {
        ProjectResourceRepository projectResourceRepository = new ProjectResourceRepository(facet, modules);
        if (projectResourceRepository == null) {
            ProjectResourceRepository.$$$reportNull$$$0(10);
        }
        return projectResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ProjectResourceRepository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ProjectResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateInstance";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findProjectResources";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

