/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.DownloadJdk8Hyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseEmbeddedJdkHyperlink;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jdks {
    @NonNls
    public static final String DOWNLOAD_JDK_8_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html";
    private static final LanguageLevel DEFAULT_LANG_LEVEL = LanguageLevel.JDK_1_8;
    @NotNull
    private final IdeInfo myIdeInfo;

    @NotNull
    public static Jdks getInstance() {
        Jdks jdks = (Jdks)ServiceManager.getService(Jdks.class);
        if (jdks == null) {
            Jdks.$$$reportNull$$$0(0);
        }
        return jdks;
    }

    public Jdks(@NotNull IdeInfo ideInfo) {
        if (ideInfo == null) {
            Jdks.$$$reportNull$$$0(1);
        }
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public Sdk chooseOrCreateJavaSdk() {
        return this.chooseOrCreateJavaSdk(null);
    }

    @Nullable
    public Sdk chooseOrCreateJavaSdk(@Nullable LanguageLevel langLevel) {
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if (this.myIdeInfo.isAndroidStudio() && !IdeSdks.getInstance().isUsingEmbeddedJdk()) {
            File embeddedJdkPath = EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath();
            if (embeddedJdkPath == null) {
                embeddedJdkPath = new File(System.getProperty("java.home"));
            }
            Sdk jdk = this.createJdk(embeddedJdkPath.getPath());
            assert (jdk != null && this.isApplicableJdk(jdk, langLevel));
            return jdk;
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!this.isApplicableJdk(sdk, langLevel)) continue;
            return sdk;
        }
        String jdkHomePath = Jdks.getJdkHomePath(langLevel);
        if (jdkHomePath != null) {
            return this.createJdk(jdkHomePath);
        }
        return null;
    }

    public boolean isApplicableJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(2);
        }
        return this.isApplicableJdk(jdk, null);
    }

    public boolean isApplicableJdk(@NotNull Sdk jdk, @Nullable LanguageLevel langLevel) {
        JavaSdkVersion version;
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(3);
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if ((version = JavaSdk.getInstance().getVersion(jdk)) != null) {
            return Jdks.hasMatchingLangLevel(version, langLevel);
        }
        return false;
    }

    @Nullable
    private static String getJdkHomePath(@NotNull LanguageLevel langLevel) {
        ArrayList jdkHomePaths;
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(4);
        }
        if ((jdkHomePaths = new ArrayList(JavaSdk.getInstance().suggestHomePaths())).isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String javaHome = SystemProperties.getJavaHome();
        if (javaHome != null && !javaHome.isEmpty()) {
            Iterator it = jdkHomePaths.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (path == null || !javaHome.startsWith(path)) continue;
                it.remove();
                list.add(path);
            }
        }
        list.addAll(jdkHomePaths);
        return Jdks.getBestJdkHomePath(list, langLevel);
    }

    @Nullable
    private static String getBestJdkHomePath(@NotNull Collection<String> jdkHomePaths, @NotNull LanguageLevel langLevel) {
        if (jdkHomePaths == null) {
            Jdks.$$$reportNull$$$0(5);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(6);
        }
        ArrayList roots = Lists.newArrayList();
        for (String jdkHomePath : jdkHomePaths) {
            if (!StringUtil.isNotEmpty((String)jdkHomePath)) continue;
            roots.add(jdkHomePath);
            roots.addAll(Jdks.getChildrenPaths(jdkHomePath));
        }
        return Jdks.getBestJdk(roots, langLevel);
    }

    @NotNull
    private static List<String> getChildrenPaths(@NotNull String dirPath) {
        File dir;
        if (dirPath == null) {
            Jdks.$$$reportNull$$$0(7);
        }
        if (!(dir = new File(dirPath)).isDirectory()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                Jdks.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList childrenPaths = Lists.newArrayList();
        for (File child : FileUtil.notNullize((File[])dir.listFiles())) {
            boolean directory = child.isDirectory();
            if (!directory) continue;
            childrenPaths.add(child.getAbsolutePath());
        }
        ArrayList arrayList = childrenPaths;
        if (arrayList == null) {
            Jdks.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static String getBestJdk(@NotNull List<String> jdkRoots, @NotNull LanguageLevel langLevel) {
        if (jdkRoots == null) {
            Jdks.$$$reportNull$$$0(10);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(11);
        }
        String bestJdk = null;
        for (String jdkRoot : jdkRoots) {
            if (!JavaSdk.getInstance().isValidSdkHome(jdkRoot)) continue;
            if (bestJdk == null && Jdks.hasMatchingLangLevel(jdkRoot, langLevel)) {
                bestJdk = jdkRoot;
                continue;
            }
            if (bestJdk == null) continue;
            bestJdk = Jdks.selectJdk(bestJdk, jdkRoot, langLevel);
        }
        return bestJdk;
    }

    @Nullable
    private static String selectJdk(@NotNull String jdk1, @NotNull String jdk2, @NotNull LanguageLevel langLevel) {
        if (jdk1 == null) {
            Jdks.$$$reportNull$$$0(12);
        }
        if (jdk2 == null) {
            Jdks.$$$reportNull$$$0(13);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(14);
        }
        if (Jdks.hasMatchingLangLevel(jdk1, langLevel)) {
            return jdk1;
        }
        if (Jdks.hasMatchingLangLevel(jdk2, langLevel)) {
            return jdk2;
        }
        return null;
    }

    private static boolean hasMatchingLangLevel(@NotNull String jdkRoot, @NotNull LanguageLevel langLevel) {
        JavaSdkVersion version;
        if (jdkRoot == null) {
            Jdks.$$$reportNull$$$0(15);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(16);
        }
        if ((version = Jdks.getVersion(jdkRoot)) == null) {
            version = JavaSdkVersion.JDK_1_0;
        }
        return Jdks.hasMatchingLangLevel(version, langLevel);
    }

    @VisibleForTesting
    static boolean hasMatchingLangLevel(@NotNull JavaSdkVersion jdkVersion, @NotNull LanguageLevel langLevel) {
        if (jdkVersion == null) {
            Jdks.$$$reportNull$$$0(17);
        }
        if (langLevel == null) {
            Jdks.$$$reportNull$$$0(18);
        }
        LanguageLevel max = jdkVersion.getMaxLanguageLevel();
        return max.isAtLeast(langLevel);
    }

    @Nullable
    public JavaSdkVersion findVersion(@NotNull File jdkRoot) {
        if (jdkRoot == null) {
            Jdks.$$$reportNull$$$0(19);
        }
        return Jdks.getVersion(jdkRoot.getPath());
    }

    @Nullable
    private static JavaSdkVersion getVersion(String jdkRoot) {
        String version = JavaSdk.getInstance().getVersionString(jdkRoot);
        return StringUtil.isEmpty((String)version) ? null : JavaSdkVersion.fromVersionString((String)version);
    }

    @Nullable
    public Sdk createJdk(@NotNull String jdkHomePath) {
        Sdk jdk;
        if (jdkHomePath == null) {
            Jdks.$$$reportNull$$$0(20);
        }
        if ((jdk = SdkConfigurationUtil.createAndAddSDK((String)jdkHomePath, (SdkType)JavaSdk.getInstance())) == null) {
            String msg = String.format("Unable to create JDK from path '%1$s'", jdkHomePath);
            Logger.getInstance(Jdks.class).error(msg);
        }
        return jdk;
    }

    @Nullable
    public Sdk createEmbeddedJdk() {
        if (this.myIdeInfo.isAndroidStudio()) {
            File path = EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath();
            if (path == null) {
                return null;
            }
            Sdk jdk = this.createJdk(path.getPath());
            assert (jdk != null);
            return jdk;
        }
        return null;
    }

    public void setJdk(@NotNull Project project, @NotNull Sdk jdk) {
        if (project == null) {
            Jdks.$$$reportNull$$$0(21);
        }
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(22);
        }
        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)jdk);
    }

    @NotNull
    public List<NotificationHyperlink> getWrongJdkQuickFixes(@NotNull Project project) {
        if (project == null) {
            Jdks.$$$reportNull$$$0(23);
        }
        ArrayList quickFixes = Lists.newArrayList();
        UseEmbeddedJdkHyperlink useEmbeddedJdkHyperlink = UseEmbeddedJdkHyperlink.create();
        if (useEmbeddedJdkHyperlink != null) {
            quickFixes.add(useEmbeddedJdkHyperlink);
        }
        quickFixes.add(new DownloadJdk8Hyperlink());
        SelectJdkFromFileSystemHyperlink selectJdkHyperlink = SelectJdkFromFileSystemHyperlink.create(project);
        if (selectJdkHyperlink != null) {
            quickFixes.add(selectJdkHyperlink);
        }
        ArrayList arrayList = quickFixes;
        if (arrayList == null) {
            Jdks.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/Jdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 2: 
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHomePaths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkRoots";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk2";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkVersion";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHomePath";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/Jdks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenPaths";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrongJdkQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableJdk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJdkHomePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBestJdkHomePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenPaths";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBestJdk";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectJdk";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchingLangLevel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findVersion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setJdk";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getWrongJdkQuickFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

