/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.progress;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProgressRunner
implements ProgressRunner {
    private boolean myModal;
    private final boolean myCancellable;
    private final Project myProject;
    private final String myProgressTitle;

    public StudioProgressRunner(boolean modal, boolean cancellable, String progressTitle, @Nullable Project project) {
        this.myModal = modal;
        this.myCancellable = cancellable;
        this.myProject = project;
        this.myProgressTitle = progressTitle;
    }

    public void runAsyncWithProgress(@NotNull ProgressRunner.ProgressRunnable r) {
        if (r == null) {
            StudioProgressRunner.$$$reportNull$$$0(0);
        }
        this.runAsyncWithProgress(r, false);
    }

    public void runAsyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable r, final boolean overrideTestMode) {
        if (r == null) {
            StudioProgressRunner.$$$reportNull$$$0(1);
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean hasOpenProjects;
                Task.Backgroundable task = new Task.Backgroundable(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable, new PerformInBackgroundOption(){

                    public boolean shouldStartInBackground() {
                        return !StudioProgressRunner.this.myModal;
                    }
                }){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            if (r == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            if (indicator == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this);
                        });
                    }

                    public boolean isConditionalModal() {
                        return true;
                    }

                    public boolean isHeadless() {
                        return overrideTestMode ? false : super.isHeadless();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "r";
                                break;
                            }
                        }
                        objectArray2[1] = "com/android/tools/idea/sdk/progress/StudioProgressRunner$1$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$run$0";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                boolean bl = hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
                if (hasOpenProjects) {
                    ProgressManager.getInstance().run((Task)task);
                } else {
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (com.intellij.openapi.progress.ProgressIndicator)new EmptyProgressIndicator());
                }
            }
        });
    }

    public void runSyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable progressRunnable) {
        if (progressRunnable == null) {
            StudioProgressRunner.$$$reportNull$$$0(2);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (progressRunnable == null) {
                StudioProgressRunner.$$$reportNull$$$0(7);
            }
            Task.Modal task = new Task.Modal(this.myProject, this.myProgressTitle, this.myCancellable){

                public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    StudioProgressRunner.this.doRunSync(indicator, progressRunnable);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/progress/StudioProgressRunner$2", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task);
        });
    }

    private void doRunSync(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator, @NotNull ProgressRunner.ProgressRunnable progressRunnable) {
        if (indicator == null) {
            StudioProgressRunner.$$$reportNull$$$0(3);
        }
        if (progressRunnable == null) {
            StudioProgressRunner.$$$reportNull$$$0(4);
        }
        RepoProgressIndicatorAdapter repoProgress = new RepoProgressIndicatorAdapter(indicator);
        try {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (progressRunnable == null) {
                    StudioProgressRunner.$$$reportNull$$$0(6);
                }
                progressRunnable.run((ProgressIndicator)repoProgress, (ProgressRunner)this);
            }).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public void runSyncWithoutProgress(@NotNull Runnable r) {
        if (r == null) {
            StudioProgressRunner.$$$reportNull$$$0(5);
        }
        r.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressRunnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/sdk/progress/StudioProgressRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runAsyncWithProgress";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runSyncWithProgress";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRunSync";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runSyncWithoutProgress";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doRunSync$1";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runSyncWithProgress$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

