/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedInitialization {
    private final Project myProject;
    private final GradleSyncState mySyncState;
    private final GradleSyncInvoker mySyncInvoker;
    private final GradleBuildState myBuildState;
    private final List<RunnablePair> myRunnables;
    private final Object myLock;

    @NotNull
    public static DelayedInitialization getInstance(@NotNull Project project) {
        if (project == null) {
            DelayedInitialization.$$$reportNull$$$0(0);
        }
        DelayedInitialization delayedInitialization = (DelayedInitialization)ServiceManager.getService((Project)project, DelayedInitialization.class);
        if (delayedInitialization == null) {
            DelayedInitialization.$$$reportNull$$$0(1);
        }
        return delayedInitialization;
    }

    public DelayedInitialization(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleBuildState buildState) {
        if (project == null) {
            DelayedInitialization.$$$reportNull$$$0(2);
        }
        if (syncState == null) {
            DelayedInitialization.$$$reportNull$$$0(3);
        }
        if (syncInvoker == null) {
            DelayedInitialization.$$$reportNull$$$0(4);
        }
        if (buildState == null) {
            DelayedInitialization.$$$reportNull$$$0(5);
        }
        this.myLock = new Object();
        this.myProject = project;
        this.mySyncState = syncState;
        this.mySyncInvoker = syncInvoker;
        this.myBuildState = buildState;
        this.myRunnables = new ArrayList<RunnablePair>();
        GradleBuildState.subscribe(project, new BuildListener());
        GradleSyncState.subscribe(project, new SyncListener());
        this.runAfterBuild(this::clearResourceCache, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterBuild(@NotNull Runnable success, @Nullable Runnable buildFailure) {
        GradleBuildStatus status;
        if (success == null) {
            DelayedInitialization.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            status = this.getBuildStatus();
            if (status != GradleBuildStatus.BUILD_SUCCESS) {
                this.myRunnables.add(new RunnablePair(success, buildFailure));
            }
        }
        switch (status) {
            case BUILDING: {
                break;
            }
            case BUILD_NEEDED: {
                this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
                break;
            }
            case BUILD_ERROR: {
                if (buildFailure == null) break;
                buildFailure.run();
                break;
            }
            case BUILD_SUCCESS: {
                success.run();
                break;
            }
            default: {
                assert (false) : "Not Implemented";
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterBuild() {
        boolean buildError = this.getBuildStatus() != GradleBuildStatus.BUILD_SUCCESS;
        ArrayList<RunnablePair> runnables = new ArrayList<RunnablePair>();
        Object object = this.myLock;
        synchronized (object) {
            runnables.addAll(this.myRunnables);
            if (!buildError) {
                this.myRunnables.clear();
            }
        }
        runnables.stream().map(pair -> buildError ? pair.failure : pair.success).filter(Objects::nonNull).forEach(Runnable::run);
    }

    private void clearResourceCache() {
        if (AppResourceRepository.testAndClearTempResourceCached(this.myProject)) {
            ResourceClassRegistry.get(this.myProject).clearCache();
            for (AndroidFacet facet : AndroidUtils.getApplicationFacets(this.myProject)) {
                facet.refreshResources();
                ModuleResourceManagers.getInstance(facet).getLocalResourceManager().invalidateAttributeDefinitions();
            }
        }
    }

    private GradleBuildStatus getBuildStatus() {
        if (this.mySyncState.isSyncInProgress()) {
            return GradleBuildStatus.BUILDING;
        }
        if (this.mySyncState.getSummary().getSyncTimestamp() > 0L && this.mySyncState.lastSyncFailedOrHasIssues()) {
            return GradleBuildStatus.BUILD_ERROR;
        }
        BuildSummary buildSummary = this.myBuildState.getSummary();
        if (buildSummary == null || this.myBuildState.isBuildInProgress()) {
            return GradleBuildStatus.BUILDING;
        }
        if (buildSummary.getTimestamp() < 0L || buildSummary.getStatus() == BuildStatus.CANCELED || this.mySyncState.isSyncNeeded() != ThreeState.NO) {
            return GradleBuildStatus.BUILD_NEEDED;
        }
        if (buildSummary.getStatus() == BuildStatus.FAILED) {
            return GradleBuildStatus.BUILD_ERROR;
        }
        return GradleBuildStatus.BUILD_SUCCESS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/startup/DelayedInitialization";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncInvoker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "success";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/startup/DelayedInitialization";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runAfterBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunnablePair {
        public final Runnable success;
        public final Runnable failure;

        private RunnablePair(@NotNull Runnable success, @Nullable Runnable failure) {
            if (success == null) {
                RunnablePair.$$$reportNull$$$0(0);
            }
            this.success = success;
            this.failure = failure;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "success", "com/android/tools/idea/startup/DelayedInitialization$RunnablePair", "<init>"));
        }
    }

    private class BuildListener
    extends GradleBuildListener.Adapter {
        private BuildListener() {
        }

        @Override
        public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
            if (status == null) {
                BuildListener.$$$reportNull$$$0(0);
            }
            DelayedInitialization.this.afterBuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/android/tools/idea/startup/DelayedInitialization$BuildListener", "buildFinished"));
        }
    }

    private class SyncListener
    extends GradleSyncListener.Adapter {
        private SyncListener() {
        }

        @Override
        public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
            if (project == null) {
                SyncListener.$$$reportNull$$$0(0);
            }
            if (errorMessage == null) {
                SyncListener.$$$reportNull$$$0(1);
            }
            DelayedInitialization.this.afterBuild();
        }

        @Override
        public void syncSkipped(@NotNull Project project) {
            if (project == null) {
                SyncListener.$$$reportNull$$$0(2);
            }
            DelayedInitialization.this.afterBuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/startup/DelayedInitialization$SyncListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncFailed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncSkipped";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum GradleBuildStatus {
        BUILDING,
        BUILD_NEEDED,
        BUILD_ERROR,
        BUILD_SUCCESS;

    }
}

