/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeDependencies;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.utils.FileUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludedRoots {
    @NotNull
    private final Module myModule;
    @NotNull
    private final ExcludedModules myExcludedModules;
    private final boolean myAndroidTest;
    @NotNull
    private final Set<File> myExcludedRoots;
    @NotNull
    private final Set<String> myIncludedRootNames;

    ExcludedRoots(@NotNull Module module, @NotNull ExcludedModules excludedModules, @NotNull DependencySet dependenciesToExclude, @NotNull DependencySet dependenciesToInclude, boolean isAndroidTest) {
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(0);
        }
        if (excludedModules == null) {
            ExcludedRoots.$$$reportNull$$$0(1);
        }
        if (dependenciesToExclude == null) {
            ExcludedRoots.$$$reportNull$$$0(2);
        }
        if (dependenciesToInclude == null) {
            ExcludedRoots.$$$reportNull$$$0(3);
        }
        this.myExcludedRoots = new HashSet<File>();
        this.myIncludedRootNames = new HashSet<String>();
        this.myModule = module;
        this.myExcludedModules = excludedModules;
        this.myAndroidTest = isAndroidTest;
        this.addFolderPathsFromExcludedModules();
        this.addRemainingModelsIfNecessary();
        for (LibraryDependency libraryDependency : dependenciesToInclude.onLibraries()) {
            File[] binaryPaths;
            for (File binaryPath : binaryPaths = libraryDependency.getPaths(LibraryDependency.PathType.BINARY)) {
                this.myIncludedRootNames.add(binaryPath.getName());
            }
        }
        this.addLibraryPaths(dependenciesToExclude);
        this.removeLibraryPaths(dependenciesToInclude);
    }

    private void addFolderPathsFromExcludedModules() {
        for (Module module : this.myExcludedModules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(sourceFolder.getUrl()));
                }
                CompilerModuleExtension compiler = (CompilerModuleExtension)rootManager.getModuleExtension(CompilerModuleExtension.class);
                String url = compiler.getCompilerOutputUrl();
                if (!StringUtil.isNotEmpty((String)url)) continue;
                this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(url));
            }
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null) continue;
            this.myExcludedRoots.add(androidModuleModel.getMainArtifact().getJavaResourcesFolder());
        }
    }

    @Nullable
    private static File urlToFilePath(@NotNull String url) {
        if (url == null) {
            ExcludedRoots.$$$reportNull$$$0(4);
        }
        if (url.startsWith("jar://")) {
            return FilePaths.getJarFromJarUrl(url);
        }
        String path = VfsUtilCore.urlToPath((String)url);
        return new File(FileUtils.toSystemDependentPath((String)path));
    }

    private void addRemainingModelsIfNecessary() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myExcludedModules.getProject());
        for (Module module : moduleManager.getModules()) {
            if (this.myExcludedModules.contains(module)) continue;
            this.addModuleIfNecessary(module);
        }
    }

    private void addModuleIfNecessary(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(5);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            IdeBaseArtifact includeArtifact;
            IdeVariant variant = androidModel.getSelectedVariant();
            IdeJavaArtifact unitTestArtifact = variant.getUnitTestArtifact();
            IdeAndroidArtifact androidTestArtifact = variant.getAndroidTestArtifact();
            IdeBaseArtifact excludeArtifact = this.myAndroidTest ? unitTestArtifact : androidTestArtifact;
            IdeBaseArtifact ideBaseArtifact = includeArtifact = this.myAndroidTest ? androidTestArtifact : unitTestArtifact;
            if (excludeArtifact != null) {
                ExcludedRoots.processFolders(excludeArtifact, androidModel, this.myExcludedRoots::add);
            }
            if (includeArtifact != null) {
                ExcludedRoots.processFolders(includeArtifact, androidModel, this.myExcludedRoots::remove);
            }
        }
    }

    private static void processFolders(@NotNull IdeBaseArtifact artifact, @NotNull AndroidModuleModel androidModel, @NotNull Consumer<File> action) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(6);
        }
        if (androidModel == null) {
            ExcludedRoots.$$$reportNull$$$0(7);
        }
        if (action == null) {
            ExcludedRoots.$$$reportNull$$$0(8);
        }
        action.accept(artifact.getClassesFolder());
        for (File file : artifact.getGeneratedSourceFolders()) {
            action.accept(file);
        }
        String artifactName = artifact.getName();
        List<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(artifactName);
        for (SourceProvider sourceProvider : testSourceProviders) {
            for (File file : IdeaSourceProvider.getAllSourceFolders(sourceProvider)) {
                action.accept(file);
            }
        }
    }

    private void addLibraryPaths(@NotNull DependencySet dependencies2) {
        if (dependencies2 == null) {
            ExcludedRoots.$$$reportNull$$$0(9);
        }
        for (LibraryDependency dependency : dependencies2.onLibraries()) {
            Collections.addAll(this.myExcludedRoots, dependency.getPaths(LibraryDependency.PathType.BINARY));
        }
    }

    void removeLibraryPaths(@NotNull DependencySet dependencies2) {
        if (dependencies2 == null) {
            ExcludedRoots.$$$reportNull$$$0(10);
        }
        for (LibraryDependency dependency : dependencies2.onLibraries()) {
            for (File path : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                this.myExcludedRoots.remove(path);
            }
        }
        Project project = this.myModule.getProject();
        for (ModuleDependency dependency : dependencies2.onModules()) {
            Module module = dependency.getModule(project);
            if (module == null) continue;
            this.addLibraryPaths(module);
        }
    }

    private void addLibraryPaths(@NotNull Module module) {
        AndroidModuleModel model;
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(11);
        }
        if ((model = AndroidModuleModel.get(module)) != null) {
            IdeBaseArtifact include;
            IdeVariant variant = model.getSelectedVariant();
            IdeBaseArtifact exclude = this.myAndroidTest ? variant.getUnitTestArtifact() : variant.getAndroidTestArtifact();
            IdeBaseArtifact ideBaseArtifact = include = this.myAndroidTest ? variant.getAndroidTestArtifact() : variant.getUnitTestArtifact();
            if (exclude != null) {
                this.addLibraryPaths(exclude);
            }
            if (include != null) {
                this.removeLibraryPaths(include);
            }
        }
    }

    private void addLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(12);
        }
        IdeDependencies dependencies2 = artifact.getDependencies();
        dependencies2.forEachLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                for (File file : library.getLocalJars()) {
                    if (this.isAlreadyIncluded(file)) continue;
                    this.myExcludedRoots.add(file);
                }
            }
        });
        dependencies2.forEachJavaLibrary(library -> {
            File jarFile;
            if (StringUtil.isEmpty((String)library.getProject()) && !this.isAlreadyIncluded(jarFile = library.getJarFile())) {
                this.myExcludedRoots.add(jarFile);
            }
        });
    }

    private boolean isAlreadyIncluded(@NotNull File file) {
        if (file == null) {
            ExcludedRoots.$$$reportNull$$$0(13);
        }
        return this.myIncludedRootNames.contains(file.getName());
    }

    private void removeLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(14);
        }
        IdeDependencies dependencies2 = artifact.getDependencies();
        dependencies2.forEachLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                for (File file : library.getLocalJars()) {
                    this.myExcludedRoots.remove(file);
                }
            }
        });
        dependencies2.forEachJavaLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                this.myExcludedRoots.remove(library.getJarFile());
            }
        });
    }

    @NotNull
    public Set<File> get() {
        Set<File> set = this.myExcludedRoots;
        if (set == null) {
            ExcludedRoots.$$$reportNull$$$0(15);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedModules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesToExclude";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesToInclude";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/ExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/ExcludedRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModuleIfNecessary";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processFolders";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryPaths";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraryPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyIncluded";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

