/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.error.IssueModel;
import com.android.tools.idea.uibuilder.error.IssueView;
import com.android.tools.idea.uibuilder.error.NlIssue;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuePanel
extends JPanel
implements Disposable {
    private static final String ISSUE_PANEL_NAME = "Layout Editor Error Panel";
    private static final String TITLE_NO_ISSUES = "No issues";
    private static final String TITLE_NO_IMPORTANT_ISSUE = "Issues";
    private static final String WARNING = "Warning";
    private static final String ERROR = "Error";
    private static final String ACTION_PREVIOUS = "PREVIOUS";
    private static final String ACTION_NEXT = "next";
    private static final String ACTION_EXPAND = "expand";
    private static final String ACTION_COLLAPSE = "collapse";
    private static final String SHOW_ISSUES_CHECKBOX_TEXT = "Show issues on the preview";
    private static final Pattern MULTIPLE_SPACES = Pattern.compile("\\s+");
    private final HashBiMap<NlIssue, IssueView> myDisplayedError;
    private final IssueModel myIssueModel;
    private final JPanel myErrorListPanel;
    private final JBLabel myTitleLabel;
    private final IssueModel.IssueModelListener myIssueModelListener;
    private final JBScrollPane myScrollPane;
    private final DesignSurface mySurface;
    @Nullable
    private MinimizeListener myMinimizeListener;
    @Nullable
    private IssueView mySelectedIssueView;
    private boolean hasUserSeenNewErrors;
    private boolean isMinimized;

    public IssuePanel(@NotNull DesignSurface designSurface, @NotNull IssueModel issueModel) {
        if (designSurface == null) {
            IssuePanel.$$$reportNull$$$0(0);
        }
        if (issueModel == null) {
            IssuePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myDisplayedError = HashBiMap.create();
        this.setName(ISSUE_PANEL_NAME);
        this.myIssueModel = issueModel;
        this.mySurface = designSurface;
        this.myTitleLabel = IssuePanel.createTitleLabel();
        JComponent titlePanel = this.createTitlePanel(this.myTitleLabel);
        this.add((Component)titlePanel, "North");
        this.myErrorListPanel = IssuePanel.createErrorListPanel();
        this.myScrollPane = IssuePanel.createListScrollPane(this.myErrorListPanel);
        this.add((Component)this.myScrollPane, "Center");
        this.updateTitlebarStyle();
        this.myIssueModelListener = this::updateErrorList;
        this.myIssueModel.addErrorModelListener(this.myIssueModelListener);
        this.updateErrorList();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.registerKeyboardActions();
        this.addFocusListener(this.createFocusListener());
        this.setMinimized(true);
    }

    @NotNull
    private FocusListener createFocusListener() {
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IssuePanel.this.mySelectedIssueView != null) {
                    IssuePanel.this.mySelectedIssueView.setFocused(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (IssuePanel.this.mySelectedIssueView != null) {
                    IssuePanel.this.mySelectedIssueView.setFocused(false);
                }
            }
        };
        if (focusListener == null) {
            IssuePanel.$$$reportNull$$$0(2);
        }
        return focusListener;
    }

    private void registerKeyboardActions() {
        this.getActionMap().put(ACTION_PREVIOUS, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.keyboardSelect(-1);
            }
        });
        this.getActionMap().put(ACTION_NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.keyboardSelect(1);
            }
        });
        this.getActionMap().put(ACTION_EXPAND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.expandSelectedIssue(true);
            }
        });
        this.getActionMap().put(ACTION_COLLAPSE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.expandSelectedIssue(false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_PREVIOUS);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_NEXT);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), ACTION_EXPAND);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), ACTION_COLLAPSE);
    }

    private void expandSelectedIssue(boolean expanded) {
        if (this.mySelectedIssueView != null) {
            this.mySelectedIssueView.setExpanded(expanded);
        }
    }

    private void keyboardSelect(int direction) {
        Component component2;
        if (!this.myDisplayedError.isEmpty() && this.mySelectedIssueView == null && (component2 = this.myErrorListPanel.getComponent(0)) instanceof IssueView) {
            this.setSelectedIssue((IssueView)component2);
            return;
        }
        Component[] components = this.myErrorListPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component3 = components[i];
            if (component3 != this.mySelectedIssueView) continue;
            int selectedIndex = (i + (direction >= 0 ? 1 : -1)) % this.myDisplayedError.size();
            if (selectedIndex < 0) {
                selectedIndex += this.myDisplayedError.size();
            }
            assert (components[i] instanceof IssueView);
            this.setSelectedIssue((IssueView)components[selectedIndex]);
            this.mySelectedIssueView.scrollRectToVisible(this.mySelectedIssueView.getBounds());
            this.myScrollPane.getViewport().setViewPosition(this.mySelectedIssueView.getLocation());
            return;
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MinimizeAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        toolbar.setLayoutPolicy(0);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            IssuePanel.$$$reportNull$$$0(3);
        }
        return actionToolbar;
    }

    @NotNull
    private JComponent createTitlePanel(@NotNull JBLabel titleLabel) {
        if (titleLabel == null) {
            IssuePanel.$$$reportNull$$$0(4);
        }
        JBCheckBox checkBox = new JBCheckBox(SHOW_ISSUES_CHECKBOX_TEXT, AndroidEditorSettings.getInstance().getGlobalState().isShowLint());
        checkBox.addItemListener(e -> {
            AndroidEditorSettings.getInstance().getGlobalState().setShowLint(e.getStateChange() == 1);
            this.mySurface.repaint();
        });
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)titleLabel, "West");
        JPanel rightPanel = new JPanel(new FlowLayout(2, 0, 0));
        rightPanel.add((Component)checkBox);
        rightPanel.add(this.createToolbar().getComponent());
        titlePanel.add((Component)rightPanel, "East");
        titlePanel.setBorder(IdeBorderFactory.createBorder((int)8));
        JPanel jPanel = titlePanel;
        if (jPanel == null) {
            IssuePanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    private static JBScrollPane createListScrollPane(@NotNull JPanel content) {
        if (content == null) {
            IssuePanel.$$$reportNull$$$0(6);
        }
        JBScrollPane pane = new JBScrollPane((Component)content);
        pane.setBorder(null);
        pane.setAlignmentX(0.5f);
        JBScrollPane jBScrollPane = pane;
        if (jBScrollPane == null) {
            IssuePanel.$$$reportNull$$$0(7);
        }
        return jBScrollPane;
    }

    @NotNull
    private static JPanel createErrorListPanel() {
        JPanel panel = new JPanel(null, true);
        panel.setBackground(UIUtil.getEditorPaneBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel jPanel = panel;
        if (jPanel == null) {
            IssuePanel.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @NotNull
    private static JBLabel createTitleLabel() {
        JBLabel label = new JBLabel(TITLE_NO_IMPORTANT_ISSUE, 2);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)20));
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            IssuePanel.$$$reportNull$$$0(9);
        }
        return jBLabel;
    }

    private void updateErrorList() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (!this.myIssueModel.hasIssues()) {
                this.myTitleLabel.setText(TITLE_NO_ISSUES);
                this.myDisplayedError.clear();
                this.myErrorListPanel.removeAll();
                this.setMinimized(true);
                return;
            }
            this.updateTitlebarStyle();
            boolean needsRevalidate = false;
            ImmutableList<NlIssue> nlIssues = this.myIssueModel.getNlErrors();
            if (this.myDisplayedError.isEmpty()) {
                nlIssues.forEach(this::addErrorEntry);
            } else {
                this.removeOldIssues((List<NlIssue>)nlIssues);
                needsRevalidate = this.displayNewIssues((List<NlIssue>)nlIssues);
            }
            if (needsRevalidate) {
                this.revalidate();
                this.repaint();
            }
        });
    }

    private void updateTitlebarStyle() {
        this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(!this.isMinimized() || this.hasUserSeenNewErrors ? 0 : 1));
        int warningCount = this.myIssueModel.getWarningCount();
        int errorCount = this.myIssueModel.getErrorCount();
        if (warningCount == 0 && errorCount == 0) {
            this.myTitleLabel.setText(TITLE_NO_IMPORTANT_ISSUE);
        } else {
            StringBuilder title = new StringBuilder();
            if (warningCount > 0) {
                title.append(warningCount).append(' ').append(StringUtil.pluralize((String)WARNING, (int)warningCount)).append(' ');
            }
            if (errorCount > 0) {
                title.append(errorCount).append(' ').append(StringUtil.pluralize((String)ERROR, (int)errorCount));
            }
            this.myTitleLabel.setText(title.toString());
        }
    }

    private boolean displayNewIssues(@NotNull List<NlIssue> nlIssues) {
        if (nlIssues == null) {
            IssuePanel.$$$reportNull$$$0(10);
        }
        boolean needsRevalidate = false;
        for (NlIssue error : nlIssues) {
            if (this.myDisplayedError.containsKey((Object)error)) continue;
            this.addErrorEntry(error);
            needsRevalidate = true;
        }
        return needsRevalidate;
    }

    private void removeOldIssues(@NotNull List<NlIssue> nlIssues) {
        if (nlIssues == null) {
            IssuePanel.$$$reportNull$$$0(11);
        }
        Iterator iterator = this.myDisplayedError.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            NlIssue nlIssue = (NlIssue)entry.getKey();
            if (nlIssues.contains(nlIssue)) continue;
            IssueView issueView = (IssueView)entry.getValue();
            this.myErrorListPanel.remove(issueView);
            iterator.remove();
        }
    }

    private void addErrorEntry(@NotNull NlIssue error) {
        if (error == null) {
            IssuePanel.$$$reportNull$$$0(12);
        }
        if (this.myErrorListPanel.getComponentCount() == 0) {
            this.myErrorListPanel.add(Box.createVerticalGlue(), -1);
        }
        IssueView issueView = new IssueView(error, this);
        this.myDisplayedError.put((Object)error, (Object)issueView);
        this.myErrorListPanel.add((Component)issueView, this.getInsertionIndex(issueView));
    }

    private int getInsertionIndex(IssueView issueView) {
        int insertIndex = 0;
        for (int i = 0; i < this.myErrorListPanel.getComponentCount(); ++i) {
            Component component2 = this.myErrorListPanel.getComponent(i);
            if (!(component2 instanceof IssueView)) continue;
            if (((IssueView)component2).getDisplayPriority() > issueView.getDisplayPriority()) break;
            ++insertIndex;
        }
        return insertIndex;
    }

    @Nullable
    public IssueView getSelectedIssueView() {
        return this.mySelectedIssueView;
    }

    @Override
    public void doLayout() {
        int categoryColumnSize = 0;
        int sourceColumnSize = 0;
        Set values = this.myDisplayedError.values();
        for (IssueView view : values) {
            categoryColumnSize = Math.max(categoryColumnSize, view.getCategoryLabelWidth());
            sourceColumnSize = Math.max(sourceColumnSize, view.getSourceLabelWidth());
        }
        for (IssueView view : values) {
            view.setCategoryLabelSize(categoryColumnSize);
            view.setSourceLabelSize(sourceColumnSize);
        }
        super.doLayout();
    }

    public void setMinimized(boolean minimized) {
        if (minimized == this.isMinimized) {
            return;
        }
        if (!minimized) {
            this.hasUserSeenNewErrors = true;
        }
        this.isMinimized = minimized;
        this.setVisible(!this.isMinimized);
        this.revalidate();
        this.repaint();
        if (this.myMinimizeListener != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myMinimizeListener.onMinimizeChanged(this.isMinimized));
        }
    }

    public void setMinimizeListener(@Nullable MinimizeListener listener) {
        this.myMinimizeListener = listener;
    }

    public void dispose() {
        this.myMinimizeListener = null;
        this.myIssueModel.removeErrorModelListener(this.myIssueModelListener);
    }

    public boolean isMinimized() {
        return this.isMinimized;
    }

    public void setSelectedIssue(@Nullable IssueView selectedIssue) {
        if (this.mySelectedIssueView != selectedIssue) {
            if (this.mySelectedIssueView != null) {
                this.mySelectedIssueView.setSelected(false);
            }
            this.mySelectedIssueView = selectedIssue;
            if (this.mySelectedIssueView != null) {
                this.mySelectedIssueView.setSelected(true);
                NlIssue issue2 = (NlIssue)this.myDisplayedError.inverse().get((Object)this.mySelectedIssueView);
                if (issue2 == null) {
                    return;
                }
                NlComponent source = issue2.getSource();
                if (source != null) {
                    source.getModel().getSelectionModel().setSelection(Collections.singletonList(source));
                }
            }
        }
    }

    public String getTitleText() {
        return this.myTitleLabel.getText();
    }

    public IssueModel getIssueModel() {
        return this.myIssueModel;
    }

    public boolean containsErrorWithText(@NotNull String text) {
        if (text == null) {
            IssuePanel.$$$reportNull$$$0(13);
        }
        return this.myDisplayedError.values().stream().anyMatch(view -> {
            if (text == null) {
                IssuePanel.$$$reportNull$$$0(14);
            }
            return view.getIssueTitle().contains(text) || MULTIPLE_SPACES.matcher(view.getIssueDescription()).replaceAll(" ").contains(text);
        });
    }

    public void showIssueForComponent(NlComponent component2, boolean collapseOthers) {
        IssueView issueView;
        NlIssue issue2 = this.myIssueModel.findIssue(component2);
        if (issue2 != null && (issueView = (IssueView)this.myDisplayedError.get((Object)issue2)) != null) {
            this.setMinimized(false);
            this.setSelectedIssue(issueView);
            issueView.setExpanded(true);
            this.myScrollPane.getViewport().setViewPosition(issueView.getLocation());
            if (collapseOthers) {
                for (IssueView other : this.myDisplayedError.values()) {
                    if (other == issueView) continue;
                    other.setExpanded(false);
                }
            }
        }
    }

    public int getSuggestedHeight() {
        int suggestedHeight = this.myTitleLabel.getHeight();
        suggestedHeight = this.mySelectedIssueView != null ? (suggestedHeight += this.mySelectedIssueView.getHeight()) : (suggestedHeight += this.myDisplayedError.size() * 30);
        return Math.max(this.getHeight(), suggestedHeight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueModel";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/error/IssuePanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleLabel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nlIssues";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/error/IssuePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitlePanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createListScrollPane";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorListPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitleLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTitlePanel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createListScrollPane";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "displayNewIssues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeOldIssues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addErrorEntry";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorWithText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsErrorWithText$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MinimizeAction
    extends AnAction {
        private static final String DESCRIPTION = "Hide the render errors panel";

        private MinimizeAction() {
            super(DESCRIPTION, DESCRIPTION, StudioIcons.Common.CLOSE);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MinimizeAction.$$$reportNull$$$0(0);
            }
            IssuePanel.this.setMinimized(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/error/IssuePanel$MinimizeAction", "actionPerformed"));
        }
    }

    public static interface MinimizeListener {
        public void onMinimizeChanged(boolean var1);
    }
}

