/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.error.IssuePanel;
import com.android.tools.idea.uibuilder.error.NlIssue;
import com.android.utils.HtmlBuilder;
import com.android.utils.Pair;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueView
extends JPanel {
    private static final Dimension COLLAPSED_ROW_SIZE = JBUI.size((int)Integer.MAX_VALUE, (int)30);
    private static final String SUGGESTED_FIXES = "Suggested Fixes";
    private static final RoundedLineBorder SELECTED_BORDER = IdeBorderFactory.createRoundedBorder((int)1);
    private static final Border UNSELECTED_BORDER = IdeBorderFactory.createEmptyBorder((int)SELECTED_BORDER.getThickness());
    private final IssuePanel myContainerIssuePanel;
    private JPanel myContent;
    private JBLabel myExpandIcon;
    private JLabel myErrorIcon;
    private JBLabel myCategoryLabel;
    private JLabel mySourceLabel;
    private JTextPane myErrorDescription;
    private JBLabel myErrorTitle;
    private JPanel myFixPanel;
    private JPanel myDetailPanel;
    private JBLabel mySuggestedFixLabel;
    private boolean myIsExpanded;
    private final int myDisplayPriority;

    IssueView(@NotNull NlIssue issue2, @NotNull IssuePanel container) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(0);
        }
        if (container == null) {
            IssueView.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.addMouseListener(this.createMouseListener());
        this.myContainerIssuePanel = container;
        this.myDisplayPriority = IssueView.getDisplayPriority(issue2);
        this.setupHeader(issue2);
        this.setupDescriptionPanel(issue2);
        this.setupFixPanel(issue2);
        this.setMaximumSize(COLLAPSED_ROW_SIZE);
        this.setBackground(UIUtil.getEditorPaneBackground());
    }

    private void setupHeader(@NotNull NlIssue issue2) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(2);
        }
        this.myErrorIcon.setIcon(IssueView.getSeverityIcon(issue2.getSeverity()));
        this.myExpandIcon.setIcon(UIUtil.getTreeCollapsedIcon());
        this.myErrorTitle.setText(issue2.getSummary());
        this.myCategoryLabel.setText(issue2.getCategory());
        NlComponent source = issue2.getSource();
        if (source != null) {
            String id = source.getId();
            String tag = source.getTagName();
            this.mySourceLabel.setText((id != null ? id + " " : "") + "<" + tag + ">");
        }
    }

    private void setupFixPanel(@NotNull NlIssue issue2) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(3);
        }
        this.myFixPanel.setLayout(new BoxLayout(this.myFixPanel, 1));
        issue2.getFixes().forEach(this::createFixEntry);
        if (this.myFixPanel.getComponentCount() > 0) {
            this.myFixPanel.setVisible(true);
            this.mySuggestedFixLabel.setVisible(true);
            if (this.myFixPanel.getComponentCount() > 1) {
                this.mySuggestedFixLabel.setText(SUGGESTED_FIXES);
            }
        }
    }

    private void setupDescriptionPanel(@NotNull NlIssue issue2) {
        if (issue2 == null) {
            IssueView.$$$reportNull$$$0(4);
        }
        String description = issue2.getDescription();
        String formattedText = new HtmlBuilder().openHtmlBody().addHtml(description).closeHtmlBody().getHtml();
        this.myErrorDescription.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myErrorDescription.addHyperlinkListener(issue2.getHyperlinkListener());
        this.myErrorDescription.setText(formattedText);
        this.myErrorDescription.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IssueView.this.myContainerIssuePanel.setSelectedIssue(IssueView.this);
                IssueView.this.setFocused(true);
            }
        });
        IssueView.applyIssueDescriptionStyle(this.myErrorDescription);
    }

    private static int getDisplayPriority(@NotNull NlIssue error) {
        if (error == null) {
            IssueView.$$$reportNull$$$0(5);
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            return 0;
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            return 1;
        }
        if (error.getSeverity().equals((Object)HighlightSeverity.WEAK_WARNING)) {
            return 2;
        }
        return 3;
    }

    int getDisplayPriority() {
        return this.myDisplayPriority;
    }

    private void createFixEntry(Pair<String, Runnable> pair) {
        this.myFixPanel.add(new FixEntry((String)pair.getFirst(), (Runnable)pair.getSecond()).getComponent());
    }

    @NotNull
    private MouseAdapter createMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IssueView.this.myContainerIssuePanel.requestFocusInWindow();
                if (e.getClickCount() == 1) {
                    IssueView.this.myContainerIssuePanel.setSelectedIssue(IssueView.this);
                    IssueView.this.setFocused(true);
                }
                if (e.getX() > IssueView.this.myExpandIcon.getX() - 3 && e.getX() < IssueView.this.myExpandIcon.getX() + IssueView.this.myExpandIcon.getWidth() + 3 || e.getClickCount() >= 2) {
                    IssueView.this.setExpanded(!IssueView.this.myIsExpanded);
                }
            }
        };
        if (mouseAdapter == null) {
            IssueView.$$$reportNull$$$0(6);
        }
        return mouseAdapter;
    }

    void setExpanded(boolean expanded) {
        this.myIsExpanded = expanded;
        this.myDetailPanel.setVisible(this.myIsExpanded);
        this.myExpandIcon.setIcon(this.myIsExpanded ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon());
    }

    @NotNull
    public static Icon getSeverityIcon(@Nullable HighlightSeverity severity) {
        if (severity != null) {
            if (HighlightSeverity.ERROR.equals((Object)severity)) {
                Icon icon = AndroidIcons.Issue.Error;
                if (icon == null) {
                    IssueView.$$$reportNull$$$0(7);
                }
                return icon;
            }
            if (HighlightSeverity.WARNING.equals((Object)severity)) {
                Icon icon = AndroidIcons.Issue.Warning;
                if (icon == null) {
                    IssueView.$$$reportNull$$$0(8);
                }
                return icon;
            }
        }
        Icon icon = AndroidIcons.Issue.Info;
        if (icon == null) {
            IssueView.$$$reportNull$$$0(9);
        }
        return icon;
    }

    void setSelected(boolean selected) {
        this.setOpaque(selected);
        this.setBackground(selected ? UIUtil.getPanelBackground() : UIUtil.getEditorPaneBackground());
        this.setFocused(this.myContainerIssuePanel.hasFocus() && selected);
    }

    int getCategoryLabelWidth() {
        return this.myCategoryLabel.getFontMetrics(this.myCategoryLabel.getFont()).stringWidth(this.myCategoryLabel.getText());
    }

    int getSourceLabelWidth() {
        return this.mySourceLabel.getFontMetrics(this.mySourceLabel.getFont()).stringWidth(this.mySourceLabel.getText());
    }

    void setSourceLabelSize(int sourceLabelSize) {
        Dimension size = this.mySourceLabel.getPreferredSize();
        size.width = sourceLabelSize;
        this.mySourceLabel.setPreferredSize(size);
    }

    void setCategoryLabelSize(int categoryLabelSize) {
        Dimension size = this.myCategoryLabel.getPreferredSize();
        size.width = categoryLabelSize;
        this.myCategoryLabel.setPreferredSize(size);
    }

    public String getIssueDescription() {
        return this.myErrorDescription.getText();
    }

    public String getIssueTitle() {
        return this.myErrorTitle.getText();
    }

    private void createUIComponents() {
        this.myContent = this;
    }

    private static void applyIssueDescriptionStyle(@NotNull JTextPane textPane) {
        if (textPane == null) {
            IssueView.$$$reportNull$$$0(10);
        }
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL);
        MutableAttributeSet attrs = textPane.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        textPane.getStyledDocument().setCharacterAttributes(0, textPane.getStyledDocument().getLength() + 1, attrs, false);
    }

    void setFocused(boolean focused) {
        this.setBorder((Border)(focused ? SELECTED_BORDER : UNSELECTED_BORDER));
    }

    static {
        SELECTED_BORDER.setColor(UIUtil.getTreeSelectionBorderColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/error/IssueView";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/error/IssueView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMouseListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupHeader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupFixPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupDescriptionPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayPriority";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyIssueDescriptionStyle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JTextPane jTextPane;
        JPanel jPanel2;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JLabel jLabel;
        JLabel jLabel2;
        JBLabel jBLabel4;
        this.createUIComponents();
        JPanel jPanel3 = this.myContent;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(2, 5, 2, 5), -1, -1, false, false));
        jPanel3.setOpaque(false);
        this.myExpandIcon = jBLabel4 = new JBLabel();
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorIcon = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceLabel = jLabel = new JLabel();
        jPanel3.add((Component)jLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCategoryLabel = jBLabel3 = new JBLabel();
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myErrorTitle = jBLabel2 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel2.getFont());
        if (font != null) {
            jBLabel2.setFont(font);
        }
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setHorizontalTextPosition(2);
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 0, null, null, null));
        this.myDetailPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        ((Component)jPanel2).setVisible(false);
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 2, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myErrorDescription = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jPanel2.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 2, null, new Dimension(558, 50), null));
        this.mySuggestedFixLabel = jBLabel = new JBLabel();
        Font font2 = this.$$$getFont$$$(null, 1, -1, jBLabel.getFont());
        if (font2 != null) {
            jBLabel.setFont(font2);
        }
        jBLabel.setText("Suggested Fix");
        jBLabel.setVisible(false);
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(558, 17), null));
        this.myFixPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 9, 0, 3, 3, null, new Dimension(558, 24), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(558, 14), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContent;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    public static class FixEntry {
        private JButton myFixButton;
        private JBLabel myFixText;
        private JComponent myComponent;

        public FixEntry(@NotNull String text, @NotNull Runnable fixRunnable) {
            if (text == null) {
                FixEntry.$$$reportNull$$$0(0);
            }
            if (fixRunnable == null) {
                FixEntry.$$$reportNull$$$0(1);
            }
            this.$$$setupUI$$$();
            this.myFixText.setText(text);
            this.myFixButton.addActionListener(e -> {
                if (fixRunnable == null) {
                    FixEntry.$$$reportNull$$$0(3);
                }
                fixRunnable.run();
            });
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                FixEntry.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixRunnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/error/IssueView$FixEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/error/IssueView$FixEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$new$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBLabel jBLabel;
            JButton jButton;
            JPanel jPanel = new JPanel();
            this.myComponent = jPanel;
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.setOpaque(false);
            this.myFixButton = jButton = new JButton();
            jButton.setOpaque(false);
            jButton.setText("Fix");
            jPanel.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, new Dimension(-1, 30)));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myFixText = jBLabel = new JBLabel();
            jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myComponent;
        }
    }
}

