/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.FancyStroke;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class DrawConnection
implements DrawCommand {
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_SPRING = 2;
    public static final int TYPE_CHAIN = 3;
    public static final int TYPE_CENTER = 4;
    public static final int TYPE_BASELINE = 5;
    public static final int TYPE_CENTER_WIDGET = 6;
    public static final int TYPE_ADJACENT = 7;
    private static final long MILISECONDS = 1000000L;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_SELECTED = 2;
    public static final int MODE_COMPUTED = 7;
    public static final int MODE_WILL_DESTROY = 6;
    public static final int MODE_WILL_HOVER = 3;
    public static final int MODE_SUBDUED = 1;
    public static final int TOTAL_MODES = 3;
    private static int[] ourModeLookup = null;
    public static final int DIR_LEFT = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_TOP = 2;
    public static final int DIR_BOTTOM = 3;
    private static final int OVER_HANG = 20;
    private static final long TRANSITION_TIME = 1000000000L;
    static GeneralPath ourPath = new GeneralPath();
    static final int[] dirDeltaX = new int[]{-1, 1, 0, 0};
    static final int[] dirDeltaY = new int[]{0, 0, -1, 1};
    static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};
    public static final int GAP = 10;
    int myConnectionType;
    Rectangle mySource = new Rectangle();
    int mySourceDirection;
    Rectangle myDest = new Rectangle();
    int myDestDirection;
    public static final int DEST_NORMAL = 0;
    public static final int DEST_PARENT = 1;
    public static final int DEST_GUIDELINE = 2;
    int myDestType;
    boolean myShift;
    int myMargin;
    int myMarginDistance;
    boolean myIsMarginReference;
    float myBias;
    int myModeFrom;
    int myModeTo;
    long myStateChangeTime;
    static Stroke myBackgroundStroke = new BasicStroke(8.0f);
    static Stroke myDashStroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);
    static Stroke mySpringStroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    static Stroke myChainStroke1 = new FancyStroke(FancyStroke.Type.HALF_CHAIN1, 2.5f, 9, 1.0f);
    static Stroke myChainStroke2 = new FancyStroke(FancyStroke.Type.HALF_CHAIN2, 2.5f, 9, 1.0f);

    @Override
    public int getLevel() {
        switch (this.myModeTo) {
            case 6: {
                return 70;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 60;
            }
        }
        return 10;
    }

    @Override
    public String serialize() {
        return "DrawConnection," + this.myConnectionType + "," + DrawConnection.rectToString(this.mySource) + "," + this.mySourceDirection + "," + DrawConnection.rectToString(this.myDest) + "," + this.myDestDirection + "," + this.myDestType + "," + this.myShift + "," + this.myMargin + "," + this.myMarginDistance + "," + this.myIsMarginReference + "," + this.myBias + "," + this.myModeFrom + "," + this.myModeTo + "," + 0;
    }

    private static String rectToString(Rectangle r) {
        return r.x + "x" + r.y + "x" + r.width + "x" + r.height;
    }

    private static Rectangle stringToRect(String s) {
        String[] sp = s.split("x");
        int c = 0;
        Rectangle r = new Rectangle();
        r.x = Integer.parseInt(sp[c++]);
        r.y = Integer.parseInt(sp[c++]);
        r.width = Integer.parseInt(sp[c++]);
        r.height = Integer.parseInt(sp[c++]);
        return r;
    }

    public DrawConnection(String s) {
        String[] sp = s.split(",");
        int c = 0;
        this.myConnectionType = Integer.parseInt(sp[c++]);
        this.mySource = DrawConnection.stringToRect(sp[c++]);
        this.mySourceDirection = Integer.parseInt(sp[c++]);
        this.myDest = DrawConnection.stringToRect(sp[c++]);
        this.myDestDirection = Integer.parseInt(sp[c++]);
        this.myDestType = Integer.parseInt(sp[c++]);
        this.myShift = Boolean.parseBoolean(sp[c++]);
        this.myMargin = Integer.parseInt(sp[c++]);
        this.myMarginDistance = Integer.parseInt(sp[c++]);
        this.myIsMarginReference = Boolean.parseBoolean(sp[c++]);
        this.myBias = Float.parseFloat(sp[c++]);
        this.myModeFrom = Integer.parseInt(sp[c++]);
        this.myModeTo = Integer.parseInt(sp[c++]);
        this.myStateChangeTime = Long.parseLong(sp[c++]);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet color = sceneContext.getColorSet();
        g.setColor(color.getConstraints());
        boolean animate = DrawConnection.draw(g, color, this.myConnectionType, this.mySource, this.mySourceDirection, this.myDest, this.myDestDirection, this.myDestType, this.myMargin, this.myMarginDistance, this.myIsMarginReference, this.myModeFrom, this.myModeTo, this.myStateChangeTime);
        if (animate) {
            sceneContext.repaint();
        }
    }

    public DrawConnection(int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long nanoTime) {
        this.config(connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias, modeFrom, modeTo, nanoTime);
    }

    public static void buildDisplayList(DisplayList list, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long nanoTime) {
        list.add(new DrawConnection(connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias, modeFrom, modeTo, nanoTime));
    }

    public void config(int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long stateChangeTime) {
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myConnectionType = connectionType;
        this.mySource.setBounds(source);
        this.mySourceDirection = sourceDirection;
        this.myDest.setBounds(dest);
        this.myDestDirection = destDirection;
        this.myDestType = destType;
        this.myShift = shift;
        this.myMargin = margin;
        this.myMarginDistance = marginDistance;
        this.myIsMarginReference = isMarginReference;
        this.myBias = bias.floatValue();
        this.myModeFrom = modeFrom;
        this.myModeTo = modeTo;
        this.myStateChangeTime = stateChangeTime;
    }

    public static Color modeGetConstraintsColor(int mode, ColorSet color) {
        switch (mode) {
            case 0: {
                return color.getConstraints();
            }
            case 2: {
                return color.getSelectedConstraints();
            }
            case 7: {
                return color.getCreatedConstraints();
            }
            case 6: {
                return color.getAnchorDisconnectionCircle();
            }
            case 1: {
                return color.getSubduedConstraints();
            }
        }
        return color.getConstraints();
    }

    public static Color modeGetMarginColor(int mode, ColorSet color) {
        switch (mode) {
            case 0: {
                return color.getMargins();
            }
            case 2: {
                return color.getConstraints();
            }
            case 7: {
                return color.getHighlightedConstraints();
            }
            case 1: {
                return color.getSubduedConstraints();
            }
        }
        return color.getMargins();
    }

    static Color interpolate(Color fromColor, Color toColor, float percent) {
        int col1 = fromColor.getRGB();
        int col2 = toColor.getRGB();
        int c1 = (int)((float)(col1 >> 0 & 0xFF) * (1.0f - percent) + (float)(col2 >> 0 & 0xFF) * percent);
        int c2 = (int)((float)(col1 >> 8 & 0xFF) * (1.0f - percent) + (float)(col2 >> 8 & 0xFF) * percent);
        int c3 = (int)((float)(col1 >> 16 & 0xFF) * (1.0f - percent) + (float)(col2 >> 16 & 0xFF) * percent);
        return new Color(c3, c2, c1);
    }

    public static boolean draw(Graphics2D g, ColorSet color, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int myDestType, int margin, int marginDistance, boolean isMarginReference, int modeFrom, int modeTo, long stateChange) {
        boolean animate = false;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color constraintColor = DrawConnection.modeGetConstraintsColor(modeTo, color);
        Color marginColor = DrawConnection.modeGetMarginColor(modeTo, color);
        long timeSince = System.nanoTime() - stateChange;
        if (timeSince < 1000000000L) {
            float t = (float)((double)timeSince / 1.0E9);
            Color fromColor = DrawConnection.modeGetConstraintsColor(modeFrom, color);
            Color toColor = DrawConnection.modeGetConstraintsColor(modeTo, color);
            constraintColor = DrawConnection.interpolate(fromColor, toColor, t);
            animate = true;
        }
        if (connectionType == 5) {
            DrawConnection.drawBaseLine(g, source, dest, constraintColor);
            return animate;
        }
        int startx = DrawConnection.getConnectionX(sourceDirection, source);
        int starty = DrawConnection.getConnectionY(sourceDirection, source);
        int endx = DrawConnection.getConnectionX(destDirection, dest);
        int endy = DrawConnection.getConnectionY(destDirection, dest);
        int dx = DrawConnection.getDestinationDX(destDirection);
        int dy = DrawConnection.getDestinationDY(destDirection);
        int manhattanDistance = Math.abs(startx - endx) + Math.abs(starty - endy);
        int scale_source = Math.min(90, manhattanDistance);
        int scale_dest = myDestType == 1 ? -scale_source : scale_source;
        boolean flip_arrow = false;
        if (myDestType != 0) {
            switch (destDirection) {
                case 2: 
                case 3: {
                    endx = startx;
                    break;
                }
                case 0: 
                case 1: {
                    endy = starty;
                }
            }
        } else if (sourceDirection == destDirection) {
            switch (destDirection) {
                case 3: {
                    if (endy - 1 <= starty) break;
                    scale_dest *= -1;
                    dy *= -1;
                    flip_arrow = true;
                    break;
                }
                case 2: {
                    if (endy >= starty) break;
                    scale_dest *= -1;
                    dy *= -1;
                    flip_arrow = true;
                    break;
                }
                case 0: {
                    if (endx >= startx) break;
                    scale_dest *= -1;
                    dx *= -1;
                    flip_arrow = true;
                    break;
                }
                case 1: {
                    if (endx - 1 <= startx) break;
                    scale_dest *= -1;
                    dx *= -1;
                    flip_arrow = true;
                }
            }
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int dir = myDestType == 1 ^ flip_arrow ? ourOppositeDirection[destDirection] : destDirection;
        ourPath.reset();
        ourPath.moveTo(startx, starty);
        if (manhattanDistance == 0) {
            g.setColor(constraintColor);
            DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
            g.fillPolygon(xPoints, yPoints, 3);
            g.draw(ourPath);
        }
        switch (connectionType) {
            case 3: {
                boolean flip_chain;
                boolean bl = flip_chain = endx + endy > startx + starty;
                if (flip_chain) {
                    ourPath.moveTo(startx, starty);
                    ourPath.curveTo(startx + scale_source * dirDeltaX[sourceDirection], starty + scale_source * dirDeltaY[sourceDirection], endx + scale_dest * dirDeltaX[destDirection], endy + scale_dest * dirDeltaY[destDirection], endx, endy);
                } else {
                    ourPath.moveTo(endx, endy);
                    ourPath.curveTo(endx + scale_source * dirDeltaX[destDirection], endy + scale_source * dirDeltaY[destDirection], startx + scale_dest * dirDeltaX[sourceDirection], starty + scale_dest * dirDeltaY[sourceDirection], startx, starty);
                }
                Stroke defaultStroke = g.getStroke();
                g.setColor(constraintColor);
                g.setStroke(flip_chain ? myChainStroke1 : myChainStroke2);
                g.draw(ourPath);
                g.setStroke(defaultStroke);
                if (modeTo != 6) break;
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                break;
            }
            case 7: {
                g.setColor(constraintColor);
                DrawConnectionUtils.getSmallArrow(dir, startx - dx / 2, starty - dy / 2, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                if (destDirection == 0 || destDirection == 1) {
                    endx = startx = (startx + endx) / 2;
                } else {
                    endy = starty = (starty + endy) / 2;
                }
                g.drawLine(startx, starty, endx, endy);
                break;
            }
            case 2: {
                boolean drawArrow = true;
                int springEndX = endx;
                int springEndY = endy;
                if (myDestType != 0) {
                    if (margin != 0) {
                        String marginString = Integer.toString(margin);
                        if (destDirection == 0 || destDirection == 1) {
                            int gap = Math.max(marginDistance, DrawConnectionUtils.getHorizontalMarginGap(g, marginString));
                            if (Math.abs(startx - endx) > gap) {
                                int marginX = endx - (endx > startx ? gap : -gap);
                                int arrow = (endx > startx ? 1 : -1) * 6;
                                g.setColor(marginColor);
                                DrawConnectionUtils.drawHorizontalMargin(g, marginString, isMarginReference, marginX, endx - arrow, endy);
                                springEndX = marginX;
                            }
                        } else {
                            int gap = Math.max(marginDistance, DrawConnectionUtils.getVerticalMarginGap(g));
                            if (Math.abs(starty - endy) > gap) {
                                int marginY = endy - (endy > starty ? gap : -gap);
                                int arrow = (endy > starty ? 1 : -1) * 6;
                                g.setColor(marginColor);
                                DrawConnectionUtils.drawVerticalMargin(g, marginString, isMarginReference, endx, marginY, endy - arrow);
                                springEndY = marginY;
                            }
                        }
                    }
                    if (endx == startx) {
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawVerticalZigZagLine(ourPath, startx, starty, springEndY);
                        g.fillRect(startx - 4, springEndY, 9, 1);
                    } else {
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawHorizontalZigZagLine(ourPath, startx, springEndX, endy);
                        g.fillRect(springEndX, endy - 4, 1, 9);
                    }
                } else {
                    g.setColor(constraintColor);
                    if (destDirection == 0 || destDirection == 1) {
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawHorizontalZigZagLine(ourPath, startx, endx, starty);
                        Stroke defaultStroke = g.getStroke();
                        g.setStroke(mySpringStroke);
                        drawArrow = false;
                        g.drawLine(endx, starty, endx, endy);
                        g.setStroke(defaultStroke);
                        g.fillRoundRect(endx - 2, endy - 2, 5, 5, 2, 2);
                    } else {
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawVerticalZigZagLine(ourPath, startx, starty, endy);
                        Stroke defaultStroke = g.getStroke();
                        g.setStroke(mySpringStroke);
                        drawArrow = false;
                        g.drawLine(startx, endy, endx, endy);
                        g.setStroke(defaultStroke);
                        g.fillRoundRect(endx - 2, endy - 2, 5, 5, 2, 2);
                    }
                }
                g.setColor(constraintColor);
                g.draw(ourPath);
                if (!drawArrow) break;
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                break;
            }
            case 4: 
            case 6: {
                Stroke stroke;
                int p6y;
                int p6x;
                int dir0_x = 0;
                int dir0_y = 0;
                int dir1_x = 0;
                int dir1_y = 0;
                int dir2_x = 0;
                int dir2_y = 0;
                if (destDirection == 0 || destDirection == 1) {
                    dir0_x = sourceDirection == 0 ? -1 : 1;
                    dir1_y = endy > starty ? 1 : -1;
                    dir2_x = destDirection == 0 ? -1 : 1;
                    p6x = destDirection == 0 ? endx - 20 : endx + 20;
                    p6y = starty + dir0_y * 10 + (source.height / 2 + 10) * dir1_y;
                    int vline_y1 = -1;
                    int vline_y2 = -1;
                    if (source.y > dest.y + dest.height) {
                        vline_y1 = dest.y + dest.height;
                        vline_y2 = source.y;
                    }
                    if (source.y + source.height < dest.y) {
                        vline_y1 = source.y + source.height;
                        vline_y2 = dest.y;
                    }
                    if (vline_y1 != -1) {
                        stroke = g.getStroke();
                        g.setStroke(myDashStroke);
                        int xpos = source.x + source.width / 2;
                        g.setColor(constraintColor);
                        g.drawLine(xpos, vline_y1, xpos, vline_y2);
                        g.setStroke(stroke);
                    }
                } else {
                    dir1_x = endx > startx ? 1 : -1;
                    dir0_y = sourceDirection == 2 ? -1 : 1;
                    dir2_y = destDirection == 2 ? -1 : 1;
                    p6y = destDirection == 2 ? endy - 20 : endy + 20;
                    p6x = startx + dir0_x * 10 + (source.width / 2 + 10) * dir1_x;
                    int vline_x1 = -1;
                    int vline_x2 = -1;
                    if (source.x > dest.x + dest.width) {
                        vline_x1 = dest.x + dest.width;
                        vline_x2 = source.x;
                    }
                    if (source.x + source.width < dest.x) {
                        vline_x1 = source.x + source.width;
                        vline_x2 = dest.x;
                    }
                    if (vline_x1 != -1) {
                        stroke = g.getStroke();
                        g.setStroke(myDashStroke);
                        int ypos = source.y + source.height / 2;
                        g.setColor(constraintColor);
                        g.drawLine(vline_x1, ypos, vline_x2, ypos);
                        g.setStroke(stroke);
                    }
                }
                int len = 6;
                int[] px = new int[len];
                int[] py = new int[len];
                px[0] = startx;
                py[0] = starty;
                px[1] = startx + dir0_x * 10;
                py[1] = starty + dir0_y * 10;
                px[2] = px[1] + (source.width / 2 + 10) * dir1_x;
                py[2] = py[1] + (source.height / 2 + 10) * dir1_y;
                px[3] = p6x;
                py[3] = p6y;
                px[4] = endx + 2 * dir2_x * 10;
                py[4] = endy + 2 * dir2_y * 10;
                px[5] = endx;
                py[5] = endy;
                g.setColor(constraintColor);
                if (6 == connectionType) {
                    len = DrawConnectionUtils.removeZigZag(px, py, len, 50);
                }
                DrawConnectionUtils.drawRound(ourPath, px, py, len, 10);
                DrawConnectionUtils.getArrow(destDirection, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
                break;
            }
            case 1: {
                if (margin > 0) {
                    if (sourceDirection == 1 || sourceDirection == 0) {
                        boolean above = starty < endy;
                        int line_y = starty + (above ? -1 : 1) * source.height / 4;
                        g.setColor(marginColor);
                        DrawConnectionUtils.drawHorizontalMarginIndicator(g, String.valueOf(margin), isMarginReference, startx, endx, line_y);
                        if (myDestType != 1 || line_y < dest.y || line_y > dest.y + dest.height) {
                            int constraintX = destDirection == 0 ? dest.x : dest.x + dest.width;
                            Stroke stroke = g.getStroke();
                            g.setStroke(myDashStroke);
                            int overlap = above ? -20 : 20;
                            g.setColor(constraintColor);
                            g.drawLine(constraintX, line_y + overlap, constraintX, above ? dest.y : dest.y + dest.height);
                            g.setStroke(stroke);
                        }
                    } else {
                        boolean left = startx < endx;
                        int line_x = startx + (left ? -1 : 1) * source.width / 4;
                        g.setColor(marginColor);
                        DrawConnectionUtils.drawVerticalMarginIndicator(g, String.valueOf(margin), isMarginReference, line_x, starty, endy);
                        if (myDestType != 1 || line_x < dest.x || line_x > dest.x + dest.width) {
                            int constraint_y = destDirection == 2 ? dest.y : dest.y + dest.height;
                            Stroke stroke = g.getStroke();
                            g.setStroke(myDashStroke);
                            g.setColor(constraintColor);
                            int overlap = left ? -20 : 20;
                            g.drawLine(line_x + overlap, constraint_y, left ? dest.x : dest.x + dest.width, constraint_y);
                            g.setStroke(stroke);
                        }
                    }
                }
                if ((startx - endx == 0 || starty - endy == 0) && sourceDirection != destDirection) {
                    scale_source = 0;
                    scale_dest = 0;
                }
                g.setColor(constraintColor);
                if (sourceDirection == destDirection && margin == 0) {
                    ourPath.curveTo(startx + (scale_source /= 3) * dirDeltaX[sourceDirection], starty + scale_source * dirDeltaY[sourceDirection], endx + dx + (scale_dest /= 2) * dirDeltaX[destDirection], endy + dy + scale_dest * dirDeltaY[destDirection], endx + dx, endy + dy);
                } else {
                    int xgap = startx - endx;
                    int ygap = starty - endy;
                    if (startx - endx == 0 && dirDeltaX[sourceDirection] == 0) {
                        scale_source = 0;
                        scale_dest = 0;
                    } else if (starty - endy == 0 && dirDeltaY[sourceDirection] == 0) {
                        scale_dest = 0;
                        scale_source = 0;
                    }
                    ourPath.curveTo(startx + scale_source * dirDeltaX[sourceDirection], starty + scale_source * dirDeltaY[sourceDirection], endx + dx + scale_dest * dirDeltaX[destDirection], endy + dy + scale_dest * dirDeltaY[destDirection], endx + dx, endy + dy);
                }
                Stroke defaultStroke = g.getStroke();
                g.setStroke(myBackgroundStroke);
                g.setColor(color.getBackground());
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
                g.setStroke(defaultStroke);
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
            }
        }
        return animate;
    }

    private static void drawBaseLine(Graphics2D g, Rectangle source, Rectangle dest, Color color) {
        g.setColor(color);
        ourPath.reset();
        ourPath.moveTo((double)source.x + (double)source.width / 2.0, (double)source.y);
        ourPath.curveTo((double)source.x + (double)source.width / 2.0, (double)(source.y - 40), (double)dest.x + (double)dest.width / 2.0, (double)(dest.y + 40), (double)dest.x + (double)dest.width / 2.0, (double)dest.y);
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        DrawConnectionUtils.getArrow(3, dest.x + dest.width / 2, dest.y, xPoints, yPoints);
        int inset = source.width / 5;
        g.fillRect(source.x + inset, source.y, source.width - inset * 2, 1);
        inset = dest.width / 5;
        g.fillRect(dest.x + inset, dest.y, dest.width - inset * 2, 1);
        g.fillPolygon(xPoints, yPoints, 3);
        g.draw(ourPath);
    }

    private static int getConnectionX(int side, Rectangle rect) {
        switch (side) {
            case 0: {
                return rect.x;
            }
            case 1: {
                return rect.x + rect.width;
            }
            case 2: 
            case 3: {
                return rect.x + rect.width / 2;
            }
        }
        return 0;
    }

    private static int getConnectionY(int side, Rectangle rect) {
        switch (side) {
            case 0: 
            case 1: {
                return rect.y + rect.height / 2;
            }
            case 2: {
                return rect.y;
            }
            case 3: {
                return rect.y + rect.height;
            }
        }
        return 0;
    }

    private static int getDestinationDX(int side) {
        switch (side) {
            case 0: {
                return -6;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private static int getDestinationDY(int side) {
        switch (side) {
            case 2: {
                return -6;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }
}

