/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.Color;
import java.awt.Graphics2D;

public class DrawResize
extends DrawRegion {
    public static final int NORMAL = 0;
    public static final int OVER = 1;
    int myMode;

    public DrawResize(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
    }

    public DrawResize(int x, int y, int width, int height, int mode) {
        super(x, y, width, height);
        this.myMode = mode;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getSelectedFrames();
        g.setColor(background);
        g.fillRect(this.x, this.y, this.width, this.height);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, float right, float bottom, int mode) {
        int l = transform.getSwingX(left);
        int t = transform.getSwingY(top);
        int w = transform.getSwingDimension(right - left);
        int h = transform.getSwingDimension(bottom - top);
        list.add(new DrawResize(l, t, w, h, mode));
    }
}

