/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.adaptiveicon.ShapeMenuAction;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.menu.NavigationViewSceneView;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.inspector.NlInspectorProviders;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.ConstraintsLayer;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.MockupLayer;
import com.android.tools.idea.uibuilder.surface.PanZoomPanel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.surface.SelectionLayer;
import com.android.tools.idea.uibuilder.surface.WarningLayer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.update.Update;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDesignSurface
extends DesignSurface {
    @NotNull
    private static ScreenMode ourDefaultScreenMode = ScreenMode.loadPreferredMode();
    @NotNull
    private ScreenMode myScreenMode;
    @Nullable
    private ScreenView myBlueprintView;
    private int myScreenX;
    private int myScreenY;
    private boolean myIsCanvasResizing;
    private boolean myStackVertically;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private boolean myCentered;
    @Nullable
    private ScreenView myScreenView;
    private final boolean myInPreview;
    private WeakReference<PanZoomPanel> myPanZoomPanel;
    private ShapeMenuAction.AdaptiveIconShape myAdaptiveIconShape;

    public NlDesignSurface(@NotNull Project project, boolean inPreview, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(1);
        }
        super(project, parentDisposable);
        this.myScreenMode = ourDefaultScreenMode;
        this.myScreenX = 70;
        this.myScreenY = 70;
        this.myIsCanvasResizing = false;
        this.myPanZoomPanel = new WeakReference<Object>(null);
        this.myAdaptiveIconShape = ShapeMenuAction.AdaptiveIconShape.getDefaultShape();
        this.myInPreview = inPreview;
    }

    public boolean isPreviewSurface() {
        return this.myInPreview;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    @Override
    public void activate() {
        super.activate();
        this.showPanZoomPanelIfRequired();
    }

    @NotNull
    public ScreenMode getScreenMode() {
        ScreenMode screenMode = this.myScreenMode;
        if (screenMode == null) {
            NlDesignSurface.$$$reportNull$$$0(2);
        }
        return screenMode;
    }

    public void setScreenMode(@NotNull ScreenMode screenMode, boolean setAsDefault) {
        if (screenMode == null) {
            NlDesignSurface.$$$reportNull$$$0(3);
        }
        if (setAsDefault && ourDefaultScreenMode != screenMode) {
            ourDefaultScreenMode = screenMode;
            ScreenMode.savePreferredMode(screenMode);
        }
        if (screenMode != this.myScreenMode) {
            boolean adjustZoom = screenMode == ScreenMode.BOTH || this.myScreenMode == ScreenMode.BOTH;
            this.myScreenMode = screenMode;
            this.createSceneViews();
            if (this.myScreenView != null && adjustZoom) {
                this.zoomToFit();
            }
            if (screenMode != ScreenMode.BLUEPRINT_ONLY) {
                SceneManager manager = this.getSceneManager();
                if (manager != null) {
                    manager.requestRender();
                }
            } else {
                this.repaint();
            }
        }
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model) {
        if (model == null) {
            NlDesignSurface.$$$reportNull$$$0(4);
        }
        LayoutlibSceneManager layoutlibSceneManager = new LayoutlibSceneManager(model, this);
        if (layoutlibSceneManager == null) {
            NlDesignSurface.$$$reportNull$$$0(5);
        }
        return layoutlibSceneManager;
    }

    private void setLayers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new MyBottomLayer());
        switch (this.myScreenMode) {
            case SCREEN_ONLY: {
                assert (this.myScreenView != null);
                builder.addAll(NlDesignSurface.getScreenLayers(this, this.myScreenView));
                break;
            }
            case BLUEPRINT_ONLY: {
                assert (this.myScreenView != null);
                builder.addAll(NlDesignSurface.getBlueprintLayers(this, this.myScreenView));
                break;
            }
            case BOTH: {
                assert (this.myScreenView != null && this.myBlueprintView != null);
                builder.addAll(NlDesignSurface.getScreenLayers(this, this.myScreenView));
                builder.addAll(NlDesignSurface.getBlueprintLayers(this, this.myBlueprintView));
                break;
            }
            default: {
                assert (false) : this.myScreenMode;
                break;
            }
        }
        this.setLayers((ImmutableList<Layer>)builder.build());
    }

    @NotNull
    private static ImmutableList<Layer> getScreenLayers(@NotNull NlDesignSurface surface, @NotNull ScreenView screenView) {
        if (surface == null) {
            NlDesignSurface.$$$reportNull$$$0(6);
        }
        if (screenView == null) {
            NlDesignSurface.$$$reportNull$$$0(7);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new ScreenViewLayer(screenView));
        builder.add((Object)new SelectionLayer(screenView));
        if (screenView.getModel().getType().isLayout()) {
            builder.add((Object)new ConstraintsLayer(surface, screenView, true));
        }
        SceneLayer sceneLayer = new SceneLayer(surface, screenView, false);
        sceneLayer.setAlwaysShowSelection(true);
        builder.add((Object)new WarningLayer(screenView));
        builder.add((Object)sceneLayer);
        if (surface.getLayoutType().isSupportedByDesigner()) {
            builder.add((Object)new CanvasResizeLayer(surface, screenView));
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            NlDesignSurface.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<Layer> getBlueprintLayers(@NotNull NlDesignSurface surface, @NotNull ScreenView view) {
        if (surface == null) {
            NlDesignSurface.$$$reportNull$$$0(9);
        }
        if (view == null) {
            NlDesignSurface.$$$reportNull$$$0(10);
        }
        ImmutableList immutableList = ImmutableList.of((Object)new SelectionLayer(view), (Object)new MockupLayer(view), (Object)new CanvasResizeLayer(surface, view), (Object)new SceneLayer(surface, view, true));
        if (immutableList == null) {
            NlDesignSurface.$$$reportNull$$$0(11);
        }
        return immutableList;
    }

    public void forceLayersPaint(boolean value) {
        for (Layer layer : this.getLayers()) {
            if (layer instanceof ConstraintsLayer) {
                ConstraintsLayer constraintsLayer = (ConstraintsLayer)layer;
                constraintsLayer.setTemporaryShow(value);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer)) continue;
            SceneLayer sceneLayer = (SceneLayer)layer;
            sceneLayer.setTemporaryShow(value);
            this.repaint();
        }
    }

    @Override
    @Nullable
    public ScreenView getCurrentSceneView() {
        return this.myScreenView;
    }

    @Override
    @Nullable
    public SceneView getSceneView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && y >= this.myBlueprintView.getY()) {
            return this.myBlueprintView;
        }
        return this.myScreenView;
    }

    @Override
    @Nullable
    public ScreenView getHoverSceneView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && x <= this.myBlueprintView.getX() + this.myBlueprintView.getSize().width && y >= this.myBlueprintView.getY() && y <= this.myBlueprintView.getY() + this.myBlueprintView.getSize().height) {
            return this.myBlueprintView;
        }
        if (this.myScreenView != null && x >= this.myScreenView.getX() && x <= this.myScreenView.getX() + this.myScreenView.getSize().width && y >= this.myScreenView.getY() && y <= this.myScreenView.getY() + this.myScreenView.getSize().height) {
            return this.myScreenView;
        }
        return null;
    }

    @Override
    @NotNull
    public NlInspectorProviders getInspectorProviders(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable) {
        if (propertiesManager == null) {
            NlDesignSurface.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(13);
        }
        NlInspectorProviders nlInspectorProviders = new NlInspectorProviders(propertiesManager, parentDisposable);
        if (nlInspectorProviders == null) {
            NlDesignSurface.$$$reportNull$$$0(14);
        }
        return nlInspectorProviders;
    }

    @Nullable
    public ScreenView getBlueprintView() {
        return this.myBlueprintView;
    }

    @Override
    public Dimension getScrolledAreaSize() {
        if (this.myScreenView == null) {
            return null;
        }
        Dimension size = this.myScreenView.getSize();
        Dimension dimension = new Dimension(size.width + 100, size.height + 100);
        if (this.myScreenMode == ScreenMode.BOTH) {
            if (this.isStackVertically()) {
                dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)size.height + 10.0);
            } else {
                dimension.setSize(dimension.getWidth() + (double)size.width + 10.0, dimension.getHeight());
            }
        }
        return dimension;
    }

    public void setAdaptiveIconShape(@NotNull ShapeMenuAction.AdaptiveIconShape adaptiveIconShape) {
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(15);
        }
        this.myAdaptiveIconShape = adaptiveIconShape;
    }

    @NotNull
    public ShapeMenuAction.AdaptiveIconShape getAdaptiveIconShape() {
        ShapeMenuAction.AdaptiveIconShape adaptiveIconShape = this.myAdaptiveIconShape;
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(16);
        }
        return adaptiveIconShape;
    }

    private static boolean isVerticalScreenConfig(int availableWidth, int availableHeight, @NotNull Dimension preferredSize) {
        boolean stackVertically;
        if (preferredSize == null) {
            NlDesignSurface.$$$reportNull$$$0(17);
        }
        boolean bl = stackVertically = preferredSize.width > preferredSize.height;
        if (availableWidth > 10 && availableHeight > 3 * availableWidth / 2) {
            stackVertically = true;
        }
        return stackVertically;
    }

    public void setCentered(boolean centered) {
        this.myCentered = centered;
    }

    @NotNull
    protected NlActionManager createActionManager() {
        NlActionManager nlActionManager = new NlActionManager(this);
        if (nlActionManager == null) {
            NlDesignSurface.$$$reportNull$$$0(18);
        }
        return nlActionManager;
    }

    @Override
    protected void layoutContent() {
        if (this.myScreenView == null) {
            return;
        }
        Dimension screenViewSize = this.myScreenView.getSize();
        int availableWidth = this.myScrollPane.getWidth();
        int availableHeight = this.myScrollPane.getHeight();
        this.myStackVertically = NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, screenViewSize);
        if (!this.myIsCanvasResizing) {
            if (this.myCentered && availableWidth > 10 && availableHeight > 10) {
                int requiredWidth = screenViewSize.width;
                if (this.myScreenMode == ScreenMode.BOTH && !this.myStackVertically) {
                    requiredWidth += 10;
                    requiredWidth += screenViewSize.width;
                }
                this.myScreenX = Math.max((availableWidth - requiredWidth) / 2, 70);
                int requiredHeight = screenViewSize.height;
                if (this.myScreenMode == ScreenMode.BOTH && this.myStackVertically) {
                    requiredHeight += 10;
                    requiredHeight += screenViewSize.height;
                }
                this.myScreenY = Math.max((availableHeight - requiredHeight) / 2, 70);
            } else if (this.myDeviceFrames) {
                this.myScreenX = 120;
                this.myScreenY = 120;
            } else {
                this.myScreenX = 70;
                this.myScreenY = 70;
            }
        }
        this.myScreenView.setLocation(this.myScreenX, this.myScreenY);
        if (this.myBlueprintView != null) {
            if (this.myStackVertically) {
                this.myBlueprintView.setLocation(this.myScreenX, this.myScreenY + screenViewSize.height + 10);
            } else {
                this.myBlueprintView.setLocation(this.myScreenX + screenViewSize.width + 10, this.myScreenY);
            }
        }
        if (this.myScreenView != null) {
            Scene scene = this.myScreenView.getScene();
            scene.needsRebuildList();
        }
        if (this.myBlueprintView != null) {
            Scene scene = this.myBlueprintView.getScene();
            scene.needsRebuildList();
        }
    }

    @Override
    protected int getContentOriginX() {
        return this.myScreenX;
    }

    @Override
    protected int getContentOriginY() {
        return this.myScreenY;
    }

    public boolean isStackVertically() {
        return this.myStackVertically;
    }

    @Override
    protected void doCreateSceneViews() {
        this.myScreenView = null;
        this.myBlueprintView = null;
        if (this.myModel == null) {
            return;
        }
        NlLayoutType type = this.myModel.getType();
        if (type.equals((Object)NlLayoutType.MENU)) {
            this.doCreateSceneViewsForMenu();
            return;
        }
        if (type.equals((Object)NlLayoutType.PREFERENCE_SCREEN)) {
            this.myScreenMode = ScreenMode.SCREEN_ONLY;
        }
        switch (this.myScreenMode) {
            case SCREEN_ONLY: {
                this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, this.myModel);
                break;
            }
            case BLUEPRINT_ONLY: {
                this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.BLUEPRINT, this.myModel);
                break;
            }
            case BOTH: {
                this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, this.myModel);
                this.myBlueprintView = new ScreenView(this, ScreenView.ScreenViewType.BLUEPRINT, this.myModel);
                this.myBlueprintView.setLocation(this.myScreenX + this.myScreenView.getPreferredSize().width + 10, this.myScreenY);
            }
        }
        this.updateErrorDisplay();
        this.getLayeredPane().setPreferredSize(this.myScreenView.getPreferredSize());
        this.setLayers();
        this.layoutContent();
    }

    private void doCreateSceneViewsForMenu() {
        this.myScreenMode = ScreenMode.SCREEN_ONLY;
        XmlTag tag = this.myModel.getFile().getRootTag();
        if (tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view")) {
            this.myScreenView = new NavigationViewSceneView(this, this.myModel);
            this.setLayers((ImmutableList<Layer>)ImmutableList.of((Object)new ScreenViewLayer(this.myScreenView)));
        } else {
            this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, this.myModel);
            this.setLayers(NlDesignSurface.getScreenLayers(this, this.myScreenView));
        }
        this.updateErrorDisplay();
        this.getLayeredPane().setPreferredSize(this.myScreenView.getPreferredSize());
        this.layoutContent();
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        if (this.myScreenMode == ScreenMode.BOTH && this.myScreenView != null && this.myBlueprintView != null) {
            if (this.isStackVertically()) {
                dimension.setSize(this.myScreenView.getSize().getWidth(), this.myScreenView.getSize().getHeight() + this.myBlueprintView.getSize().getHeight());
            } else {
                dimension.setSize(this.myScreenView.getSize().getWidth() + this.myBlueprintView.getSize().getWidth(), this.myScreenView.getSize().getHeight());
            }
        } else if (this.getCurrentSceneView() != null) {
            dimension.setSize(this.getCurrentSceneView().getSize().getWidth(), this.getCurrentSceneView().getSize().getHeight());
        }
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            NlDesignSurface.$$$reportNull$$$0(19);
        }
        return dimension2;
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(120, 120);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        assert (this.myScreenView != null);
        Dimension preferredSize = this.myScreenView.getPreferredSize();
        int requiredWidth = preferredSize.width;
        int requiredHeight = preferredSize.height;
        if (this.myScreenMode == ScreenMode.BOTH) {
            if (NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, preferredSize)) {
                requiredHeight *= 2;
                requiredHeight += 10;
            } else {
                requiredWidth *= 2;
                requiredWidth += 10;
            }
        }
        Dimension dimension = new Dimension(requiredWidth, requiredHeight);
        if (dimension == null) {
            NlDesignSurface.$$$reportNull$$$0(20);
        }
        return dimension;
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlDesignSurface.$$$reportNull$$$0(21);
        }
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
        ViewEditor editor = this.getViewEditor();
        if (handler != null && editor != null) {
            handler.onActivateInComponentTree(editor, component2);
        }
        super.notifyComponentActivate(component2);
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2, int x, int y) {
        if (component2 == null) {
            NlDesignSurface.$$$reportNull$$$0(22);
        }
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
        ViewEditor editor = this.getViewEditor();
        if (handler != null && editor != null) {
            handler.onActivateInDesignSurface(editor, component2, x, y);
        }
        super.notifyComponentActivate(component2, x, y);
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    private void setPanZoomPanel(@Nullable PanZoomPanel panZoomPanel) {
        this.myPanZoomPanel = new WeakReference<PanZoomPanel>(panZoomPanel);
    }

    @Nullable
    public PanZoomPanel getPanZoomPanel() {
        return (PanZoomPanel)this.myPanZoomPanel.get();
    }

    private void showPanZoomPanelIfRequired() {
        if (PanZoomPanel.isPropertyComponentOpen()) {
            this.setPanZoomPanelVisible(true);
        }
    }

    public void setPanZoomPanelVisible(boolean show) {
        PanZoomPanel panel = (PanZoomPanel)this.myPanZoomPanel.get();
        if (show) {
            if (panel == null) {
                panel = new PanZoomPanel(this);
            }
            this.setPanZoomPanel(panel);
            if (this.isShowing()) {
                panel.showPopup();
            } else {
                final PanZoomPanel finalPanel = panel;
                ComponentAdapter adapter = new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        finalPanel.showPopup();
                        NlDesignSurface.this.removeComponentListener(this);
                    }
                };
                this.addComponentListener(adapter);
            }
        } else if (panel != null) {
            panel.closePopup();
        }
    }

    public void updateErrorDisplay() {
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                RenderResult result;
                RenderResult renderResult = result = NlDesignSurface.this.getCurrentSceneView() != null ? NlDesignSurface.this.getCurrentSceneView().getResult() : null;
                if (result == null) {
                    return;
                }
                BuildMode gradleBuildMode = BuildSettings.getInstance(NlDesignSurface.this.getProject()).getBuildMode();
                RenderErrorModel model = gradleBuildMode != null && result.getLogger().hasErrors() ? RenderErrorModel.STILL_BUILDING_ERROR_MODEL : RenderErrorModelFactory.createErrorModel(result, DataManager.getInstance().getDataContext((Component)NlDesignSurface.this.getIssuePanel()));
                NlDesignSurface.this.getIssueModel().setRenderErrorModel(model);
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    protected void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            NlDesignSurface.$$$reportNull$$$0(23);
        }
        if (this.getCurrentSceneView() != null) {
            this.updateErrorDisplay();
        }
        super.modelRendered(model);
    }

    @Override
    protected boolean useSmallProgressIcon() {
        return this.getCurrentSceneView() != null && this.getCurrentSceneView().getResult() != null;
    }

    @Override
    @NotNull
    public NlComponent createComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            NlDesignSurface.$$$reportNull$$$0(24);
        }
        NlComponent nlComponent = NlDesignSurface.createComponent(tag, this.getModel());
        if (nlComponent == null) {
            NlDesignSurface.$$$reportNull$$$0(25);
        }
        return nlComponent;
    }

    @NotNull
    public static NlComponent createComponent(@NotNull XmlTag tag, @NotNull NlModel model) {
        if (tag == null) {
            NlDesignSurface.$$$reportNull$$$0(26);
        }
        if (model == null) {
            NlDesignSurface.$$$reportNull$$$0(27);
        }
        NlComponent result = DesignSurface.createComponent(tag, model);
        NlComponentHelper.INSTANCE.registerComponent(result);
        NlComponent nlComponent = result;
        if (nlComponent == null) {
            NlDesignSurface.$$$reportNull$$$0(28);
        }
        return nlComponent;
    }

    @Override
    protected double getMinScale() {
        return Math.min(this.getFitScale(false), 1.0);
    }

    @Override
    @Nullable
    public Interaction doCreateInteractionOnClick(int mouseX, int mouseY, @NotNull SceneView view) {
        ViewGroupHandler viewGroupHandler;
        if (view == null) {
            NlDesignSurface.$$$reportNull$$$0(29);
        }
        ScreenView screenView = (ScreenView)view;
        Dimension size = screenView.getSize();
        Rectangle resizeZone = new Rectangle(view.getX() + size.width, screenView.getY() + size.height, 48, 48);
        if (resizeZone.contains(mouseX, mouseY)) {
            return new CanvasResizeInteraction(this);
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        NlComponent component2 = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component2 == null) {
            if (!selectionModel.isEmpty()) {
                component2 = selectionModel.getPrimary();
            } else {
                return null;
            }
        }
        ViewGroupHandler viewGroupHandler2 = viewGroupHandler = component2 != null ? NlComponentHelperKt.getViewGroupHandler(component2) : null;
        if (viewGroupHandler == null) {
            return null;
        }
        Interaction interaction = null;
        if (!selectionModel.isEmpty()) {
            NlComponent parent;
            NlComponent primary = screenView.getSelectionModel().getPrimary();
            NlComponent nlComponent = parent = primary != null ? primary.getParent() : null;
            if (parent != null) {
                ViewGroupHandler handler;
                int ax = Coordinates.getAndroidX(screenView, mouseX);
                int ay = Coordinates.getAndroidY(screenView, mouseY);
                if (NlComponentHelperKt.containsX(primary, ax) && NlComponentHelperKt.containsY(primary, ay) && (handler = NlComponentHelperKt.getViewGroupHandler(parent)) != null) {
                    interaction = handler.createInteraction(screenView, primary);
                }
            }
        }
        if (interaction == null) {
            interaction = viewGroupHandler.createInteraction(screenView, component2);
        }
        return interaction;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(@NotNull SceneComponent draggedSceneComponent, @Nullable SceneComponent primary) {
        List<Object> dragged;
        NlComponent primaryNlComponent;
        if (draggedSceneComponent == null) {
            NlDesignSurface.$$$reportNull$$$0(30);
        }
        NlComponent nlComponent = primaryNlComponent = primary != null ? primary.getNlComponent() : null;
        if (this.getSelectionModel().isSelected(draggedSceneComponent.getNlComponent())) {
            dragged = Lists.newArrayList();
            if (primary != null) {
                if (primary.getParent() == null) {
                    primaryNlComponent = null;
                } else {
                    dragged.add(primaryNlComponent);
                }
            }
            for (NlComponent selected : this.getSelectionModel().getSelection()) {
                if (selected.isRoot() || selected == primaryNlComponent) continue;
                dragged.add(selected);
            }
        } else {
            dragged = Collections.singletonList(primaryNlComponent);
        }
        return new DragDropInteraction(this, (List<NlComponent>)dragged);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenMode";
                break;
            }
            case 4: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 10: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adaptiveIconShape";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredSize";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedSceneComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSceneManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenLayers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlueprintLayers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProviders";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconShape";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setScreenMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScreenLayers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBlueprintLayers";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInspectorProviders";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAdaptiveIconShape";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isVerticalScreenConfig";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doCreateInteractionOnClick";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createInteractionOnDrag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyBottomLayer
    extends Layer {
        private boolean myPaintedFrame;

        private MyBottomLayer() {
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            if (g2d == null) {
                MyBottomLayer.$$$reportNull$$$0(0);
            }
            Composite oldComposite = g2d.getComposite();
            assert (NlDesignSurface.this.myScreenView != null);
            RenderResult result = NlDesignSurface.this.myScreenView.getResult();
            this.myPaintedFrame = false;
            if (NlDesignSurface.this.myDeviceFrames && result != null && result.hasImage()) {
                Configuration configuration = NlDesignSurface.this.myScreenView.getConfiguration();
                Device device = configuration.getDevice();
                State deviceState = configuration.getDeviceState();
                DeviceArtPainter painter = DeviceArtPainter.getInstance();
                if (device != null && painter.hasDeviceFrame(device) && deviceState != null) {
                    this.myPaintedFrame = true;
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
                    painter.paintFrame(g2d, device, deviceState.getOrientation(), true, NlDesignSurface.this.myScreenX, NlDesignSurface.this.myScreenY, (int)(NlDesignSurface.this.myScale * (double)result.getRenderedImage().getHeight()));
                }
            }
            g2d.setComposite(oldComposite);
            if (!NlDesignSurface.this.getLayoutType().isSupportedByDesigner()) {
                return;
            }
            if (!this.myPaintedFrame) {
                this.paintBorder(g2d);
            }
        }

        private void paintBorder(Graphics2D g2d) {
            if (NlDesignSurface.this.myScreenView == null) {
                return;
            }
            Shape screenShape = NlDesignSurface.this.myScreenView.getScreenShape();
            if (screenShape != null) {
                g2d.draw(screenShape);
                return;
            }
            ScreenView.BorderPainter.paint(g2d, NlDesignSurface.this.myScreenView);
            if (NlDesignSurface.this.myScreenMode == ScreenMode.BOTH) {
                ScreenView.BorderPainter.paint(g2d, NlDesignSurface.this.myBlueprintView);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/uibuilder/surface/NlDesignSurface$MyBottomLayer", "paint"));
        }
    }

    public static enum ScreenMode {
        SCREEN_ONLY,
        BLUEPRINT_ONLY,
        BOTH;

        @NotNull
        static final ScreenMode DEFAULT_SCREEN_MODE;
        static final String SCREEN_MODE_PROPERTY = "NlScreenMode";

        @NotNull
        public ScreenMode next() {
            ScreenMode[] values = ScreenMode.values();
            ScreenMode screenMode = values[(this.ordinal() + 1) % values.length];
            if (screenMode == null) {
                ScreenMode.$$$reportNull$$$0(0);
            }
            return screenMode;
        }

        @NotNull
        public static ScreenMode loadPreferredMode() {
            ScreenMode screenMode;
            String modeName = PropertiesComponent.getInstance().getValue(SCREEN_MODE_PROPERTY, DEFAULT_SCREEN_MODE.name());
            try {
                screenMode = ScreenMode.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                Logger.getInstance(NlDesignSurface.class).warn("The mode " + modeName + " is not recognized, use default mode " + SCREEN_MODE_PROPERTY + " instead");
                ScreenMode screenMode2 = DEFAULT_SCREEN_MODE;
                if (screenMode2 == null) {
                    ScreenMode.$$$reportNull$$$0(2);
                }
                return screenMode2;
            }
            if (screenMode == null) {
                ScreenMode.$$$reportNull$$$0(1);
            }
            return screenMode;
        }

        public static void savePreferredMode(@NotNull ScreenMode mode) {
            if (mode == null) {
                ScreenMode.$$$reportNull$$$0(3);
            }
            PropertiesComponent.getInstance().setValue(SCREEN_MODE_PROPERTY, mode.name());
        }

        static {
            DEFAULT_SCREEN_MODE = BOTH;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$ScreenMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "next";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadPreferredMode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$ScreenMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "savePreferredMode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

