/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template;

import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.base.Function;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TemplateWizardState
implements Function<String, Object> {
    public static final String ACTIVITY_NAME_SUFFIX = "Activity";
    public static final String LAYOUT_NAME_PREFIX = "activity_";
    private static final String MAIN_FLAVOR_SOURCE_PATH = "src" + File.separator + "main";
    private static final String TEST_SOURCE_PATH = "src" + File.separator + "androidTest";
    private static final String JAVA_SOURCE_PATH = "java";
    private static final String RESOURCE_SOURCE_PATH = "res";
    private static final String AIDL_SOURCE_PATH = "aidl";
    private static final Logger logger = Logger.getInstance(TemplateWizardState.class);
    @Nullable
    private Template myTemplate;
    private final Map<String, Object> myParameters;
    public final Set<String> myHidden;
    private final Set<String> myFinal;
    public final Set<String> myModified;

    public TemplateWizardState() {
        this.myParameters = new HashMap<String, Object>();
        this.myHidden = new HashSet<String>();
        this.myFinal = new HashSet<String>();
        this.myModified = new HashSet<String>();
        this.put("isNewProject", false);
        this.put("isGradle", true);
        this.put("isLibraryProject", false);
        this.put("hasApplicationTheme", true);
        this.put("srcDir", "src/main/java");
        this.put("resDir", "src/main/res");
        this.put("aidlDir", "src/main/aidl");
        this.put("manifestDir", "src/main");
        this.put("testDir", "src/androidTest");
    }

    public TemplateWizardState(@NotNull Template template) {
        if (template == null) {
            TemplateWizardState.$$$reportNull$$$0(0);
        }
        this();
        this.myTemplate = template;
    }

    public void populateDirectoryParameters() {
        File projectRoot = new File(this.getString("projectLocation"));
        File moduleRoot = new File(projectRoot, this.getString("projectName"));
        File mainFlavorSourceRoot = new File(moduleRoot, MAIN_FLAVOR_SOURCE_PATH);
        File testSourceRoot = new File(moduleRoot, TEST_SOURCE_PATH);
        if (!this.myParameters.containsKey("resOut") || this.myParameters.get("resOut") == null) {
            File resourceSourceRoot = new File(mainFlavorSourceRoot, RESOURCE_SOURCE_PATH);
            this.put("resOut", FileUtil.toSystemIndependentName((String)resourceSourceRoot.getPath()));
        }
        String javaPackageDir = this.getString("packageName").replace('.', File.separatorChar);
        if (!this.myParameters.containsKey("srcOut") || this.myParameters.get("srcOut") == null) {
            File javaSourcePackageRoot;
            File javaSourceRoot = new File(mainFlavorSourceRoot, JAVA_SOURCE_PATH);
            if (this.myParameters.containsKey("packageRoot")) {
                javaSourcePackageRoot = new File(this.getString("packageRoot"));
                String relativePath = FileUtil.getRelativePath((File)javaSourceRoot, (File)javaSourcePackageRoot);
                String javaPackage = relativePath != null ? FileUtil.toSystemIndependentName((String)relativePath).replace('/', '.') : null;
                this.put("packageName", javaPackage);
            } else {
                javaSourcePackageRoot = new File(javaSourceRoot, javaPackageDir);
            }
            this.put("srcOut", FileUtil.toSystemIndependentName((String)javaSourcePackageRoot.getPath()));
        }
        if (!this.myParameters.containsKey("aidlOut") || this.get("aidlOut") == null) {
            File aidlRoot = new File(mainFlavorSourceRoot, AIDL_SOURCE_PATH);
            File aidlOut = new File(aidlRoot, javaPackageDir);
            this.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlOut.getPath()));
        }
        if (!this.myParameters.containsKey("manifestOut") || this.myParameters.get("manifestOut") == null) {
            this.put("manifestOut", FileUtil.toSystemIndependentName((String)mainFlavorSourceRoot.getPath()));
        }
        if (!this.myParameters.containsKey("testOut") || this.myParameters.get("testOut") == null) {
            String relativeTestOut = FileUtil.join((String[])new String[]{JAVA_SOURCE_PATH, javaPackageDir});
            File testOut = new File(testSourceRoot, relativeTestOut);
            this.put("testOut", FileUtil.toSystemIndependentName((String)testOut.getPath()));
        }
        this.put("topOut", FileUtil.toSystemIndependentName((String)projectRoot.getPath()));
        this.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getPath()));
    }

    public boolean hasTemplate() {
        return this.myTemplate != null && this.myTemplate.getMetadata() != null;
    }

    @Nullable
    public Template getTemplate() {
        return this.myTemplate;
    }

    @Nullable
    public TemplateMetadata getTemplateMetadata() {
        if (this.myTemplate == null) {
            return null;
        }
        return this.myTemplate.getMetadata();
    }

    @NotNull
    public Map<String, Object> getParameters() {
        Map<String, Object> map = this.myParameters;
        if (map == null) {
            TemplateWizardState.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Nullable
    public Object get(@NotNull String key) {
        if (key == null) {
            TemplateWizardState.$$$reportNull$$$0(2);
        }
        return this.myParameters.get(key);
    }

    public boolean getBoolean(@NotNull String key) {
        if (key == null) {
            TemplateWizardState.$$$reportNull$$$0(3);
        }
        return this.get(key, Boolean.class);
    }

    public int getInt(@NotNull String key) {
        if (key == null) {
            TemplateWizardState.$$$reportNull$$$0(4);
        }
        return this.get(key, Integer.class);
    }

    @NotNull
    public String getString(@NotNull String key) {
        if (key == null) {
            TemplateWizardState.$$$reportNull$$$0(5);
        }
        String string = this.get(key, String.class);
        if (string == null) {
            TemplateWizardState.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private <T> T get(@NotNull String key, @NotNull Class<T> valueType) {
        if (key == null) {
            TemplateWizardState.$$$reportNull$$$0(7);
        }
        if (valueType == null) {
            TemplateWizardState.$$$reportNull$$$0(8);
        }
        Object val = this.get(key);
        assert (valueType.isInstance(val));
        T t = valueType.cast(val);
        if (t == null) {
            TemplateWizardState.$$$reportNull$$$0(9);
        }
        return t;
    }

    public boolean hasAttr(String key) {
        return this.myParameters.containsKey(key);
    }

    public void put(@NotNull String key, @Nullable Object value) {
        if (key == null) {
            TemplateWizardState.$$$reportNull$$$0(10);
        }
        this.myParameters.put(key, value);
    }

    public void setTemplateLocation(@NotNull File file) {
        if (file == null) {
            TemplateWizardState.$$$reportNull$$$0(11);
        }
        if (this.myTemplate == null || !this.myTemplate.getRootPath().getAbsolutePath().equals(file.getAbsolutePath())) {
            if (this.myTemplate != null && this.myTemplate.getMetadata() != null) {
                for (Parameter param : this.myTemplate.getMetadata().getParameters()) {
                    if (this.myFinal.contains(param.id)) continue;
                    this.myParameters.remove(param.id);
                }
            }
            this.myTemplate = Template.createFromPath(file);
            this.setParameterDefaults();
        }
    }

    public void setParameterDefaults() {
        TemplateMetadata metadata = this.myTemplate.getMetadata();
        if (metadata == null) {
            logger.warn("Null metadata");
            return;
        }
        for (Parameter param : metadata.getParameters()) {
            if (this.myFinal.contains(param.id) || this.myParameters.containsKey(param.id) || param.initial == null) continue;
            assert (param.id != null);
            switch (param.type) {
                case BOOLEAN: {
                    this.put(param.id, Boolean.valueOf(param.initial));
                    break;
                }
                case ENUM: 
                case STRING: {
                    this.put(param.id, param.initial);
                    break;
                }
            }
        }
    }

    public Object apply(String input) {
        return this.get(input);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/wizard/template/TemplateWizardState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/wizard/template/TemplateWizardState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

