/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.compiler.ant.Generator;
import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElementType;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackagePresentation;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFinalPackageElement
extends PackagingElement<AndroidFinalPackageElementState>
implements FacetBasedPackagingElement,
ModuleOutputPackagingElement {
    @NonNls
    static final String FACET_ATTRIBUTE = "facet";
    private FacetPointer<AndroidFacet> myFacetPointer;
    private final Project myProject;

    public AndroidFinalPackageElement(@NotNull Project project, @Nullable AndroidFacet facet) {
        if (project == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(0);
        }
        super((PackagingElementType)AndroidFinalPackageElementType.getInstance());
        this.myProject = project;
        this.myFacetPointer = facet != null ? FacetPointersManager.getInstance((Project)this.myProject).create((Facet)facet) : null;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(1);
        }
        return new DelegatedPackagingElementPresentation((TreeNodePresentation)new AndroidFinalPackagePresentation(this.myFacetPointer));
    }

    @Nullable
    private String getApkPath() {
        if (this.myFacetPointer == null) {
            return null;
        }
        AndroidFacet facet = (AndroidFacet)this.myFacetPointer.getFacet();
        if (facet == null) {
            return null;
        }
        String apkPath = AndroidRootUtil.getApkPath(facet);
        String path = apkPath != null ? AndroidCommonUtils.addSuffixToFileName((String)apkPath, (String)".afp") : null;
        return path != null ? FileUtil.toSystemIndependentName((String)path) + "!/" : null;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        String apkPath;
        if (resolvingContext == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(2);
        }
        if (creator == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(3);
        }
        if (generationContext == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(4);
        }
        if (artifactType == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(5);
        }
        if ((apkPath = this.getApkPath()) != null) {
            return Collections.singletonList(creator.createExtractedDirectoryInstruction(apkPath));
        }
        return Collections.emptyList();
    }

    @Nullable
    public AndroidFacet getFacet() {
        return this.myFacetPointer != null ? (AndroidFacet)this.myFacetPointer.getFacet() : null;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(6);
        }
        if (!(element instanceof AndroidFinalPackageElement)) {
            return false;
        }
        AndroidFinalPackageElement packageElement = (AndroidFinalPackageElement)element;
        return this.myFacetPointer == null ? packageElement.myFacetPointer == null : this.myFacetPointer.equals(packageElement.myFacetPointer);
    }

    public AndroidFinalPackageElementState getState() {
        AndroidFinalPackageElementState state = new AndroidFinalPackageElementState();
        state.myFacetPointer = this.myFacetPointer != null ? this.myFacetPointer.getId() : null;
        return state;
    }

    public AndroidFacet findFacet(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(7);
        }
        return this.myFacetPointer != null ? (AndroidFacet)this.myFacetPointer.findFacet(context.getModulesProvider(), context.getFacetsProvider()) : null;
    }

    public void loadState(@NotNull AndroidFinalPackageElementState state) {
        if (state == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(8);
        }
        this.myFacetPointer = state.myFacetPointer != null ? FacetPointersManager.getInstance((Project)this.myProject).create(state.myFacetPointer) : null;
    }

    public String getModuleName() {
        return this.myFacetPointer != null ? this.myFacetPointer.getModuleName() : null;
    }

    public Module findModule(PackagingElementResolvingContext context) {
        AndroidFacet facet = this.findFacet(context);
        return facet != null ? facet.getModule() : null;
    }

    @NotNull
    public Collection<VirtualFile> getSourceRoots(PackagingElementResolvingContext context) {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            AndroidFinalPackageElement.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeAntInstructions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFacet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AndroidFinalPackageElementState {
        @Attribute(value="facet")
        public String myFacetPointer;
    }
}

