/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.gwt.facet.GwtFacetEditor;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtJavaScriptOutputStyle;
import org.jetbrains.jps.gwt.model.impl.GwtModuleExtensionProperties;
import org.jetbrains.jps.gwt.model.impl.GwtModulePackagingProperties;

public class GwtFacetConfiguration
implements FacetConfiguration,
PersistentStateComponent<GwtModuleExtensionProperties> {
    private GwtModuleExtensionProperties myState = new GwtModuleExtensionProperties();
    private final Map<String, GwtModulePackagingProperties> myPackagingStates = new HashMap<String, GwtModulePackagingProperties>();

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        return new FacetEditorTab[]{new GwtFacetEditor(editorContext, validatorsManager, this)};
    }

    public void loadState(@NotNull GwtModuleExtensionProperties state) {
        if (state == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(0);
        }
        this.myState = state;
        this.myPackagingStates.clear();
        for (GwtModulePackagingProperties packagingState : state.myPackagingStates) {
            this.myPackagingStates.put(packagingState.myName, packagingState);
        }
    }

    public GwtModuleExtensionProperties getState() {
        this.myState.myPackagingStates.clear();
        Object[] names = ArrayUtil.toStringArray(this.myPackagingStates.keySet());
        Arrays.sort(names);
        for (Object name : names) {
            GwtModulePackagingProperties packagingState = this.myPackagingStates.get(name);
            if (packagingState.myPath == null && packagingState.myEnabled) continue;
            this.myState.myPackagingStates.add(packagingState);
        }
        return this.myState;
    }

    public String getGwtSdkPath() {
        return FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)this.myState.mySdkUrl));
    }

    public void setGwtSdkUrlAndType(String gwtUrl) {
        this.setGwtSdkUrl(gwtUrl);
        GwtSdkType type = GwtSdkManager.getInstance().detectSdkType(this.myState.mySdkUrl);
        this.setGwtSdkType(type != null ? type.getId() : null);
    }

    public void setGwtSdkUrl(String gwtUrl) {
        this.myState.mySdkUrl = gwtUrl;
    }

    @NotNull
    public GwtSdk getSdk() {
        GwtSdk gwtSdk = GwtSdkManager.getInstance().getGwtSdk(this.getGwtSdkUrl(), this.getGwtSdkType());
        if (gwtSdk == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(1);
        }
        return gwtSdk;
    }

    public String getGwtSdkUrl() {
        return this.myState.mySdkUrl;
    }

    public String getGwtSdkType() {
        return this.myState.mySdkType;
    }

    public void setGwtSdkType(String gwtSdkType) {
        this.myState.mySdkType = gwtSdkType;
    }

    public String getCompilerParameters() {
        return this.myState.myCompilerParameters;
    }

    public void setCompilerParameters(String compilerParameters) {
        this.myState.myCompilerParameters = compilerParameters;
    }

    public String getAdditionalCompilerVMParameters() {
        return this.myState.myAdditionalCompilerVMParameters;
    }

    public void setAdditionalCompilerVMParameters(String additionalCompilerVMParameters) {
        this.myState.myAdditionalCompilerVMParameters = additionalCompilerVMParameters;
    }

    public int getCompilerMaxHeapSize() {
        return this.myState.myCompilerMaxHeapSize > 0 ? this.myState.myCompilerMaxHeapSize : 1024;
    }

    public void setCompilerMaxHeapSize(int compilerMaxHeapSize) {
        this.myState.myCompilerMaxHeapSize = compilerMaxHeapSize;
    }

    @NotNull
    public GwtJavaScriptOutputStyle getOutputStyle() {
        GwtJavaScriptOutputStyle gwtJavaScriptOutputStyle = this.myState.myOutputStyle != null ? this.myState.myOutputStyle : GwtJavaScriptOutputStyle.DETAILED;
        if (gwtJavaScriptOutputStyle == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(2);
        }
        return gwtJavaScriptOutputStyle;
    }

    public void setOutputStyle(GwtJavaScriptOutputStyle outputStyle) {
        this.myState.myOutputStyle = outputStyle;
    }

    public void setWebFacetName(String webFacetName) {
        this.myState.myWebFacetName = webFacetName;
    }

    @Nullable
    public String getWebFacetName() {
        return this.myState.myWebFacetName;
    }

    @NotNull
    public String getPackagingRelativePath(@NotNull GwtModule module) {
        GwtModulePackagingProperties state;
        if (module == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(3);
        }
        if ((state = this.myPackagingStates.get(module.getQualifiedName())) != null && state.myPath != null) {
            String string = state.myPath;
            if (string == null) {
                GwtFacetConfiguration.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = GwtFacetConfiguration.getDefaultPackagingPath(module);
        if (string == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isModuleCompilationEnabled(@NotNull GwtModule module) {
        GwtModulePackagingProperties state;
        if (module == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(6);
        }
        return (state = this.myPackagingStates.get(module.getQualifiedName())) == null || state.myEnabled;
    }

    public static String getDefaultPackagingPath(GwtModule module) {
        return "/" + module.getOutputName();
    }

    public void setPackagingRelativePath(@NotNull String moduleName, @Nullable String path) {
        if (moduleName == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(7);
        }
        this.getOrCreateState((String)moduleName).myPath = path;
    }

    public void setModuleCompilationEnabled(@NotNull String moduleName, boolean enable) {
        if (moduleName == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(8);
        }
        this.getOrCreateState((String)moduleName).myEnabled = enable;
    }

    private GwtModulePackagingProperties getOrCreateState(String moduleName) {
        GwtModulePackagingProperties state = this.myPackagingStates.get(moduleName);
        if (state == null) {
            state = new GwtModulePackagingProperties();
            state.myName = moduleName;
            this.myPackagingStates.put(moduleName, state);
        }
        return state;
    }

    @Nullable
    public String getClientLanguageLevelString() {
        return this.myState.getClientLanguageLevel();
    }

    @NotNull
    public LanguageLevel getClientLanguageLevel() {
        String sourceLevelStr = this.getClientLanguageLevelString();
        LanguageLevel languageLevel = null;
        if (sourceLevelStr != null) {
            languageLevel = LanguageLevel.parse((String)sourceLevelStr);
        }
        LanguageLevel languageLevel2 = languageLevel == null ? this.getSdk().getVersion().getHighestSupportedLanguageLevel() : languageLevel;
        if (languageLevel2 == null) {
            GwtFacetConfiguration.$$$reportNull$$$0(9);
        }
        return languageLevel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/facet/GwtFacetConfiguration";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/facet/GwtFacetConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStyle";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagingRelativePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackagingRelativePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isModuleCompilationEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPackagingRelativePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setModuleCompilationEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

