/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.CommonBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.CompoundRunConfigurationType;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.FacetTypeId;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetFrameworkSupportProvider;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.packaging.GwtCompileOutputRelativePathSuggester;
import com.intellij.gwt.packaging.GwtCompilerOutputElement;
import com.intellij.gwt.rpc.GwtServletUtil;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.web.GwtWebUtil;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class GwtSampleApplicationCreator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.facet.GwtSampleApplicationCreator");
    @NonNls
    private static final String WAR_STRING = "/war/";
    @NonNls
    private static final String JAVA_STRING = "/java/";
    private final GwtFacet myFacet;
    private final ModifiableRootModel myRootModel;
    private final String myAppName;
    private final FrameworkSupportModel myFrameworkSupportModel;
    private final Module myModule;
    private final String myAppPackageName;

    public GwtSampleApplicationCreator(GwtFacet facet, String qualifiedAppName, ModifiableRootModel rootModel, FrameworkSupportModel model) {
        this.myFacet = facet;
        this.myRootModel = rootModel;
        this.myAppName = StringUtil.getShortName((String)qualifiedAppName);
        this.myFrameworkSupportModel = model;
        this.myModule = this.myFacet.getModule();
        this.myAppPackageName = StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)qualifiedAppName), (String)StringUtil.decapitalize((String)this.myAppName));
    }

    public String getAppName() {
        return this.myAppName;
    }

    public void create() {
        try {
            WriteAction.run(this::doCreate);
        }
        catch (IOException exc) {
            LOG.info((Throwable)exc);
            Messages.showErrorDialog((String)("Cannot create sample GWT application: " + exc.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    private void doCreate() throws IOException {
        ContentEntry[] contentEntries;
        VirtualFile contentRoot = null;
        VirtualFile sourceRoot = null;
        for (ContentEntry contentEntry : contentEntries = this.myRootModel.getContentEntries()) {
            String path;
            SourceFolder folder = (SourceFolder)ContainerUtil.getFirstItem((List)contentEntry.getSourceFolders((JpsModuleSourceRootType)JavaSourceRootType.SOURCE));
            if (folder == null) continue;
            contentRoot = GwtSampleApplicationCreator.getOrCreateContentRoot(contentEntry);
            sourceRoot = folder.getFile();
            if (sourceRoot != null || (sourceRoot = VfsUtil.createDirectoryIfMissing((String)(path = VfsUtil.urlToPath((String)folder.getUrl())))) != null) continue;
            throw new IOException("Cannot create source root " + path);
        }
        if (sourceRoot == null) {
            if (contentEntries.length == 0) {
                throw new IOException("Module does not have content roots");
            }
            ContentEntry entry = contentEntries[0];
            contentRoot = GwtSampleApplicationCreator.getOrCreateContentRoot(entry);
            sourceRoot = this.findOrCreateChildDirectory(contentRoot, "src");
            entry.addSourceFolder(sourceRoot, false);
        }
        VirtualFile javaDirectory = sourceRoot;
        for (String dirName : StringUtil.split((String)this.myAppPackageName, (String)".")) {
            javaDirectory = this.findOrCreateChildDirectory(javaDirectory, dirName);
        }
        VirtualFile finalContentRoot = contentRoot;
        VirtualFile finalJavaDirectory = javaDirectory;
        Project project = this.myModule.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            GwtVersion gwtVersion = this.myFacet.getSdkVersion();
            WebFacet webFacet = this.myFacet.getWebFacet();
            if (gwtVersion.isHostedModeRequiresWebXml() && webFacet == null) {
                webFacet = GwtWebUtil.createWebFacet(this.myFacet, finalContentRoot);
            }
            CommonStrategy javaEeConfiguration = null;
            for (RunConfiguration configuration : RunManager.getInstance((Project)project).getAllConfigurationsList()) {
                if (!(configuration instanceof CommonStrategy)) continue;
                javaEeConfiguration = (CommonStrategy)configuration;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            GwtRunConfiguration gwtRunConfiguration = (GwtRunConfiguration)((Object)((Object)((Object)ContainerUtil.findInstance((Iterable)runManager.getAllConfigurationsList(), GwtRunConfiguration.class))));
            if (javaEeConfiguration != null) {
                javaEeConfiguration.setUrlToOpenInBrowser(javaEeConfiguration.getUrlToOpenInBrowser() + gwtRunConfiguration.getPage());
                CommonStrategy javaEeDevMode = javaEeConfiguration.clone();
                javaEeDevMode.getSettingsBean().OPEN_IN_BROWSER = false;
                javaEeDevMode.setName(javaEeConfiguration.getName() + " DevMode");
                runManager.addConfiguration(runManager.createConfiguration((RunConfiguration)javaEeDevMode, javaEeConfiguration.getFactory()));
                ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
                String webFacetName = webFacet == null ? null : webFacet.getName();
                String artifactName = JavaeeUtil.suggestArtifactName((String)this.myModule.getName(), (String)webFacetName, (FacetTypeId)WebFacet.ID);
                DeploymentSettings javaEeDeploymentSettings = javaEeConfiguration.getDeploymentSettings();
                if (javaEeDeploymentSettings != null) {
                    Artifact warExplodedArtifact = this.createNewArtifact(project, webFacet, artifactManager, artifactName, true);
                    javaEeDeploymentSettings.getOrCreateModel(warExplodedArtifact);
                    BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)javaEeConfiguration, (Artifact)warExplodedArtifact);
                }
                DeploymentSettings javaEeDevModeDeploymentSettings = javaEeDevMode.getDeploymentSettings();
                Artifact warExplodedDevModeArtifact = this.createNewArtifact(project, webFacet, artifactManager, artifactName + " DevMode", false);
                if (javaEeDevModeDeploymentSettings != null) {
                    javaEeDevModeDeploymentSettings.getOrCreateModel(warExplodedDevModeArtifact);
                    GwtRunConfiguration noServerConfiguration = (GwtRunConfiguration)gwtRunConfiguration.clone();
                    noServerConfiguration.setName(gwtRunConfiguration.getName() + " NoServer");
                    String programParameters = gwtRunConfiguration.getProgramParameters() + " -noserver -port " + javaEeDevMode.getPort() + " -war " + warExplodedDevModeArtifact.getOutputPath();
                    noServerConfiguration.setProgramParameters(programParameters);
                    runManager.addConfiguration(runManager.createConfiguration((RunConfiguration)noServerConfiguration, gwtRunConfiguration.getFactory()));
                    BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)noServerConfiguration, (Artifact)warExplodedDevModeArtifact);
                    BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)javaEeDevMode, (Artifact)warExplodedDevModeArtifact);
                    CompoundRunConfiguration compoundRunConfiguration = new CompoundRunConfiguration(project, CompoundRunConfigurationType.getInstance(), noServerConfiguration.getName() + " with " + javaEeDevMode.getName());
                    compoundRunConfiguration.setConfigurationsWithoutTargets((Collection)ContainerUtil.list((Object[])new LocatableConfigurationBase[]{noServerConfiguration, javaEeDevMode}));
                    runManager.addConfiguration(runManager.createConfiguration((RunConfiguration)compoundRunConfiguration, compoundRunConfiguration.getFactory()));
                }
            }
            this.generateFiles(finalContentRoot, finalJavaDirectory, gwtVersion);
        }));
    }

    @NotNull
    private Artifact createNewArtifact(Project project, WebFacet webFacet, ArtifactManager artifactManager, String artifactName, boolean includeGwtOutput) {
        ArtifactType explodedArtifactType = ((JavaeeFacetType)webFacet.getType()).getExplodedArtifactType();
        Artifact artifact = artifactManager.addArtifact(artifactName, explodedArtifactType, null);
        artifactManager.addElementsToDirectory(artifact, "WEB-INF/classes", PackagingElementFactory.getInstance().createModuleOutput(this.myModule));
        String relativePath = GwtCompileOutputRelativePathSuggester.suggestRelativeOutputPath(this.myFrameworkSupportModel);
        if (includeGwtOutput) {
            artifactManager.addElementsToDirectory(artifact, relativePath, (PackagingElement)new GwtCompilerOutputElement(project, this.myFacet));
        }
        GwtFacetFrameworkSupportProvider.addServletJarToArtifact(artifactManager, artifact, ((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk());
        JavaeeArtifactUtil javaeeArtifactUtil = JavaeeArtifactUtil.getInstance();
        artifactManager.addElementsToDirectory(artifact, relativePath, javaeeArtifactUtil.createFacetResourcesElement((JavaeeFacet)webFacet));
        Artifact artifact2 = artifact;
        if (artifact2 == null) {
            GwtSampleApplicationCreator.$$$reportNull$$$0(0);
        }
        return artifact2;
    }

    @NotNull
    private static VirtualFile getOrCreateContentRoot(ContentEntry contentEntry) throws IOException {
        String path;
        VirtualFile contentRoot = contentEntry.getFile();
        if (contentRoot == null && (contentRoot = VfsUtil.createDirectoryIfMissing((String)(path = VfsUtil.urlToPath((String)contentEntry.getUrl())))) == null) {
            throw new IOException("Cannot create content root " + path);
        }
        VirtualFile virtualFile = contentRoot;
        if (virtualFile == null) {
            GwtSampleApplicationCreator.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    private void generateFiles(@NotNull VirtualFile contentRoot, @NotNull VirtualFile javaDirectory, @NotNull GwtVersion gwtVersion) {
        if (contentRoot == null) {
            GwtSampleApplicationCreator.$$$reportNull$$$0(2);
        }
        if (javaDirectory == null) {
            GwtSampleApplicationCreator.$$$reportNull$$$0(3);
        }
        if (gwtVersion == null) {
            GwtSampleApplicationCreator.$$$reportNull$$$0(4);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("NAME", this.myAppName);
        properties.put("PACKAGE_NAME", this.myAppPackageName);
        properties.put("RELATIVE_SERVLET_PATH", this.myAppPackageName + "." + this.myAppName + "/" + this.myAppName + "Service");
        String serviceName = this.myAppName + "Service";
        properties.put("SHORT_SERVLET_PATH", serviceName);
        properties.put("GWT_MODULE_DOCTYPE", gwtVersion.getGwtModuleDocTypeString());
        Project project = this.myModule.getProject();
        GwtModule gwtModule = null;
        PsiClass servletImpl = null;
        if (!javaDirectory.isValid()) {
            try {
                javaDirectory = VfsUtil.createDirectoryIfMissing((String)javaDirectory.getPath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        for (String templatePath : this.myFacet.getSdkVersion().getGwtSampleAppTemplates()) {
            InputStream stream = this.getClass().getResourceAsStream(templatePath);
            LOG.assertTrue(stream != null, (Object)(templatePath + " template not found"));
            try {
                VirtualFile parent;
                String relativePath;
                String text = StreamUtil.readText((InputStream)stream, (String)"UTF-8");
                int i = templatePath.indexOf(JAVA_STRING);
                if (i != -1) {
                    relativePath = templatePath.substring(i + JAVA_STRING.length());
                    parent = javaDirectory;
                } else {
                    i = templatePath.indexOf(WAR_STRING);
                    relativePath = templatePath.substring(i + WAR_STRING.length());
                    LOG.assertTrue(i != -1, (Object)("incorrect template path: " + templatePath));
                    WebFacet webFacet = this.myFacet.getWebFacet();
                    LOG.assertTrue(webFacet != null);
                    List webRoots = webFacet.getWebRoots();
                    if (webRoots.isEmpty()) {
                        parent = this.findOrCreateChildDirectory(contentRoot, "web");
                        webFacet.addWebRoot(parent, "/");
                    } else {
                        parent = ((WebRoot)webRoots.get(0)).getFile();
                    }
                }
                String[] names = relativePath.split("/");
                for (int j = 0; j < names.length - 1; ++j) {
                    parent = this.findOrCreateChildDirectory(parent, names[j]);
                }
                String fileName = StringUtil.trimEnd((String)StringUtil.replace((String)names[names.length - 1], (String)"App", (String)this.myAppName), (String)".ft");
                VirtualFile file = parent.createChildData((Object)this, fileName);
                for (Map.Entry entry : properties.entrySet()) {
                    text = StringUtil.replace((String)text, (String)("${" + (String)entry.getKey() + "}"), (String)((String)entry.getValue()));
                }
                VfsUtil.saveText((VirtualFile)file, (String)text);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                if (fileName.endsWith(".gwt.xml")) {
                    gwtModule = GwtModulesManager.getInstance(project).getGwtModuleByXmlFile(psiFile);
                    continue;
                }
                if (!fileName.endsWith("ServiceImpl.java")) continue;
                servletImpl = ((PsiJavaFile)psiFile).getClasses()[0];
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myFacet.getSdkVersion().isHostedModeRequiresWebXml()) {
            String urlPattern = "/" + this.myAppName + "/" + serviceName;
            WebApp root = this.myFacet.getWebFacet().getRoot();
            if (root != null) {
                GwtServletUtil.registerServletForService(gwtModule, root, servletImpl, serviceName, urlPattern);
            }
        }
    }

    @NotNull
    private VirtualFile findOrCreateChildDirectory(VirtualFile parent, String name) throws IOException {
        VirtualFile child = parent.findChild(name);
        if (child != null) {
            VirtualFile virtualFile = child;
            if (virtualFile == null) {
                GwtSampleApplicationCreator.$$$reportNull$$$0(5);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = parent.createChildDirectory((Object)this, name);
        if (virtualFile == null) {
            GwtSampleApplicationCreator.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/facet/GwtSampleApplicationCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewArtifact";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContentRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/facet/GwtSampleApplicationCreator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateChildDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

