/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.rpc.GwtSerializableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtInconsistentSerializableClassInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtInconsistentSerializableClassInspection");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.incorrect.serializable.class", new Object[0]);
        if (string == null) {
            GwtInconsistentSerializableClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GwtInconsistentSerializableClass" == null) {
            GwtInconsistentSerializableClassInspection.$$$reportNull$$$0(1);
        }
        return "GwtInconsistentSerializableClass";
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiField[] psiFields;
        GwtFacet gwtFacet;
        if (aClass == null) {
            GwtInconsistentSerializableClassInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            GwtInconsistentSerializableClassInspection.$$$reportNull$$$0(3);
        }
        if ((gwtFacet = GwtInconsistentSerializableClassInspection.getFacet((PsiElement)aClass)) == null || aClass instanceof PsiTypeParameter) {
            return null;
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List<GwtModule> gwtModules = GwtModulesManager.getInstance(manager.getProject()).findGwtModulesByClientSourceFile(virtualFile);
        if (gwtModules.isEmpty()) {
            return null;
        }
        GwtSerializableUtil.SerializableChecker serializableChecker = GwtSerializableUtil.createSerializableChecker(gwtFacet, true);
        if (!serializableChecker.isMarkedSerializable(aClass)) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        for (PsiField psiField : psiFields = aClass.getFields()) {
            PsiType type;
            if (psiField.hasModifierProperty("transient") || serializableChecker.isSerializable(type = psiField.getType())) continue;
            String description = GwtBundle.message("problem.description.field.0.is.not.serializable", type.getPresentableText());
            PsiTypeElement element = psiField.getTypeElement();
            if (element == null) {
                element = psiField;
            }
            descriptors.add(manager.createProblemDescriptor((PsiElement)element, description, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        if (!(GwtSerializableUtil.hasPublicNoArgConstructor(aClass) || aClass.isEnum() || aClass instanceof PsiAnonymousClass)) {
            LOG.assertTrue(aClass.getName() != null, (Object)aClass);
            PsiMethod constructor = GwtSerializableUtil.findNoArgConstructor(aClass);
            String description = GwtBundle.message("problem.description.serializable.class.should.provide.public.no.args.constructor", new Object[0]);
            if (constructor == null) {
                LocalQuickFixAndIntentionActionOnPsiElement quickfix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
                descriptors.add(manager.createProblemDescriptor(GwtInconsistentSerializableClassInspection.getElementToHighlight(aClass), description, (LocalQuickFix)quickfix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            } else if (!gwtFacet.getSdkVersion().isPrivateNoArgConstructorInSerializableClassAllowed()) {
                LocalQuickFixAndIntentionActionOnPsiElement quickfix = QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)constructor, "public", true, true);
                descriptors.add(manager.createProblemDescriptor(GwtInconsistentSerializableClassInspection.getElementToHighlight(constructor), description, (LocalQuickFix)quickfix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtInconsistentSerializableClassInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtInconsistentSerializableClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

