/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.gwt.run.remoteUi.DevModeLogDescriptor;
import com.intellij.gwt.run.remoteUi.RemoteUiRequest;
import com.intellij.gwt.run.remoteUi.RemoteUiView;
import com.intellij.gwt.run.remoteUi.responses.AddLogBranchResponse;
import com.intellij.gwt.run.remoteUi.responses.AddLogEntryResponse;
import com.intellij.gwt.run.remoteUi.responses.AddLogResponseBase;
import com.intellij.gwt.run.remoteUi.responses.AddMainLogResponse;
import com.intellij.gwt.run.remoteUi.responses.AddModuleLogResponse;
import com.intellij.gwt.run.remoteUi.responses.AddWebServerLogResponse;
import com.intellij.gwt.run.remoteUi.responses.DisconnectLogResponse;
import com.intellij.gwt.run.remoteUi.responses.RemoteUiResponse;
import com.intellij.gwt.shell.remoteUi.generated.RemoteMessageProto;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.SocketConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class RemoteUiLogManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.run.remoteUi.RemoteUiLogManager");
    private int myNextLogHandle;
    private final Object myLock = new Object();
    private final TIntObjectHashMap<LogBranchDescriptor> myLogDescriptors = new TIntObjectHashMap();
    private final SocketConnection<RemoteUiRequest, RemoteUiResponse> myConnection;
    private final List<LogMessage> myPendingMessages = new ArrayList<LogMessage>();
    private final RemoteUiView myView;
    private final MergingUpdateQueue myLogUpdateQueue;

    public RemoteUiLogManager(SocketConnection<RemoteUiRequest, RemoteUiResponse> connection, RemoteUiView view) {
        this.myConnection = connection;
        this.myView = view;
        this.myLogUpdateQueue = new MergingUpdateQueue("GWT RemoteUI Log updates", 300, true, null, connection);
    }

    public void registerHandlers() {
        this.myConnection.registerHandler(AddMainLogResponse.class, new AddLogResponseHandler());
        this.myConnection.registerHandler(AddWebServerLogResponse.class, new AddLogResponseHandler());
        this.myConnection.registerHandler(AddModuleLogResponse.class, (AbstractResponseHandler)new AddModuleLogResponseHandler());
        this.myConnection.registerHandler(AddLogBranchResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<AddLogBranchResponse>(){

            public void processResponse(AddLogBranchResponse response) {
                RemoteMessageProto.Message.Request.ViewerRequest.AddLogBranch addLogBranch = response.getAddLogBranch();
                RemoteUiLogManager.this.addLogEntry(addLogBranch.getParentLogHandle(), addLogBranch.getLogData());
                int handle = RemoteUiLogManager.this.createNewLogBranch(addLogBranch.getParentLogHandle());
                RemoteUiLogManager.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createAddLogBranchResponse(handle, response.getMessageId()));
            }
        });
        this.myConnection.registerHandler(AddLogEntryResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<AddLogEntryResponse>(){

            public void processResponse(AddLogEntryResponse response) {
                RemoteUiLogManager.this.addLogEntry(response.getAddLogEntry().getLogHandle(), response.getAddLogEntry().getLogData());
                RemoteUiLogManager.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createDummyResponseRequest(response.getMessageId()));
            }
        });
        this.myConnection.registerHandler(DisconnectLogResponse.class, (AbstractResponseHandler)new AbstractResponseHandler<DisconnectLogResponse>(){

            public void processResponse(DisconnectLogResponse response) {
                RemoteUiLogManager.this.removeLog(response.getLogHandle());
                RemoteUiLogManager.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createDummyResponseRequest(response.getMessageId()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLog(int logHandle) {
        Object object = this.myLock;
        synchronized (object) {
            this.myLogDescriptors.remove(logHandle);
        }
    }

    private void addLogEntry(int logHandle, RemoteMessageProto.Message.Request.ViewerRequest.LogData data) {
        String details = data.getDetails();
        this.addLogEntry(logHandle, data.getLevel() + ": " + data.getSummary() + (StringUtil.isEmpty((String)details) ? "" : "\n" + details), "ERROR".equals(data.getLevel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogEntry(int logHandle, String message, boolean error) {
        Object object = this.myLock;
        synchronized (object) {
            LogBranchDescriptor descriptor = (LogBranchDescriptor)this.myLogDescriptors.get(logHandle);
            if (descriptor == null) {
                LOG.info("descriptor " + logHandle + " not found");
                return;
            }
            this.myPendingMessages.add(new LogMessage(descriptor, message, error));
        }
        this.myLogUpdateQueue.queue((Update)new LogUpdate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewLogBranch(int parentLogHandle) {
        Object object = this.myLock;
        synchronized (object) {
            LogBranchDescriptor parent = (LogBranchDescriptor)this.myLogDescriptors.get(parentLogHandle);
            if (parent == null) {
                LOG.info("parent not found: " + parentLogHandle);
                return this.createNewLog(DevModeLogDescriptor.MAIN_LOG_DESCRIPTOR, 0);
            }
            return this.createNewLog(parent.myRootDescriptor, parent.myIndent + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createNewLog(DevModeLogDescriptor logDescriptor, int indent) {
        Object object = this.myLock;
        synchronized (object) {
            int handle = this.myNextLogHandle++;
            this.myLogDescriptors.put(handle, (Object)new LogBranchDescriptor(logDescriptor, indent));
            return handle;
        }
    }

    private class AddModuleLogResponseHandler
    extends AddLogResponseHandler<AddModuleLogResponse> {
        private AddModuleLogResponseHandler() {
        }

        @Override
        public void processResponse(AddModuleLogResponse response) {
            String sessionKey;
            int handle = this.doProcess(response);
            RemoteMessageProto.Message.Request.ViewerRequest.AddLog.ModuleLog moduleLog = response.getModuleLog();
            RemoteUiLogManager.this.addLogEntry(handle, "Loading module: " + moduleLog.getName(), false);
            int branch = RemoteUiLogManager.this.createNewLogBranch(handle);
            String url = moduleLog.getUrl();
            if (url != null) {
                RemoteUiLogManager.this.addLogEntry(branch, "Top URL: " + url, false);
            }
            RemoteUiLogManager.this.addLogEntry(branch, "User agent: " + moduleLog.getUserAgent(), false);
            RemoteUiLogManager.this.addLogEntry(branch, "Remote host: " + moduleLog.getRemoteHost(), false);
            String tabKey = moduleLog.getTabKey();
            if (tabKey != null) {
                RemoteUiLogManager.this.addLogEntry(branch, "Tab key: " + tabKey, false);
            }
            if ((sessionKey = moduleLog.getSessionKey()) != null) {
                RemoteUiLogManager.this.addLogEntry(branch, "Session key: " + sessionKey, false);
            }
        }
    }

    private class AddLogResponseHandler<T extends AddLogResponseBase>
    extends AbstractResponseHandler<T> {
        private AddLogResponseHandler() {
        }

        public void processResponse(T response) {
            this.doProcess(response);
        }

        protected int doProcess(T response) {
            int handle = RemoteUiLogManager.this.createNewLog(((AddLogResponseBase)response).createLogDescriptor(), 0);
            RemoteUiLogManager.this.myConnection.sendRequest((AbstractRequest)RemoteUiRequest.createAddLogResponse(handle, ((RemoteUiResponse)response).getMessageId()));
            return handle;
        }
    }

    private class LogUpdate
    extends Update {
        public LogUpdate() {
            super((Object)"LogUpdate");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LogMessage[] messages;
            LogMessage[] logMessageArray = RemoteUiLogManager.this.myLock;
            synchronized (logMessageArray) {
                messages = RemoteUiLogManager.this.myPendingMessages.toArray(new LogMessage[0]);
                RemoteUiLogManager.this.myPendingMessages.clear();
            }
            for (LogMessage message : messages) {
                ConsoleView consoleView = message.myDescriptor.myRootDescriptor.getConsole(RemoteUiLogManager.this.myView);
                String indent = StringUtil.repeatSymbol((char)' ', (int)(2 * message.myDescriptor.myIndent));
                ConsoleViewContentType contentType = message.myError ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
                consoleView.print(indent + message.myText + "\n", contentType);
            }
        }

        public boolean canEat(Update update) {
            return update instanceof LogUpdate;
        }
    }

    private static class LogMessage {
        private LogBranchDescriptor myDescriptor;
        private String myText;
        private boolean myError;

        private LogMessage(LogBranchDescriptor descriptor, String text, boolean error) {
            this.myDescriptor = descriptor;
            this.myText = text;
            this.myError = error;
        }
    }

    private static class LogBranchDescriptor {
        private DevModeLogDescriptor myRootDescriptor;
        private int myIndent;

        private LogBranchDescriptor(DevModeLogDescriptor rootDescriptor, int indent) {
            this.myRootDescriptor = rootDescriptor;
            this.myIndent = indent;
        }
    }
}

