/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk.impl;

import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum GwtVersionImpl implements GwtVersion
{
    VERSION_1_0,
    VERSION_FROM_1_1_TO_1_3,
    VERSION_1_4,
    VERSION_1_5,
    VERSION_1_6,
    VERSION_2_0,
    VERSION_2_4,
    VERSION_2_5,
    VERSION_2_6,
    VERSION_2_7,
    VERSION_2_8;

    public static final GwtVersionImpl LATEST;
    @NonNls
    private static final String[] GWT_15_SAMPLE_TEMPLATES;
    @NonNls
    private static final String[] GWT_16_SAMPLE_TEMPLATES;
    @NonNls
    private static final String[] GWT_20_SAMPLE_TEMPLATES;
    @NonNls
    private static final String GWT_MODULE_OLD_DOCTYPE_FORMAT = "<!DOCTYPE module PUBLIC \"-//Google Inc.//DTD Google Web Toolkit ${VERSION}//EN\" \"http://google-web-toolkit.googlecode.com/svn/releases/${VERSION}/distro-source/core/src/gwt-module.dtd\">";
    @NonNls
    private static final String GWT_MODULE_NEW_DOCTYPE_FORMAT = "<!DOCTYPE module PUBLIC \"-//Google Inc.//DTD Google Web Toolkit ${VERSION}//EN\" \"http://gwtproject.org/doctype/${VERSION}/gwt-module.dtd\">";

    @Override
    @NotNull
    public String getGwtModuleHtmlTemplate() {
        String string = this.isAtLeast(VERSION_1_6) ? "GwtAppHtml_1_6.html" : (this.isAtLeast(VERSION_1_4) ? "GwtAppHtml_1_4.html" : "GwtAppHtml.html");
        if (string == null) {
            GwtVersionImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGwtServiceJavaTemplate() {
        String string = this == VERSION_1_0 ? "GwtAppService_1_0.java" : (this.isAtLeast(VERSION_1_5) ? "GwtAppService_1_5.java" : "GwtAppService.java");
        if (string == null) {
            GwtVersionImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGwtModuleXmlTemplate() {
        if (this.isAtLeast(VERSION_1_6)) {
            if ("GwtApp_1_6.gwt.xml" == null) {
                GwtVersionImpl.$$$reportNull$$$0(2);
            }
            return "GwtApp_1_6.gwt.xml";
        }
        if (this == VERSION_1_5) {
            if ("GwtApp_1_5.gwt.xml" == null) {
                GwtVersionImpl.$$$reportNull$$$0(3);
            }
            return "GwtApp_1_5.gwt.xml";
        }
        if ("GwtApp_1_4.gwt.xml" == null) {
            GwtVersionImpl.$$$reportNull$$$0(4);
        }
        return "GwtApp_1_4.gwt.xml";
    }

    public boolean isAtLeast(GwtVersionImpl another) {
        return this.compareTo(another) >= 0;
    }

    @Override
    @NotNull
    public String[] getGwtSampleAppTemplates() {
        String[] templates;
        String samplesVersion;
        if (this.isAtLeast(VERSION_2_0)) {
            samplesVersion = "20";
            templates = GWT_20_SAMPLE_TEMPLATES;
        } else if (this.isAtLeast(VERSION_1_6)) {
            samplesVersion = "16";
            templates = GWT_16_SAMPLE_TEMPLATES;
        } else {
            samplesVersion = "15";
            templates = GWT_15_SAMPLE_TEMPLATES;
        }
        String root = "/sampleApps/gwt" + samplesVersion + "/";
        String[] result = new String[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            result[i] = root + templates[i];
        }
        if (result == null) {
            GwtVersionImpl.$$$reportNull$$$0(5);
        }
        return result;
    }

    @Override
    public boolean isJavaIoSerializableSupported() {
        return this.isAtLeast(VERSION_1_4);
    }

    @Override
    public boolean isPrivateNoArgConstructorInSerializableClassAllowed() {
        return this.isAtLeast(VERSION_1_5);
    }

    @Override
    public boolean isGenericsSupported() {
        return this.isAtLeast(VERSION_1_5);
    }

    @Override
    public boolean isNewExpressionInJavaScriptSupported() {
        return this.isAtLeast(VERSION_1_5);
    }

    @Override
    public boolean isShortClassReferencesInJavaScriptSupported() {
        return this.isAtLeast(VERSION_2_7);
    }

    @Override
    public boolean isWildcardMethodReferencesInJavaScriptSupported() {
        return this.isAtLeast(VERSION_2_5);
    }

    @Override
    @NotNull
    public String getCompilerClassName() {
        String string = this.isAtLeast(VERSION_1_6) ? "com.google.gwt.dev.Compiler" : "com.google.gwt.dev.GWTCompiler";
        if (string == null) {
            GwtVersionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDevModeClass() {
        if (this.isAtLeast(VERSION_2_0)) {
            if ("com.google.gwt.dev.DevMode" == null) {
                GwtVersionImpl.$$$reportNull$$$0(7);
            }
            return "com.google.gwt.dev.DevMode";
        }
        String string = this.isAtLeast(VERSION_1_6) ? "com.google.gwt.dev.HostedMode" : "com.google.gwt.dev.GWTShell";
        if (string == null) {
            GwtVersionImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean isModulesToLoadSpecifiedInDevMode() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isHostedModeRequiresWebXml() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isHtmlFilesOutsideSourcesAreAllowed() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isEventHandlersSupported() {
        return this.isAtLeast(VERSION_1_6);
    }

    @Override
    public boolean isDevModeSupportsOutputStyleOption() {
        return !this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isOutOfProcessHostedModeSupported() {
        return this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isUseSystemIndependentGwtDevJar() {
        return this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isUiBinderSupported() {
        return this.isAtLeast(VERSION_2_0);
    }

    @Override
    public boolean isUiRendererSupported() {
        return this.isAtLeast(VERSION_2_5);
    }

    @Override
    public String getGwtModuleDocTypeString() {
        if (this.isAtLeast(VERSION_2_4)) {
            String version = this.isAtLeast(VERSION_2_8) ? "2.8.0" : (this.isAtLeast(VERSION_2_7) ? "2.7.0" : (this.isAtLeast(VERSION_2_6) ? "2.6.0" : (this.isAtLeast(VERSION_2_5) ? "2.5.0" : "2.4.0")));
            return StringUtil.replace((String)GWT_MODULE_NEW_DOCTYPE_FORMAT, (String)"${VERSION}", (String)version);
        }
        String version = this.isAtLeast(VERSION_2_0) ? "2.0" : "1.6";
        return StringUtil.replace((String)GWT_MODULE_OLD_DOCTYPE_FORMAT, (String)"${VERSION}", (String)version);
    }

    @Override
    public boolean isBrowserSupportedInDevMode(@NotNull BrowserFamily family) {
        if (family == null) {
            GwtVersionImpl.$$$reportNull$$$0(9);
        }
        return family != BrowserFamily.OPERA;
    }

    @Override
    public boolean isSuperDevModeSupported() {
        return this.isAtLeast(VERSION_2_5);
    }

    @Override
    public boolean isLegacyJarForNewSuperDevModeRequired() {
        return this.isAtLeast(VERSION_2_5) && !this.isAtLeast(VERSION_2_7);
    }

    @Override
    public boolean isSuperDevModeUsedByDefault() {
        return this.isAtLeast(VERSION_2_7);
    }

    @Override
    @NotNull
    public String getCompilerOutputDirParameterName() {
        String string = this.isAtLeast(VERSION_1_6) ? "-war" : "-out";
        if (string == null) {
            GwtVersionImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static GwtVersionImpl getDefaultVersion() {
        return VERSION_2_5;
    }

    @Override
    @NotNull
    public LanguageLevel getHighestSupportedLanguageLevel() {
        if (this.isAtLeast(VERSION_2_8)) {
            LanguageLevel languageLevel = LanguageLevel.JDK_1_8;
            if (languageLevel == null) {
                GwtVersionImpl.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        if (this.isAtLeast(VERSION_2_6)) {
            LanguageLevel languageLevel = LanguageLevel.JDK_1_7;
            if (languageLevel == null) {
                GwtVersionImpl.$$$reportNull$$$0(12);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.JDK_1_6;
        if (languageLevel == null) {
            GwtVersionImpl.$$$reportNull$$$0(13);
        }
        return languageLevel;
    }

    static {
        LATEST = VERSION_2_8;
        GWT_15_SAMPLE_TEMPLATES = new String[]{"java/client/App.java.ft", "java/client/AppService.java.ft", "java/client/AppServiceAsync.java.ft", "java/public/App.html.ft", "java/server/AppServiceImpl.java.ft", "java/App.gwt.xml.ft"};
        GWT_16_SAMPLE_TEMPLATES = new String[]{"java/client/App.java.ft", "java/client/AppService.java.ft", "java/client/AppServiceAsync.java.ft", "java/server/AppServiceImpl.java.ft", "java/App.gwt.xml.ft", "war/App.html.ft"};
        GWT_20_SAMPLE_TEMPLATES = new String[]{"java/client/App.java.ft", "java/client/AppService.java.ft", "java/client/AppServiceAsync.java.ft", "java/server/AppServiceImpl.java.ft", "java/App.gwt.xml.ft", "war/App.html.ft", "war/App.css.ft"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/sdk/impl/GwtVersionImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGwtModuleHtmlTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGwtServiceJavaTemplate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGwtModuleXmlTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGwtSampleAppTemplates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerClassName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevModeClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/sdk/impl/GwtVersionImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOutputDirParameterName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighestSupportedLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isBrowserSupportedInDevMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

