/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"parentAnyway", "Lorg/jetbrains/uast/UElement;", "getParentAnyway", "(Lorg/jetbrains/uast/UElement;)Lorg/jetbrains/uast/UElement;", "getIdentifierAnnotationOwner", "Lorg/jetbrains/uast/UDeclaration;", "identifier", "Lcom/intellij/psi/PsiElement;", "getNameElement", "uElement", "getUParentForAnnotationIdentifier", "isResolvedToAnnotation", "", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "intellij.platform.uast"})
@JvmName(name="UAnnotationUtils")
@ApiStatus.Experimental
public final class UAnnotationUtils {
    @Nullable
    public static final PsiElement getNameElement(@Nullable UElement uElement) {
        PsiElement psiElement;
        UElement uElement2 = uElement;
        if (uElement2 instanceof UAnnotation) {
            psiElement = UAnnotationKt.getNamePsiElement((UAnnotation)uElement);
        } else if (uElement2 instanceof USimpleNameReferenceExpression) {
            psiElement = uElement.getSourcePsi();
        } else if (uElement2 instanceof UCallExpression) {
            UIdentifier uIdentifier = ((UCallExpression)uElement).getMethodIdentifier();
            if (uIdentifier != null && (uIdentifier = uIdentifier.getSourcePsi()) != null) {
                UIdentifier uIdentifier2;
                UIdentifier it = uIdentifier2 = uIdentifier;
                psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)it);
            } else {
                psiElement = null;
            }
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    public static final UDeclaration getIdentifierAnnotationOwner(@NotNull PsiElement identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        UElement uElement = UAnnotationUtils.getUParentForAnnotationIdentifier(identifier);
        return uElement != null ? UDeclarationKt.getContainingDeclaration(uElement) : null;
    }

    @Nullable
    public static final UElement getUParentForAnnotationIdentifier(@NotNull PsiElement identifier) {
        UElement originalParent;
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        UElement uElement = UastUtils.getUParentForIdentifier(identifier);
        if (uElement == null) {
            return null;
        }
        UElement uElement2 = originalParent = uElement;
        if (uElement2 instanceof UAnnotation) {
            return originalParent;
        }
        if (uElement2 instanceof UCallExpression) {
            return UAnnotationUtils.isResolvedToAnnotation(((UCallExpression)originalParent).getClassReference()) ? originalParent : null;
        }
        if (uElement2 instanceof UReferenceExpression && UAnnotationUtils.isResolvedToAnnotation((UReferenceExpression)originalParent)) {
            UElement uElement3 = UAnnotationUtils.getParentAnyway(originalParent);
            if (uElement3 == null) {
                return null;
            }
            UElement parentAnyway2 = uElement3;
            UElement uElement4 = (UElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile(UElementKt.getWithContainingElements(parentAnyway2), (Function1)getUParentForAnnotationIdentifier.annotationLikeParent.1.INSTANCE));
            if (uElement4 == null) {
                return parentAnyway2;
            }
            UElement annotationLikeParent2 = uElement4;
            if (!(annotationLikeParent2 instanceof UAnnotation) && annotationLikeParent2.getUastParent() instanceof UAnnotation) {
                return annotationLikeParent2.getUastParent();
            }
            return annotationLikeParent2;
        }
        return null;
    }

    private static final boolean isResolvedToAnnotation(UReferenceExpression reference) {
        UReferenceExpression uReferenceExpression = reference;
        Object object = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
        if (!(object instanceof PsiClass)) {
            object = null;
        }
        PsiClass psiClass = (PsiClass)object;
        return psiClass != null && psiClass.isAnnotationType();
    }

    private static final UElement getParentAnyway(@NotNull UElement $receiver) {
        UElement uElement = $receiver.getUastParent();
        if (uElement == null) {
            PsiElement psiElement = $receiver.getSourcePsi();
            uElement = (UElement)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)(psiElement != null ? psiElement.getParent() : null), (Function1)parentAnyway.1.INSTANCE), (Function1)parentAnyway.2.INSTANCE));
        }
        return uElement;
    }
}

