/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.javascript.jest.coverage.JestCoverageEngine;
import com.intellij.javascript.testFramework.coverage.CoverageSerializationUtils;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(JestCoverageRunner.class);
    private String myWorkingDirectory;

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    @NotNull
    public static JestCoverageRunner getInstance() {
        JestCoverageRunner jestCoverageRunner = (JestCoverageRunner)((Object)ObjectUtils.assertNotNull((Object)CoverageRunner.getInstance(JestCoverageRunner.class)));
        if (jestCoverageRunner == null) {
            JestCoverageRunner.$$$reportNull$$$0(0);
        }
        return jestCoverageRunner;
    }

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            JestCoverageRunner.$$$reportNull$$$0(1);
        }
        File basePathDir = this.getBaseDir();
        try {
            return JestCoverageRunner.readProjectData(sessionDataFile, basePathDir);
        }
        catch (Exception e) {
            LOG.warn("Can't read coverage data", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private File getBaseDir() {
        String basePath = this.myWorkingDirectory;
        if (basePath != null) {
            File file2 = new File(basePath);
            if (file2 == null) {
                JestCoverageRunner.$$$reportNull$$$0(2);
            }
            return file2;
        }
        File file3 = new File(".");
        if (file3 == null) {
            JestCoverageRunner.$$$reportNull$$$0(3);
        }
        return file3;
    }

    @NotNull
    private static ProjectData readProjectData(@NotNull File dataFile, @NotNull File basePath) throws IOException {
        if (dataFile == null) {
            JestCoverageRunner.$$$reportNull$$$0(4);
        }
        if (basePath == null) {
            JestCoverageRunner.$$$reportNull$$$0(5);
        }
        ProjectData projectData = new ProjectData();
        LcovCoverageReport report = CoverageSerializationUtils.readLCOV((File)basePath, (File)dataFile);
        String targetBaseDir = JestCoverageRunner.dereferenceBasePath(basePath);
        for (Map.Entry entry : report.getInfo().entrySet()) {
            String filePath = (String)entry.getKey();
            ClassData classData = projectData.getOrCreateClassData(filePath);
            int max = 0;
            List lineHitsList = (List)entry.getValue();
            if (lineHitsList.size() > 0) {
                LcovCoverageReport.LineHits lastLineHits = (LcovCoverageReport.LineHits)lineHitsList.get(lineHitsList.size() - 1);
                max = lastLineHits.getLineNumber();
            }
            LineData[] lines = new LineData[max + 1];
            for (LcovCoverageReport.LineHits lineHits : lineHitsList) {
                LineData lineData = new LineData(lineHits.getLineNumber(), null);
                lineData.setHits(lineHits.getHits());
                lines[lineHits.getLineNumber()] = lineData;
            }
            classData.setLines(lines);
            if (targetBaseDir == null || !filePath.startsWith(targetBaseDir)) continue;
            File fileInsideBasePath = new File(basePath, filePath.substring(targetBaseDir.length()));
            ClassData classData2 = projectData.getOrCreateClassData(fileInsideBasePath.getAbsolutePath());
            classData2.setLines(lines);
        }
        ProjectData projectData2 = projectData;
        if (projectData2 == null) {
            JestCoverageRunner.$$$reportNull$$$0(6);
        }
        return projectData2;
    }

    @Nullable
    private static String dereferenceBasePath(@NotNull File file2) {
        if (file2 == null) {
            JestCoverageRunner.$$$reportNull$$$0(7);
        }
        String path = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        try {
            File canonicalFile = file2.getCanonicalFile();
            String canonicalPath = FileUtil.toSystemIndependentName((String)canonicalFile.getAbsolutePath());
            if (!canonicalPath.equals(path)) {
                return StringUtil.trimEnd((String)canonicalPath, (char)'/') + "/";
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to dereference " + path, (Throwable)e);
        }
        return null;
    }

    public String getPresentableName() {
        return "JestPresentableName";
    }

    public String getId() {
        return "JestJavaScriptTestRunnerCoverage";
    }

    public String getDataFileExtension() {
        return "dat";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            JestCoverageRunner.$$$reportNull$$$0(8);
        }
        return engine instanceof JestCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readProjectData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readProjectData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceBasePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

