/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class NpmRegistryServiceImpl
extends NpmRegistryService {
    private static final String USER_AGENT = "JetBrains IDE";
    private static final Logger LOG = Logger.getInstance(NpmRegistryServiceImpl.class);
    private static final String LATEST_DIST_TAG = "latest";
    private final ConcurrentMap<String, TimestampedDistTags> myDistTagsCache = ContainerUtil.createConcurrentSoftMap();
    private final ConcurrentMap<String, Future<DistTags>> myRunningFutures = ContainerUtil.newConcurrentMap();
    private final ExecutorService myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"npm registry pool", (int)2);

    @Override
    public void findPackagesByPrefix(@Nullable ProgressIndicator indicator, @NotNull String prefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) throws IOException, ProcessCanceledException {
        if (prefix == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String baseUrl = prefix.startsWith("@") ? "https://replicate.npmjs.com" : "https://skimdb.npmjs.com";
        HashSet all = ContainerUtil.newHashSet();
        int found = 0;
        int skip = 0;
        while (found < limit) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            int localLimit = limit - found;
            List<NodePackageBasicInfo> results = NpmRegistryServiceImpl.findPackagesOrWaitForIt(indicator, baseUrl, prefix, skip, localLimit);
            skip += localLimit;
            String duplicate = null;
            for (NodePackageBasicInfo info : results) {
                if (all.add(info.getName())) {
                    if (!filter.value((Object)info)) continue;
                    consumer.consume((Object)info);
                    ++found;
                    continue;
                }
                duplicate = info.getName();
            }
            if (results.size() < localLimit) break;
            if (duplicate == null) continue;
            LOG.warn("Duplicated package: " + duplicate + ", prefix: " + prefix + ". Stopping to preserve infinite loop.");
            break;
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> findPackagesOrWaitForIt(@Nullable ProgressIndicator indicator, @NotNull String baseUrl, @NotNull String prefix, int skip, int limit) throws IOException {
        if (baseUrl == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            List list;
            try {
                list = (List)ApplicationUtil.runWithCheckCanceled(() -> {
                    if (baseUrl == null) {
                        NpmRegistryServiceImpl.$$$reportNull$$$0(40);
                    }
                    if (prefix == null) {
                        NpmRegistryServiceImpl.$$$reportNull$$$0(41);
                    }
                    return NpmRegistryServiceImpl.doFetchPackages(indicator, baseUrl, prefix, skip, limit);
                }, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<NodePackageBasicInfo> list = NpmRegistryServiceImpl.doFetchPackages(indicator, baseUrl, prefix, skip, limit);
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> doFetchPackages(@Nullable ProgressIndicator indicator, @NotNull String baseUrl, @NotNull String prefix, int skip, int limit) throws IOException {
        List<NodePackageBasicInfo> list;
        if (baseUrl == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(8);
        }
        String startKey = "[\"" + prefix + "\"]";
        String endKey = "[\"" + prefix + "z\",{}]";
        String url = baseUrl + "/registry/_design/app/_view/browseAll?group_level=2&skip=" + skip + "&limit=" + limit + "&start_key=" + URLUtil.encodeURIComponent((String)startKey) + "&end_key=" + URLUtil.encodeURIComponent((String)endKey);
        try {
            long startNano = System.nanoTime();
            String content = HttpRequests.request((String)url).userAgent(USER_AGENT).readString(indicator);
            JsonReader reader = new JsonReader((Reader)new StringReader(content));
            List<NodePackageBasicInfo> infos = NpmRegistryServiceImpl.readPackages(reader);
            LOG.info("Found " + infos.size() + " packages matching '" + prefix + "*' in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms (" + url + ")");
            list = infos;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch packages for '" + prefix + "'", e);
        }
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> readPackages(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(10);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<NodePackageBasicInfo> list = Collections.emptyList();
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        reader.beginObject();
        List<NodePackageBasicInfo> packages = Collections.emptyList();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("rows".equals(name)) {
                packages = NpmRegistryServiceImpl.readPackagesInsideRows(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        List<NodePackageBasicInfo> list = packages;
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> readPackagesInsideRows(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(13);
        }
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            List<NodePackageBasicInfo> list = Collections.emptyList();
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        reader.beginArray();
        ArrayList infos = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            NodePackageBasicInfo info = NpmRegistryServiceImpl.readSinglePackage(reader);
            if (info == null) continue;
            infos.add(info);
        }
        reader.endArray();
        ArrayList arrayList = infos;
        if (arrayList == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static NodePackageBasicInfo readSinglePackage(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(16);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        NodePackageBasicInfo info = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("key".equals(name)) {
                info = NpmRegistryServiceImpl.readArrayInsideKey(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return info;
    }

    @Nullable
    private static NodePackageBasicInfo readArrayInsideKey(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(17);
        }
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            return null;
        }
        reader.beginArray();
        String name = null;
        String description = null;
        int i = 0;
        while (reader.hasNext()) {
            if (i < 2 && reader.peek() == JsonToken.STRING) {
                String str = reader.nextString();
                if (i == 0) {
                    name = str;
                } else {
                    description = str;
                }
            } else {
                reader.skipValue();
            }
            ++i;
        }
        reader.endArray();
        return name != null ? new NodePackageBasicInfo(name, description) : null;
    }

    @Override
    @Nullable
    public List<Pair<String, SemVer>> getCachedPackageDistTags(@NotNull String packageName) {
        TimestampedDistTags cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(18);
        }
        if ((cache = (TimestampedDistTags)this.myDistTagsCache.get(packageName)) != null && cache.getCreateTimeNano() + TimeUnit.MINUTES.toNanos(10L) > System.nanoTime()) {
            DistTags tags = cache.getDistTags();
            return tags != null ? tags.getList() : Collections.emptyList();
        }
        return null;
    }

    @Override
    public void asyncUpdatePackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(19);
        }
        this.getOrCreateDistTagsFetchFuture(packageName);
    }

    @Override
    @NotNull
    public Promise<List<Pair<String, SemVer>>> asyncUpdateAndGetPackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(20);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (packageName == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(39);
            }
            Future<DistTags> future = this.getOrCreateDistTagsFetchFuture(packageName);
            try {
                DistTags distTags = future.get();
                promise.setResult(distTags.getList());
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(21);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public List<Pair<String, SemVer>> getCachedOrFetchPackageDistTags(@NotNull String packageName, @Nullable ProgressIndicator indicator) {
        List<Pair<String, SemVer>> cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(22);
        }
        if ((cache = this.getCachedPackageDistTags(packageName)) != null) {
            List<Pair<String, SemVer>> list = cache;
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(23);
            }
            return list;
        }
        Future<DistTags> future = this.getOrCreateDistTagsFetchFuture(packageName);
        DistTags distTags = null;
        if (indicator == null) {
            try {
                distTags = future.get();
            }
            catch (Exception exception) {}
        } else {
            while (true) {
                try {
                    distTags = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (!indicator.isCanceled()) continue;
                    List<Pair<String, SemVer>> list = Collections.emptyList();
                    if (list == null) {
                        NpmRegistryServiceImpl.$$$reportNull$$$0(24);
                    }
                    return list;
                }
                catch (Exception e) {
                    // empty catch block
                }
                break;
            }
        }
        this.myDistTagsCache.put(packageName, new TimestampedDistTags(distTags));
        List<Object> list = distTags != null ? distTags.getList() : Collections.emptyList();
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private Future<DistTags> getOrCreateDistTagsFetchFuture(@NotNull String packageName) {
        FutureTask<DistTags> newFuture;
        Future running;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(26);
        }
        if ((running = (Future)this.myRunningFutures.putIfAbsent(packageName, newFuture = new FutureTask<DistTags>(() -> {
            if (packageName == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(38);
            }
            DistTags tags = NpmRegistryServiceImpl.fetchPackageDistTags(packageName);
            this.myDistTagsCache.put(packageName, new TimestampedDistTags(tags));
            this.myRunningFutures.remove(packageName);
            return tags;
        }))) != null) {
            Future future = running;
            if (future == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(27);
            }
            return future;
        }
        this.myExecutorService.submit(newFuture);
        FutureTask<DistTags> futureTask = newFuture;
        if (futureTask == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(28);
        }
        return futureTask;
    }

    @Nullable
    private static DistTags fetchPackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(29);
        }
        String packagePath = packageName.startsWith("@") ? "@" + URLUtil.encodeURIComponent((String)packageName.substring(1)) : URLUtil.encodeURIComponent((String)packageName);
        String url = "http://registry.npmjs.org/" + packagePath;
        long startNano = System.nanoTime();
        try {
            RequestBuilder builder = HttpRequests.request((String)url);
            builder.userAgent(USER_AGENT);
            builder.accept("application/vnd.npm.install-v1+json; q=1.0, application/json; q=0.8, */*");
            builder.gzip(true);
            String content = builder.readString(null);
            JsonReader reader = new JsonReader((Reader)new StringReader(content));
            List<Pair<String, SemVer>> distTags = NpmRegistryServiceImpl.readDistTagsFromPackageMetadata(reader);
            reader.close();
            NpmRegistryServiceImpl.sortDistTags(distTags);
            LOG.info("Found " + distTags.size() + " dist-tags for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
            return new DistTags(distTags);
        }
        catch (Exception e) {
            LOG.info("Failed to fetch dist-tags from " + url, (Throwable)e);
            return null;
        }
    }

    private static void sortDistTags(@NotNull List<Pair<String, SemVer>> distTags) {
        if (distTags == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(30);
        }
        Collections.sort(distTags, (d1, d2) -> {
            String name1 = (String)d1.getFirst();
            String name2 = (String)d2.getFirst();
            if (LATEST_DIST_TAG.equals(name1) != LATEST_DIST_TAG.equals(name2)) {
                return LATEST_DIST_TAG.equals(name1) ? -1 : 1;
            }
            return -1 * ((SemVer)d1.getSecond()).compareTo((SemVer)d2.getSecond());
        });
    }

    @NotNull
    private static List<Pair<String, SemVer>> readDistTagsFromPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(31);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<Pair<String, SemVer>> list = Collections.emptyList();
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(32);
            }
            return list;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("dist-tags".equals(name)) {
                List<Pair<String, SemVer>> list = NpmRegistryServiceImpl.readDistTags(reader);
                if (list == null) {
                    NpmRegistryServiceImpl.$$$reportNull$$$0(33);
                }
                return list;
            }
            reader.skipValue();
        }
        reader.endObject();
        List<Pair<String, SemVer>> list = Collections.emptyList();
        if (list == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    private static List<Pair<String, SemVer>> readDistTags(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(35);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<Pair<String, SemVer>> list = Collections.emptyList();
            if (list == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(36);
            }
            return list;
        }
        reader.beginObject();
        ArrayList distTags = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String distTagName = reader.nextName();
            String versionStr = reader.nextString();
            SemVer version = SemVer.parseFromText((String)versionStr);
            if (version == null) {
                LOG.info("Cannot parse dist-tag version from " + versionStr);
                continue;
            }
            distTags.add(Pair.create((Object)distTagName, (Object)version));
        }
        reader.endObject();
        ArrayList arrayList = distTags;
        if (arrayList == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 7: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 29: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackagesOrWaitForIt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchPackages";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackages";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackagesInsideRows";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncUpdateAndGetPackageDistTags";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOrFetchPackageDistTags";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDistTagsFetchFuture";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "readDistTagsFromPackageMetadata";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "readDistTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesByPrefix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesOrWaitForIt";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFetchPackages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readPackages";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readPackagesInsideRows";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readSinglePackage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readArrayInsideKey";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPackageDistTags";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdatePackageDistTags";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateAndGetPackageDistTags";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrFetchPackageDistTags";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDistTagsFetchFuture";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDistTags";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sortDistTags";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readDistTagsFromPackageMetadata";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readDistTags";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateDistTagsFetchFuture$2";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$asyncUpdateAndGetPackageDistTags$1";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findPackagesOrWaitForIt$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DistTags {
        private final List<Pair<String, SemVer>> myList;

        public DistTags(@NotNull List<Pair<String, SemVer>> list) {
            if (list == null) {
                DistTags.$$$reportNull$$$0(0);
            }
            this.myList = list;
        }

        @NotNull
        public List<Pair<String, SemVer>> getList() {
            List<Pair<String, SemVer>> list = this.myList;
            if (list == null) {
                DistTags.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$DistTags";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$DistTags";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TimestampedDistTags {
        private final long myCreateTimeNano;
        private final DistTags myDistTags;

        private TimestampedDistTags(@Nullable DistTags distTags) {
            this.myDistTags = distTags;
            this.myCreateTimeNano = System.nanoTime();
        }

        public long getCreateTimeNano() {
            return this.myCreateTimeNano;
        }

        @Nullable
        public DistTags getDistTags() {
            return this.myDistTags;
        }
    }
}

