/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageManagerUtil {
    public static final String NPM_PACKAGE_NAME = "npm";
    public static final String YARN_PACKAGE_NAME = "yarn";
    public static final String YARN_LOCK_FILENAME = "yarn.lock";
    public static final String PACKAGE_MANAGER_LABEL = "Package &manager:";
    public static final String PROJECT_PACKAGE_MANAGER_REFERENCE_NAME = "Project";
    public static final NodePackageDescriptor DESCRIPTOR = new NpmPackageDescriptor(false);
    private static final String NPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "npm-cli.js";
    private static final NodePackageRefResolver RESOLVER = new NodePackageRefResolver(null, DESCRIPTOR, null);

    private NodePackageManagerUtil() {
    }

    @NotNull
    public static NodePackageRef createProjectPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = NodePackageRef.create(PROJECT_PACKAGE_MANAGER_REFERENCE_NAME);
        if (nodePackageRef == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(0);
        }
        return nodePackageRef;
    }

    public static boolean isProjectPackageManagerPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(1);
        }
        return PROJECT_PACKAGE_MANAGER_REFERENCE_NAME.equals(packageRef.getReferenceName());
    }

    @NotNull
    public static NodePackageField createPackageManagerPackageField(@NotNull NodeJsInterpreterField interpreterField, boolean projectField) {
        if (interpreterField == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(2);
        }
        NodePackageField nodePackageField = new NodePackageField(interpreterField, new NpmPackageDescriptor(projectField), null);
        if (nodePackageField == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(3);
        }
        return nodePackageField;
    }

    @NotNull
    public static String getValidNpmCliJsFilePath(@NotNull NodePackage packageManagerPkg) throws ExecutionException {
        String npmPackageDirPath;
        if (packageManagerPkg == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(npmPackageDirPath = packageManagerPkg.getSystemIndependentPath()))) {
            throw new ExecutionException("Please specify npm or yarn package");
        }
        File npmPackageDir = new File(npmPackageDirPath);
        if (!npmPackageDir.isAbsolute() || !npmPackageDir.isDirectory()) {
            throw new ExecutionException("Please correct path to npm or yarn package: no such directory \"" + npmPackageDirPath + "\"");
        }
        if (NodePackageManagerUtil.isYarnAlikePackage(packageManagerPkg)) {
            String string = NodePackageManagerUtil.findValidFile(npmPackageDir, "bin" + File.separator + "yarn.js");
            if (string == null) {
                NodePackageManagerUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = NodePackageManagerUtil.findValidFile(npmPackageDir, NPM_CLI_JS_RELATIVE_PATH);
        if (string == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean isYarnAlikePackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(7);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return NodePackageManagerUtil.isYarnAlikePackage(pkg);
        }
        return StringUtil.containsIgnoreCase((String)Objects.requireNonNull(packageManagerPkgRef.getReferenceName()), (String)YARN_PACKAGE_NAME);
    }

    public static boolean isYarnAlikePackage(@NotNull NodePackage packageManagerPkg) {
        String packageName;
        if (packageManagerPkg == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(8);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = PathUtil.getFileName((String)packageManagerPkg.getSystemIndependentPath())), (String)YARN_PACKAGE_NAME)) {
            return true;
        }
        return "libexec".equals(packageName) && packageManagerPkg.getSystemIndependentPath().contains(YARN_PACKAGE_NAME);
    }

    @NotNull
    private static String findValidFile(@NotNull File packageDir, @NotNull String relativePath) throws ExecutionException {
        File mainJsFile;
        if (packageDir == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(9);
        }
        if (relativePath == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(10);
        }
        if (!(mainJsFile = new File(packageDir, relativePath)).isFile()) {
            throw new ExecutionException("Please specify npm or yarn package: cannot find \"" + relativePath + "\" inside \"" + packageDir + "\" directory");
        }
        String string = mainJsFile.getAbsolutePath();
        if (string == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static NodePackage resolveRef(@NotNull NodePackageRef ref, @NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        if (ref == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            NodePackageManagerUtil.$$$reportNull$$$0(13);
        }
        return RESOLVER.resolve(DESCRIPTOR.dereferenceIfProjectRef(project, ref), interpreter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageManagerUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkg";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkgRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectPackageManagerPackageRef";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageManagerUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageManagerPackageField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidNpmCliJsFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findValidFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProjectPackageManagerPackageRef";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPackageManagerPackageField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValidNpmCliJsFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackageRef";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findValidFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NpmPackageDescriptor
    extends NodePackageDescriptor {
        private final boolean myProjectField;

        public NpmPackageDescriptor(boolean projectField) {
            super(NodePackageManagerUtil.NPM_PACKAGE_NAME, NodePackageManagerUtil.YARN_PACKAGE_NAME);
            this.myProjectField = projectField;
        }

        @Override
        @NotNull
        public NodePackageRef createPackageRef(@NotNull String text) {
            if (text == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(0);
            }
            if (this.getPackageNames().contains(text) || NodePackageManagerUtil.PROJECT_PACKAGE_MANAGER_REFERENCE_NAME.equals(text)) {
                NodePackageRef nodePackageRef = NodePackageRef.create(text);
                if (nodePackageRef == null) {
                    NpmPackageDescriptor.$$$reportNull$$$0(1);
                }
                return nodePackageRef;
            }
            NodePackageRef nodePackageRef = super.createPackageRef(text);
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(2);
            }
            return nodePackageRef;
        }

        @Override
        @NotNull
        public NodePackageRef dereferenceIfProjectRef(@NotNull Project project, @NotNull NodePackageRef ref) {
            if (project == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(3);
            }
            if (ref == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(4);
            }
            if (NodePackageManagerUtil.isProjectPackageManagerPackageRef(ref)) {
                NodePackageRef nodePackageRef = NpmManager.getInstance(project).getPackageRef();
                if (nodePackageRef == null) {
                    NpmPackageDescriptor.$$$reportNull$$$0(5);
                }
                return nodePackageRef;
            }
            NodePackageRef nodePackageRef = ref;
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(6);
            }
            return nodePackageRef;
        }

        @Override
        @NotNull
        public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
            if (project == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(7);
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            if (!this.myProjectField) {
                result2.add(NodePackageManagerUtil.createProjectPackageManagerPackageRef());
            }
            for (String pkgName : this.getPackageNames()) {
                result2.add(NodePackageRef.create(pkgName));
            }
            List<NodePackageRef> refs = super.listPackageRefs(project, null, contextFileOrDirectory);
            result2.addAll(refs);
            ArrayList arrayList = result2;
            if (arrayList == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageManagerUtil$NpmPackageDescriptor";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageManagerUtil$NpmPackageDescriptor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPackageRef";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dereferenceIfProjectRef";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listPackageRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPackageRef";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "dereferenceIfProjectRef";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "listPackageRefs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

