/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.Location;
import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.javascript.protractor.ProtractorConfigurationType;
import com.intellij.javascript.protractor.ProtractorRunConfiguration;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunConfigurationProducer
extends CompatibleRunConfigurationProducer<ProtractorRunConfiguration> {
    protected ProtractorRunConfigurationProducer() {
        super((ConfigurationType)ProtractorConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        JSFile jsFile;
        if (configuration == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((jsFile = ProtractorRunConfigurationProducer.getConfigJsFile(context.getLocation())) == null) {
            return false;
        }
        VirtualFile configVirtualFile = jsFile.getVirtualFile();
        if (configVirtualFile == null) {
            return false;
        }
        sourceElement.set((Object)jsFile);
        ProtractorRunConfigurationProducer.setupProtractorConfiguration(configuration, configVirtualFile);
        return true;
    }

    private static void setupProtractorConfiguration(@NotNull ProtractorRunConfiguration configuration, @NotNull VirtualFile config2) {
        if (configuration == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (config2 == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        configuration.setConfigFile(config2);
        String name = configuration.suggestedName();
        configuration.setName(name);
    }

    public boolean isConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context) {
        VirtualFile contextConfigVirtualFile;
        if (configuration == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if ((contextConfigVirtualFile = ProtractorRunConfigurationProducer.getFileFromContext(context)) == null) {
            return false;
        }
        String contextConfigFilePath = FileUtil.toSystemDependentName((String)contextConfigVirtualFile.getPath());
        String candidateConfigFilePath = configuration.getRunSettings().getConfigFileSystemDependentPath();
        return contextConfigFilePath.equals(candidateConfigFilePath);
    }

    @Nullable
    private static VirtualFile getFileFromContext(@Nullable ConfigurationContext context) {
        if (context == null) {
            return null;
        }
        PsiFile file2 = ProtractorRunConfigurationProducer.getPsiFile(context.getLocation());
        return file2 != null ? file2.getVirtualFile() : null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Location location) {
        return location != null ? location.getPsiElement().getContainingFile() : null;
    }

    @Nullable
    private static JSFile getConfigJsFile(@Nullable Location location) {
        PsiFile file2 = ProtractorRunConfigurationProducer.getPsiFile(location);
        if (file2 instanceof JSFile && ProtractorUtil.isProtractorConfigFile(file2.getName())) {
            return (JSFile)file2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromCompatibleContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setupProtractorConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromCompatibleContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

