/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.InjectorMatchingEndFinder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInjectionBracesUtil {
    public static final String DEFAULT_START = "{{";
    public static final String DEFAULT_END = "}}";
    public static final String START_SYMBOL_KEY = "startSymbol";
    public static final String END_SYMBOL_KEY = "endSymbol";
    private static final Set<String> DEFAULT_CONFLICTS = ContainerUtil.set((Object[])new String[]{"DjangoTemplate", "Jinja2", "Web2Py", "Handlebars", "Twig", "Blade", "AngularJS", "VueJS"});
    private static final Set<String> FORBIDDEN_SYMBOLS = ContainerUtil.set((Object[])new String[]{"//", "/*", "*/", "{", "}", "/", "\\", "[", "]", "(", ")", ";", "'", "\"", "`", ".", ",", ":", ";", "!", "+", "-", "*", "%", "^", "~", "&", "|", "=", "<=", ">=", "<", ">", "?", "==", "!="});

    private static boolean hasConflicts(@NotNull String start, @NotNull String end, @NotNull PsiElement element, @NotNull Set<String> otherLanguages, @NotNull String selfLanguageName) {
        Language elementLanguage;
        if (start == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(0);
        }
        if (end == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(2);
        }
        if (otherLanguages == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(3);
        }
        if (selfLanguageName == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(4);
        }
        if ("JSP".equals((elementLanguage = element.getLanguage()).getDisplayName())) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        if (DEFAULT_START.equals(start) || DEFAULT_END.equals(end)) {
            if (!selfLanguageName.equals(elementLanguage.getDisplayName()) && elementLanguage.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                return true;
            }
            for (Language language : file2.getViewProvider().getLanguages()) {
                if (!otherLanguages.contains(language.getDisplayName())) continue;
                return true;
            }
        }
        return false;
    }

    public static NullableFunction<PsiElement, Pair<String, String>> delimitersFactory(@NotNull String languageName, @NotNull PairFunction<Project, String, Pair<String, PsiElement>> provider2) {
        if (languageName == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(5);
        }
        if (provider2 == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(6);
        }
        Key startKey = Key.create((String)(languageName + "." + START_SYMBOL_KEY));
        Key endKey = Key.create((String)(languageName + "." + END_SYMBOL_KEY));
        HashSet<String> otherLanguages = new HashSet<String>(DEFAULT_CONFLICTS);
        otherLanguages.remove(languageName);
        return element -> {
            Project project;
            Pair result2;
            if (provider2 == null) {
                JSInjectionBracesUtil.$$$reportNull$$$0(18);
            }
            if (languageName == null) {
                JSInjectionBracesUtil.$$$reportNull$$$0(19);
            }
            if (JSInjectionBracesUtil.hasConflicts((String)(result2 = Pair.create((Object)JSInjectionBracesUtil.getInjectionDelimiter(project = element.getProject(), (Key<CachedValue<String>>)startKey, provider2, DEFAULT_START), (Object)JSInjectionBracesUtil.getInjectionDelimiter(project, (Key<CachedValue<String>>)endKey, provider2, DEFAULT_END))).getFirst(), (String)result2.getSecond(), element, otherLanguages, languageName)) {
                return null;
            }
            return result2;
        };
    }

    private static String getInjectionDelimiter(@NotNull Project project, Key<CachedValue<String>> key, @NotNull PairFunction<Project, String, Pair<String, PsiElement>> provider2, @NotNull String defaultDelimiter) {
        if (project == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(7);
        }
        if (provider2 == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(8);
        }
        if (defaultDelimiter == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(9);
        }
        return (String)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> {
            String id;
            Pair delimiter;
            if (provider2 == null) {
                JSInjectionBracesUtil.$$$reportNull$$$0(15);
            }
            if (project == null) {
                JSInjectionBracesUtil.$$$reportNull$$$0(16);
            }
            if (defaultDelimiter == null) {
                JSInjectionBracesUtil.$$$reportNull$$$0(17);
            }
            if ((delimiter = (Pair)provider2.fun((Object)project, (Object)(id = key.toString()).substring(id.lastIndexOf(".") + 1))) != null && !StringUtil.isEmptyOrSpaces((String)((String)delimiter.getFirst())) && !FORBIDDEN_SYMBOLS.contains(delimiter.getFirst())) {
                return CachedValueProvider.Result.create((Object)delimiter.getFirst(), (Object[])new Object[]{delimiter.getSecond()});
            }
            return CachedValueProvider.Result.create((Object)defaultDelimiter, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootModificationTracker.getInstance((Project)project)});
        }, false);
    }

    public static void injectInXmlTextByDelimiters(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context, @NotNull Language language, @NotNull String start, @NotNull String end) {
        if (registrar == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(10);
        }
        if (context == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(11);
        }
        if (language == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(12);
        }
        if (start == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(13);
        }
        if (end == null) {
            JSInjectionBracesUtil.$$$reportNull$$$0(14);
        }
        assert (!StringUtil.isEmptyOrSpaces((String)start));
        assert (!StringUtil.isEmptyOrSpaces((String)end));
        if (!context.textContains(start.charAt(0))) {
            return;
        }
        String text = context.getText();
        int previousSearchStart = -1;
        int searchStart = 0;
        while (searchStart > previousSearchStart && searchStart < text.length()) {
            previousSearchStart = searchStart;
            int startIdx = text.indexOf(start, searchStart);
            if (startIdx < 0) {
                return;
            }
            int endIndex = InjectorMatchingEndFinder.findMatchingEnd((String)start, (String)end, (String)text, (int)(startIdx += start.length()));
            endIndex = endIndex > 0 ? endIndex : ElementManipulators.getValueTextRange((PsiElement)context).getEndOffset();
            searchStart = Math.max(endIndex + 1, startIdx);
            if (startIdx >= endIndex) continue;
            PsiElement injectionCandidate = context.findElementAt(startIdx);
            while (injectionCandidate instanceof PsiWhiteSpace) {
                injectionCandidate = injectionCandidate.getNextSibling();
            }
            if (injectionCandidate == null || injectionCandidate.getStartOffsetInParent() > endIndex || XmlTokenType.COMMENTS.contains(injectionCandidate.getNode().getElementType()) || injectionCandidate.getNode().getElementType() == XmlElementType.XML_COMMENT || injectionCandidate instanceof OuterLanguageElement) continue;
            registrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(startIdx, endIndex)).doneInjecting();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherLanguages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfLanguageName";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageName";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDelimiter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/JSInjectionBracesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConflicts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "delimitersFactory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectionDelimiter";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "injectInXmlTextByDelimiters";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getInjectionDelimiter$1";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$delimitersFactory$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class InterpolationBracesCompleter {
        private static final int MAX_FORWARD_LOOKUP = 100;
        private final NullableFunction<PsiElement, Pair<String, String>> myDelimitersFactory;

        public InterpolationBracesCompleter(NullableFunction<PsiElement, Pair<String, String>> factory) {
            this.myDelimitersFactory = factory;
        }

        public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file2) {
            if (file2.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider || DumbService.isDumb((Project)project)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (!(file2.getFileType() instanceof LanguageFileType && ((LanguageFileType)file2.getFileType()).getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (!this.checkTypingContext(editor, file2)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            Pair braces = (Pair)this.myDelimitersFactory.fun((Object)file2);
            if (braces == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            String start = (String)braces.getFirst();
            String end = (String)braces.getSecond();
            if (InterpolationBracesCompleter.startMatches(start, c, editor)) {
                if (InterpolationBracesCompleter.alreadyHasEnding(start, end, editor)) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                InterpolationBracesCompleter.insertWithEndCompletion(c, editor, file2, start, end);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (InterpolationBracesCompleter.handleEndDelimiter(start, end, c, editor)) {
                return TypedHandlerDelegate.Result.STOP;
            }
            return TypedHandlerDelegate.Result.CONTINUE;
        }

        protected boolean checkTypingContext(@NotNull Editor editor, @NotNull PsiFile file2) {
            PsiElement atCaret;
            if (editor == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(1);
            }
            return (atCaret = InterpolationBracesCompleter.getContextElement(editor, file2)) == null || atCaret instanceof XmlElement;
        }

        @Nullable
        protected static PsiElement getContextElement(@NotNull Editor editor, @NotNull PsiFile file2) {
            PsiElement atCaret;
            if (editor == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(3);
            }
            atCaret = (atCaret = file2.findElementAt(editor.getCaretModel().getCurrentCaret().getOffset())) instanceof XmlElement || atCaret == null ? atCaret : PsiTreeUtil.findFirstParent((PsiElement)atCaret, element -> !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment));
            return atCaret;
        }

        private static void insertWithEndCompletion(char c, Editor editor, PsiFile file2, String start, String end) {
            String interpolation;
            int caretBackOffset = end.length();
            if (JSCodeStyleSettings.getSettings((PsiElement)file2).SPACES_WITHIN_INTERPOLATION_EXPRESSIONS) {
                interpolation = String.valueOf(c) + "  " + end;
                ++caretBackOffset;
            } else {
                interpolation = start.length() == 1 ? end : String.valueOf(c) + end;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)interpolation, (boolean)true, (int)(interpolation.length() - caretBackOffset));
        }

        private static boolean alreadyHasEnding(@NotNull String start, @NotNull String end, @NotNull Editor editor) {
            int offset;
            int i;
            if (start == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(4);
            }
            if (end == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(5);
            }
            if (editor == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(6);
            }
            HashSet stopChars = ContainerUtil.newHashSet((int)(start.length() + end.length() + 1));
            stopChars.add(Character.valueOf('\n'));
            InterpolationBracesCompleter.addChars(start, stopChars);
            InterpolationBracesCompleter.addChars(end, stopChars);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            for (i = offset = editor.getCaretModel().getOffset(); i < sequence.length() && i < offset + 100 && !stopChars.contains(Character.valueOf(sequence.charAt(i))); ++i) {
            }
            if (i + end.length() > sequence.length()) {
                return false;
            }
            return end.contentEquals(sequence.subSequence(i, i + end.length()));
        }

        private static void addChars(@NotNull String start, Set<Character> stopChars) {
            if (start == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(7);
            }
            for (int i = 0; i < start.length(); ++i) {
                stopChars.add(Character.valueOf(start.charAt(i)));
            }
        }

        public static boolean handleEndDelimiter(String start, String end, char typedChar, @NotNull Editor editor) {
            int partLength;
            if (editor == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(8);
            }
            if (StringUtil.isEmptyOrSpaces((String)end) || end.length() > 3) {
                return false;
            }
            if (!end.contains(String.valueOf(typedChar))) {
                return false;
            }
            boolean sameDelimiters = start.equals(end);
            int offset = editor.getCaretModel().getOffset();
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if (!sameDelimiters && !StringUtil.contains((CharSequence)sequence.subSequence(Math.max(0, offset - 100), offset), (CharSequence)start)) {
                return false;
            }
            for (partLength = end.length(); !(partLength <= 0 || offset >= partLength && end.substring(0, partLength).contentEquals(sequence.subSequence(offset - partLength, offset))); --partLength) {
            }
            if (partLength == end.length()) {
                if (sameDelimiters && offset < sequence.length() && sequence.charAt(offset) == typedChar && end.charAt(0) == typedChar) {
                    editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                    return true;
                }
                return false;
            }
            if (typedChar == end.charAt(partLength)) {
                if (offset < sequence.length() && sequence.charAt(offset) == typedChar) {
                    editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                    return true;
                }
                String delimiterPart = end.substring(partLength, end.length());
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)delimiterPart, (boolean)true, (int)delimiterPart.length());
                return true;
            }
            return false;
        }

        public static boolean startMatches(String start, char typedChar, @NotNull Editor editor) {
            if (editor == null) {
                InterpolationBracesCompleter.$$$reportNull$$$0(9);
            }
            if (StringUtil.isEmptyOrSpaces((String)start)) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if (start.charAt(start.length() - 1) != typedChar) {
                return false;
            }
            if (start.length() == 1) {
                return offset <= 0 || sequence.charAt(offset - 1) != start.charAt(0);
            }
            if (offset < start.length() - 1) {
                return false;
            }
            return start.substring(0, start.length() - 1).contentEquals(sequence.subSequence(offset - start.length() + 1, offset));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "start";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "end";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/JSInjectionBracesUtil$InterpolationBracesCompleter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkTypingContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContextElement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "alreadyHasEnding";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChars";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleEndDelimiter";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startMatches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

