/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.javascript.buildTools.TreeCellHyperlink;
import com.intellij.lang.javascript.buildTools.TreeCellHyperlinkSupport;
import com.intellij.lang.javascript.buildTools.base.JsbtExecutor;
import com.intellij.lang.javascript.buildTools.base.JsbtFileListener;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtPersistentPath;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListingFailUtil;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayout;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayoutManager;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeUiState;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtTaskTreeView
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JsbtTaskTreeView.class);
    private static final String ROOT = "<root>";
    private final Project myProject;
    private final JsbtService myService;
    private final String myLayoutPlace;
    private final JsbtFileManager myBuildfileManager;
    private final DefaultMutableTreeNode myTreeRoot;
    private final DefaultTreeModel myTreeModel;
    private final Tree myTree;
    private final MyJsbtFileListener myListener;
    private int myActiveTaskReloadCount;
    private final CopyOnWriteArrayList<Runnable> myActionCallbacks;

    public JsbtTaskTreeView(@NotNull JsbtService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(1);
        }
        this.myActiveTaskReloadCount = 0;
        this.myActionCallbacks = ContainerUtil.createEmptyCOWList();
        this.myProject = project;
        this.myService = service;
        this.myLayoutPlace = layoutPlace;
        this.myBuildfileManager = this.myService.getFileManager(project);
        this.myTreeRoot = new DefaultMutableTreeNode(ROOT, true);
        this.myTreeModel = new DefaultTreeModel(this.myTreeRoot, false);
        this.myTree = new JsbtTree(this.myTreeModel);
        this.myListener = new MyJsbtFileListener();
    }

    public void init() {
        this.myTree.setExpandsSelectedPaths(true);
        this.myTree.getEmptyText().setText(this.getEmptyText());
        this.myTree.setToggleClickCount(0);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new JsbtTreeCellRenderer()));
        this.myTree.setRootVisible(false);
        TreeUtil.expandAll((JTree)this.myTree);
        this.installSpeedSearch(this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.installUpDownCycleScrollingInPopups();
        this.installPopupActions();
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
        this.myBuildfileManager.addListener(this.myListener, null);
        for (VirtualFile buildfile : this.myBuildfileManager.getBuildfiles()) {
            this.addBuildfile(buildfile);
        }
        this.restoreLayout();
        new UiNotifyConnector((Component)this.myTree, new Activatable(){
            private boolean myShowing = false;
            private boolean mySkipCached = false;

            public void showNotify() {
                if (!this.myShowing) {
                    JsbtTaskTreeView.this.reloadTasksForAllBuildfiles(true, this.mySkipCached);
                    this.myShowing = true;
                }
                this.mySkipCached = true;
            }

            public void hideNotify() {
                this.myShowing = false;
            }
        });
    }

    private void installUpDownCycleScrollingInPopups() {
        if (this.myLayoutPlace == null || !UISettings.getShadowInstance().getCycleScrolling()) {
            return;
        }
        this.myTree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path;
                int size = JsbtTaskTreeView.this.myTree.getRowCount();
                int row = JsbtTaskTreeView.this.myTree.getLeadSelectionRow();
                if (size <= 1 || row > 0) {
                    TreeUtil.moveUp((JTree)JsbtTaskTreeView.this.myTree);
                } else if (row == 0 && (path = JsbtTaskTreeView.this.myTree.getPathForRow(size - 1)) != null) {
                    TreeUtil.selectPath((JTree)JsbtTaskTreeView.this.myTree, (TreePath)path);
                }
            }
        });
        this.myTree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = JsbtTaskTreeView.this.myTree.getRowCount();
                int row = JsbtTaskTreeView.this.myTree.getLeadSelectionRow();
                if (size <= 1 || row < size - 1) {
                    TreeUtil.moveDown((JTree)JsbtTaskTreeView.this.myTree);
                } else {
                    TreeUtil.selectFirstNode((JTree)JsbtTaskTreeView.this.myTree);
                }
            }
        });
    }

    @NotNull
    private String getEmptyText() {
        Shortcut shortcut = JsbtAddBuildfileAction.getKeyboardShortcut();
        if (shortcut != null) {
            String string = "Add " + this.myService.getBuildfileCommonName() + " with " + KeymapUtil.getShortcutText((Shortcut)shortcut);
            if (string == null) {
                JsbtTaskTreeView.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("No files added" == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(3);
        }
        return "No files added";
    }

    protected abstract void addBuildfileChildren(@NotNull DefaultMutableTreeNode var1, @NotNull JsbtFileStructure var2);

    protected abstract boolean hasTaskNodes(@NotNull DefaultMutableTreeNode var1);

    protected abstract void customizeCell(@NotNull Project var1, @NotNull ColoredTreeCellRenderer var2, @NotNull DefaultMutableTreeNode var3);

    @Nullable
    protected abstract String getPersistentId(@NotNull DefaultMutableTreeNode var1);

    @Nullable
    protected abstract String stringifyForSpeedSearch(@NotNull DefaultMutableTreeNode var1);

    @Nullable
    protected abstract JsbtTaskSet createTaskSetFromSelectedNodes();

    @Nullable
    protected abstract OpenFileDescriptor createJumpToSourceDescriptor(@NotNull Project var1, @NotNull DefaultMutableTreeNode var2);

    protected boolean shouldShowSettingMenuItem() {
        return true;
    }

    @NotNull
    protected DefaultMutableTreeNode getRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.myTreeRoot;
        if (defaultMutableTreeNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(4);
        }
        return defaultMutableTreeNode;
    }

    private void restoreLayout() {
        if (this.myLayoutPlace == null) {
            return;
        }
        JsbtTreeLayout layout = JsbtTreeLayoutManager.getInstance(this.myProject).getLayout(this.myLayoutPlace);
        if (layout == null) {
            return;
        }
        Point viewPosition = layout.getScrollPaneViewPosition();
        if (viewPosition != null) {
            UiNotifyConnector.doWhenFirstShown((JComponent)this.myTree, () -> {
                JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.myTree);
                if (scrollPane != null) {
                    scrollPane.getViewport().setViewPosition(viewPosition);
                }
            });
        }
        for (JsbtPersistentPath path : layout.getSelectedPaths()) {
            TreeNode nodeToSelect = this.findNodeByPath(path);
            if (nodeToSelect == null) continue;
            this.myTree.addSelectionPath(TreeUtil.getPathFromRoot((TreeNode)nodeToSelect));
        }
    }

    private void saveLayout() {
        if (this.myLayoutPlace == null) {
            return;
        }
        Point scrollPaneViewPosition = null;
        JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.myTree);
        if (scrollPane != null) {
            scrollPaneViewPosition = scrollPane.getViewport().getViewPosition();
        }
        List<DefaultMutableTreeNode> selectedNodes = this.getSelectedNodes();
        ArrayList selectedPaths = ContainerUtil.newArrayList();
        for (DefaultMutableTreeNode node : selectedNodes) {
            JsbtPersistentPath path = this.toPersistentPath(node);
            if (path == null) continue;
            selectedPaths.add(path);
        }
        JsbtTreeLayout layout = new JsbtTreeLayout(this.myLayoutPlace, scrollPaneViewPosition, selectedPaths);
        JsbtTreeLayoutManager.getInstance(this.myProject).add(layout);
    }

    @Nullable
    private JsbtPersistentPath toPersistentPath(@NotNull DefaultMutableTreeNode node) {
        TreeNode n;
        if (node == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(5);
        }
        ArrayList ids = ContainerUtil.newArrayList();
        for (n = node; n != this.myTreeRoot && n instanceof DefaultMutableTreeNode; n = n.getParent()) {
            String id = this.getPersistentId((DefaultMutableTreeNode)n);
            if (id == null) {
                return null;
            }
            ids.add(id);
        }
        Collections.reverse(ids);
        return n == this.myTreeRoot ? new JsbtPersistentPath(ids) : null;
    }

    public void dispose() {
        this.saveLayout();
        this.myBuildfileManager.removeListener(this.myListener);
        this.myActionCallbacks.clear();
    }

    private void selectBuildfile(@NotNull VirtualFile buildfile) {
        DefaultMutableTreeNode node;
        if (buildfile == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(6);
        }
        if ((node = this.findBuildfileNode(buildfile)) != null) {
            DefaultMutableTreeNode child;
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
            this.myTree.setSelectionPath(path);
            TreePath scrollPath = path;
            if (this.myTree.isExpanded(path) && node.getChildCount() > 0 && (child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)node.getChildAt(0), DefaultMutableTreeNode.class)) != null) {
                scrollPath = TreeUtil.getPathFromRoot((TreeNode)child);
            }
            this.myTree.scrollPathToVisible(scrollPath);
        }
    }

    public void addActionCallback(@NotNull Runnable callback) {
        if (callback == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(7);
        }
        this.myActionCallbacks.add(callback);
    }

    public void fireAction() {
        for (Runnable callback : this.myActionCallbacks) {
            callback.run();
        }
    }

    private void installSpeedSearch(@NotNull Tree tree) {
        if (tree == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(8);
        }
        new TreeSpeedSearch(tree, path -> {
            DefaultMutableTreeNode node = JsbtTree.toNode(path);
            JsbtFileStructure structure = JsbtTree.getUserObject(node, JsbtFileStructure.class);
            if (structure != null) {
                return structure.getBuildfile().getName();
            }
            if (node != null) {
                return StringUtil.notNullize((String)this.stringifyForSpeedSearch(node));
            }
            return "";
        }, true);
    }

    private void installPopupActions() {
        ArrayList actionList = ContainerUtil.newArrayList((Object[])new AnAction[]{new RunAction(), new DebugAction(), new EditRunSettingsAction(), new Separator(), new ShowTaskListSettingAction(), new JumpToSourceAction(), new ReloadTasks()});
        AnAction copyPathsAction = ActionManager.getInstance().getAction("CopyPaths");
        if (copyPathsAction != null) {
            actionList.add(copyPathsAction);
        }
        actionList.add(new JsbtRemoveBuildfileAction(this.myService, this));
        DefaultActionGroup actionGroup = new DefaultActionGroup((List)actionList);
        for (AnAction action : actionList) {
            action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)this.myTree);
        }
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)actionGroup, (String)"JavaScriptBuildTool", (ActionManager)ActionManager.getInstance());
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                JsbtTaskSet taskSet;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (event.getButton() == 1 && clickCount == 2 && (taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes()) != null) {
                    new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet).run();
                    JsbtTaskTreeView.this.fireAction();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$4", "onClick"));
            }
        }.installOn((Component)this.myTree);
    }

    @Nullable
    private DefaultMutableTreeNode findBuildfileNode(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(9);
        }
        Ref buildfileNodeRef = Ref.create(null);
        this.iterateBuildfileNodes((Processor<DefaultMutableTreeNode>)((Processor)buildfileTreeNode -> {
            JsbtFileStructure structure;
            if (buildfile == null) {
                JsbtTaskTreeView.$$$reportNull$$$0(38);
            }
            if ((structure = JsbtTree.getUserObject(buildfileTreeNode, JsbtFileStructure.class)) != null && structure.getBuildfile().equals(buildfile)) {
                buildfileNodeRef.set(buildfileTreeNode);
                return false;
            }
            return true;
        }));
        return (DefaultMutableTreeNode)buildfileNodeRef.get();
    }

    public void reloadTasksForAllBuildfiles(boolean silently, boolean reloadFailedOnly) {
        this.iterateBuildfileNodes((Processor<DefaultMutableTreeNode>)((Processor)buildfileTreeNode -> {
            if (!reloadFailedOnly || JsbtTaskTreeView.getErrorInfo(buildfileTreeNode) != null) {
                this.reloadTasksFor((DefaultMutableTreeNode)buildfileTreeNode, silently);
            }
            return true;
        }));
    }

    private void iterateBuildfileNodes(@NotNull Processor<DefaultMutableTreeNode> processor) {
        DefaultMutableTreeNode buildfileTreeNode;
        if (processor == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(10);
        }
        int childCount = this.myTreeRoot.getChildCount();
        for (int i = 0; i < childCount && ((buildfileTreeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)this.myTreeRoot.getChildAt(i), DefaultMutableTreeNode.class)) == null || processor.process((Object)buildfileTreeNode)); ++i) {
        }
    }

    private void addBuildfile(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(11);
        }
        if (!buildfile.isValid() || buildfile.isDirectory()) {
            return;
        }
        JsbtFileStructure structure = this.myBuildfileManager.getCachedStructure(buildfile);
        if (structure == null) {
            structure = this.myService.createEmptyFileStructure(buildfile);
        }
        DefaultMutableTreeNode buildfileTreeNode = new DefaultMutableTreeNode(structure, true);
        this.myTreeModel.insertNodeInto(buildfileTreeNode, this.myTreeRoot, this.myTreeRoot.getChildCount());
        this.setBuildfileChildren(buildfileTreeNode, structure, null);
        if (this.myTree.isShowing()) {
            this.reloadTasksFor(buildfileTreeNode, true);
        }
    }

    private void reloadTasksFor(final @NotNull DefaultMutableTreeNode buildfileTreeNode, boolean silently) {
        StructureFetchErrorInfo errorInfo;
        JsbtFileStructure structure;
        if (buildfileTreeNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(12);
        }
        if ((structure = JsbtTree.getUserObject(buildfileTreeNode, JsbtFileStructure.class)) == null) {
            LOG.warn("reloadTasksFor called on wrong tree node");
            return;
        }
        this.structureFetchStarted();
        boolean showLoadingNode = true;
        if (silently) {
            boolean bl = showLoadingNode = !this.hasTaskNodes(buildfileTreeNode);
        }
        if ((errorInfo = JsbtTaskTreeView.getErrorInfo(buildfileTreeNode)) != null) {
            JsbtTaskListingFailUtil.hideError(this.myProject, errorInfo.getException());
        }
        if (showLoadingNode) {
            boolean expand = buildfileTreeNode.getChildCount() == 0;
            buildfileTreeNode.removeAllChildren();
            buildfileTreeNode.add((MutableTreeNode)new LoadingNode());
            this.myTreeModel.nodeStructureChanged(buildfileTreeNode);
            if (expand) {
                this.expandNode(buildfileTreeNode);
            }
        }
        this.myBuildfileManager.fetchStructure(structure.getBuildfile(), new CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException>(){

            public void consume(JsbtFileStructure structure) {
                JsbtTaskTreeView.this.setBuildfileChildren(buildfileTreeNode, structure, null);
                JsbtTaskTreeView.this.structureFetchDone();
            }

            public void consume(JsbtTaskFetchException e) {
                JsbtTaskTreeView.this.setBuildfileChildren(buildfileTreeNode, null, e);
                JsbtTaskTreeView.this.structureFetchDone();
            }
        });
    }

    @Nullable
    private static StructureFetchErrorInfo getErrorInfo(@NotNull DefaultMutableTreeNode buildfileTreeNode) {
        if (buildfileTreeNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(13);
        }
        int childCount = buildfileTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)buildfileTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(childNode);
            if (errorInfo == null) continue;
            return errorInfo;
        }
        return null;
    }

    private void structureFetchStarted() {
        if (this.myActiveTaskReloadCount == 0) {
            this.myTree.setPaintBusy(true);
        }
        ++this.myActiveTaskReloadCount;
    }

    private void structureFetchDone() {
        --this.myActiveTaskReloadCount;
        if (this.myActiveTaskReloadCount == 0) {
            this.myTree.setPaintBusy(false);
        }
    }

    private void setBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @Nullable JsbtFileStructure structure, @Nullable JsbtTaskFetchException e) {
        if (buildfileTreeNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(14);
        }
        if (structure == null && e == null) {
            LOG.error("Undefined structure and exception");
            return;
        }
        JsbtTreeUiState uiState = buildfileTreeNode.getChildCount() > 0 ? this.getUiState(buildfileTreeNode) : null;
        buildfileTreeNode.removeAllChildren();
        if (structure != null) {
            buildfileTreeNode.setUserObject(structure);
            this.addBuildfileChildren(buildfileTreeNode, structure);
            this.sort(buildfileTreeNode, this.getSortingMode());
        } else {
            buildfileTreeNode.setUserObject(this.myService.createEmptyFileStructure(e.getBuildfile()));
            buildfileTreeNode.add(new DefaultMutableTreeNode(new StructureFetchErrorInfo(this.myProject, e, this), false));
        }
        this.myTreeModel.nodeStructureChanged(buildfileTreeNode);
        if (uiState != null) {
            this.restoreUiState(uiState, buildfileTreeNode);
        } else {
            this.expandNode(buildfileTreeNode);
        }
    }

    private void sortAll(@NotNull JsbtSortingMode newSortingMode) {
        if (newSortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(15);
        }
        this.iterateBuildfileNodes((Processor<DefaultMutableTreeNode>)((Processor)buildfileNode -> {
            if (newSortingMode == null) {
                JsbtTaskTreeView.$$$reportNull$$$0(37);
            }
            JsbtTreeUiState uiState = buildfileNode.getChildCount() > 0 ? this.getUiState((DefaultMutableTreeNode)buildfileNode) : null;
            this.sort((DefaultMutableTreeNode)buildfileNode, newSortingMode);
            this.myTreeModel.nodeStructureChanged((TreeNode)buildfileNode);
            if (uiState != null) {
                this.restoreUiState(uiState, (DefaultMutableTreeNode)buildfileNode);
            }
            return true;
        }));
    }

    private void sort(@NotNull DefaultMutableTreeNode buildfileNode, @NotNull JsbtSortingMode newSortingMode) {
        if (buildfileNode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(16);
        }
        if (newSortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(17);
        }
        TreeUtil.sortRecursively((MutableTreeNode)buildfileNode, (node1, node2) -> {
            if (newSortingMode == null) {
                JsbtTaskTreeView.$$$reportNull$$$0(36);
            }
            return this.compareNodes((DefaultMutableTreeNode)node1, (DefaultMutableTreeNode)node2, newSortingMode);
        });
    }

    protected abstract int compareNodes(@NotNull DefaultMutableTreeNode var1, @NotNull DefaultMutableTreeNode var2, @NotNull JsbtSortingMode var3);

    @NotNull
    private JsbtTreeUiState getUiState(@NotNull DefaultMutableTreeNode root) {
        if (root == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(18);
        }
        JsbtTreeUiState state = new JsbtTreeUiState();
        this.addUiState(state, root, new JsbtPersistentPath(Collections.emptyList()));
        JsbtTreeUiState jsbtTreeUiState = state;
        if (jsbtTreeUiState == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(19);
        }
        return jsbtTreeUiState;
    }

    private void addUiState(@NotNull JsbtTreeUiState state, @NotNull TreeNode node, @NotNull JsbtPersistentPath path) {
        boolean expanded;
        if (state == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(20);
        }
        if (node == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(21);
        }
        if (path == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(22);
        }
        if (node instanceof LoadingNode) {
            return;
        }
        TreePath treePath = TreeUtil.getPathFromRoot((TreeNode)node);
        if (this.myTree.isPathSelected(treePath)) {
            state.addSelectedPath(path);
        }
        if (!(expanded = this.myTree.isExpanded(treePath))) {
            state.addCollapsedPath(path);
        }
        if (expanded) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String childId;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)node.getChildAt(i), DefaultMutableTreeNode.class);
                String string = childId = child != null ? this.getPersistentId(child) : null;
                if (childId == null) continue;
                this.addUiState(state, child, path.createChildPath(childId));
            }
        }
    }

    private void restoreUiState(@NotNull JsbtTreeUiState state, @NotNull DefaultMutableTreeNode root) {
        TreeNode node;
        if (state == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(23);
        }
        if (root == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(24);
        }
        for (JsbtPersistentPath path : state.getSelectedPaths()) {
            node = this.findNodeByPath(path, root);
            if (node == null) continue;
            this.myTree.addSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
        for (JsbtPersistentPath path : state.getCollapsedPaths()) {
            node = this.findNodeByPath(path, root);
            if (node == null) continue;
            this.myTree.collapsePath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    @Nullable
    private TreeNode findNodeByPath(@NotNull JsbtPersistentPath path) {
        if (path == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(25);
        }
        return this.findNodeByPath(path, this.myTreeRoot);
    }

    @Nullable
    private TreeNode findNodeByPath(@NotNull JsbtPersistentPath path, @NotNull TreeNode root) {
        if (path == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(26);
        }
        if (root == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(27);
        }
        TreeNode parent = root;
        for (String id : path.getIds()) {
            DefaultMutableTreeNode newParent = null;
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String childId;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(i), DefaultMutableTreeNode.class);
                String string = childId = child != null ? this.getPersistentId(child) : null;
                if (childId == null || !childId.equals(id)) continue;
                newParent = child;
                break;
            }
            if (newParent == null) {
                return null;
            }
            parent = newParent;
        }
        return parent;
    }

    private void expandNode(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(28);
        }
        this.myTree.expandPath(TreeUtil.getPathFromRoot((TreeNode)node));
    }

    public boolean isReloading() {
        return this.myActiveTaskReloadCount > 0;
    }

    @NotNull
    public JsbtService getService() {
        JsbtService jsbtService = this.myService;
        if (jsbtService == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(29);
        }
        return jsbtService;
    }

    @NotNull
    public Tree getComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(30);
        }
        return tree;
    }

    @NotNull
    public List<DefaultMutableTreeNode> getSelectedNodes() {
        List<DefaultMutableTreeNode> list = JsbtTree.getSelectedNodes((JTree)this.myTree);
        if (list == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(31);
        }
        return list;
    }

    public void showError(@NotNull Project project, @NotNull JsbtTaskFetchException e) {
        if (project == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(32);
        }
        if (e == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(33);
        }
        if (e.hasInvalidSettings()) {
            boolean ok = this.myService.showTaskListingSettingsDialog(project, e.getBuildfile());
            if (ok) {
                this.reloadTasksForAllBuildfiles(true, false);
            }
        } else {
            JsbtTaskListFetchFail fetchFail = e.getFetchFail();
            if (fetchFail != null) {
                JsbtTaskListingFailUtil.showError(project, fetchFail);
            } else {
                VirtualFile buildfile = e.getBuildfile();
                if (buildfile.isValid()) {
                    new OpenFileDescriptor(this.myProject, buildfile).navigate(true);
                } else {
                    PopupUtil.showBalloonForComponent((Component)this.myTree, (String)"No such file", (MessageType)MessageType.WARNING, (boolean)true, null);
                }
            }
        }
    }

    @Nullable
    private JsbtFileStructure getSelectedBuildfileStructure() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.size() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ContainerUtil.getFirstItem(nodes);
            return JsbtTree.getUserObject(node, JsbtFileStructure.class);
        }
        return null;
    }

    @NotNull
    public JsbtSortingMode getSortingMode() {
        JsbtSortingMode jsbtSortingMode = this.myService.getFileManager(this.myProject).getSortingMode();
        if (jsbtSortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(34);
        }
        return jsbtSortingMode;
    }

    public void setSortingMode(@NotNull JsbtSortingMode sortingMode) {
        if (sortingMode == null) {
            JsbtTaskTreeView.$$$reportNull$$$0(35);
        }
        this.myService.getFileManager(this.myProject).setSortingMode(sortingMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView";
                break;
            }
            case 5: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfileTreeNode";
                break;
            }
            case 15: 
            case 17: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSortingMode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfileNode";
                break;
            }
            case 18: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiState";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toPersistentPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectBuildfile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addActionCallback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installSpeedSearch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findBuildfileNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateBuildfileNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBuildfile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reloadTasksFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setBuildfileChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sortAll";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUiState";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addUiState";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "restoreUiState";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findNodeByPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setSortingMode";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sort$5";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sortAll$4";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findBuildfileNode$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyJsbtFileListener
    implements JsbtFileListener {
        private MyJsbtFileListener() {
        }

        @Override
        public void onBuildfileAdded(@NotNull VirtualFile buildfile) {
            if (buildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(0);
            }
            JsbtTaskTreeView.this.addBuildfile(buildfile);
            JsbtTaskTreeView.this.selectBuildfile(buildfile);
        }

        @Override
        public void onBuildfileSelected(@NotNull VirtualFile buildfile) {
            if (buildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(1);
            }
            JsbtTaskTreeView.this.selectBuildfile(buildfile);
        }

        @Override
        public void onBuildfileChanged(@NotNull VirtualFile oldBuildfile, @NotNull VirtualFile newBuildfile) {
            DefaultMutableTreeNode buildfileNode;
            if (oldBuildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(2);
            }
            if (newBuildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(3);
            }
            if ((buildfileNode = JsbtTaskTreeView.this.findBuildfileNode(oldBuildfile)) != null) {
                JsbtFileStructure structure = JsbtTaskTreeView.this.myBuildfileManager.getCachedStructure(newBuildfile);
                if (structure == null) {
                    structure = JsbtTaskTreeView.this.myService.createEmptyFileStructure(newBuildfile);
                }
                buildfileNode.setUserObject(structure);
                JsbtTaskTreeView.this.reloadTasksFor(buildfileNode, true);
                JsbtTaskTreeView.this.myTreeModel.nodeChanged(buildfileNode);
            }
        }

        @Override
        public void onBuildfileRemoved(@NotNull VirtualFile buildfile) {
            DefaultMutableTreeNode buildfileNode;
            if (buildfile == null) {
                MyJsbtFileListener.$$$reportNull$$$0(4);
            }
            if ((buildfileNode = JsbtTaskTreeView.this.findBuildfileNode(buildfile)) != null) {
                DefaultMutableTreeNode nodeToSelect = null;
                if (JsbtTaskTreeView.this.myTree.isPathSelected(TreeUtil.getPathFromRoot((TreeNode)buildfileNode)) && (nodeToSelect = buildfileNode.getNextSibling()) == null) {
                    nodeToSelect = buildfileNode.getPreviousSibling();
                }
                JsbtTaskTreeView.this.myTreeModel.removeNodeFromParent(buildfileNode);
                if (nodeToSelect != null) {
                    JsbtTaskTreeView.this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)nodeToSelect));
                }
            }
        }

        @Override
        public void onSortingModeChanged(@NotNull JsbtSortingMode newSortingMode) {
            if (newSortingMode == null) {
                MyJsbtFileListener.$$$reportNull$$$0(5);
            }
            JsbtTaskTreeView.this.sortAll(newSortingMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildfile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldBuildfile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBuildfile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSortingMode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$MyJsbtFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileSelected";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBuildfileRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSortingModeChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class JsbtTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeCellHyperlinkSupport myCellHyperlinkSupport;

        private JsbtTreeCellRenderer() {
            this.myCellHyperlinkSupport = TreeCellHyperlinkSupport.installOn((JTree)JsbtTaskTreeView.this.myTree);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                JsbtTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node instanceof LoadingNode) {
                    String text = (String)ObjectUtils.tryCast((Object)node.getUserObject(), String.class);
                    text = StringUtil.notNullize((String)text, (String)LoadingNode.getText());
                    this.append(text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    return;
                }
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    this.setIcon(AllIcons.General.ExclMark);
                    this.setIconOnTheRight(false);
                    this.append("Failed to list tasks", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append("  ");
                    int style = 0;
                    if (this.myCellHyperlinkSupport.isMouseInsideHyperlink()) {
                        style |= 0x10;
                    }
                    boolean hyperlinkBoundsUndefined = errorInfo.getHyperlinkBounds() == null;
                    Dimension dimensionBefore = null;
                    if (hyperlinkBoundsUndefined) {
                        dimensionBefore = this.computePreferredSize(false);
                    }
                    this.append("details", new SimpleTextAttributes(null, PlatformColors.BLUE, null, style));
                    if (hyperlinkBoundsUndefined) {
                        Dimension dimensionAfter = this.computePreferredSize(false);
                        Rectangle b = new Rectangle(dimensionBefore.width, 0, dimensionAfter.width - dimensionBefore.width, dimensionAfter.height);
                        errorInfo.setHyperlinkBounds(b);
                    }
                } else {
                    JsbtTaskTreeView.this.customizeCell(JsbtTaskTreeView.this.myProject, this, node);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JsbtTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private class ReloadTasks
    extends AnAction
    implements DumbAware {
        private ReloadTasks() {
            super(JsbtTaskTreeView.this.myService.getReloadTasksActionName(), null, AllIcons.Actions.Refresh);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadTasks.$$$reportNull$$$0(0);
            }
            JsbtFileStructure structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure();
            e.getPresentation().setEnabledAndVisible(structure != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DefaultMutableTreeNode node;
            List<DefaultMutableTreeNode> nodes;
            if (e == null) {
                ReloadTasks.$$$reportNull$$$0(1);
            }
            if ((nodes = JsbtTaskTreeView.this.getSelectedNodes()).size() == 1 && (node = (DefaultMutableTreeNode)ContainerUtil.getFirstItem(nodes)) != null) {
                JsbtTaskTreeView.this.reloadTasksFor(node, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ReloadTasks";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class JumpToSourceAction
    extends AnAction
    implements DumbAware {
        private JumpToSourceAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"EditSource");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                JumpToSourceAction.$$$reportNull$$$0(0);
            }
            List<DefaultMutableTreeNode> nodes = JsbtTaskTreeView.this.getSelectedNodes();
            boolean enabled = false;
            if (nodes.size() == 1) {
                DefaultMutableTreeNode node = nodes.get(0);
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    e.getPresentation().setText("Show error details");
                    enabled = true;
                } else {
                    OpenFileDescriptor descriptor2 = this.createDescriptor(node);
                    if (descriptor2 != null) {
                        enabled = true;
                    }
                }
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(enabled);
        }

        @Nullable
        private OpenFileDescriptor createDescriptor(@NotNull DefaultMutableTreeNode node) {
            JsbtFileStructure structure;
            if (node == null) {
                JumpToSourceAction.$$$reportNull$$$0(1);
            }
            if ((structure = JsbtTree.getUserObject(node, JsbtFileStructure.class)) != null) {
                VirtualFile buildfile = structure.getBuildfile();
                return buildfile.isValid() ? new OpenFileDescriptor(JsbtTaskTreeView.this.myProject, buildfile) : null;
            }
            return JsbtTaskTreeView.this.createJumpToSourceDescriptor(JsbtTaskTreeView.this.myProject, node);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DefaultMutableTreeNode> nodes;
            if (e == null) {
                JumpToSourceAction.$$$reportNull$$$0(2);
            }
            if ((nodes = JsbtTaskTreeView.this.getSelectedNodes()).size() == 1) {
                DefaultMutableTreeNode node = nodes.get(0);
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    JsbtTaskTreeView.this.showError(JsbtTaskTreeView.this.myProject, errorInfo.getException());
                } else {
                    OpenFileDescriptor descriptor2 = this.createDescriptor(node);
                    if (descriptor2 != null) {
                        descriptor2.navigate(true);
                        JsbtTaskTreeView.this.fireAction();
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JumpToSourceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowTaskListSettingAction
    extends AnAction
    implements DumbAware {
        private ShowTaskListSettingAction() {
            super(JsbtTaskTreeView.this.myService.getToolWindowSettingsActionName(), null, AllIcons.General.GearPlain);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowTaskListSettingAction.$$$reportNull$$$0(0);
            }
            JsbtFileStructure structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure();
            e.getPresentation().setEnabledAndVisible(JsbtTaskTreeView.this.shouldShowSettingMenuItem() && structure != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JsbtFileStructure structure;
            if (e == null) {
                ShowTaskListSettingAction.$$$reportNull$$$0(1);
            }
            if ((structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure()) != null) {
                JsbtTaskTreeView.this.myService.showTaskListingSettingsDialog(JsbtTaskTreeView.this.myProject, structure.getBuildfile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ShowTaskListSettingAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditRunSettingsAction
    extends AnAction
    implements DumbAware {
        private EditRunSettingsAction() {
            super("Edit", null, AllIcons.Actions.EditSource);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditRunSettingsAction.$$$reportNull$$$0(0);
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            e.getPresentation().setEnabledAndVisible(taskSet != null);
            if (taskSet != null) {
                e.getPresentation().setText("&Edit '" + taskSet.getName() + "' settings...");
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JsbtTaskSet taskSet;
            if (e == null) {
                EditRunSettingsAction.$$$reportNull$$$0(1);
            }
            if ((taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes()) != null) {
                JsbtExecutor executor = new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet);
                executor.editSettings();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$EditRunSettingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class ExecuteAction
    extends AnAction
    implements DumbAware {
        private final Executor myExecutor;

        private ExecuteAction(Executor executor) {
            if (executor == null) {
                ExecuteAction.$$$reportNull$$$0(0);
            }
            super(executor.getStartActionText(), null, executor.getIcon());
            this.myExecutor = executor;
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteAction.$$$reportNull$$$0(1);
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            e.getPresentation().setEnabledAndVisible(taskSet != null);
            if (taskSet != null) {
                e.getPresentation().setText(this.myExecutor.getStartActionText(taskSet.getName()));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JsbtTaskSet taskSet;
            if (e == null) {
                ExecuteAction.$$$reportNull$$$0(2);
            }
            if ((taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes()) != null) {
                new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet).execute(this.myExecutor);
                JsbtTaskTreeView.this.fireAction();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ExecuteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DebugAction
    extends ExecuteAction {
        private DebugAction() {
            super(DefaultDebugExecutor.getDebugExecutorInstance());
            ActionUtil.copyFrom((AnAction)this, (String)DefaultDebugExecutor.getDebugExecutorInstance().getContextActionId());
        }
    }

    private class RunAction
    extends ExecuteAction {
        private RunAction() {
            super(DefaultRunExecutor.getRunExecutorInstance());
            this.setShortcutSet(CommonShortcuts.ENTER);
        }
    }

    public static class StructureFetchErrorInfo
    implements TreeCellHyperlink {
        private final Project myProject;
        private final JsbtTaskFetchException myException;
        private final JsbtTaskTreeView myTreeView;
        private Rectangle myHyperlinkBounds;

        public StructureFetchErrorInfo(@NotNull Project project, @NotNull JsbtTaskFetchException e, @NotNull JsbtTaskTreeView treeView) {
            if (project == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(0);
            }
            if (e == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(1);
            }
            if (treeView == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myException = e;
            this.myTreeView = treeView;
        }

        @NotNull
        public JsbtTaskFetchException getException() {
            JsbtTaskFetchException jsbtTaskFetchException = this.myException;
            if (jsbtTaskFetchException == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(3);
            }
            return jsbtTaskFetchException;
        }

        @Override
        @NotNull
        public Runnable getClickHandler() {
            Runnable runnable = () -> this.myTreeView.showError(this.myProject, this.myException);
            if (runnable == null) {
                StructureFetchErrorInfo.$$$reportNull$$$0(4);
            }
            return runnable;
        }

        @Override
        @Nullable
        public Rectangle getHyperlinkBounds() {
            return this.myHyperlinkBounds;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return "Click to show error details";
        }

        public void setHyperlinkBounds(Rectangle hyperlinkBounds) {
            this.myHyperlinkBounds = hyperlinkBounds;
        }

        @Nullable
        public static StructureFetchErrorInfo getUserObject(@Nullable DefaultMutableTreeNode node) {
            if (node == null) {
                return null;
            }
            return (StructureFetchErrorInfo)ObjectUtils.tryCast((Object)node.getUserObject(), StructureFetchErrorInfo.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeView";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClickHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

