/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBuildToolGruntFileManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GruntfileManager
extends JsbtFileManager
implements PersistentStateComponent<Element> {
    private static final String GRUNTFILE_TAG = "gruntfile";
    private static final String DETECTION_DONE_ATTR = "detection-done";
    private static final String SORTING_ATTR = "sorting";
    private static final String PATH_ATTR = "path";
    private static final String ALIAS_TASK_TAG = "alias-task";
    private static final String TASK_NAME_ATTR = "name";
    private static final String TASK_INFO_ATTR = "info";
    private static final String TASK_FILE_PATH_ATTR = "file-path";
    private static final String MULTI_ATTR = "multi";
    private static final String ALIAS_TASK_DEPENDENCY_TAG = "dependency";
    private static final String CORE_TASK_TAG = "core-task";
    private static final String CORE_TASK_TARGET_TAG = "target";

    public GruntfileManager(@NotNull Project project) {
        if (project == null) {
            GruntfileManager.$$$reportNull$$$0(0);
        }
        super(project, GruntService.getInstance());
    }

    public static GruntfileManager getInstance(@NotNull Project project) {
        if (project == null) {
            GruntfileManager.$$$reportNull$$$0(1);
        }
        return (GruntfileManager)ServiceManager.getService((Project)project, GruntfileManager.class);
    }

    @Override
    @Nullable
    public GruntfileStructure getCachedStructure(@NotNull VirtualFile gruntfile) {
        if (gruntfile == null) {
            GruntfileManager.$$$reportNull$$$0(2);
        }
        return (GruntfileStructure)super.getCachedStructure(gruntfile);
    }

    public void fetchGruntStructure(@NotNull VirtualFile gruntfile, final @NotNull CatchingConsumer<GruntfileStructure, JsbtTaskFetchException> consumer) {
        if (gruntfile == null) {
            GruntfileManager.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            GruntfileManager.$$$reportNull$$$0(4);
        }
        super.fetchStructure(gruntfile, new CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException>(){

            public void consume(JsbtTaskFetchException e) {
                consumer.consume((Throwable)e);
            }

            public void consume(JsbtFileStructure structure) {
                consumer.consume((Object)((GruntfileStructure)structure));
            }
        });
    }

    @Nullable
    public Element getState() {
        Element parent = new Element("gruntfiles");
        if (this.isDetectionDone()) {
            parent.setAttribute(DETECTION_DONE_ATTR, Boolean.TRUE.toString());
        }
        parent.setAttribute(SORTING_ATTR, this.getSortingMode().name());
        for (VirtualFile buildfile : this.getBuildfiles()) {
            GruntfileStructure structure = (GruntfileStructure)ObjectUtils.tryCast((Object)this.getCachedStructure(buildfile), GruntfileStructure.class);
            Element gruntfileElement = new Element(GRUNTFILE_TAG);
            gruntfileElement.setAttribute(PATH_ATTR, buildfile.getPath());
            parent.addContent(gruntfileElement);
            if (structure == null) continue;
            for (GruntAliasTask gruntAliasTask : structure.getAliasTasks()) {
                gruntfileElement.addContent(GruntfileManager.aliasTaskToXml(gruntAliasTask));
            }
            for (GruntCoreTask gruntCoreTask : structure.getCoreTasks()) {
                gruntfileElement.addContent(GruntfileManager.coreTaskToXml(gruntCoreTask));
            }
        }
        return parent;
    }

    @NotNull
    private static Element aliasTaskToXml(@NotNull GruntAliasTask task) {
        if (task == null) {
            GruntfileManager.$$$reportNull$$$0(5);
        }
        Element element = new Element(ALIAS_TASK_TAG);
        element.setAttribute(TASK_NAME_ATTR, task.getName());
        if (task.getInfo() != null) {
            element.setAttribute(TASK_INFO_ATTR, task.getInfo());
        }
        if (task.getFilePath() != null) {
            element.setAttribute(TASK_FILE_PATH_ATTR, task.getFilePath());
        }
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)element, (String)ALIAS_TASK_DEPENDENCY_TAG, task.getDependencies());
        Element element2 = element;
        if (element2 == null) {
            GruntfileManager.$$$reportNull$$$0(6);
        }
        return element2;
    }

    @NotNull
    private static Element coreTaskToXml(@NotNull GruntCoreTask task) {
        if (task == null) {
            GruntfileManager.$$$reportNull$$$0(7);
        }
        Element element = new Element(CORE_TASK_TAG);
        element.setAttribute(TASK_NAME_ATTR, task.getName());
        if (task.getInfo() != null) {
            element.setAttribute(TASK_INFO_ATTR, task.getInfo());
        }
        if (task.getFilePath() != null) {
            element.setAttribute(TASK_FILE_PATH_ATTR, task.getFilePath());
        }
        element.setAttribute(MULTI_ATTR, Boolean.toString(task.isMulti()));
        List targets = ContainerUtil.map(task.getTargetTasks(), task1 -> task1.getTargetName());
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)element, (String)CORE_TASK_TARGET_TAG, (List)targets);
        Element element2 = element;
        if (element2 == null) {
            GruntfileManager.$$$reportNull$$$0(8);
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            GruntfileManager.$$$reportNull$$$0(9);
        }
        if (state == null) {
            return;
        }
        this.clearAllBuildfiles();
        if (Boolean.parseBoolean(state.getAttributeValue(DETECTION_DONE_ATTR))) {
            this.setDetectionDone();
        }
        this.setSortingMode(JsbtSortingMode.findByName(state.getAttributeValue(SORTING_ATTR), JsbtSortingMode.DEFINITION_ORDER));
        List elements = state.getChildren(GRUNTFILE_TAG);
        for (Element element : elements) {
            VirtualFile file2;
            String path = element.getAttributeValue(PATH_ATTR);
            if (!StringUtil.isNotEmpty((String)path) || (file2 = LocalFileSystem.getInstance().findFileByPath(path)) == null || !file2.isValid() || file2.isDirectory()) continue;
            GruntfileStructure structure = new GruntfileStructure(file2);
            ArrayList aliasTasks = ContainerUtil.newArrayList();
            for (Element aliasTaskElement : element.getChildren(ALIAS_TASK_TAG)) {
                GruntAliasTask aliasTask = GruntfileManager.createAliasTask(structure, aliasTaskElement);
                if (aliasTask == null) continue;
                aliasTasks.add(aliasTask);
            }
            ArrayList coreTasks = ContainerUtil.newArrayList();
            for (Element coreTaskElement : element.getChildren(CORE_TASK_TAG)) {
                GruntCoreTask coreTask = GruntfileManager.createCoreTask(structure, coreTaskElement);
                if (coreTask == null) continue;
                coreTasks.add(coreTask);
            }
            structure.setTasks(aliasTasks, coreTasks);
            this.addBuildfileStructure(structure);
        }
    }

    @Nullable
    private static GruntAliasTask createAliasTask(@NotNull GruntfileStructure structure, @NotNull Element aliasTaskElement) {
        String name;
        if (structure == null) {
            GruntfileManager.$$$reportNull$$$0(10);
        }
        if (aliasTaskElement == null) {
            GruntfileManager.$$$reportNull$$$0(11);
        }
        if ((name = aliasTaskElement.getAttributeValue(TASK_NAME_ATTR)) != null) {
            String info = aliasTaskElement.getAttributeValue(TASK_INFO_ATTR);
            String filePath = aliasTaskElement.getAttributeValue(TASK_FILE_PATH_ATTR);
            boolean multi = Boolean.parseBoolean(aliasTaskElement.getAttributeValue(MULTI_ATTR));
            List dependencies = JDOMExternalizerUtil.getChildrenValueAttributes((Element)aliasTaskElement, (String)ALIAS_TASK_DEPENDENCY_TAG);
            return new GruntAliasTask(structure, name, info, filePath, multi, dependencies);
        }
        return null;
    }

    @Nullable
    private static GruntCoreTask createCoreTask(@NotNull GruntfileStructure structure, @NotNull Element coreTaskElement) {
        String name;
        if (structure == null) {
            GruntfileManager.$$$reportNull$$$0(12);
        }
        if (coreTaskElement == null) {
            GruntfileManager.$$$reportNull$$$0(13);
        }
        if ((name = coreTaskElement.getAttributeValue(TASK_NAME_ATTR)) != null) {
            String info = coreTaskElement.getAttributeValue(TASK_INFO_ATTR);
            String filePath = coreTaskElement.getAttributeValue(TASK_FILE_PATH_ATTR);
            boolean multi = Boolean.parseBoolean(coreTaskElement.getAttributeValue(MULTI_ATTR));
            List targets = JDOMExternalizerUtil.getChildrenValueAttributes((Element)coreTaskElement, (String)CORE_TASK_TARGET_TAG);
            return new GruntCoreTask(structure, name, info, filePath, multi, targets);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = GRUNTFILE_TAG;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasTaskElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreTaskElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "aliasTaskToXml";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "coreTaskToXml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedStructure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchGruntStructure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "aliasTaskToXml";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "coreTaskToXml";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAliasTask";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCoreTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

