/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;

public class JSLookupElementRenderer
extends LookupElementRenderer<LookupElement>
implements JSLookupUtilImpl.IBoldnessProvidingLookupElementRenderer {
    private final String myName;
    private final JSLookupPriority myPriority;
    private final PsiElement myValue;
    private final boolean myEcma;
    private final boolean myIsBold;
    private final JSTypeSubstitutor myTypeSubstitutor;

    public JSLookupElementRenderer(String name, JSLookupPriority priority, PsiElement value, boolean ecma, boolean isBold, JSTypeSubstitutor typeSubstitutor) {
        this.myName = name;
        this.myPriority = priority;
        this.myValue = value;
        this.myEcma = ecma;
        this.myIsBold = isBold;
        this.myTypeSubstitutor = typeSubstitutor;
    }

    public void renderElement(LookupElement element, LookupElementPresentation presentation) {
        if (presentation instanceof JSLookupUtilImpl.BoldCheckingLookupElementPresentation) {
            presentation.setItemTextBold(this.myIsBold);
            ((JSLookupUtilImpl.BoldCheckingLookupElementPresentation)presentation).setUseRenderer(this);
            return;
        }
        presentation.setItemText(JSUtils.isPrivateSharpItem(this.myValue) ? "#" + this.myName : this.myName);
        boolean real = presentation.isReal();
        if (this.myPriority.compareTo(JSLookupPriority.MAX_PRIORITY) >= 0 || real) {
            presentation.setIcon(real ? JSLookupUtilImpl.getIcon(this.myValue, this.myEcma) : JSLookupUtilImpl.IconHolder.ourEmptyIconWithVisibility);
            if (real) {
                presentation.setStrikeout(JSDocumentationUtils.isDeprecated(this.myValue));
            }
            presentation.setItemTextBold(this.myIsBold);
            if (this.myValue != null) {
                Couple<String> typeAndTail = JSLookupUtilImpl.getTypeAndTailTexts(this.myValue, this.myTypeSubstitutor);
                presentation.setTypeText((String)typeAndTail.first);
                presentation.setTailText((String)typeAndTail.second, false);
            }
        }
    }

    @Override
    public LookupElementRenderer<LookupElement> copyWithBoldness(boolean bold) {
        if (this.myIsBold == bold) {
            return this;
        }
        return new JSLookupElementRenderer(this.myName, this.myPriority, this.myValue, this.myEcma, bold, this.myTypeSubstitutor);
    }
}

