/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSymbolInfo;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocBuilderParameterInfo
extends JSDocBuilderSimpleInfo {
    boolean optional;
    boolean rest;
    String initialValue;
    String defaultValue;
    @Nullable
    String docName;
    Map<String, JSDocBuilderParameterInfo> optionsMap;

    JSDocBuilderParameterInfo() {
    }

    JSDocBuilderParameterInfo(@Nullable JSParameterTypeDecorator parameterType) {
        this.type = parameterType != null ? parameterType.getType() : null;
        this.optional = parameterType != null && parameterType.isOptional();
        this.rest = parameterType != null && parameterType.isRest();
    }

    boolean hasSomeInfo() {
        return this.hasDescription() || this.optional || this.rest || this.hasType();
    }

    public void appendDoc(String actualName, @NotNull JSDocBuilderSymbolInfo symbolInfo, @NotNull StringBuilder result2) {
        if (symbolInfo == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(1);
        }
        result2.append("<div class='definition'><pre>");
        StringBuilder options = new StringBuilder();
        JSDocBuilderSymbolInfo.addVisibilityAndAccess(this, options);
        if (options.length() > 0) {
            result2.append((CharSequence)options).append("<br>");
        }
        if (!StringUtil.isEmpty((String)symbolInfo.namespace)) {
            result2.append(symbolInfo.namespace).append('.');
        }
        result2.append(actualName);
        if (this.hasType()) {
            result2.append(": ");
            result2.append(this.getTypeString());
        }
        result2.append("</pre></div>");
        int contentStart = result2.length();
        result2.append("<div class='content'>");
        result2.append(this.getDescriptionMergedWithConfigOptions());
        if (result2.length() == contentStart + "<div class='content'>".length()) {
            result2.setLength(contentStart);
        } else {
            result2.append("</div>");
        }
    }

    public String getDescriptionMergedWithConfigOptions() {
        if (this.optionsMap != null) {
            StringBuilder optionsBuilder = new StringBuilder();
            optionsBuilder.append("<table class='sections'>");
            optionsBuilder.append("<tr><td valign='top' class='section'><p>");
            optionsBuilder.append("Config options").append(":");
            optionsBuilder.append("</td><td>");
            for (Map.Entry<String, JSDocBuilderParameterInfo> field : this.optionsMap.entrySet()) {
                optionsBuilder.append("<p>");
                field.getValue().appendOptionDescription(field.getKey(), optionsBuilder);
            }
            optionsBuilder.append("</table>");
            String description = this.getFinalDescription();
            int i = description.indexOf("<tr><td valign='top' class='section'><p>See also:</td><td>");
            if (i != -1) {
                return new StringBuilder(description).insert(i, optionsBuilder).toString();
            }
            return description + optionsBuilder;
        }
        return this.getFinalDescription();
    }

    private static void insertParameterInfoDescription(@NotNull StringBuilder description, @NotNull StringBuilder builder) {
        int i;
        if (description == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(3);
        }
        if ((i = description.indexOf("<tr><td valign='top' class='section'><p>See also:</td><td>")) != -1) {
            description.insert(i, builder);
        } else {
            description.append((CharSequence)builder);
        }
    }

    public void appendParameterInfoInSignature(@NotNull String actualName, @NotNull StringBuilder result2) {
        if (actualName == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(5);
        }
        if (this.rest) {
            result2.append("...");
        }
        if (!StringUtil.isEmpty((String)this.namespace)) {
            result2.append(this.namespace).append('.');
        }
        result2.append(actualName);
        if (this.optional) {
            result2.append("?");
        }
        if (this.hasType()) {
            result2.append(": ");
            result2.append(this.getTypeString());
            if (this.rest) {
                result2.append("[]");
            }
        }
        if (this.initialValue != null) {
            result2.append(" = ").append(this.initialValue);
        }
    }

    public void appendOptionDescription(@NotNull String name, @NotNull StringBuilder builder) {
        if (name == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(7);
        }
        this.appendParameterInfoInSignature(name, builder);
        builder.append(" &ndash; ");
        builder.append(this.getFinalDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolInfo";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderParameterInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDoc";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insertParameterInfoDescription";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendParameterInfoInSignature";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "appendOptionDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

