/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSDocBuilderParameterInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSSeeAlsoDocBuilderInfo;
import com.intellij.lang.javascript.psi.JSConstantValueOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocBuilderSymbolInfo
extends JSDocBuilderSimpleInfo {
    public static final String EVENTS = "Events:";
    @Nullable
    protected final JSPsiElementBase namedItem;
    @Nullable
    protected final PsiElement contextElement;
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final JSSeeAlsoDocBuilderInfo mySeeAlsoDocBuilderInfo;
    @NotNull
    protected final Map<String, String> mySimpleTags;
    @Nullable
    Map<String, JSDocBuilderParameterInfo> myProperties;
    @Nullable
    private String defaultValue;

    void addSimpleTag(@NotNull String key, @Nullable String text) {
        if (key == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(0);
        }
        this.mySimpleTags.put(key, StringUtil.notNullize((String)text));
    }

    void addEventTag(@Nullable String name, @Nullable String text) {
        String oldValue = this.mySimpleTags.get(EVENTS);
        String value = StringUtil.notNullize((String)oldValue) + "<p>" + StringUtil.notNullize((String)name) + " &ndash; " + StringUtil.notNullize((String)text);
        this.mySimpleTags.put(EVENTS, value);
    }

    void addSeeAlsoText(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.mySeeAlsoDocBuilderInfo.addText(text);
    }

    public JSDocBuilderSymbolInfo(@NotNull PsiElement element, @Nullable PsiElement _contextElement, boolean canBeNamed) {
        if (element == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(1);
        }
        this.mySimpleTags = new HashMap<String, String>();
        this.namedItem = element instanceof JSPsiElementBase && canBeNamed ? (JSPsiElementBase)element : null;
        this.contextElement = _contextElement;
        this.myElement = element;
        this.mySeeAlsoDocBuilderInfo = new JSSeeAlsoDocBuilderInfo(this.myElement);
        if (this.namedItem != null) {
            PsiElement parent = element.getParent();
            this.namespace = element instanceof JSClass && parent instanceof JSPackageStatement ? ((JSPackageStatement)parent).getQualifiedName() : null;
        }
    }

    public final void appendDoc(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider2) {
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(3);
        }
        this.appendDefinitionDoc(result2);
        JSDocBuilderSymbolInfo.addContent(this, result2);
        result2.append("<table class='sections'>");
        JSDocBuilderSymbolInfo.addSections(this.mySimpleTags, result2);
        this.appendBodyDoc(result2);
        this.mySeeAlsoDocBuilderInfo.appendDoc(result2, provider2);
        result2.append("</table>");
    }

    protected void appendBodyDoc(@NotNull StringBuilder result2) {
        String text;
        String value;
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(4);
        }
        if (this.defaultValue != null) {
            result2.append(this.defaultValue);
        }
        if (this.myProperties != null) {
            JSDocBuilderSymbolInfo.startNamedSection("Properties:", result2);
            result2.append("<td>");
            for (Map.Entry<String, JSDocBuilderParameterInfo> field : this.myProperties.entrySet()) {
                result2.append("<p>");
                field.getValue().appendOptionDescription(field.getKey(), result2);
            }
            result2.append("</td>");
        }
        if (this.myElement instanceof JSConstantValueOwner && (value = ((JSConstantValueOwner)this.myElement).getConstantValueDescription()) != null) {
            JSDocBuilderSymbolInfo.startNamedSection("Constant value:", result2);
            JSDocBuilderSymbolInfo.appendSingleNamedDescriptionSection(value, "", result2);
        }
        if (this.contextElement != null && !(this.contextElement instanceof JSImplicitElement) && (text = this.contextElement.getText()).startsWith("#") && text.length() == 7) {
            result2.append(JSDocBuilderSymbolInfo.buildCurrentOrDefaultValue(text.substring(1), true, false, text, true));
        }
    }

    protected void appendDefinitionDoc(@NotNull StringBuilder result2) {
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(5);
        }
        if (this.namedItem != null || this.myElement instanceof JSAttributeNameValuePair) {
            result2.append("<div class='definition'><pre>");
            result2.append(this.namedItem != null ? JSDocumentationBuilder.getNameForDocumentation(this.namedItem) : ((JSAttributeNameValuePair)this.myElement).getSimpleValue());
            if (this.type != null) {
                result2.append(": ");
                result2.append(this.getTypeString());
            }
            result2.append("</pre></div>");
        }
    }

    protected static void addVisibilityAndAccess(JSDocBuilderSimpleInfo generationInfo, StringBuilder options) {
        if (generationInfo.modifiers != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.modifiers);
        }
        if (generationInfo.finalAccess != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.finalAccess);
        }
        if (generationInfo.deprecated) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append("deprecated");
        }
    }

    public static void addContent(@NotNull JSDocBuilderSymbolInfo info, @NotNull StringBuilder result2) {
        if (info == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(7);
        }
        if (info.hasDescription()) {
            result2.append("<div class='content'>");
            JSDocBuilderSymbolInfo.addDescription(info.getFinalDescription(), result2);
            result2.append("</div>");
        }
    }

    public static void addSections(@NotNull Map<String, String> sections, @NotNull StringBuilder result2) {
        if (sections == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, String> entry : sections.entrySet()) {
            JSDocBuilderSymbolInfo.startNamedSection(entry.getKey(), result2);
            result2.append("<td>");
            String value = entry.getValue();
            if (!value.startsWith("<p>")) {
                result2.append("<p>");
            }
            result2.append(value);
            result2.append("</td>");
        }
    }

    void setDefaultValue(String content, boolean color, String originalText) {
        this.defaultValue = JSDocBuilderSymbolInfo.buildCurrentOrDefaultValue(content, color, true, originalText, true);
    }

    public static void startNamedSection(String sectionName, StringBuilder result2) {
        result2.append("<tr><td valign='top' class='section'><p>");
        result2.append(sectionName);
        result2.append("</td>");
    }

    public static void appendSingleNamedDescriptionSection(String name, String description, @NotNull StringBuilder builder) {
        if (builder == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(10);
        }
        builder.append(name);
        if (description.length() > 0) {
            builder.append(" &ndash; ");
            builder.append(description);
        }
    }

    public static void addDescription(@NotNull String description, @NotNull StringBuilder builder) {
        if (description == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(12);
        }
        builder.append("<p>");
        builder.append(description);
    }

    protected static String buildCurrentOrDefaultValue(String content, boolean color, boolean isDefaultValue, String originalText, boolean needSection) {
        content = color ? "<code style='background-color:#" + content + "; color: #" + JSDocBuilderSymbolInfo.contrastColor(content) + "'>" + originalText + "</code>" : "<code>" + content + "</code>";
        String label = (isDefaultValue ? "Default" : "Value") + ":";
        if (!needSection) {
            return "<p>" + label + content;
        }
        return "<tr><td valign='top' class='section'><p>" + label + "</td><td>" + "<p>" + content;
    }

    private static String contrastColor(String remainingLineContent) {
        try {
            Color color = ColorUtil.fromHex((String)remainingLineContent);
            return ColorUtil.toHex((Color)(ColorUtil.isDark((Color)color) ? Color.WHITE : Color.BLACK));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return remainingLineContent;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sections";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderSymbolInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addSimpleTag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDoc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBodyDoc";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDefinitionDoc";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addSections";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSingleNamedDescriptionSection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

