/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSRefactoringFilterProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStatementUpDownMover
extends LineMover {
    private PsiElement myBlockStatementContainer;
    private boolean myShouldAddComma;

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        JSRefactoringFilterProvider refactoringFilterProvider;
        PsiLanguageInjectionHost languageInjectionHost;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof JSFile) && !(file2 instanceof XmlFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file2, info, down)) {
            return false;
        }
        this.myBlockStatementContainer = null;
        this.myShouldAddComma = false;
        if (file2 instanceof XmlFile && (languageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PsiLanguageInjectionHost.class)) != null) {
            Document document = editor.getDocument();
            int movedLineStartOffset = document.getLineStartOffset(info.toMove.startLine);
            TextRange possibleInjectionRange = languageInjectionHost.getTextRange();
            if (info.toMove.endLine < document.getLineCount() && possibleInjectionRange.containsRange(movedLineStartOffset, document.getLineStartOffset(info.toMove.endLine)) && info.toMove2.endLine < document.getLineCount() && possibleInjectionRange.containsRange(document.getLineStartOffset(info.toMove2.startLine), document.getLineStartOffset(info.toMove2.endLine))) {
                Ref result2 = new Ref();
                InjectedLanguageManager.getInstance((Project)file2.getProject()).enumerate((PsiElement)languageInjectionHost, (injectedPsi, places) -> {
                    if (editor == null) {
                        JSStatementUpDownMover.$$$reportNull$$$0(43);
                    }
                    if (info == null) {
                        JSStatementUpDownMover.$$$reportNull$$$0(44);
                    }
                    if (injectedPsi instanceof JSFile) {
                        StatementUpDownMover.MoveInfo myInfo = new StatementUpDownMover.MoveInfo();
                        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)injectedPsi);
                        int lineNumberDiff = editor.getDocument().getLineNumber(editor.getCaretModel().getOffset()) - injectedEditor.getDocument().getLineNumber(injectedEditor.getCaretModel().getOffset());
                        myInfo.toMove = new LineRange(info.toMove.startLine - lineNumberDiff, info.toMove.endLine - lineNumberDiff);
                        myInfo.toMove2 = new LineRange(info.toMove2.startLine - lineNumberDiff, info.toMove2.endLine - lineNumberDiff);
                        if (this.canMoveIt(injectedEditor, injectedPsi, myInfo, down)) {
                            myInfo.toMove = new LineRange(myInfo.toMove.startLine + lineNumberDiff, myInfo.toMove.endLine + lineNumberDiff);
                            myInfo.toMove2 = new LineRange(myInfo.toMove2.startLine + lineNumberDiff, myInfo.toMove2.endLine + lineNumberDiff);
                            result2.set((Object)myInfo);
                        }
                    }
                });
                StatementUpDownMover.MoveInfo newInfo = (StatementUpDownMover.MoveInfo)result2.get();
                if (newInfo != null) {
                    info.toMove = newInfo.toMove;
                    info.toMove2 = newInfo.toMove2;
                    return true;
                }
            }
        }
        if ((refactoringFilterProvider = (JSRefactoringFilterProvider)JSRefactoringFilterProvider.INSTANCE.forLanguage(file2.getLanguage())) == null) {
            refactoringFilterProvider = JSRefactoringFilterProvider.DEFAULT_INSTANCE;
        }
        if (!refactoringFilterProvider.isRefactoringEnabled(JSStatementUpDownMover.class)) {
            return false;
        }
        boolean result3 = this.canMoveIt(editor, file2, info, down);
        if (info.toMove2 == null) {
            return result3;
        }
        if (down && info.toMove.endLine > info.toMove2.startLine) {
            return false;
        }
        if (!down && info.toMove.startLine < info.toMove2.endLine) {
            return false;
        }
        return result3;
    }

    private boolean canMoveIt(Editor editor, PsiFile file2, StatementUpDownMover.MoveInfo info, boolean down) {
        Document document = editor.getDocument();
        if (JSStatementUpDownMover.isSameNode(file2, info, document, down)) {
            return false;
        }
        ElementRange movedRange = JSStatementUpDownMover.getSourceElementRange(editor, file2, info.toMove, document);
        if (JSStatementUpDownMover.isNotValidStatementRange(movedRange)) {
            return false;
        }
        info.toMove = new LineRange(Math.min(info.toMove.startLine, movedRange.rangeToMove.startLine), Math.max(movedRange.rangeToMove.endLine, info.toMove.endLine));
        if (movedRange.first instanceof JSProperty) {
            return this.moveListItem(info, down, document, movedRange, JSProperty.class);
        }
        if (movedRange.first.getParent() instanceof JSArrayLiteralExpression) {
            return this.moveListItem(info, down, document, movedRange, JSExpression.class);
        }
        if (movedRange.first.getParent() instanceof JSClass || movedRange.first.getParent() instanceof TypeScriptObjectType) {
            PsiElement meaningfulSibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, (Condition<PsiElement>)((Condition)element -> JSStatementUpDownMover.elementOfTypeOrOwnComment(element, JSFunction.class, JSVarStatement.class, TypeScriptTypeMember.class)), down);
            if (meaningfulSibling != null) {
                return JSStatementUpDownMover.moveNextTo(meaningfulSibling, info, document);
            }
            if (JSClassUtils.isES6ClassImplementation(movedRange.first)) {
                return info.prohibitMove();
            }
            return JSStatementUpDownMover.moveElementsByLine(info, document, movedRange, down);
        }
        if (movedRange.first instanceof JSSourceElement) {
            return this.moveSourceElements(info, down, document, movedRange);
        }
        return JSStatementUpDownMover.moveElementsByLine(info, document, movedRange, down);
    }

    private <T extends PsiElement> boolean moveListItem(StatementUpDownMover.MoveInfo info, boolean down, Document document, ElementRange movedRange, Class<? extends T> siblingClass) {
        PsiElement arrayElement = JSStatementUpDownMover.findSiblingByCondition(movedRange, (Condition<PsiElement>)((Condition)element -> siblingClass.isInstance(element)), down);
        if (arrayElement != null) {
            PsiElement lastElement = down ? arrayElement : movedRange.second;
            this.myShouldAddComma = JSStatementUpDownMover.isLastElementWithoutComma(lastElement, siblingClass);
            return JSStatementUpDownMover.moveNextTo(arrayElement, info, document);
        }
        return info.prohibitMove();
    }

    private boolean moveSourceElements(StatementUpDownMover.MoveInfo info, boolean down, Document document, ElementRange movedRange) {
        if (movedRange.first.getParent() instanceof JSPackageStatement) {
            return false;
        }
        if (movedRange.first instanceof JSStatement) {
            return this.moveStatements(info, down, document, movedRange);
        }
        PsiElement sibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, (Condition<PsiElement>)((Condition)element -> JSStatementUpDownMover.elementOfTypeOrOwnComment(element, JSSourceElement.class)), down);
        if (sibling != null) {
            return JSStatementUpDownMover.moveNextTo(sibling, info, document);
        }
        return JSStatementUpDownMover.moveElementsByLine(info, document, movedRange, down);
    }

    private boolean moveStatements(StatementUpDownMover.MoveInfo info, boolean down, Document document, ElementRange movedRange) {
        PsiElement sibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, (Condition<PsiElement>)((Condition)element -> JSStatementUpDownMover.elementOfTypeOrOwnComment(element, JSSourceElement.class)), down);
        if (JSStatementUpDownMover.isBlockStatementContainer(sibling)) {
            PsiElement body = JSStatementUpDownMover.getStatementBodyOrNull(sibling, down);
            if (!(body instanceof JSBlockStatement)) {
                return this.moveIntoAndSurroundWithBlock(info, down, document, sibling);
            }
            return JSStatementUpDownMover.moveIntoBlock((JSBlockStatement)body, info, document, down);
        }
        if (sibling == null && movedRange.first.getParent() instanceof JSBlockStatement) {
            JSIfStatement ifStatement;
            PsiElement block = movedRange.second.getParent();
            JSIfStatement jSIfStatement = ifStatement = block.getParent() instanceof JSIfStatement ? (JSIfStatement)block.getParent() : null;
            if (ifStatement != null) {
                JSBlockStatement thenBlock = (JSBlockStatement)ObjectUtils.tryCast((Object)ifStatement.getThen(), JSBlockStatement.class);
                JSBlockStatement elseBlock = (JSBlockStatement)ObjectUtils.tryCast((Object)ifStatement.getElse(), JSBlockStatement.class);
                if (elseBlock != null && thenBlock != null && (block == ifStatement.getThen() && down || block == ifStatement.getElse() && !down)) {
                    TextRange additionalBlockRange = JSStatementUpDownMover.blockHeaderRange(elseBlock);
                    if (additionalBlockRange != null) {
                        additionalBlockRange = new TextRange(thenBlock.getNode().findChildByType(JSTokenTypes.RBRACE).getStartOffset(), additionalBlockRange.getEndOffset());
                        int start = document.getLineNumber(additionalBlockRange.getStartOffset());
                        int end = JSStatementUpDownMover.advanceToRange(document, additionalBlockRange.getEndOffset());
                        info.toMove2 = new LineRange(start, end);
                        return true;
                    }
                    return false;
                }
            }
            return JSStatementUpDownMover.moveOut((JSBlockStatement)block, info, document, down);
        }
        if (sibling != null) {
            JSSourceElement body;
            JSFunction possibleFunction = JSStatementUpDownMover.findPossibleFunction(sibling);
            if (possibleFunction != null && JSStatementUpDownMover.isMultiline((PsiElement)possibleFunction, document) && JSStatementUpDownMover.findPossibleFunction(movedRange.first) == null && JSStatementUpDownMover.findPossibleFunction(movedRange.second) == null && (body = (JSSourceElement)ArrayUtil.getFirstElement((Object[])possibleFunction.getBody())) != null) {
                return JSStatementUpDownMover.moveIntoBlock((JSBlockStatement)possibleFunction.getBody()[0], info, document, down);
            }
            return JSStatementUpDownMover.moveNextTo(sibling, info, document);
        }
        return JSStatementUpDownMover.moveElementsByLine(info, document, movedRange, down);
    }

    private static boolean moveElementsByLine(@NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document, @NotNull ElementRange movedRange, boolean down) {
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(3);
        }
        if (document == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(4);
        }
        if (movedRange == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(5);
        }
        if (down) {
            int destinationLine = movedRange.rangeToMove.endLine + 1;
            if (destinationLine >= document.getLineCount()) {
                return info.prohibitMove();
            }
            info.toMove2 = new LineRange(movedRange.rangeToMove.endLine, destinationLine);
            return true;
        }
        info.toMove2 = new LineRange(Math.max(movedRange.rangeToMove.startLine - 1, 0), movedRange.rangeToMove.startLine);
        return true;
    }

    @Nullable
    private static PsiElement findSiblingByCondition(@NotNull ElementRange range, @NotNull Condition<PsiElement> condition, boolean down) {
        PsiElement child;
        if (range == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(6);
        }
        if (condition == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(7);
        }
        PsiElement startElement = down ? range.second : range.first;
        PsiElement psiElement = child = down ? startElement.getNextSibling() : startElement.getPrevSibling();
        while (child != null) {
            if (condition.value((Object)child)) {
                return child;
            }
            child = down ? child.getNextSibling() : child.getPrevSibling();
        }
        return null;
    }

    private static boolean elementOfTypeOrOwnComment(PsiElement element, Class<? extends PsiElement> ... classes) {
        if (element instanceof PsiComment) {
            return JSStatementUpDownMover.findLeadingCommentOwner((PsiComment)element) == null && JSStatementUpDownMover.findTrailingEndOfLineCommentOwner((PsiComment)element) == null;
        }
        return ContainerUtil.or((Object[])classes, aClass -> aClass.isInstance(element));
    }

    private boolean moveIntoAndSurroundWithBlock(StatementUpDownMover.MoveInfo info, boolean down, Document document, PsiElement sibling) {
        if (down) {
            int lineNumber = info.toMove.endLine;
            info.toMove2 = new LineRange(lineNumber, Math.min(lineNumber + 1, document.getLineCount()));
        } else {
            int lineNumber = info.toMove.startLine;
            info.toMove2 = new LineRange(Math.max(0, lineNumber - 1), lineNumber);
        }
        this.myBlockStatementContainer = sibling;
        return true;
    }

    private static boolean moveOut(@NotNull JSBlockStatement blockStatement, @NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document, boolean down) {
        if (blockStatement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(8);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(9);
        }
        if (document == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(10);
        }
        return JSStatementUpDownMover.moveIntoBlock(blockStatement, info, document, !down);
    }

    private static boolean moveIntoBlock(@NotNull JSBlockStatement body, @NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document, boolean down) {
        if (body == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(11);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(12);
        }
        if (document == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(13);
        }
        if (down) {
            TextRange blockHeaderRange = JSStatementUpDownMover.blockHeaderRange(body);
            int start = document.getLineNumber(blockHeaderRange.getStartOffset());
            int end = JSStatementUpDownMover.advanceToRange(document, blockHeaderRange.getEndOffset());
            info.toMove2 = new LineRange(start, end);
        } else {
            TextRange range = JSStatementUpDownMover.blockTailRange(body);
            int start = document.getLineNumber(range.getStartOffset());
            int end = JSStatementUpDownMover.advanceToRange(document, range.getEndOffset());
            info.toMove2 = new LineRange(start, end);
        }
        return true;
    }

    private static boolean moveNextTo(@NotNull PsiElement destination, @NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document) {
        ElementRange destinationRange;
        if (destination == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(14);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(15);
        }
        if (document == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(16);
        }
        if (JSStatementUpDownMover.isNotValidStatementRange(destinationRange = new ElementRange(destination, destination, new LineRange(JSStatementUpDownMover.expandRangeBefore(destination), JSStatementUpDownMover.expandRangeAfter(destination), document)))) {
            return false;
        }
        info.toMove2 = destinationRange.rangeToMove;
        return true;
    }

    @Nullable
    private static JSFunction findPossibleFunction(@NotNull PsiElement element) {
        JSVariable[] variables;
        JSStatement statement;
        if (element == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(17);
        }
        if (element instanceof JSFunction) {
            return (JSFunction)element;
        }
        JSExpression candidate = null;
        JSStatement jSStatement = statement = element instanceof JSStatement ? (JSStatement)element : null;
        if (statement instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)statement).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                candidate = ((JSAssignmentExpression)expression).getROperand();
            } else if (expression instanceof JSCallExpression && ((JSCallExpression)expression).getArguments().length == 1) {
                candidate = (JSExpression)ArrayUtil.getFirstElement((Object[])((JSCallExpression)expression).getArguments());
            }
        } else if (statement instanceof JSVarStatement && (variables = ((JSVarStatement)statement).getVariables()).length == 1) {
            candidate = variables[0].getInitializer();
        }
        return (JSFunction)ObjectUtils.tryCast((Object)JSUtils.unparenthesize(candidate), JSFunctionExpression.class);
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(18);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(19);
        }
        super.beforeMove(editor, info, down);
        if (this.myBlockStatementContainer != null && JSStatementUpDownMover.isMultiline(this.myBlockStatementContainer, editor.getDocument())) {
            this.surroundWithCodeBlock(editor, info, down);
        }
        if (this.myShouldAddComma) {
            JSStatementUpDownMover.addComma(editor, info, down);
        }
    }

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(21);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(22);
        }
        super.afterMove(editor, file2, info, down);
        this.myBlockStatementContainer = null;
    }

    private static boolean isMultiline(PsiElement element, Document document) {
        TextRange textRange = element.getTextRange();
        int start = document.getLineNumber(textRange.getStartOffset());
        int end = document.getLineNumber(textRange.getEndOffset());
        return end - start != 0;
    }

    private static void addComma(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(23);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(24);
        }
        Document document = editor.getDocument();
        int offset = document.getLineEndOffset((down ? info.toMove2.endLine : info.toMove.endLine) - 1);
        document.insertString(offset, (CharSequence)",");
        offset = document.getLineEndOffset((down ? info.toMove.endLine : info.toMove2.endLine) - 1);
        String text = document.getText(new TextRange(offset - 1, offset));
        if (text.equals(",")) {
            document.deleteString(offset - 1, offset);
        }
        PsiDocumentManager.getInstance((Project)editor.getProject()).commitDocument(document);
    }

    private void surroundWithCodeBlock(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int endOffset;
        int startOffset;
        PsiElement body;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(25);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(26);
        }
        if ((body = JSStatementUpDownMover.getStatementBodyOrNull(this.myBlockStatementContainer, down)) == null || body instanceof JSBlockStatement) {
            return;
        }
        Document document = editor.getDocument();
        Project project = this.myBlockStatementContainer.getProject();
        PsiFile containingFile = this.myBlockStatementContainer.getContainingFile();
        if (down) {
            startOffset = document.getLineEndOffset(info.toMove2.startLine);
            endOffset = body.getTextRange().getEndOffset() + 1;
        } else {
            startOffset = body.getTextRange().getStartOffset();
            endOffset = document.getLineEndOffset(info.toMove.endLine - 1) + 1;
        }
        document.insertString(startOffset, (CharSequence)"{");
        document.insertString(endOffset, (CharSequence)"}");
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)containingFile, startOffset, endOffset + 2);
    }

    @Nullable
    private static PsiElement getStatementBodyOrNull(PsiElement statement, boolean down) {
        if (statement instanceof JSLoopStatement) {
            return ((JSLoopStatement)statement).getBody();
        }
        if (statement instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)statement;
            if (down) {
                return ifStatement.getThen();
            }
            JSStatement elseBranch = ifStatement.getElse();
            return JSStatementUpDownMover.getStatementBodyOrNull((PsiElement)(elseBranch == null ? ifStatement.getThen() : elseBranch), false);
        }
        return statement;
    }

    private static boolean isSameNode(PsiFile file2, StatementUpDownMover.MoveInfo info, Document document, boolean down) {
        int endOffset;
        int startOffset;
        if (down) {
            startOffset = document.getLineStartOffset(info.toMove.startLine);
            endOffset = document.getLineEndOffset(info.toMove2.endLine - 1);
        } else {
            startOffset = document.getLineStartOffset(info.toMove2.startLine);
            endOffset = document.getLineEndOffset(info.toMove.endLine - 1);
        }
        return file2.findElementAt(startOffset) == file2.findElementAt(endOffset);
    }

    private static int advanceToRange(Document document, int offset) {
        int afterNextLf = CharArrayUtil.shiftForwardUntil((CharSequence)document.getCharsSequence(), (int)offset, (String)"\n") + 1;
        return afterNextLf < document.getTextLength() ? document.getLineNumber(afterNextLf) : document.getLineCount();
    }

    @NotNull
    private static TextRange blockTailRange(@NotNull JSBlockStatement blockStatement) {
        if (blockStatement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(27);
        }
        ASTNode rBrace = blockStatement.getNode().findChildByType(JSTokenTypes.RBRACE);
        assert (rBrace != null);
        TextRange textRange = new TextRange(rBrace.getTextRange().getStartOffset(), blockStatement.getParent().getTextRange().getEndOffset());
        if (textRange == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(28);
        }
        return textRange;
    }

    @NotNull
    private static TextRange blockHeaderRange(@NotNull JSBlockStatement blockStatement) {
        if (blockStatement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(29);
        }
        ASTNode lBrace = blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE);
        assert (lBrace != null);
        TextRange textRange = new TextRange(blockStatement.getNode().getTreeParent().getStartOffset(), lBrace.getTextRange().getEndOffset());
        if (textRange == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(30);
        }
        return textRange;
    }

    private static PsiElement expandRangeBefore(PsiElement first) {
        ASTNode node = first.getNode();
        if (node.getElementType() == JSTokenTypes.COMMA) {
            PsiElement prevElement = first.getPrevSibling();
            if (prevElement instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement instanceof JSProperty) {
                return prevElement;
            }
        }
        if (JSStatementUpDownMover.isCommentOwner(first)) {
            return JSPsiImplUtils.findLeadingCommentOrSelf(first);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)JSStatementUpDownMover.expandLineCommentBlock(node, false), (Object)first);
    }

    private static boolean isTrivialWs(PsiWhiteSpace prevElement) {
        String text = prevElement.getText();
        return text.startsWith("\n") && text.indexOf("\n", 1) == -1;
    }

    private static PsiElement expandRangeAfter(PsiElement second) {
        if (second instanceof JSProperty) {
            PsiElement nextElement = second.getNextSibling();
            if (nextElement instanceof PsiWhiteSpace) {
                nextElement = nextElement.getNextSibling();
            }
            if (nextElement != null && nextElement.getNode().getElementType() == JSTokenTypes.COMMA) {
                return nextElement;
            }
        }
        if (JSStatementUpDownMover.isCommentOwner(second)) {
            return (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.findTrailingEndOfLineComment(second), (Object)second);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)JSStatementUpDownMover.expandLineCommentBlock(second.getNode(), true), (Object)second);
    }

    private static boolean isCommentOwner(@Nullable PsiElement nextElement) {
        return nextElement instanceof JSExpressionStatement || nextElement instanceof JSQualifiedNamedElement || nextElement instanceof TypeScriptTypeMember || nextElement instanceof JSVarStatement;
    }

    @Nullable
    private static PsiElement expandLineCommentBlock(ASTNode node, boolean down) {
        if (node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            ASTNode prev;
            do {
                prev = node;
                ASTNode aSTNode = node = down ? node.getTreeNext() : node.getTreePrev();
                if (!(node instanceof PsiWhiteSpace) || !JSStatementUpDownMover.isTrivialWs((PsiWhiteSpace)node)) continue;
                ASTNode aSTNode2 = node = down ? node.getTreeNext() : node.getTreePrev();
            } while (node != null && node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT);
            return prev.getPsi();
        }
        return null;
    }

    private static boolean isNotValidStatementRange(@Nullable ElementRange range) {
        if (range == null || range.first.getParent() != range.second.getParent()) {
            return true;
        }
        if (JSStatementUpDownMover.isAdjacentToError(range.first, false)) {
            return true;
        }
        return JSStatementUpDownMover.isAdjacentToError(range.second, true);
    }

    private static boolean isAdjacentToError(@NotNull PsiElement element, boolean down) {
        PsiElement prevLeaf;
        if (element == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(31);
        }
        PsiElement psiElement = prevLeaf = down ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        while (prevLeaf instanceof PsiWhiteSpace) {
            prevLeaf = down ? PsiTreeUtil.nextLeaf((PsiElement)prevLeaf) : PsiTreeUtil.prevLeaf((PsiElement)prevLeaf);
            if (prevLeaf == null || prevLeaf.getNode() == null || prevLeaf.getNode().getElementType() != JSTokenTypes.SEMICOLON) continue;
            prevLeaf = down ? PsiTreeUtil.nextLeaf((PsiElement)prevLeaf) : PsiTreeUtil.prevLeaf((PsiElement)prevLeaf);
        }
        return prevLeaf instanceof PsiErrorElement;
    }

    private static Couple<PsiElement> findElementRange(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull LineRange toMove) {
        PsiElement endingElement;
        int lineCount;
        Document document;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(32);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(33);
        }
        if (toMove == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(34);
        }
        int startOffset = document.getLineStartOffset(toMove.startLine < (lineCount = (document = editor.getDocument()).getLineCount()) ? toMove.startLine : lineCount - 1);
        PsiElement startingElement = JSStatementUpDownMover.firstNonWhiteElement((int)startOffset, (PsiFile)file2, (boolean)true);
        int endOffset = toMove.endLine < lineCount ? document.getLineStartOffset(toMove.endLine) - 1 : document.getLineEndOffset(lineCount - 1);
        PsiElement psiElement = endingElement = endOffset > startOffset ? JSStatementUpDownMover.firstNonWhiteElement((int)endOffset, (PsiFile)file2, (boolean)false) : startingElement;
        if (startingElement != null && endingElement != null && startingElement.getTextRange().getStartOffset() > endingElement.getTextRange().getEndOffset()) {
            endingElement = startingElement = file2.findElementAt(startOffset);
        }
        return Couple.of((Object)startingElement, (Object)endingElement);
    }

    @Nullable
    private static ElementRange getSourceElementRange(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull LineRange toMove, @NotNull Document document) {
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(36);
        }
        if (toMove == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(37);
        }
        if (document == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(38);
        }
        Couple<PsiElement> range = JSStatementUpDownMover.findElementRange(editor, file2, toMove);
        PsiElement statement = JSStatementUpDownMover.getSourceElement((PsiElement)range.first);
        PsiElement statement2 = JSStatementUpDownMover.getSourceElement((PsiElement)range.second);
        if (statement2 != null && PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)statement2, (boolean)false)) {
            statement2 = statement;
        }
        if (statement != null && PsiTreeUtil.isAncestor((PsiElement)statement2, (PsiElement)statement, (boolean)false)) {
            statement = statement2;
        }
        if (statement == null || statement2 == null) {
            return null;
        }
        LineRange rangeToMove = new LineRange(JSStatementUpDownMover.expandRangeBefore(statement), JSStatementUpDownMover.expandRangeAfter(statement2), document);
        return new ElementRange(statement, statement2, rangeToMove);
    }

    @Nullable
    private static PsiElement findLeadingCommentOwner(@NotNull PsiComment comment) {
        PsiElement nextElement;
        if (comment == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(39);
        }
        if ((nextElement = comment.getNextSibling()) instanceof PsiWhiteSpace && JSStatementUpDownMover.isTrivialWs((PsiWhiteSpace)nextElement)) {
            nextElement = nextElement.getNextSibling();
        }
        if (JSStatementUpDownMover.isCommentOwner(nextElement)) {
            return nextElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement findTrailingEndOfLineCommentOwner(@NotNull PsiComment comment) {
        if (comment == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(40);
        }
        if (comment.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) {
            return null;
        }
        PsiElement prev = comment.getPrevSibling();
        return prev != null && (!(prev instanceof PsiWhiteSpace) || !prev.textContains('\n')) ? comment : null;
    }

    private static boolean isBlockStatementContainer(PsiElement parent) {
        return parent instanceof JSLoopStatement || parent instanceof JSIfStatement;
    }

    @Nullable
    private static PsiElement getSourceElement(PsiElement first) {
        if (first == null) {
            return null;
        }
        if (first.getNode().getElementType() == JSTokenTypes.COMMA || first.getNode().getElementType() == JSTokenTypes.SEMICOLON) {
            PsiElement prevElement = first.getPrevSibling();
            if (prevElement instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement == null) {
                return null;
            }
            first = prevElement;
        }
        return PsiTreeUtil.findFirstParent((PsiElement)first, (boolean)false, parent -> {
            if (parent instanceof JSExpression && parent.getParent() instanceof JSArrayLiteralExpression) {
                return true;
            }
            if (parent instanceof JSFunctionExpression) {
                return false;
            }
            if (parent instanceof JSStatement) {
                return !(parent instanceof JSBlockStatement) && !(parent instanceof JSPackageStatement);
            }
            return parent instanceof JSFunction || parent instanceof PsiComment || parent instanceof JSProperty || parent instanceof TypeScriptTypeMember || parent instanceof JSClass;
        });
    }

    private static boolean isLastElementWithoutComma(@NotNull PsiElement lastElement, @NotNull Class<? extends PsiElement> elementType) {
        if (lastElement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(41);
        }
        if (elementType == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(42);
        }
        return PsiTreeUtil.getNextSiblingOfType((PsiElement)lastElement, elementType) == null && TreeUtil.findSibling((ASTNode)lastElement.getNode(), (IElementType)JSTokenTypes.COMMA) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 21: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedRange";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStatement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JSStatementUpDownMover";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMove";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JSStatementUpDownMover";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "blockTailRange";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "blockHeaderRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveElementsByLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingByCondition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveOut";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveIntoBlock";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moveNextTo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleFunction";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "afterMove";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addComma";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "surroundWithCodeBlock";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "blockTailRange";
                break;
            }
            case 28: 
            case 30: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "blockHeaderRange";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAdjacentToError";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findElementRange";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElementRange";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findLeadingCommentOwner";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingEndOfLineCommentOwner";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isLastElementWithoutComma";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkAvailable$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementRange {
        @NotNull
        public final PsiElement first;
        @NotNull
        public final PsiElement second;
        @NotNull
        public final LineRange rangeToMove;

        public ElementRange(@NotNull PsiElement first, @NotNull PsiElement second, @NotNull LineRange rangeToMove) {
            if (first == null) {
                ElementRange.$$$reportNull$$$0(0);
            }
            if (second == null) {
                ElementRange.$$$reportNull$$$0(1);
            }
            if (rangeToMove == null) {
                ElementRange.$$$reportNull$$$0(2);
            }
            this.first = first;
            this.second = second;
            this.rangeToMove = rangeToMove;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "first";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "second";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeToMove";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/editing/JSStatementUpDownMover$ElementRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

