/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.frameworks.amd.JSAmdBaseUrlIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdRequirePathIndex;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAmdIndexingHandler
extends FrameworkIndexingHandler {
    static final int VERSION = 2;
    private static final String[] INTERESTED_PROPERTIES = new String[]{"baseUrl", "paths"};
    private static final String DEFINE = "define";
    private static final String[] INTERESTED_METHOD_NAMES = new String[]{"define"};

    @Override
    @NotNull
    public String[] interestedProperties() {
        if (INTERESTED_PROPERTIES == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(0);
        }
        return INTERESTED_PROPERTIES;
    }

    @Override
    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        PsiElement argList;
        if (property == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(1);
        }
        if (!((argList = property.getParent().getParent()) instanceof JSArgumentList)) {
            return outData;
        }
        PsiElement callExpr = argList.getParent();
        if (!(callExpr instanceof JSCallExpression)) {
            return outData;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpr).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return outData;
        }
        if (!"config".equals(((JSReferenceExpression)methodExpression).getReferencedName())) {
            return outData;
        }
        String name = property.getName();
        JSExpression value = property.getValue();
        if ("baseUrl".equals(name) && value instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            String url = StringUtil.unquoteString((String)value.getText());
            if (!url.contains(":")) {
                if (outData == null) {
                    outData = new JSElementIndexingDataImpl();
                }
                outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl.Builder("jsRequireBaseUrl", (PsiElement)value).setTypeString(url).setUserString("abu").toImplicitElement());
                return outData;
            }
        } else if ("paths".equals(name) && value instanceof JSObjectLiteralExpression) {
            THashMap paths = new THashMap();
            for (JSProperty path : ((JSObjectLiteralExpression)value).getProperties()) {
                JSExpression pathValue = path.getValue();
                if (!(pathValue instanceof JSLiteralExpression) || !((JSLiteralExpression)pathValue).isQuotedLiteral()) continue;
                paths.put(path.getName(), StringUtil.unquoteString((String)pathValue.getText()));
            }
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl.Builder("jsRequirePathAliases", (PsiElement)value).setTypeString(JSAmdIndexingHandler.serializeMap((Map<String, String>)paths)).setUserString("arp").toImplicitElement());
            return outData;
        }
        return outData;
    }

    @Override
    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        if (element == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            return false;
        }
        String string = element.getUserString();
        if ("abu".equals(string)) {
            sink.occurrence(JSAmdBaseUrlIndex.KEY, (Object)element.getName());
        } else if ("arp".equals(string)) {
            sink.occurrence(JSAmdRequirePathIndex.KEY, (Object)element.getName());
        }
        return super.indexImplicitElement(element, sink);
    }

    private static String serializeMap(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtil.containsAnyChar((String)key, (String)"*|") || StringUtil.containsAnyChar((String)value, (String)"*|")) continue;
            builder.append(separator).append(key).append("*").append(value);
            separator = "|";
        }
        return builder.toString();
    }

    public static Map<String, String> deserializeMap(String serialized) {
        THashMap map = new THashMap();
        for (String entry : StringUtil.split((String)serialized, (String)"|")) {
            int separatorIndex = entry.indexOf(42);
            assert (separatorIndex >= 0);
            map.put(entry.substring(0, separatorIndex), entry.substring(separatorIndex + 1));
        }
        return map;
    }

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(3);
        }
        if (JSAmdPsiUtil.isDefineCall(callExpression)) {
            String referenceName;
            Collection returnedExpressions;
            JSReferenceExpression returnedReference;
            String localAlias = "";
            JSExpression moduleInitializer = JSAmdPsiUtil.getModuleInitializer(callExpression);
            if (moduleInitializer instanceof JSFunctionExpression && (returnedReference = (JSReferenceExpression)ContainerUtil.getFirstItem(returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)moduleInitializer), JSReferenceExpression.class))) != null && returnedReference.getQualifier() == null && (referenceName = returnedReference.getReferenceName()) != null) {
                localAlias = referenceName;
            }
            outData.putUserString("def", localAlias);
        }
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        return JSAmdPsiUtil.isDefineCall(node);
    }

    @Override
    @NotNull
    public String[] implicitProviderMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(4);
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            JSAmdIndexingHandler.$$$reportNull$$$0(5);
        }
        if (DEFINE.equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    if (argument == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (callExpression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outIndexingData == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (!JSAmdPsiUtil.isDefineCall(callExpression)) {
                        return;
                    }
                    JSExpression[] arguments = callExpression.getArguments();
                    if (arguments[0] != argument) {
                        return;
                    }
                    String name = JSAmdPsiUtil.unifyModuleName(argument);
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)argument).setContext(JSContext.STATIC).setNamespaceExplicitlyDeclared(true).setType(JSImplicitElement.Type.Namespace).setUserString("amd");
                    outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "argument";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outIndexingData";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler$1";
                    objectArray[2] = "fillIndexingData";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    static {
        JSImplicitElement.ourUserStringsRegistry.registerUserString("amd");
        JSImplicitElement.ourUserStringsRegistry.registerUserString("abu");
        JSImplicitElement.ourUserStringsRegistry.registerUserString("arp");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "interestedProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/amd/JSAmdIndexingHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "implicitProviderMethodNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAnyProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "indexImplicitElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralImplicitElementProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

