/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.editor.ES6CopyPasteProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.frameworks.react.JSXAttributeCustomMapping;
import com.intellij.lang.javascript.frameworks.react.JSXCopyPasteTagProcessor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.JBIterable;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J*\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J8\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/frameworks/react/JSXCopyPasteTagProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "()V", "buildNewTextWithReplacedAttributes", "", "originalText", "attributes", "", "Lcom/intellij/lang/javascript/frameworks/react/JSXCopyPasteTagProcessor$AttributeToReplace;", "collectAttributes", "tag", "Lcom/intellij/psi/xml/XmlTag;", "isFileAcceptable", "", "file", "Lcom/intellij/psi/PsiFile;", "isPossibleContentWithTag", "text", "preprocessOnCopy", "startOffsets", "", "endOffsets", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "AttributeToReplace", "intellij.javascript.impl"})
public final class JSXCopyPasteTagProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file2, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkParameterIsNotNull((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return null;
    }

    private final boolean isFileAcceptable(PsiFile file2) {
        return file2 instanceof JSFile || file2 instanceof HtmlFileImpl;
    }

    @NotNull
    public String preprocessOnPaste(@Nullable Project project, @Nullable PsiFile file2, @Nullable Editor editor, @NotNull String text, @Nullable RawText rawText) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (project == null || file2 == null || !this.isFileAcceptable(file2) || !JSEditorOptions.getInstance().CONVERT_HTML_TO_JSX || editor == null) {
            return text;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement context = ES6CopyPasteProcessor.getContextElementOrFile(file2, offset);
        if (context == null || !DialectDetector.isJSX(context) || ES6CopyPasteProcessor.isStringLiteralOrCommentContext(context) || !this.isPossibleContentWithTag(text)) {
            return text;
        }
        ASTNode aSTNode = JSChangeUtil.createStatementFromTextWithContext("<>" + text + "</>", context);
        if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
            return text;
        }
        ASTNode parentStatement = aSTNode;
        PsiElement fragmentCandidate = parentStatement.getFirstChild();
        if (!(fragmentCandidate instanceof JSXmlLiteralExpressionImpl)) {
            return text;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)fragmentCandidate, PsiErrorElement.class) != null) {
            return text;
        }
        List<AttributeToReplace> attributes = this.collectAttributes((XmlTag)fragmentCandidate);
        if (attributes.isEmpty()) {
            return text;
        }
        return this.buildNewTextWithReplacedAttributes(text, attributes);
    }

    private final String buildNewTextWithReplacedAttributes(String originalText, List<AttributeToReplace> attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        int prevOffset = 0;
        Iterable $receiver$iv = attributes;
        for (Object element$iv : $receiver$iv) {
            AttributeToReplace it = (AttributeToReplace)element$iv;
            int startOffsetInOriginalText = it.getStartOffsetInOriginalText();
            stringBuilder.append(originalText.subSequence(prevOffset, startOffsetInOriginalText));
            stringBuilder.append(it.getNewName());
            prevOffset = it.getEndOffsetInOriginalText();
        }
        stringBuilder.append(originalText.subSequence(prevOffset, originalText.length()));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AttributeToReplace> collectAttributes(XmlTag tag) {
        Comparator comparator;
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)tag)).traverse().filter(XmlTag.class).filter((Condition)collectAttributes.tagList.1.INSTANCE);
        List tagList2 = jBIterable.sorted(comparator = (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                XmlTag it;
                XmlTag xmlTag = it = (XmlTag)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag, (String)"it");
                it = (XmlTag)b;
                Comparable comparable = Integer.valueOf(xmlTag.getTextOffset());
                XmlTag xmlTag2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag2, (String)"it");
                Integer n = xmlTag2.getTextOffset();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        }).toList();
        if (tagList2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        Project project = tag.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"tag.project");
        JSXAttributeCustomMapping mapping = JSXAttributeCustomMapping.Companion.getMapping(project);
        List list = tagList2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"tagList");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            String string;
            Map map;
            void $receiver$iv$iv;
            XmlElementDescriptor tagDescriptor;
            XmlTag it;
            XmlTag xmlTag = it = (XmlTag)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag, (String)"it");
            if (xmlTag.getDescriptor() == null) {
                continue;
            }
            XmlAttributeDescriptor[] attributesDescriptors = tagDescriptor.getAttributesDescriptors(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)attributesDescriptors, (String)"attributesDescriptors");
            Object[] $receiver$iv2 = attributesDescriptors;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$receiver$iv2.length), (int)16);
            Object[] objectArray = $receiver$iv2;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (String element$iv$iv : $receiver$iv$iv) {
                String string2;
                void it2;
                XmlAttributeDescriptor xmlAttributeDescriptor = (XmlAttributeDescriptor)element$iv$iv;
                map = destination$iv$iv;
                void v3 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull((Object)v3.getName(), (String)"it.name");
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                map.put(string, element$iv$iv);
            }
            Map namesFromTag = destination$iv$iv;
            for (XmlAttribute attribute : it.getAttributes()) {
                String element$iv$iv;
                String realAttrName = attribute.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)realAttrName, (String)"realAttrName");
                map = namesFromTag;
                String string4 = element$iv$iv;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                XmlAttributeDescriptor descriptor2 = (XmlAttributeDescriptor)map.get(string);
                if (descriptor2 == null) {
                    String mappedName = mapping.getMappedAttribute(realAttrName);
                    if (mappedName == null) continue;
                    result2.add(new AttributeToReplace(attribute, mappedName));
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)descriptor2.getName(), (Object)realAttrName) ^ true)) continue;
                String string5 = descriptor2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"descriptor.name");
                result2.add(new AttributeToReplace(attribute, string5));
            }
        }
        return result2;
    }

    private final boolean isPossibleContentWithTag(String text) {
        String string;
        String string2 = string = text;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String trimmedText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)trimmedText, (String)"<", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)trimmedText, (String)">", (boolean)false, (int)2, null)) {
            return false;
        }
        char firstLetter = trimmedText.charAt(1);
        char c = firstLetter;
        return Character.isLetter(c) && Character.isLowerCase(c = firstLetter);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/frameworks/react/JSXCopyPasteTagProcessor$AttributeToReplace;", "", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "newName", "", "(Lcom/intellij/psi/xml/XmlAttribute;Ljava/lang/String;)V", "endOffsetInOriginalText", "", "getEndOffsetInOriginalText", "()I", "getNewName", "()Ljava/lang/String;", "startOffsetInOriginalText", "getStartOffsetInOriginalText", "intellij.javascript.impl"})
    public static final class AttributeToReplace {
        private final int startOffsetInOriginalText;
        private final int endOffsetInOriginalText;
        @NotNull
        private final String newName;

        public final int getStartOffsetInOriginalText() {
            return this.startOffsetInOriginalText;
        }

        public final int getEndOffsetInOriginalText() {
            return this.endOffsetInOriginalText;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        public AttributeToReplace(@NotNull XmlAttribute attribute, @NotNull String newName) {
            Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
            Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
            this.newName = newName;
            this.startOffsetInOriginalText = attribute.getTextOffset() - 2;
            this.endOffsetInOriginalText = attribute.getTextOffset() + attribute.getName().length() - 2;
        }
    }
}

