/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSGenerateAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Pair<Editor, PsiFile> editorAndPsiFile = BaseJSGenerateAction.getEditorAndPsiFile(e);
        this.getGenerateHandler().invoke(project, (Editor)editorAndPsiFile.first, (PsiFile)editorAndPsiFile.second);
    }

    private static Pair<Editor, PsiFile> getEditorAndPsiFile(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return Pair.create(null, null);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file2 != null && JavaScriptSupportLoader.isFlexMxmFile(file2)) {
            editor = BaseCodeInsightAction.getInjectedEditor((Project)project, (Editor)editor);
            psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        }
        return Pair.create((Object)editor, (Object)psiFile);
    }

    @NotNull
    protected abstract BaseJSGenerateHandler getGenerateHandler();

    public void update(AnActionEvent e) {
        PsiFile psiFile;
        Editor editor;
        Pair<Editor, PsiFile> editorAndPsiFile = BaseJSGenerateAction.getEditorAndPsiFile(e);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        PsiElement jsClass = this.getMemberContainer(file2, editor = (Editor)editorAndPsiFile.first, psiFile = (PsiFile)editorAndPsiFile.second);
        boolean status = jsClass != null && this.isApplicableForMemberContainer(jsClass, psiFile, editor);
        e.getPresentation().setEnabled(status);
        e.getPresentation().setVisible(status);
    }

    @Nullable
    protected PsiElement getMemberContainer(@Nullable VirtualFile file2, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (file2 != null && psiFile != null && editor != null) {
            return BaseJSGenerateHandler.findClassOrObjectLiteral(psiFile, editor, (Condition<PsiElement>)((Condition)element -> DialectDetector.dialectOfElement(element) != null && JSClassUtils.canHaveClasses(element)));
        }
        return null;
    }

    protected boolean isApplicableForMemberContainer(@NotNull PsiElement jsClass, PsiFile psiFile, @NotNull Editor editor) {
        if (jsClass == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BaseJSGenerateAction.$$$reportNull$$$0(1);
        }
        return jsClass instanceof JSClass && !((JSClass)jsClass).isInterface() || jsClass instanceof JSObjectLiteralExpression;
    }

    public boolean startInTransaction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "jsClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/generation/BaseJSGenerateAction";
        objectArray[2] = "isApplicableForMemberContainer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

