/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JSNamedElementNode
extends JSChooserElementNode {
    public JSNamedElementNode(JSPsiNamedElementBase node) {
        super((PsiElement)node, JSNamedElementNode.buildTextFor(node), JSNamedElementNode.buildIcon(node));
    }

    private static Icon buildIcon(JSPsiNamedElementBase node) {
        JSFunction function;
        Icon accessIcon;
        Icon icon = node.getIcon(1);
        if (node instanceof JSFunction && (accessIcon = (function = (JSFunction)node).isGetProperty() ? PlatformIcons.VARIABLE_READ_ACCESS : (function.isSetProperty() ? PlatformIcons.VARIABLE_WRITE_ACCESS : null)) != null) {
            icon = JSNamedElementNode.mergeWithAccessIcon(icon, accessIcon);
        }
        return icon;
    }

    private static String buildTextFor(JSPsiNamedElementBase node) {
        String propertyName = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)node, false);
        StringBuilder text = new StringBuilder(propertyName == null ? "" : propertyName);
        if (node instanceof JSFunction) {
            JSFunction function = (JSFunction)node;
            text.append("(");
            JSParameterList parameterList = function.getParameterList();
            if (parameterList != null) {
                boolean first = true;
                for (JSParameterListElement p : parameterList.getParameters()) {
                    if (!first) {
                        text.append(", ");
                    }
                    first = false;
                    text.append(JSParameterInfoHandler.getSignatureForParameter((JSParameterItem)p));
                }
            }
            text.append(")");
            JSType type = function.getReturnType();
            if (type != null) {
                text.append(":").append(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
            }
        } else if (node instanceof JSVariable) {
            JSVariable var = (JSVariable)node;
            JSType type = var.getType();
            String typeString = null;
            if (type != null) {
                typeString = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
            if (typeString != null) {
                text.append(":").append(typeString);
            }
        }
        return text.toString();
    }
}

