/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6PossiblyAsyncFunctionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (!DialectDetector.hasFeature((PsiElement)node, JSLanguageFeature.ASYNC_AWAIT)) {
                    return;
                }
                JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "await") && parentFunction != null && (this.isUnterminatedStatement((PsiElement)node) || node.resolve() == null)) {
                    holder.registerProblem((PsiElement)node, ES6PossiblyAsyncFunctionInspection.getQuickFixText(parentFunction), new LocalQuickFix[]{new MyQuickFix()});
                }
                super.visitJSReferenceExpression(node);
            }

            private boolean isUnterminatedStatement(PsiElement element) {
                PsiElement sibling = PsiTreeUtil.nextLeaf((PsiElement)element);
                PsiErrorElement errorElement = sibling instanceof PsiErrorElement ? (PsiErrorElement)sibling : null;
                return errorElement != null && JSBundle.message((String)"javascript.parser.message.expected.newline.or.semicolon", (Object[])new Object[0]).equals(errorElement.getErrorDescription());
            }
        };
        if (jSElementVisitor == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    @NotNull
    private static String getQuickFixText(JSFunction function) {
        String name = function.getName();
        String string = name != null ? JSBundle.message((String)"js.possibly.async.function.quick.fix", (Object[])new Object[]{name}) : JSBundle.message((String)"js.possibly.async.function.quick.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static PsiElement psiFromText(@NotNull JSFunction context, @NotNull String text) {
        ASTNode astNode;
        if (context == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(2);
        }
        if (text == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(3);
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)context);
        Project project = context.getProject();
        if (context.getParent() instanceof JSClass) {
            astNode = JSChangeUtil.createClassMemberFromText(project, text, dialect);
        } else {
            if (context instanceof JSFunctionProperty) {
                ASTNode objectLiteralNode = JSChangeUtil.createExpressionFromText(project, "{" + text + "}", dialect, true);
                assert (objectLiteralNode != null) : text;
                return ((JSObjectLiteralExpression)objectLiteralNode.getPsi()).getFirstProperty();
            }
            astNode = JSChangeUtil.createStatementFromText(project, text, dialect, true);
        }
        assert (astNode != null) : text;
        return astNode.getPsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "psiFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.possibly.async.function.quick.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            JSFunction function;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), JSFunction.class)) == null) {
                return;
            }
            JSAttributeList attributeList = function.getAttributeList();
            JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeList, project);
            wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, true);
            wrapper.applyTo((JSAttributeListOwner)function);
            function.replace(ES6PossiblyAsyncFunctionInspection.psiFromText(function, function.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

