/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPartialType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.lang.typescript.psi.TypeScriptChangeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.utils.UnnecessaryParenthesesChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveUnnecessaryParenthesesInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"unnecessary.parentheses.display.name", (Object[])new Object[0]);
        if (string == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSParenthesizedExpression(JSParenthesizedExpression element) {
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element)) {
                    return;
                }
                if (UnnecessaryParenthesesChecker.shouldRemove(element)) {
                    holder.registerProblem((PsiElement)element, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)element)});
                }
            }

            public void visitTypeScriptType(TypeScriptType type) {
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)type)) {
                    return;
                }
                if (type instanceof TypeScriptParenthesizedType && !(type.getParent() instanceof TypeScriptParenthesizedType) && JSRemoveUnnecessaryParenthesesInspection.canRemoveParenthesesInType((TypeScriptParenthesizedType)type)) {
                    holder.registerProblem((PsiElement)type, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)type)});
                }
            }

            public void visitJSParameterList(JSParameterList element) {
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element)) {
                    return;
                }
                if (DialectDetector.hasFeature((PsiElement)element, JSLanguageFeature.ARROW_FUNCTIONS) && JSPsiImplUtils.isArrowFunction((JSFunction)ObjectUtils.tryCast((Object)element.getParent(), JSFunctionExpression.class)) && JSRemoveUnnecessaryParenthesesInspection.canRemoveParenthesesAroundArrowParameters(element, (JSFunctionExpression)element.getParent())) {
                    holder.registerProblem((PsiElement)element, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)element)});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static boolean canRemoveParenthesesAroundArrowParameters(@NotNull JSParameterList parameterList, @NotNull JSFunctionExpression arrowFunction) {
        if (parameterList == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(2);
        }
        if (arrowFunction == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(3);
        }
        return parameterList.getParameters().length == 1 && parameterList.getNode().findChildByType(JSTokenTypes.LPAR) != null && !(parameterList.getParameters()[0] instanceof JSDestructuringParameter) && !parameterList.getParameters()[0].isRest() && parameterList.getParameters()[0].getTypeElement() == null && arrowFunction.getReturnTypeElement() == null && !ContainerUtil.or((Object[])parameterList.getChildren(), child -> child instanceof JSDocComment);
    }

    private static boolean canRemoveParenthesesInType(@NotNull TypeScriptParenthesizedType parenthesized) {
        if (parenthesized == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(4);
        }
        if (DialectDetector.isFlow((PsiElement)parenthesized)) {
            return false;
        }
        PsiElement parent = parenthesized.getParent();
        if (!(parent instanceof JSTypeDeclaration)) {
            return true;
        }
        JSTypeDeclaration element = TypeScriptPsiUtil.unparenthesizeType((JSTypeDeclaration)parenthesized);
        if (element == null) {
            return false;
        }
        return JSRemoveUnnecessaryParenthesesInspection.getTypePrecedence((JSTypeDeclaration)parent) > JSRemoveUnnecessaryParenthesesInspection.getTypePrecedence(element);
    }

    private static int getTypePrecedence(@NotNull JSTypeDeclaration declaration) {
        if (declaration == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(5);
        }
        if (declaration instanceof TypeScriptSingleType) {
            return 0;
        }
        if (declaration instanceof TypeScriptArrayType) {
            return 2;
        }
        if (declaration instanceof TypeScriptTypeOperator || declaration instanceof TypeScriptPartialType) {
            return 3;
        }
        if (declaration instanceof TypeScriptUnionOrIntersectionType) {
            TypeScriptUnionOrIntersectionType unionOrIntersection = (TypeScriptUnionOrIntersectionType)declaration;
            return unionOrIntersection.isIntersectionType() ? 13 : 14;
        }
        if (declaration instanceof TypeScriptFunctionType) {
            return 15;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesized";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveParenthesesAroundArrowParameters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveParenthesesInType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypePrecedence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveParenthesesFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected RemoveParenthesesFix(@Nullable PsiElement element) {
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"remove.unnecessary.parentheses.fix.text", (Object[])new Object[0]);
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement element;
            if (project == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(5);
            }
            if ((element = startElement) instanceof TypeScriptParenthesizedType) {
                JSTypeDeclaration inner = TypeScriptPsiUtil.unparenthesizeType((JSTypeDeclaration)element);
                if (inner == null) {
                    return;
                }
                element.replace((PsiElement)TypeScriptChangeUtil.createTypeFromText(element.getProject(), inner.getText()));
                return;
            }
            if (element instanceof JSParameterList) {
                PsiElement first = element.getFirstChild();
                while (first instanceof PsiWhiteSpace || first.getNode().getElementType() == JSTokenTypes.LPAR) {
                    first.delete();
                    first = element.getFirstChild();
                }
                PsiElement last = element.getLastChild();
                while (last instanceof PsiWhiteSpace || last.getNode().getElementType() == JSTokenTypes.RPAR) {
                    last.delete();
                    last = element.getFirstChild();
                }
                return;
            }
            if (element instanceof JSExpression) {
                JSExpression exp = (JSExpression)element;
                while (exp.getParent() instanceof JSExpression) {
                    exp = (JSExpression)exp.getParent();
                }
                JSElementFactory.replaceExpression(exp, ParenthesesUtils.removeParentheses(exp));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

