/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class JSUndefinedPropertyAssignmentInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                PsiElement resolvedElement;
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSExpression expression = node.getExpression();
                if (!(expression instanceof JSReferenceExpression)) {
                    return;
                }
                JSReferenceExpression refExpr = (JSReferenceExpression)expression;
                JSExpression qualifier = refExpr.getQualifier();
                if (qualifier == null) {
                    return;
                }
                if (qualifier instanceof JSReferenceExpression && (!((resolvedElement = ((JSReferenceExpression)qualifier).resolve()) instanceof JSVariable) || resolvedElement instanceof ImplicitJSVariableImpl && "arguments".equals(((ImplicitJSVariableImpl)resolvedElement).getName()) || JSCorePredefinedLibrariesProvider.isLibraryElement(resolvedElement))) {
                    return;
                }
                if (qualifier instanceof JSThisExpression) {
                    return;
                }
                JSType type = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(qualifier)));
                if (type instanceof JSNamedType && this.isExtensiblePredefinedType((JSNamedType)type)) {
                    return;
                }
                PsiElement refExprResolve = refExpr.resolve();
                if (refExprResolve != node) {
                    return;
                }
                String property = refExpr.getReferenceName();
                if (!(JSTypeUtils.isNewPropertiesDefinitionAllowed(type) || type instanceof JSRecordType && ((JSRecordType)type).hasProperty(property))) {
                    PsiElement refName = refExpr.getReferenceNameElement();
                    String message = JSBundle.message((String)"js.undefined.property.assignment.inspection.message", (Object[])new Object[]{property, type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
                    holder.registerProblem((PsiElement)(refName == null ? node : refName), message, new LocalQuickFix[0]);
                }
            }

            private boolean isExtensiblePredefinedType(JSNamedType type) {
                String typeText = type.getTypeText();
                return BaseJSSymbolProcessor.isNamedGlobalType(typeText, type.getTypeContext().toJSContext()) || "HTMLElement".equals(typeText) || "Element".equals(typeText);
            }
        };
        if (jSElementVisitor == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.undefined.property.assignment.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSUndefinedPropertyAssignmentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

