/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.StandardJSCodeStyle;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EsLintDescriptor;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSDescriptor
extends JSLinterDescriptor {
    private static final Logger LOG = Logger.getInstance(EsLintDescriptor.class);

    @Override
    @Nullable
    public String packageJsonSectionName() {
        return "standard";
    }

    @Override
    public boolean usesLanguageService() {
        return true;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"standardjs.name", (Object[])new Object[0]);
        if (string == null) {
            StandardJSDescriptor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String packageName() {
        if ("standard" == null) {
            StandardJSDescriptor.$$$reportNull$$$0(1);
        }
        return "standard";
    }

    @Override
    @NotNull
    public Class<? extends JSLinterConfiguration> getConfigurationClass() {
        if (StandardJSConfiguration.class == null) {
            StandardJSDescriptor.$$$reportNull$$$0(2);
        }
        return StandardJSConfiguration.class;
    }

    @Override
    @NotNull
    public JSLinterDescriptor.Priority getPriority() {
        JSLinterDescriptor.Priority priority = JSLinterDescriptor.Priority.High;
        if (priority == null) {
            StandardJSDescriptor.$$$reportNull$$$0(3);
        }
        return priority;
    }

    @Override
    public boolean enable(@NotNull Project project) {
        if (project == null) {
            StandardJSDescriptor.$$$reportNull$$$0(4);
        }
        super.enable(project);
        EslintConfiguration eslintConfiguration = EslintConfiguration.getInstance(project);
        if (eslintConfiguration.getExtendedState().isEnabled()) {
            LOG.debug("Turned off ESLint because of conflict with StandardJS");
            eslintConfiguration.setEnabled(false);
        }
        return true;
    }

    @Override
    public void postEnable(@NotNull Project project, @NotNull JSLinterGuesser.EnableCase enableCase) {
        if (project == null) {
            StandardJSDescriptor.$$$reportNull$$$0(5);
        }
        if (enableCase == null) {
            StandardJSDescriptor.$$$reportNull$$$0(6);
        }
        if (StandardJSCodeStyle.isInstalled(project)) {
            return;
        }
        Pair<CodeStyleSettings, Boolean> previous = StandardJSCodeStyle.install(project);
        String message = this.getDisplayName() + ": The project code style settings were updated";
        if (enableCase == JSLinterGuesser.EnableCase.dependency) {
            message = message + " based on 'standard' dependency in package.json";
        } else if (enableCase == JSLinterGuesser.EnableCase.configSection) {
            message = message + " based on 'standard' section in package.json";
        }
        JSLinterUtil.reportCodeStyleSettingsImported(project, message, null, () -> {
            if (project == null) {
                StandardJSDescriptor.$$$reportNull$$$0(7);
            }
            CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
            settingsManager.setMainProjectCodeStyle((CodeStyleSettings)previous.first);
            settingsManager.USE_PER_PROJECT_SETTINGS = (Boolean)previous.second;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "postEnable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postEnable$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

