/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public enum JscsPreset {
    airbnb("airbnb", "Airbnb", "https://github.com/airbnb/javascript"),
    crockford("crockford", "Crockford", "http://javascript.crockford.com/code.html"),
    google("google", "Google", "https://google-styleguide.googlecode.com/svn/trunk/javascriptguide.xml"),
    grunt("grunt", "Grunt", "http://gruntjs.com/contributing#syntax"),
    idiomatic("idiomatic", "Idiomatic", "https://github.com/rwaldron/idiomatic.js#idiomatic-style-manifesto"),
    jquery("jquery", "jQuery", "https://contribute.jquery.org/style-guide/js/"),
    mdcs("mdcs", "MDCS", "https://github.com/mrdoob/three.js/wiki/Mr.doob's-Code-Style%E2%84%A2"),
    node_style_guide("node-style-guide", "node-style-guide", "https://github.com/felixge/node-style-guide"),
    wikimedia("wikimedia", "Wikimedia", "https://www.mediawiki.org/wiki/Manual:Coding_conventions/JavaScript"),
    wordpress("Wordpress", "wordpress.json", "https://make.wordpress.org/core/handbook/coding-standards/javascript/"),
    yandex("yandex", "Yandex", "https://github.com/ymaps/codestyle/blob/master/js.md");

    private static final Logger LOG;
    public static final String COMMON_DESCRIPTION = "https://www.npmjs.org/package/jscs#presets";
    private final String myCode;
    private final String myDisplayName;
    private final String myDescribeUrl;

    private JscsPreset(String code, String displayName, String describeUrl) {
        this.myCode = code;
        this.myDisplayName = displayName;
        this.myDescribeUrl = describeUrl;
    }

    public String getCode() {
        return this.myCode;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getDescribeUrl() {
        return this.myDescribeUrl;
    }

    public static String[] stringValues() {
        JscsPreset[] values = JscsPreset.values();
        String[] s = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            s[i] = values[i].name();
        }
        return s;
    }

    public static JscsPreset safeValueOf(@NotNull String name) {
        if (name == null) {
            JscsPreset.$$$reportNull$$$0(0);
        }
        try {
            return JscsPreset.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("JSCS: wrong value of preset: " + name);
            return null;
        }
    }

    static {
        LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/jscs/JscsPreset", "safeValueOf"));
    }
}

