/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInstaller
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(PackageInstaller.class);
    @NotNull
    private final NodeJsLocalInterpreter myLocalInterpreter;
    @NotNull
    private final String myPackageName;
    @Nullable
    private final String myVersion;
    @NotNull
    private final File myWorkingDir;
    @NotNull
    private final PackageManagementService.Listener myListener;
    @Nullable
    private final String myExtraOptions;
    @Nullable
    private String myError;

    public PackageInstaller(@Nullable Project project, @NotNull NodeJsLocalInterpreter localInterpreter, @NotNull String packageName, @Nullable String version, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener2, @Nullable String extraOptions) {
        if (localInterpreter == null) {
            PackageInstaller.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            PackageInstaller.$$$reportNull$$$0(1);
        }
        if (workingDir == null) {
            PackageInstaller.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            PackageInstaller.$$$reportNull$$$0(3);
        }
        super(project, "Install npm module '" + packageName + "'", false);
        this.myLocalInterpreter = localInterpreter;
        this.myPackageName = packageName;
        this.myVersion = version;
        this.myWorkingDir = workingDir;
        this.myListener = listener2;
        this.myExtraOptions = extraOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        GeneralCommandLine commandLine;
        if (indicator == null) {
            PackageInstaller.$$$reportNull$$$0(4);
        }
        String packageAndVersion = this.myPackageName;
        if (this.myVersion != null) {
            packageAndVersion = packageAndVersion + "@" + this.myVersion;
        }
        ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{NodeCommandLineUtil.getInstallPackageCommand(this.myLocalInterpreter), packageAndVersion});
        if (this.myExtraOptions != null) {
            Collections.addAll(args, this.myExtraOptions.split(" +"));
        }
        if ((commandLine = (GeneralCommandLine)PackageInstaller.computeAndReportIfFailed(this.myListener, this.myPackageName, () -> NodeCommandLineUtil.createNpmCommandLine(this.myWorkingDir, this.myLocalInterpreter, args))) == null) {
            return;
        }
        try {
            ApplicationManager.getApplication().invokeLater(() -> this.myListener.operationStarted(this.myPackageName), ModalityState.any());
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = processHandler.runProcess();
            if (output.getExitCode() != 0) {
                this.myError = NodeCommandLineUtil.formatErrorMessage(commandLine, output);
            }
        }
        catch (ExecutionException e) {
            this.myError = e.getMessage();
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myListener.operationFinished(this.myPackageName, PackageManagementService.ErrorDescription.fromMessage((String)this.myError));
                LocalFileSystem.getInstance().refresh(true);
            }, ModalityState.any());
        }
    }

    @Nullable
    public static <T, E extends Exception> T computeAndReportIfFailed(@NotNull PackageManagementService.Listener listener2, @NotNull String packageName, @NotNull ThrowableComputable<T, E> computable) {
        if (listener2 == null) {
            PackageInstaller.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            PackageInstaller.$$$reportNull$$$0(6);
        }
        if (computable == null) {
            PackageInstaller.$$$reportNull$$$0(7);
        }
        try {
            return (T)computable.compute();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (listener2 == null) {
                    PackageInstaller.$$$reportNull$$$0(8);
                }
                if (packageName == null) {
                    PackageInstaller.$$$reportNull$$$0(9);
                }
                listener2.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)e.getMessage()));
            }, ModalityState.any());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localInterpreter";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/PackageInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAndReportIfFailed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$computeAndReportIfFailed$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Component
    implements NpmPackageInstallerLight {
        @Override
        public void installPackage(@Nullable Project project, @NotNull NodeJsLocalInterpreter localInterpreter, @NotNull String packageName, @Nullable String version, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener2, @Nullable String extraOptions) {
            if (localInterpreter == null) {
                Component.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                Component.$$$reportNull$$$0(1);
            }
            if (workingDir == null) {
                Component.$$$reportNull$$$0(2);
            }
            if (listener2 == null) {
                Component.$$$reportNull$$$0(3);
            }
            ProgressManager.getInstance().run((Task)new PackageInstaller(project, localInterpreter, packageName, version, workingDir, listener2, extraOptions));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localInterpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/PackageInstaller$Component";
            objectArray[2] = "installPackage";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

