/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeWithSignature;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeEvaluator
extends JSElementVisitor {
    protected final JSExpression myParent;
    protected final JSExpectedTypeKind myExpectedTypeKind;
    protected final PsiElement myGrandParent;
    protected JSType myResult;

    public ExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind expectedTypeKind) {
        this.myParent = parent;
        this.myExpectedTypeKind = expectedTypeKind;
        this.myGrandParent = this.myParent.getParent();
    }

    protected ExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind kind) {
        return new ExpectedTypeEvaluator(parent, kind);
    }

    private JSType findExpectedTypeWithNewEvaluator(JSExpression parent, JSExpectedTypeKind kind) {
        return this.newExpectedTypeEvaluator(parent, kind).findExpectedType();
    }

    @Nullable
    public final JSType findExpectedType() {
        Language language = this.myParent.getLanguage();
        JSType typeFromFramework = JSFrameworkSpecificHandlersFactory.EP_NAME.allForLanguage(language).stream().map(factory -> factory.findExpectedType(this.myParent, this.myExpectedTypeKind)).filter(Objects::nonNull).findFirst().orElse(null);
        if (typeFromFramework != null) {
            return typeFromFramework;
        }
        this.myGrandParent.accept((PsiElementVisitor)this);
        return this.myResult;
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSFunction.class);
        if (fun == null) {
            return;
        }
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
            this.appendReturnResultForExpected(node, fun);
        }
        if (this.myExpectedTypeKind.isContextual()) {
            this.appendReturnResultForContextual(node, fun);
        }
    }

    private void appendReturnResultForContextual(JSReturnStatement node, JSFunction fun) {
        JSType returnType = fun.getReturnType();
        if (returnType != null && !(returnType instanceof JSTypeofTypeImpl)) {
            JSTypeSource typeSource = returnType.getSource();
            if (typeSource.isStrict()) {
                this.myResult = returnType;
            }
        } else {
            this.addTypeFromFunctionExpression(node, fun);
        }
    }

    private void appendReturnResultForExpected(JSReturnStatement node, JSFunction fun) {
        JSTypeSource typeSource;
        JSType returnType = fun.getReturnType();
        JSTypeSource jSTypeSource = typeSource = returnType != null ? returnType.getSource() : null;
        if (returnType != null && typeSource.isStrict()) {
            PsiElement sourceElement = typeSource.getSourceElement();
            if (sourceElement == null || !sourceElement.equals(node.getExpression())) {
                this.myResult = returnType;
            } else {
                this.addTypeFromFunctionExpression(node, fun);
            }
        }
    }

    private void addTypeFromFunctionExpression(@NotNull JSReturnStatement node, @Nullable JSFunction fun) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (fun instanceof JSFunctionExpression) {
            JSType parentExpectedType = this.findExpectedTypeWithNewEvaluator((JSExpression)((JSFunctionExpression)fun), this.myExpectedTypeKind);
            if (parentExpectedType instanceof JSFunctionTypeImpl) {
                this.myResult = ((JSFunctionTypeImpl)parentExpectedType).getReturnType();
            } else {
                ArrayList types = ContainerUtil.newArrayList();
                JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
                    if (t instanceof JSFunctionTypeImpl) {
                        types.add(((JSFunctionTypeImpl)((Object)t)).getReturnType());
                    }
                    return true;
                }), parentExpectedType);
                this.myResult = JSContextualUnionTypeImpl.getContextualUnionType(types, JSTypeSourceFactory.createTypeSource((PsiElement)node, true));
            }
        }
    }

    public void visitJSIfStatement(JSIfStatement node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCondition() == this.myParent) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSLoopStatement(JSLoopStatement node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCondition() == this.myParent) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (!(JSTokenTypes.EXCL != node.getOperationSign() || node.getParent() instanceof JSPrefixExpression && JSTokenTypes.EXCL == ((JSPrefixExpression)node.getParent()).getOperationSign())) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSThrowStatement(JSThrowStatement node) {
        PsiComment docComment;
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myParent, JSFunction.class);
        if (fun != null && (docComment = JSDocumentationUtils.findDocComment((PsiElement)fun)) != null) {
            final Ref throwsTypeFromCommentRef = new Ref();
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return false;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (line == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (patternMatched == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (type == JSDocumentationProcessor.MetaDocType.THROWS && matchName != null) {
                        throwsTypeFromCommentRef.set((Object)matchName);
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "line";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "patternMatched";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCommentLine";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onPatternMatch";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            String throwsTypeFromComment = (String)throwsTypeFromCommentRef.get();
            if (throwsTypeFromComment != null) {
                this.myResult = JSTypeUtils.createType(throwsTypeFromComment, JSTypeSourceFactory.createTypeSource(this.myGrandParent, true));
                return;
            }
        }
        this.myResult = this.createNamedType("Error", this.myGrandParent);
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && node.getCondition() == this.myParent) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        } else {
            JSType parentType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node, this.myExpectedTypeKind);
            if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
                JSExpression otherExpr;
                JSExpression then = JSUtils.unparenthesize(node.getThen());
                JSExpression elze = JSUtils.unparenthesize(node.getElse());
                Object object = then == this.myParent ? elze : (otherExpr = elze == this.myParent ? then : null);
                if (otherExpr != null) {
                    JSType leftType = JSResolveUtil.getExpressionJSType(otherExpr);
                    this.assignFromParentOrOtherSide(parentType, leftType, null);
                }
            }
            if (this.myResult == null) {
                this.myResult = parentType;
            }
        }
    }

    public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getIndexExpression() == this.myParent) {
            this.evaluateIndexedAccessType(node);
        }
    }

    protected void evaluateIndexedAccessType(JSIndexedPropertyAccessExpression node) {
        this.myResult = this.createNamedType("number", this.myGrandParent);
    }

    public void visitJSYieldExpression(JSYieldExpression statement) {
        JSFunction function = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)statement, (Class[])new Class[]{JSFunction.class});
        if (function == null || !function.isGenerator()) {
            return;
        }
        if (function.getReturnTypeElement() == null && this.myExpectedTypeKind.isContextual()) {
            return;
        }
        JSType returnType = function.getReturnType();
        if (returnType == null) {
            return;
        }
        JSType type = JSTypeUtils.getIterableComponentType(returnType);
        if (type != null) {
            this.myResult = type;
        }
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        IElementType opType = node.getOperationSign();
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && node.getROperand() == this.myParent) {
            if (JSTokenTypes.OROR == opType || JSTokenTypes.ANDAND == opType) {
                this.myResult = this.createNamedType("Boolean", this.myGrandParent);
            } else {
                JSExpression lOperand = node.getLOperand();
                if (lOperand != null) {
                    this.myResult = JSResolveUtil.getQualifiedExpressionJSType(lOperand, this.myGrandParent.getContainingFile());
                }
            }
        }
        Object parentType = this.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind);
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            if (parentType != null) {
                if (this.myExpectedTypeKind.isContextual() && node.getROperand() == this.myParent) {
                    if (parentType instanceof JSTypeofTypeImpl) {
                        PsiElement sourceElement = parentType.getSource().getSourceElement();
                        parentType = sourceElement != null ? null : ((JSTypeofTypeImpl)parentType).evaluateType();
                    }
                    this.myResult = this.fixResultForOrOrRightOp((JSType)parentType, node.getLOperand());
                } else {
                    this.myResult = parentType;
                }
            }
            return;
        }
        JSExpression otherExpr = null;
        if (JSTokenTypes.OROR == opType && node.getROperand() == this.myParent) {
            otherExpr = node.getLOperand();
        }
        if (JSTokenTypes.OROR == opType && node.getLOperand() == this.myParent) {
            otherExpr = node.getROperand();
        }
        if (otherExpr != null) {
            JSType leftType = JSResolveUtil.getExpressionJSType(otherExpr);
            this.assignFromParentOrOtherSide((JSType)parentType, leftType, null);
        }
    }

    @Nullable
    @Contract(value="null, _ -> null")
    protected JSType fixResultForOrOrRightOp(@Nullable JSType type, @Nullable JSExpression operand) {
        return type;
    }

    private void assignFromParentOrOtherSide(JSType parentType, JSType leftType, Collection<JSType> miscTypes) {
        if (parentType == null && miscTypes == null) {
            if (leftType != null) {
                this.myResult = leftType;
            }
        } else if (leftType == null && miscTypes == null) {
            this.myResult = parentType;
        } else {
            int count;
            int n = count = miscTypes != null ? miscTypes.size() : 0;
            if (parentType != null) {
                ++count;
            }
            if (leftType != null) {
                ++count;
            }
            ArrayList<JSType> typeList = new ArrayList<JSType>(count);
            if (parentType != null) {
                typeList.add(parentType);
            }
            if (leftType != null) {
                typeList.add(leftType);
            }
            if (miscTypes != null) {
                typeList.addAll(miscTypes);
            }
            this.myResult = JSContextualUnionTypeImpl.getContextualUnionType(typeList, JSTypeSourceFactory.createTypeSource((PsiElement)this.myParent, false));
        }
    }

    public void visitJSCaseClause(JSCaseClause node) {
        JSExpression switchExpression;
        JSSwitchStatement switchStatement;
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCaseExpression() == this.myParent && (switchStatement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSSwitchStatement.class)) != null && (switchExpression = switchStatement.getSwitchExpression()) != null) {
            this.myResult = JSResolveUtil.getQualifiedExpressionJSType(switchExpression, this.myGrandParent.getContainingFile());
        }
    }

    public void visitJSProperty(JSProperty node) {
        PsiElement parent = node.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            PsiElement sourceElement;
            JSType parentExpectedType = this.findExpectedTypeWithNewEvaluator((JSExpression)((JSObjectLiteralExpression)parent), this.myExpectedTypeKind);
            if (parentExpectedType instanceof JSTypeofTypeImpl && (sourceElement = parentExpectedType.getSource().getSourceElement()) instanceof JSVariable && ((JSVariable)sourceElement).getInitializer() == parent) {
                return;
            }
            if ((parentExpectedType = JSTypeUtils.getValuableType(parentExpectedType)) != null && (sourceElement = parentExpectedType.getSource().getSourceElement()) == parent) {
                return;
            }
            String name = node.getName();
            JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)type -> !this.addExpectedObjectPropertyType(node, (JSType)type, name)), parentExpectedType);
        }
    }

    private boolean addExpectedObjectPropertyType(@NotNull JSProperty node, @Nullable JSType parentExpectedType, @Nullable String name) {
        JSRecordType.PropertySignature propertySignature;
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (parentExpectedType != null && (DialectDetector.isTypeScript((PsiElement)node) || parentExpectedType.isTypeScript())) {
            parentExpectedType = parentExpectedType.asRecordType();
        }
        if (parentExpectedType instanceof JSRecordType && name != null && (propertySignature = ((JSRecordType)parentExpectedType).findPropertySignature(name)) != null) {
            this.myResult = propertySignature.getType();
            return true;
        }
        return false;
    }

    public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
        JSType arrayType = this.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind);
        if (arrayType != null) {
            JSRecordType type;
            JSRecordType.PropertySignature propertySignature;
            int indexOfParent = ArrayUtil.indexOf((Object[])node.getExpressions(), (Object)this.myParent);
            if (indexOfParent >= 0 && arrayType.isTypeScript() && (propertySignature = (type = arrayType.asRecordType()).findPropertySignature(String.valueOf(indexOfParent))) != null) {
                this.myResult = propertySignature.getType();
            }
            if (this.myResult == null) {
                this.myResult = JSTypeUtils.getIterableComponentType(arrayType);
            }
        }
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
            ArrayList<JSType> allItemTypes = new ArrayList<JSType>();
            boolean found = false;
            for (JSExpression expr : node.getExpressions()) {
                JSType type;
                if (expr == null) continue;
                if (expr == this.myParent) {
                    found = true;
                    continue;
                }
                JSTypeEvaluationResult expressionType = JSTypeEvaluator.getExpressionType(expr);
                if (expressionType == null || (type = expressionType.getType()) == null) continue;
                allItemTypes.add(type);
            }
            if (!found) {
                return;
            }
            this.assignFromParentOrOtherSide(this.myResult, null, allItemTypes);
        }
    }

    public void visitJSParenthesizedExpression(JSParenthesizedExpression node) {
        this.myResult = this.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind);
    }

    public void visitTypeScriptCastExpression(TypeScriptCastExpression node) {
        TypeScriptType type = node.getType();
        if (type != null) {
            this.myResult = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)type);
        }
    }

    public void visitJSStringTemplateExpression(JSStringTemplateExpression node) {
        int argumentIndex = ArrayUtil.find((Object[])node.getArguments(), (Object)this.myParent);
        if (argumentIndex < 0) {
            return;
        }
        ES6TaggedTemplateExpression taggedTemplateExpression = (ES6TaggedTemplateExpression)ObjectUtils.tryCast((Object)node.getParent(), ES6TaggedTemplateExpression.class);
        if (taggedTemplateExpression == null) {
            return;
        }
        this.handleFunctionCall(taggedTemplateExpression.getTag(), node.getArguments(), argumentIndex + 1);
    }

    public void visitJSArgumentList(@NotNull JSArgumentList node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(2);
        }
        int _paramIndex = 0;
        for (JSExpression expr : node.getArguments()) {
            if (expr == this.myParent) break;
            ++_paramIndex;
        }
        int paramIndex = _paramIndex;
        PsiElement firstChild = node.getFirstChild();
        if (firstChild == null) {
            return;
        }
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        this.handleFunctionCall(originalElement.getMethodExpression(), node.getArguments(), paramIndex);
    }

    private void handleFunctionCall(@Nullable JSExpression methodExpr, @NotNull JSExpression[] arguments, int paramIndex) {
        if (arguments == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(3);
        }
        boolean isStrict = ExpectedTypeEvaluator.hasStrictQualifierType(methodExpr);
        if (!(methodExpr instanceof JSReferenceExpression)) {
            return;
        }
        ResolveResult[] results = ((JSReferenceExpression)methodExpr).multiResolve(this.myExpectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS);
        results = TypeScriptImplicitOverloadedAliasElement.unwrapElements(results);
        ArrayList possibleResults = ContainerUtil.newArrayList();
        for (ResolveResult r : results) {
            PsiElement element = r.getElement();
            if (element == null || !element.isValid()) continue;
            if (element instanceof JSParameter) {
                JSType index;
                JSType type;
                JSType definedParameterType = ((JSParameter)element).getType();
                JSEvaluateContext context = new JSEvaluateContext(null);
                JSType jSType = type = definedParameterType != null ? definedParameterType : JSContextTypeEvaluator.getParameterType((JSParameterListElement)((JSParameter)element), context, this.myExpectedTypeKind);
                if (!context.isJSElementsToApplyEmpty() || !(type instanceof JSFunctionTypeImpl) || (index = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type, paramIndex)) == null) continue;
                possibleResults.add(new JSTypeWithSignature(index));
                continue;
            }
            List<JSFunctionWithSubstitutor> functionsWithSubstitutor = this.calcAndFilterFunctionsForArgumentList(methodExpr, element, arguments);
            if (functionsWithSubstitutor.size() == 0) continue;
            if (functionsWithSubstitutor.size() > 1 && this.myExpectedTypeKind == JSExpectedTypeKind.CONTEXTUAL) {
                JSType type;
                JSParameterItem matchingParam;
                JSParameterItem[] params = JSUtils.resolveOverloadParameterList(functionsWithSubstitutor.stream().map(f -> f.myFunctionItem).collect(Collectors.toList()), arguments);
                if (paramIndex >= 0 && paramIndex < params.length && (matchingParam = params[paramIndex]) != null && (type = matchingParam.getType()) != null) {
                    possibleResults.add(new JSTypeWithSignature(type));
                    continue;
                }
            }
            for (JSFunctionWithSubstitutor functionWithSubstitutor : functionsWithSubstitutor) {
                TypeScriptJSFunctionTypeImpl functionType;
                JSType type;
                JSFunctionItem matchedFunction = functionWithSubstitutor.myFunctionItem;
                JSTypeSubstitutor typeSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
                if (typeSubstitutor.isEmpty()) {
                    ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, possibleResults);
                    continue;
                }
                if (!(matchedFunction instanceof JSFunction) || !((type = JSTypeUtils.applyGenericArguments(functionType = TypeScriptTypeParser.buildFunctionTypeWithoutTypeArguments(matchedFunction), (Map<String, JSType>)typeSubstitutor)) instanceof JSFunctionTypeImpl)) continue;
                ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, (JSFunctionTypeImpl)type, possibleResults);
            }
        }
        if (!possibleResults.isEmpty()) {
            if (possibleResults.size() == 1) {
                this.myResult = ((JSTypeWithSignature)possibleResults.get(0)).evaluateGenerics(methodExpr, paramIndex);
                if (!isStrict) {
                    this.myResult = JSTypeUtils.copyWithStrict(this.myResult, false);
                }
            } else {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource(this.myGrandParent, true);
                TypeScriptOverloadContextualType contextualType = new TypeScriptOverloadContextualType(source, possibleResults, paramIndex, methodExpr);
                this.myResult = this.myExpectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS ? contextualType : contextualType.asCompositeWithAppliedGenerics();
            }
        }
    }

    public void visitJSVariable(JSVariable node) {
        if (!DialectDetector.isTypeScript((PsiElement)node) || node.getTypeElement() != null) {
            this.myResult = node.getType();
        }
    }

    public void visitJSDestructuringElement(JSDestructuringElement node) {
        if (!DialectDetector.isTypeScript((PsiElement)node) || node.getTypeElement() != null) {
            this.myResult = node.getType();
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand != null) {
            if ((lOperand = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)lOperand)) instanceof JSDefinitionExpression) {
                PsiElement resolve;
                JSType type;
                if (!DialectDetector.isTypeScript((PsiElement)node) && (type = ((JSDefinitionExpression)lOperand).getTypeFromComment()) != null) {
                    this.myResult = type;
                    return;
                }
                JSExpression expression = ((JSDefinitionExpression)lOperand).getExpression();
                if (expression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) != null && JSResolveUtil.isSameReference((JSReferenceExpression)expression, resolve)) {
                    return;
                }
            }
            this.myResult = JSResolveUtil.getExpressionJSType(lOperand);
        }
    }

    protected void findRestParameterExpectedType(JSParameterItem param) {
        this.myResult = this.createNamedType("Object", (PsiElement)this.myParent);
    }

    protected JSType createNamedType(String name, PsiElement context) {
        return JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context, true), JSContext.INSTANCE);
    }

    private static boolean hasStrictQualifierType(JSExpression methodExpr) {
        JSType type;
        JSTypeEvaluationResult expressionType;
        JSExpression qualifier;
        if (methodExpr instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)methodExpr) && (qualifier = ((JSReferenceExpression)methodExpr).getQualifier()) != null && (expressionType = JSTypeEvaluator.getExpressionType(qualifier)) != null && (type = expressionType.getType()) != null) {
            return TypeScriptUtil.isStrictType(type);
        }
        return true;
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (matchedFunction == null) {
            return;
        }
        JSParameterItem[] params = matchedFunction.getParameters();
        if (params.length == 0) {
            return;
        }
        ArrayList parameterTypes = ContainerUtil.newArrayListWithCapacity((int)params.length);
        for (JSParameterItem item : params) {
            parameterTypes.add(item.getType());
        }
        boolean isLastRest = params[params.length - 1].isRest();
        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, parameterTypes, isLastRest, possibleResults);
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @Nullable JSFunctionTypeImpl matchedFunctionType, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (matchedFunctionType == null) {
            return;
        }
        List<JSParameterTypeDecorator> parameters = matchedFunctionType.getParameters();
        if (parameters.isEmpty()) {
            return;
        }
        List<JSType> parameterTypes = parameters.stream().map(JSParameterTypeDecorator::getType).collect(Collectors.toList());
        boolean isLastRest = parameters.get(parameters.size() - 1).isRest();
        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, parameterTypes, isLastRest, possibleResults);
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @NotNull List<JSType> params, boolean isLastRest, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (params == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(7);
        }
        JSType param = null;
        if (paramIndex < params.size()) {
            param = params.get(paramIndex);
        } else if (params.size() > 0 && isLastRest) {
            param = (JSType)ContainerUtil.getLastItem(params);
        }
        if (param != null) {
            possibleResults.add(new JSTypeWithSignature(param, matchedFunction));
        }
    }

    @NotNull
    protected List<JSFunctionWithSubstitutor> calcAndFilterFunctionsForArgumentList(@NotNull JSExpression methodExpression, @NotNull PsiElement resolvedElement, @NotNull JSExpression[] arguments) {
        Collection<JSFunctionWithSubstitutor> functions;
        if (methodExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (resolvedElement == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (arguments == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(10);
        }
        if ((functions = JSPsiImplUtils.calculatePossibleFunctions(resolvedElement, (PsiElement)methodExpression)).size() == 0) {
            List<JSFunctionWithSubstitutor> list = Collections.emptyList();
            if (list == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(11);
            }
            return list;
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)methodExpression);
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && isTypeScript && functions.size() == 1) {
            JSFunctionWithSubstitutor overload = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functions);
            JSFunctionItem functionItem = overload == null ? null : overload.myFunctionItem;
            ArrayList<JSFunctionWithSubstitutor> funcs = new ArrayList<JSFunctionWithSubstitutor>();
            if (functionItem instanceof TypeScriptFunction) {
                for (JSFunctionItem jSFunctionItem : TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)functionItem)) {
                    funcs.add(new JSFunctionWithSubstitutor(jSFunctionItem, overload.myTypeSubstitutor));
                }
                ArrayList<JSFunctionWithSubstitutor> arrayList = funcs;
                if (arrayList == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(12);
                }
                return arrayList;
            }
        }
        if (isTypeScript && functions.size() > 0) {
            if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
                ArrayList<JSFunctionWithSubstitutor> arrayList = new ArrayList<JSFunctionWithSubstitutor>(functions);
                if (arrayList == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(13);
                }
                return arrayList;
            }
            int argumentsLength = arguments.length;
            List<JSFunctionWithSubstitutor> list = functions.stream().filter(functionWithSubstitutor -> {
                JSFunctionItem item = functionWithSubstitutor.myFunctionItem;
                JSParameterItem[] parameters = item.getParameters();
                int min = TypeScriptSignatureChooser.getMinArgumentCount(parameters);
                int max = TypeScriptSignatureChooser.getMaxArgumentCount(parameters);
                return min <= argumentsLength && argumentsLength <= max;
            }).collect(Collectors.toList());
            if (list == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)ContainerUtil.getFirstItem(functions));
        if (list == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleResults";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAndFilterFunctionsForArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromFunctionExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addExpectedObjectPropertyType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitJSArgumentList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleFunctionCall";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcAndFilterFunctionsForArgumentList";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

