/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionBaseImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionStub;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFunctionImpl
extends TypeScriptFunctionBaseImpl<TypeScriptFunctionStub, TypeScriptFunction>
implements TypeScriptFunction,
PropertySignatureCommonImpl,
JSComputedPropertyNameOwner,
JSSuppressionHolder {
    public TypeScriptFunctionImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptFunctionImpl(TypeScriptFunctionStub stub, IStubElementType signature) {
        super(stub, signature);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFunctionDeclaration((JSFunction)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean isOverloadDeclaration() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isOverloadDeclaration();
        }
        State state = this.calcOverloadState();
        return state == State.IS_OVERLOAD || state == State.IS_OVERLOAD_AND_HAS_OVERLOADS;
    }

    private State calcOverloadState() {
        return (State)((Object)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            boolean isOverload = TypeScriptFunctionImpl.hasNextOverloadDeclaration(this);
            boolean hasOverloads = this.hasPrevOverloadDeclaration();
            if (isOverload) {
                return CachedValueProvider.Result.create((Object)((Object)(hasOverloads ? State.IS_OVERLOAD_AND_HAS_OVERLOADS : State.IS_OVERLOAD)), (Object[])new Object[]{this});
            }
            if (this.getBody().length > 0 && hasOverloads) {
                return CachedValueProvider.Result.create((Object)((Object)State.IS_OVERLOAD_IMPLEMENTATION), (Object[])new Object[]{this});
            }
            if (hasOverloads) {
                return CachedValueProvider.Result.create((Object)((Object)State.HAS_OVERLOADS), (Object[])new Object[]{this});
            }
            return CachedValueProvider.Result.create((Object)((Object)State.IS_NOT_OVERLOAD), (Object[])new Object[]{this});
        }));
    }

    public static boolean hasNextOverloadDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(1);
        }
        return TypeScriptFunctionImpl.getNextOverloadFunction(function) != null;
    }

    private boolean hasPrevOverloadDeclaration() {
        return !this.getOverloadDeclarationsImpl(true).isEmpty();
    }

    @Nullable
    private static ASTNode getNextOverloadFunction(@NotNull JSFunction function) {
        if (function == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(2);
        }
        if (function.getBody().length != 0) {
            return null;
        }
        ASTNode functionNode = function.getNode();
        ASTNode nextSourceElement = TreeUtil.findSibling((ASTNode)functionNode.getTreeNext(), (TokenSet)JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS);
        if (nextSourceElement != null && nextSourceElement.getElementType() == JSStubElementTypes.TYPESCRIPT_FUNCTION) {
            ASTNode nameIdentifier = JSPsiImplUtils.findNameIdentifierOfFunction(functionNode);
            ASTNode nextNameIdentifier = JSPsiImplUtils.findNameIdentifierOfFunction(nextSourceElement);
            if (nameIdentifier != null && nextNameIdentifier != null && StringUtil.equals((CharSequence)TypeScriptPsiUtil.getNameFromIdentifier(nameIdentifier), (CharSequence)TypeScriptPsiUtil.getNameFromIdentifier(nextNameIdentifier))) {
                return nextSourceElement;
            }
        }
        return null;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = JSResolveUtil.findUseScope(this);
        if (searchScope == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(3);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public List<TypeScriptFunction> getOverloadDeclarations() {
        if (this.hasOverloadDeclarations()) {
            List<TypeScriptFunction> list = this.getOverloadDeclarationsImpl(false);
            if (list == null) {
                TypeScriptFunctionImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    private List<TypeScriptFunction> getOverloadDeclarationsImpl(boolean firstOnly) {
        PsiElement prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling((PsiElement)this);
        String name = this.getName();
        if (name == null) {
            return ContainerUtil.emptyList();
        }
        if (prevSibling != null) {
            SmartList result2 = new SmartList();
            while (prevSibling != null) {
                if (!(prevSibling instanceof JSSourceElement)) {
                    prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(prevSibling);
                    continue;
                }
                if (!(prevSibling instanceof TypeScriptFunction) || !name.equals(((TypeScriptFunction)prevSibling).getName()) || !((TypeScriptFunction)prevSibling).isOverloadDeclaration()) break;
                result2.add(0, (TypeScriptFunction)prevSibling);
                if (firstOnly) {
                    return result2;
                }
                prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(prevSibling);
            }
            return result2;
        }
        return ContainerUtil.emptyList();
    }

    public boolean isOptional() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isOptional();
        }
        return this.isOptionalImpl();
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSFunctionStubBase jsFunctionStub = (JSFunctionStubBase)this.getGreenStub();
        if (jsFunctionStub != null) {
            return jsFunctionStub.getNamespace();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    @Override
    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        if (parent instanceof JSClass) {
            return Comparing.equal((String)"constructor", (String)this.getName(), (boolean)true);
        }
        return super.isConstructor();
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JSFunctionImpl.getFunctionIcon((JSFunctionItem)this, flags);
    }

    @Override
    protected String doGetName() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        return TypeScriptPsiUtil.getNameFromIdentifierOwner((JSNamedElement)this);
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(6);
        }
        return accessType;
    }

    @Override
    public boolean isGenerator() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isGenerator();
        }
        return super.isGenerator();
    }

    @Override
    public boolean isOverloadImplementation() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isOverloadImplementation();
        }
        return this.calcOverloadState() == State.IS_OVERLOAD_IMPLEMENTATION;
    }

    @Nullable
    public ES6ComputedName getComputedPropertyName() {
        return (ES6ComputedName)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.COMPUTED_NAME);
    }

    @Override
    public boolean hasOverloadDeclarations() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasOverloadDeclarations();
        }
        State state = this.calcOverloadState();
        return state == State.IS_OVERLOAD_IMPLEMENTATION || state == State.HAS_OVERLOADS || state == State.IS_OVERLOAD_AND_HAS_OVERLOADS;
    }

    @Override
    public ASTNode findNameIdentifier() {
        if (this.getNode().findChildByType(JSTokenTypes.LBRACKET) != null) {
            return null;
        }
        return super.findNameIdentifier();
    }

    @Nullable
    public TypeScriptFunction getNextOverloadOrImplementation() {
        StubElement sibling;
        if (!this.isOverloadDeclaration()) {
            return null;
        }
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getGreenStub();
        if (stub != null && (sibling = StubTreeUtil.getNextSibling(stub)) instanceof TypeScriptFunctionStub && Objects.equals(this.getName(), ((TypeScriptFunctionStub)sibling).getName())) {
            return (TypeScriptFunction)((TypeScriptFunctionStub)sibling).getPsi();
        }
        ASTNode functionNode = TypeScriptFunctionImpl.getNextOverloadFunction(this);
        return functionNode != null ? (TypeScriptFunction)functionNode.getPsi(TypeScriptFunction.class) : null;
    }

    @NotNull
    public JSRecordType.MemberSource getMemberSource() {
        JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource((PsiElement)this);
        if (memberSource == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(7);
        }
        return memberSource;
    }

    @NotNull
    public String getMemberName() {
        String string = TypeScriptPsiUtil.getMemberName(this);
        if (string == null) {
            TypeScriptFunctionImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public JSType getType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHE_VALUE_KEY, CACHE_VALUE_PROVIDER, false, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFunctionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFunctionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloadDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasNextOverloadDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNextOverloadFunction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum State {
        IS_NOT_OVERLOAD,
        IS_OVERLOAD,
        IS_OVERLOAD_AND_HAS_OVERLOADS,
        IS_OVERLOAD_IMPLEMENTATION,
        HAS_OVERLOADS;

    }
}

