/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringElementStubImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringElementImpl<StubT extends JSDestructuringElementStubImpl<?>>
extends JSStubElementImpl<StubT>
implements JSDestructuringElement,
StubBasedPsiElement<StubT> {
    public JSDestructuringElementImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringElementImpl(StubT stub, IStubElementType elementType) {
        super(stub, elementType);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JSDestructuringContainer destructuringContainer;
        if (processor == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(2);
        }
        if ((destructuringContainer = (JSDestructuringContainer)PsiTreeUtil.getChildOfType((PsiElement)this, JSDestructuringContainer.class)) != null) {
            return destructuringContainer.processDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringElement((JSDestructuringElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSDestructuringContainer getTarget() {
        PsiElement child = JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSElementTypes.DESTRUCTURING_CONTAINERS);
        return child instanceof JSDestructuringContainer ? (JSDestructuringContainer)child : null;
    }

    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Nullable
    public JSType getType() {
        JSTypeDeclaration element = this.getTypeElement();
        if (element != null) {
            return TypeScriptTypeParser.buildTypeFromTypeScript(element);
        }
        JSExpression initializer = this.getInitializer();
        if (initializer != null) {
            return this.buildTypeFromInitializerIfTypeScript(initializer);
        }
        return null;
    }

    @Nullable
    protected JSType buildTypeFromInitializerIfTypeScript(@NotNull JSExpression initializer) {
        if (initializer == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(4);
        }
        return DialectDetector.isTypeScript((PsiElement)this) ? new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true)) : null;
    }

    @Nullable
    public JSTypeDeclaration getTypeElement() {
        return JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    public void delete() throws IncorrectOperationException {
        if (JSVarStatementBase.handleChildDeletion((JSInitializerOwner)this)) {
            return;
        }
        if (JSDestructuringUtil.isDestructuring(this.getParent())) {
            this.getParent().delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTypeFromInitializerIfTypeScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

