/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSParameterListImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterImpl
extends JSVariableBaseImpl<JSParameterStub, JSParameter>
implements JSParameter,
StubBasedPsiElement<JSVariableStubBase> {
    private static final Key<ParameterizedCachedValue<JSParameterTypeDecorator, JSParameterImpl>> TYPE_KEY = Key.create((String)"js.parameter.type");
    private static final ParameterizedCachedValueProvider<JSParameterTypeDecorator, JSParameterImpl> TYPE_PROVIDER = psi -> {
        boolean isTypeRest;
        JSParameterStub stub = (JSParameterStub)psi.getGreenStub();
        if (stub != null) {
            isTypeRest = stub.isTypeRest();
        } else {
            PsiElement grandParent;
            isTypeRest = psi.isRest();
            if (!isTypeRest && psi.getNode().findChildByType(JSTokenTypes.COLON) == null && (grandParent = psi.getParent().getParent()) instanceof JSFunctionBaseImpl) {
                isTypeRest = ((JSFunctionBaseImpl)grandParent).isRest((JSParameter)psi);
            }
        }
        JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(psi.getType(), psi.isOptional(), isTypeRest, psi.isTypeStrict());
        return CachedValueProvider.Result.create((Object)decorator, (Object[])new Object[]{psi});
    };

    public JSParameterImpl(ASTNode node) {
        super(node);
    }

    public JSParameterImpl(JSParameterStub stub) {
        super(stub, JSStubElementTypes.FORMAL_PARAMETER);
    }

    public JSParameterImpl(JSParameterStub stub, JSStubElementType<JSParameterStub, JSParameter> elementType) {
        super(stub, elementType);
    }

    public JSFunction getDeclaringFunction() {
        JSElement owner = JSParameterImpl.getOwner((JSParameterListElement)this);
        return owner instanceof JSFunction ? (JSFunction)owner : null;
    }

    public boolean isRest() {
        JSParameterStub parameterStub = (JSParameterStub)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isRest();
        }
        return this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
    }

    public boolean isOptional() {
        PsiElement isQuest;
        JSParameterStub parameterStub = (JSParameterStub)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isOptional();
        }
        if (this.getInitializer() != null) {
            return true;
        }
        if (DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null && (isQuest = firstChild.getNextSibling()) != null && isQuest instanceof LeafPsiElement && ((LeafPsiElement)isQuest).getElementType() == JSTokenTypes.QUEST) {
            return true;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)this, JSTypeDeclaration.class) != null) {
            return false;
        }
        JSFunction function = this.getDeclaringFunction();
        if (!(function instanceof JSFunctionBaseImpl)) {
            return false;
        }
        return ((JSFunctionBaseImpl)function).isOptional(this);
    }

    protected boolean isTypeStrict() {
        JSParameterStub parameterStub = (JSParameterStub)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isTypeStrict();
        }
        JSType type = this.getType();
        if (type != null) {
            return type.getSource().isStrict();
        }
        PsiElement grandParent = this.getParent().getParent();
        if (!(grandParent instanceof JSFunctionBaseImpl)) {
            return false;
        }
        JSFunctionBaseImpl parent = (JSFunctionBaseImpl)grandParent;
        return parent.isTypeExplicitlyDeclared(this);
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecorator jSParameterTypeDecorator = (JSParameterTypeDecorator)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_KEY, TYPE_PROVIDER, false, (Object)this);
        if (jSParameterTypeDecorator == null) {
            JSParameterImpl.$$$reportNull$$$0(0);
        }
        return jSParameterTypeDecorator;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSParameterImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSParameter((JSParameter)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public Icon getIcon(int flags) {
        return PlatformIcons.PARAMETER_ICON;
    }

    @Override
    public JSAttributeList getAttributeList() {
        return JSUtils.getAttributeList(this);
    }

    @Override
    public ASTNode findNameIdentifier() {
        return JSParameterImpl.findParameterNameIdentifier(this.getNode());
    }

    @Nullable
    public PsiElement getDeclarationElement() {
        return this.getNameIdentifier();
    }

    @Nullable
    public static ASTNode findParameterNameIdentifier(ASTNode node) {
        ASTNode identifier = JSVariableBaseImpl.findVariableNameIdentifier(node);
        if (identifier == null) {
            identifier = node.getFirstChildNode();
        }
        return identifier;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        if (!JSParameterListImpl.handleChildDeletion((JSParameterListElement)this)) {
            super.delete();
        }
    }

    @Override
    public PsiElement getTypeElement() {
        return DialectDetector.isActionScript((PsiElement)this) ? ActionScriptPsiImplUtil.getTypeElementFromDeclaration(this) : JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    @Override
    @Nullable
    protected JSType doGetType() {
        ASTNode type;
        ASTNode astNode;
        ASTNode anchor;
        PsiElement grandParent;
        PsiElement parentWithoutDestructuring = JSDestructuringUtil.getParentSkippingDestructuring(this);
        if (parentWithoutDestructuring != null && (grandParent = parentWithoutDestructuring.getParent()) instanceof JSFunctionBaseImpl) {
            return this.doGetTypeFromFunction((JSFunctionBaseImpl)grandParent);
        }
        JSType t = super.doGetType();
        if (t == null && (anchor = (astNode = this.getNode()).findChildByType(JSTokenTypes.INSTANCEOF_KEYWORD)) != null && (type = astNode.findChildByType(JSTokenTypes.IDENTIFIER_TOKENS_SET, anchor)) != null) {
            t = JSTypeUtils.createType(type.getText(), JSTypeSourceFactory.createTypeSource((PsiElement)this));
        }
        return t;
    }

    @Nullable
    private JSType doGetTypeFromFunction(JSFunctionBaseImpl grandParent) {
        JSType typeFromDeclaration = JSPsiImplUtils.getTypeFromDeclaration(this);
        if (typeFromDeclaration != null) {
            return typeFromDeclaration;
        }
        JSType typeFromComments = grandParent.getTypeFromComments(this);
        if (typeFromComments == null) {
            return null;
        }
        typeFromComments = JSTypeBaseImpl.replaceEmptySourceRecursive(typeFromComments, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
        return typeFromComments;
    }

    @Nullable
    public JSType getTypeIncludingOverridden() {
        JSParameter superParameter;
        JSFunction function;
        JSType type = super.getType();
        if (type == null && (function = this.getDeclaringFunction()) != null && function.isOverride() && (superParameter = JSInheritanceUtil.findMatchedSuperParameter(this, function)) != null) {
            return superParameter.getType();
        }
        return type;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiComment elt;
        JSElement fun = JSParameterImpl.getOwner((JSParameterListElement)this);
        assert (fun != null);
        if (fun instanceof JSFunction && (elt = JSDocumentationUtils.findFunctionComment((JSFunction)fun)) != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope(new PsiElement[]{elt, fun});
            if (localSearchScope == null) {
                JSParameterImpl.$$$reportNull$$$0(2);
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)fun);
        if (localSearchScope == null) {
            JSParameterImpl.$$$reportNull$$$0(3);
        }
        return localSearchScope;
    }

    @Nullable
    public static JSElement getOwner(@NotNull JSParameterListElement parameter) {
        if (parameter == null) {
            JSParameterImpl.$$$reportNull$$$0(4);
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)parameter, (Class[])new Class[]{JSFunction.class, JSCatchBlock.class});
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.isValid() ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            JSParameterImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @Override
    @Nullable
    public String getLiteralOrReferenceInitializerText() {
        JSParameterStub stub = (JSParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralOrReferenceInitializerText();
        }
        String result2 = super.getLiteralOrReferenceInitializerText();
        if (result2 != null) {
            return result2;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)this);
        String name = this.getName();
        if (docComment instanceof JSDocComment && name != null) {
            return ((JSDocComment)docComment).getDefaultValue((JSQualifiedName)JSQualifiedNameImpl.create(name, null));
        }
        return null;
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isExportedWithDefault() {
        return false;
    }

    @Override
    public boolean hasBlockScope() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSParameterImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecorator";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSParameterImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

