/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.manipulators;

import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.manipulators.JSAbstractElementManipulator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSLiteralManipulator
extends JSAbstractElementManipulator<JSLiteralExpression> {
    @Override
    public JSLiteralExpression handleContentChange(@NotNull JSLiteralExpression element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            JSLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSLiteralManipulator.$$$reportNull$$$0(1);
        }
        if (newContent.isEmpty() && element.isRegExpLiteral()) {
            return null;
        }
        return super.handleContentChange(element, range, newContent);
    }

    @Override
    protected JSLiteralExpression createTree(String newText, JSLiteralExpression context) {
        PsiElement newExpr = JSInheritedLanguagesHelper.createExpressionFromText(newText, (PsiElement)context, false);
        return newExpr instanceof JSLiteralExpression ? (JSLiteralExpression)newExpr : context;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JSLiteralExpression element) {
        int lastIndexOfSlash;
        if (element == null) {
            JSLiteralManipulator.$$$reportNull$$$0(2);
        }
        int length = element.getTextLength();
        if (JSInheritedLanguagesHelper.isMultilineLiteral((PsiElement)element)) {
            TextRange textRange = JSInheritedLanguagesHelper.getRangeInElement((PsiElement)element);
            if (textRange == null) {
                JSLiteralManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        if (element.isQuotedLiteral() && length >= 2) {
            TextRange textRange = new TextRange(1, length - 1);
            if (textRange == null) {
                JSLiteralManipulator.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        if (element.isRegExpLiteral() && length >= 2 && (lastIndexOfSlash = element.getText().lastIndexOf(47)) > 1) {
            TextRange textRange = new TextRange(1, lastIndexOfSlash - 1);
            if (textRange == null) {
                JSLiteralManipulator.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        if (textRange == null) {
            JSLiteralManipulator.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @Override
    protected String getNewText(JSLiteralExpression element, TextRange range, String newContent) {
        if (JSInheritedLanguagesHelper.isMultilineLiteral((PsiElement)element)) {
            return JSInheritedLanguagesHelper.getMultilineLiteralContent((PsiElement)element, newContent);
        }
        if (element.isRegExpLiteral()) {
            String oldText = element.getText();
            StringBuilder sb = new StringBuilder(oldText.substring(0, range.getStartOffset()));
            JSLiteralManipulator.escapeRegex(newContent, sb);
            return sb.append(oldText.substring(range.getEndOffset())).toString();
        }
        return super.getNewText(element, range, newContent);
    }

    private static void escapeRegex(String text, StringBuilder out) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '/') {
                if (i > 0 && text.charAt(i - 1) != '\\') {
                    out.append("\\/");
                    continue;
                }
                out.append("/");
                continue;
            }
            out.append(c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

