/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptClassTypeParametersChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessibilityProcessingHandler {
    protected boolean acceptPrivateMembers = true;
    protected boolean acceptProtectedMembers = true;
    private boolean acceptProtectedMembersSet;
    protected boolean processStatics;
    protected boolean allowUnqualifiedStaticsFromInstance;
    @Nullable
    protected Set<JSClass> myClassScopes;
    protected boolean myClassDeclarationStarted;
    @Nullable
    protected final PsiElement place;
    protected boolean myProcessingInheritedClasses;
    private boolean myClassScopeExplicitlySet;
    private static final Collection<JSAccessibilityChecker> CHECKERS = ContainerUtil.newArrayList((Object[])new JSAccessibilityChecker[]{TypeScriptConfigAccessibilityChecker.INSTANCE, TypeScriptModuleAccessibilityChecker.INSTANCE, TypeScriptClassTypeParametersChecker.INSTANCE});

    public AccessibilityProcessingHandler(@Nullable PsiElement _place) {
        this.place = _place != null ? AccessibilityProcessingHandler.getRealElement(_place) : null;
    }

    public boolean accepts(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        String errorFromCheckers;
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(0);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmpty((String)(errorFromCheckers = this.processCheckers(element, resolveProcessor)))) {
            resolveProcessor.addPossibleCandidateResult(element, errorFromCheckers);
            return false;
        }
        if (this.processStatics && this.myClassDeclarationStarted && element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Tag) {
            return false;
        }
        if (element instanceof JSVariable || element instanceof JSFunction || element instanceof JSNamespaceDeclaration || element instanceof JSLocalImplicitElementImpl) {
            return this.acceptsForMembersVisibility((JSPsiElementBase)element, resolveProcessor);
        }
        return true;
    }

    protected boolean acceptsForMembersVisibility(@NotNull JSPsiElementBase element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(2);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(3);
        }
        if (!JSPsiImplUtils.isClassMember((PsiElement)element)) {
            return true;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        PsiElement parentOfElement = JSResolveUtil.findParent((PsiElement)element);
        if (this.needCheckAccessFromPlace(element, parentOfElement)) {
            if (!this.acceptPrivateMembers && accessType == JSAttributeList.AccessType.PRIVATE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.private.member.is.not.accessible.message");
                return false;
            }
            if (!this.acceptProtectedMembers && accessType == JSAttributeList.AccessType.PROTECTED && (this.myClassScopes != null || AccessibilityProcessingHandler.isParentClassContext((PsiElement)element))) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.protected.member.is.not.accessible.message");
                return false;
            }
        }
        if (JSUtils.isPrivateFieldSharpAccessContext(this.place)) {
            if (accessType != JSAttributeList.AccessType.PRIVATE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.public.member.is.not.accessible.via.sharp.message");
                return false;
            }
        } else if (JSUtils.isPrivateSharpItem((PsiElement)element) && resolveProcessor.getResultSink() instanceof ResolveResultSink) {
            resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.private.member.is.not.accessible.without.sharp.message");
            return false;
        }
        if (this.processStatics) {
            if (element.getJSContext() != JSContext.STATIC) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.instance.member.is.not.accessible.message");
                return false;
            }
        } else if (this.myClassDeclarationStarted && !this.allowUnqualifiedStaticsFromInstance && element.getJSContext() == JSContext.STATIC) {
            resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
            return false;
        }
        return true;
    }

    private boolean needCheckAccessFromPlace(@NotNull JSPsiElementBase element, PsiElement parentOfElement) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(4);
        }
        if (this.place != null && parentOfElement instanceof TypeScriptModule) {
            PsiElement parent = JSResolveUtil.findParent(this.place);
            return parent != null && !PsiTreeUtil.isAncestor((PsiElement)parentOfElement, (PsiElement)parent, (boolean)false);
        }
        return JSResolveUtil.getClassOfContext(this.place) != JSUtils.getMemberContainingClass((PsiElement)element);
    }

    @Nullable
    protected String processCheckers(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(5);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(6);
        }
        for (JSAccessibilityChecker checker : CHECKERS) {
            String check;
            if (!checker.isAvailable(this, resolveProcessor) || StringUtil.isEmpty((String)(check = checker.check(this.place, element)))) continue;
            return check;
        }
        return null;
    }

    protected static boolean isParentClassContext(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(7);
        }
        return (parent = JSResolveUtil.findParent(element)) instanceof JSClass || parent instanceof TypeScriptFunction && ((TypeScriptFunction)parent).isConstructor();
    }

    public void setTypeName(String qualifiedName) {
    }

    public void configureClassScope(JSClass jsClass) {
        this.myClassScopeExplicitlySet = true;
        this.configureCurrentClassScope(jsClass);
    }

    @Nullable
    private static JSClass getParentClass(@NotNull PsiElement element) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(8);
        }
        return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
    }

    private void configureCurrentClassScope(@Nullable JSClass jsClass) {
        if (jsClass != null) {
            jsClass = AccessibilityProcessingHandler.getRealElement(jsClass);
            this.myClassScopes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<JSClass>(){

                public int computeHashCode(JSClass object) {
                    String name = object.getQualifiedName();
                    return name != null ? name.hashCode() : object.hashCode();
                }

                public boolean equals(JSClass left, JSClass right) {
                    return left.isEquivalentTo((PsiElement)right);
                }
            });
            this.myClassScopes.add(jsClass);
            JSClass parentClass = AccessibilityProcessingHandler.getParentClass((PsiElement)jsClass);
            while (parentClass != null) {
                this.myClassScopes.add(parentClass);
                parentClass = AccessibilityProcessingHandler.getParentClass((PsiElement)parentClass);
            }
            this.acceptProtectedMembersSet = false;
        } else {
            this.acceptProtectedMembers = false;
            this.acceptProtectedMembersSet = true;
        }
    }

    @NotNull
    private static <T extends PsiElement> T getRealElement(@NotNull T psiElement) {
        PsiElement realElement;
        if (psiElement == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(9);
        }
        Object object = (realElement = CompletionUtilCoreImpl.getOriginalElement(psiElement)) != null ? realElement : psiElement;
        if (object == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(10);
        }
        return (T)object;
    }

    public void startingParent(PsiElement parent) {
        this.myClassDeclarationStarted = parent instanceof JSClass;
        if (parent instanceof JSClass) {
            final JSClass jsClass = AccessibilityProcessingHandler.getRealElement((JSClass)parent);
            if (!this.myProcessingInheritedClasses && !this.myClassScopeExplicitlySet) {
                this.configureCurrentClassScope(JSResolveUtil.getClassOfContext(this.place));
            }
            if (this.acceptPrivateMembers) {
                boolean bl = this.acceptPrivateMembers = this.myClassScopes != null && this.myClassScopes.contains(jsClass);
            }
            if (!this.acceptProtectedMembersSet) {
                this.acceptProtectedMembersSet = true;
                if (this.myClassScopes != null) {
                    this.acceptProtectedMembers = this.myClassScopes.contains(jsClass);
                    if (this.place != null) {
                        for (PsiElement psiElement : this.myClassScopes) {
                            if (this.acceptProtectedMembers || !(psiElement instanceof JSClass)) continue;
                            boolean b = psiElement.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
                                {
                                    super(name);
                                    this.setTypeContext(true);
                                    this.setToProcessMembers(false);
                                    this.setToProcessHierarchy(true);
                                    this.setLocalResolve(true);
                                }

                                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                                    if (element == null) {
                                        2.$$$reportNull$$$0(0);
                                    }
                                    if (state == null) {
                                        2.$$$reportNull$$$0(1);
                                    }
                                    if (!(element instanceof JSClass)) {
                                        return true;
                                    }
                                    return !jsClass.isEquivalentTo(element);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2 = new Object[3];
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "element";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "state";
                                            break;
                                        }
                                    }
                                    objectArray[1] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$2";
                                    objectArray[2] = "execute";
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            }, ResolveState.initial(), psiElement, psiElement);
                            boolean bl = this.acceptProtectedMembers = !b;
                            if (!(this.place instanceof JSReferenceExpression) || ((JSReferenceExpression)this.place).getQualifier() instanceof JSSuperExpression) continue;
                            this.acceptProtectedMembers = this.acceptProtectedMembers && this.processStatics;
                        }
                    }
                }
            }
        } else if (parent instanceof JSAttributeListOwner) {
            if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)parent, JSAttributeList.ModifierType.STATIC)) {
                this.processStatics = true;
            }
        } else if (parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTag) {
            this.processStatics = false;
        }
    }

    public void setProcessStatics(boolean processStatics) {
        this.processStatics = processStatics;
    }

    public void setAllowUnqualifiedStaticsFromInstance(boolean allowUnqualifiedStaticsFromInstance) {
        this.allowUnqualifiedStaticsFromInstance = allowUnqualifiedStaticsFromInstance;
    }

    public boolean isProcessStatics() {
        return this.processStatics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends JSResolveProcessor> boolean processWithStatic(@NotNull T processor, boolean newStatic, @NotNull Producer<Boolean> action) {
        if (processor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(11);
        }
        if (action == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(12);
        }
        if (!(processor instanceof ResolveProcessor)) {
            return (Boolean)action.produce();
        }
        AccessibilityProcessingHandler handler = ((ResolveProcessor)processor).getAccessibilityProcessingHandler();
        boolean oldValue = handler.processStatics;
        handler.setProcessStatics(newStatic);
        try {
            boolean bl = (Boolean)action.produce();
            return bl;
        }
        finally {
            handler.setProcessStatics(oldValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsForMembersVisibility";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "needCheckAccessFromPlace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processCheckers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isParentClassContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRealElement";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processWithStatic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

