/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionHelper;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionResultSink
extends ResultSink {
    private JSType mySmartCompletionExpectedType;
    @NotNull
    private JSCompletionPlaceFilter myPlaceFilter = JSCompletionPlaceFilter.ANY;
    private final TIntArrayList myNestingLevels = new TIntArrayList();
    private int myCurrentNestingLevel = 0;
    private int myThisClassVariantsStart = -1;
    private int myThisClassVariantsEnd = -1;
    protected ProcessingContext mySmartCompletionInheritanceProcessingContext;
    private String myReferencedParameterName;
    private String myQualifiedNameToSkip;
    private final PrefixMatcher myPrefixMatcher;
    private int myGlobalDeclarationsStart = Integer.MAX_VALUE;

    public CompletionResultSink(PsiElement place) {
        super(place);
        Condition<JSClass> filter;
        ResolveProcessor.ProcessingOptions processingOptions;
        if (place != null && (processingOptions = (ResolveProcessor.ProcessingOptions)place.getContainingFile().getOriginalFile().getUserData(ResolveProcessor.PROCESSING_OPTIONS)) != null && (filter = processingOptions.getFilter()) != null) {
            this.acceptOnlyClasses(filter);
        }
        if (place instanceof JSReferenceExpression) {
            PsiElement originalParent;
            JSParameterItem param;
            PsiElement parent;
            JSType expectedType;
            if (this.myPlaceFilter == JSCompletionPlaceFilter.ANY) {
                this.myPlaceFilter = CompletionResultSink.buildSimpleCompletionFilter(place);
            }
            if (this.isActionScript() && JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction() && (expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)place)) != null) {
                this.mySmartCompletionExpectedType = expectedType;
                this.mySmartCompletionInheritanceProcessingContext = JSSmartCompletionVariantsHandler.initProcessingContext(place);
            }
            if ((parent = place.getParent()) instanceof JSArgumentList && (param = JSResolveUtil.findParameterForUsedArgument((JSExpression)((JSReferenceExpression)place), (JSArgumentList)parent)) != null) {
                this.myReferencedParameterName = param.getName();
            }
            if (JSResolveUtil.isSelfReference(parent, place) && (originalParent = PsiUtilBase.getOriginalElement((PsiElement)parent, JSQualifiedNamedElement.class)) instanceof JSQualifiedNamedElement) {
                this.myQualifiedNameToSkip = ((JSQualifiedNamedElement)originalParent).getQualifiedName();
            }
        }
        this.myPrefixMatcher = JSCompletionContributor.getInstance().getPrefixMatcher();
    }

    @Override
    public String getName() {
        return null;
    }

    public void setSmartCompletionInheritanceProcessingContext(ProcessingContext smartCompletionInheritanceProcessingContext) {
        this.mySmartCompletionInheritanceProcessingContext = smartCompletionInheritanceProcessingContext;
    }

    public ProcessingContext getSmartCompletionInheritanceProcessingContext() {
        return this.mySmartCompletionInheritanceProcessingContext;
    }

    @Override
    public boolean accepts(PsiElement element) {
        if (element instanceof JSPsiElementBase && !this.myPlaceFilter.isAcceptable((JSPsiElementBase)element)) {
            return false;
        }
        return super.accepts(element);
    }

    @Override
    public boolean addResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        if (this.mySmartCompletionExpectedType != null && !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, this.mySmartCompletionExpectedType, this.mySmartCompletionInheritanceProcessingContext)) {
            return true;
        }
        this.myNestingLevels.add(this.myCurrentNestingLevel);
        return super.addResult(element, state, resolveProcessor);
    }

    public void acceptOnlyClasses(final @NotNull Condition<JSClass> classFilter) {
        if (classFilter == null) {
            CompletionResultSink.$$$reportNull$$$0(0);
        }
        this.myPlaceFilter = new JSCompletionPlaceFilter(){

            @Override
            boolean isAcceptable(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element instanceof JSPackageWrapper || element instanceof JSClass && classFilter.value((Object)((JSClass)element));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink$1", "isAcceptable"));
            }
        };
    }

    private void flushMyThisClassVariantsEnd() {
        if (this.myThisClassVariantsEnd == -1) {
            List<PsiElement> results = this.getResults();
            if (results == null) {
                this.myThisClassVariantsEnd = 0;
            } else {
                int classVariantsEnd = results.size();
                if (results.get(classVariantsEnd - 1) instanceof JSClass) {
                    --classVariantsEnd;
                }
                this.myThisClassVariantsEnd = classVariantsEnd;
            }
        }
    }

    @NotNull
    private static JSCompletionPlaceFilter buildSimpleCompletionFilter(PsiElement place) {
        if (DialectDetector.isActionScript(place) && place instanceof JSReferenceExpression && !ResolveProcessor.completeConstructorName(place) && !(place.getParent() instanceof JSReferenceListMember)) {
            JSCompletionPlaceFilter jSCompletionPlaceFilter = JSCompletionPlaceFilter.ANY;
            if (jSCompletionPlaceFilter == null) {
                CompletionResultSink.$$$reportNull$$$0(1);
            }
            return jSCompletionPlaceFilter;
        }
        JSCompletionPlaceFilter jSCompletionPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
        if (jSCompletionPlaceFilter == null) {
            CompletionResultSink.$$$reportNull$$$0(2);
        }
        return jSCompletionPlaceFilter;
    }

    public List<LookupElement> getResultsAsObjects() {
        List<PsiElement> processorResults = this.getResults();
        return processorResults == null ? Collections.emptyList() : this.resultsToLookupElements(processorResults);
    }

    @Nullable
    private JSType getPlaceQualifierType() {
        JSExpression qualifier;
        if (this.isActionScript()) {
            return null;
        }
        JSExpression jSExpression = qualifier = this.place instanceof JSReferenceExpression ? ((JSReferenceExpression)this.place).getQualifier() : null;
        if (qualifier != null) {
            JSTypeEvaluationResult evaluationResult = JSTypeEvaluator.getExpressionType(qualifier);
            return evaluationResult == null ? null : evaluationResult.getType();
        }
        return null;
    }

    public List<LookupElement> resultsToLookupElements(List<PsiElement> processorResults) {
        int numberOfVariants = processorResults.size();
        ArrayList<LookupElement> objects = new ArrayList<LookupElement>(numberOfVariants);
        Set<String> variantsFromSmartCompletion = JSCompletionContributor.getInstance().getAlreadyUsedClassesSet();
        THashSet processedCandidateNames = new THashSet(numberOfVariants);
        THashMap typeScriptCompleteMatches = ContainerUtil.newTroveMap();
        if (variantsFromSmartCompletion != null) {
            processedCandidateNames.addAll(variantsFromSmartCompletion);
        }
        JSType qualifierType = this.getPlaceQualifierType();
        for (int i = 0; i < numberOfVariants; ++i) {
            List<LookupElement> elements = this.toLookupElements(i, processorResults, (Set<String>)processedCandidateNames, (Map<String, Pair<Integer, PsiElement>>)typeScriptCompleteMatches, qualifierType);
            objects.addAll(elements);
        }
        return objects;
    }

    @NotNull
    private List<LookupElement> toLookupElements(int elementIndex, @NotNull List<PsiElement> processorResults, @NotNull Set<String> processedCandidateNames, @NotNull Map<String, Pair<Integer, PsiElement>> typeScriptCompleteMatches, @Nullable JSType qualifierType) {
        PsiElement resolve;
        if (processorResults == null) {
            CompletionResultSink.$$$reportNull$$$0(3);
        }
        if (processedCandidateNames == null) {
            CompletionResultSink.$$$reportNull$$$0(4);
        }
        if (typeScriptCompleteMatches == null) {
            CompletionResultSink.$$$reportNull$$$0(5);
        }
        PsiElement namedElement = processorResults.get(elementIndex);
        String name = ResolveProcessor.getName(namedElement);
        if (namedElement instanceof ES6ImportExportSpecifier && (resolve = ((PsiReference)namedElement).resolve()) != null) {
            namedElement = resolve;
        }
        if (namedElement instanceof ES6ExportDefaultAssignment) {
            name = "default";
        }
        if (name == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CompletionResultSink.$$$reportNull$$$0(6);
            }
            return list;
        }
        boolean hasExoticName = false;
        if (!JSNamesValidation.isUnqualifiedType(name)) {
            if (namedElement instanceof ImplicitJSVariableImpl) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    CompletionResultSink.$$$reportNull$$$0(7);
                }
                return list;
            }
            if (namedElement instanceof TypeScriptModule) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    CompletionResultSink.$$$reportNull$$$0(8);
                }
                return list;
            }
            name = JSSymbolUtil.handleSpecialPropertyNames(name, this.getPlaceQuoteChar(namedElement));
            hasExoticName = true;
        }
        String qName = this.getQualifiedNameForResultElement(namedElement, name);
        if (this.myQualifiedNameToSkip != null && this.myQualifiedNameToSkip.equals(qName)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CompletionResultSink.$$$reportNull$$$0(9);
            }
            return list;
        }
        int nestingLevel = this.getNestedLevelForResultElement(namedElement, elementIndex, name);
        boolean typeScript = DialectDetector.isTypeScript(namedElement);
        boolean sameClass = typeScript ? nestingLevel == 0 : this.checkInThisClassVariants(elementIndex) || namedElement instanceof JSProperty;
        JSLookupPriority priority = this.getPriorityForResultElement(namedElement, name, elementIndex, nestingLevel, typeScript);
        if (typeScript && VariantsProcessor.wasCompleteMatch(priority.getPriorityValue())) {
            Pair<Integer, PsiElement> levelToContext;
            boolean hasSameNameObject;
            boolean isClassContext;
            PsiElement currentContext = namedElement.getContext();
            String nameForMerge = qName;
            boolean bl = isClassContext = currentContext instanceof JSClass || currentContext instanceof TypeScriptObjectType;
            if (isClassContext) {
                nameForMerge = name;
            }
            boolean bl2 = hasSameNameObject = (levelToContext = typeScriptCompleteMatches.get(nameForMerge)) != null;
            if (!processedCandidateNames.add(qName) && !hasSameNameObject) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    CompletionResultSink.$$$reportNull$$$0(10);
                }
                return list;
            }
            if (levelToContext == null) {
                typeScriptCompleteMatches.put(nameForMerge, (Pair<Integer, PsiElement>)Pair.create((Object)nestingLevel, (Object)currentContext));
            }
            if (hasSameNameObject) {
                boolean overloadDeclaration;
                PsiElement storedContext = (PsiElement)levelToContext.second;
                Integer storedLevel = (Integer)levelToContext.first;
                boolean bl3 = overloadDeclaration = storedContext == currentContext || isClassContext && storedLevel.equals(nestingLevel);
                if (!overloadDeclaration) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        CompletionResultSink.$$$reportNull$$$0(11);
                    }
                    return list;
                }
            }
            if (!isClassContext && namedElement instanceof TypeScriptFunction && ((TypeScriptFunction)namedElement).isOverloadImplementation()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    CompletionResultSink.$$$reportNull$$$0(12);
                }
                return list;
            }
        } else if (!processedCandidateNames.add(qName)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CompletionResultSink.$$$reportNull$$$0(13);
            }
            return list;
        }
        JSTypeSubstitutor typeSubstitutor = typeScript ? TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(namedElement, this.place, qualifierType, null) : JSTypeSubstitutor.EMPTY;
        List<LookupElement> list = this.createLookupItems(namedElement, name, sameClass, priority, typeSubstitutor, hasExoticName);
        if (list == null) {
            CompletionResultSink.$$$reportNull$$$0(14);
        }
        return list;
    }

    private char getPlaceQuoteChar(@NotNull PsiElement namedElement) {
        if (namedElement == null) {
            CompletionResultSink.$$$reportNull$$$0(15);
        }
        if (this.place != null) {
            return JSCodeStyleSettings.getQuoteChar(this.place);
        }
        PsiFile file2 = namedElement.getContainingFile();
        if (file2 != null) {
            return JSCodeStyleSettings.getQuoteChar((PsiElement)file2);
        }
        return '\"';
    }

    private List<LookupElement> createLookupItems(PsiElement element, String name, boolean sameClass, JSLookupPriority priority, JSTypeSubstitutor typeSubstitutor, boolean hasExoticName) {
        ResolveResult[] importExportSpecifiers = ResolveResultSink.resolveImportExportSpecifiers(element);
        if (importExportSpecifiers != null && importExportSpecifiers.length > 0) {
            ArrayList results = ContainerUtil.newArrayList();
            for (ResolveResult result2 : importExportSpecifiers) {
                if (!result2.isValidResult()) continue;
                PsiElement resultElement = result2.getElement();
                if (resultElement instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                    resultElement = ((TypeScriptProxyImplicitElementWithBackingItem)resultElement).getBackingElement();
                }
                results.addAll(this.createLookupItems(resultElement, name, sameClass, priority, typeSubstitutor, hasExoticName));
            }
            if (results.size() > 0) {
                return results;
            }
        }
        if (element instanceof JSVariable) {
            List<JSFunction> functions = JSUtils.getRelatedFunctions(element, false);
            if (functions.size() <= 1) {
                return ContainerUtil.createMaybeSingletonList((Object)this.createLookupItem(element, name, sameClass, priority, typeSubstitutor, hasExoticName));
            }
            THashSet filteredFunctions = new THashSet();
            for (JSFunction function : functions) {
                function = (JSFunction)CompletionUtil.getOriginalOrSelf((PsiElement)function);
                filteredFunctions.add((Object)function);
            }
            ArrayList results = ContainerUtil.newArrayListWithCapacity((int)filteredFunctions.size());
            for (JSFunction function : filteredFunctions) {
                LookupElement lookupItem = this.createLookupItem((PsiElement)function, name, sameClass, priority, typeSubstitutor, hasExoticName);
                if (lookupItem == null) continue;
                results.add(lookupItem);
            }
            return results;
        }
        return ContainerUtil.createMaybeSingletonList((Object)this.createLookupItem(element, name, sameClass, priority, typeSubstitutor, hasExoticName));
    }

    private boolean checkInThisClassVariants(int i) {
        return i >= this.myThisClassVariantsStart && (i < this.myThisClassVariantsEnd || this.myThisClassVariantsEnd == -1);
    }

    private JSLookupPriority getPriorityForResultElement(PsiElement namedElement, String name, int currentIndex, int nestingLevel, boolean typeScript) {
        boolean matchesReferencedParameterName = this.myReferencedParameterName != null && this.myReferencedParameterName.equals(name);
        JSLookupPriority priority = null;
        if (this.place != null) {
            priority = JSDialectSpecificHandlersFactory.forElement(this.place).getSpecificCompletionVariantPriority(namedElement);
        }
        if (priority == null) {
            if (typeScript) {
                boolean fromTheSameFile;
                boolean bl = fromTheSameFile = currentIndex < this.myGlobalDeclarationsStart;
                priority = this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() == null && !fromTheSameFile && nestingLevel == 0 ? JSLookupPriority.TOP_LEVEL_SYMBOLS_FROM_OTHER_FILES : (fromTheSameFile ? JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel) : JSLookupPriority.getSameTypeValue(false, BaseJSSymbolProcessor.MatchType.COMPLETE, nestingLevel));
            } else {
                priority = JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel);
            }
            if (typeScript && namedElement instanceof JSImplicitElement && nestingLevel == 0 && ((JSImplicitElement)namedElement).hasMinorImportance()) {
                priority = JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false);
            }
        }
        return priority;
    }

    @Nullable
    private String getQualifiedNameForResultElement(PsiElement namedElement, String name) {
        JSClass jsClass;
        if (this.place != null && this.place.getParent() instanceof JSNewExpression && namedElement instanceof JSFunction && ((JSFunction)namedElement).isConstructor() && (jsClass = JSUtils.getMemberContainingClass(namedElement)) != null) {
            return jsClass.getQualifiedName() + "." + ((JSFunction)namedElement).getName();
        }
        return namedElement instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)namedElement).getQualifiedName() : name;
    }

    private int getNestedLevelForResultElement(PsiElement namedElement, int indexInResults, String name) {
        int nestingLevel = this.myNestingLevels.get(indexInResults);
        if ("arguments".equals(name) && namedElement instanceof ImplicitJSVariableImpl) {
            nestingLevel = -1;
        }
        if (namedElement instanceof JSProperty) {
            int max = 0;
            for (int j = 0; j < this.myNestingLevels.size(); ++j) {
                max = Math.max(max, this.myNestingLevels.getQuick(indexInResults));
            }
            nestingLevel = max;
        }
        return nestingLevel;
    }

    @Nullable
    protected LookupElement createLookupItem(PsiElement namedElement, String name, boolean sameClass, @NotNull JSLookupPriority priority, @NotNull JSTypeSubstitutor typeSubstitutor, boolean hasExoticName) {
        if (priority == null) {
            CompletionResultSink.$$$reportNull$$$0(16);
        }
        if (typeSubstitutor == null) {
            CompletionResultSink.$$$reportNull$$$0(17);
        }
        if (!hasExoticName) {
            for (JSCompletionHelper helper : (JSCompletionHelper[])Extensions.getExtensions(JSCompletionHelper.EP_NAME)) {
                LookupElement lookupElement = helper.createLookupElement(namedElement, name, sameClass, priority);
                if (lookupElement == null) continue;
                return lookupElement;
            }
            if (!JSLookupUtilImpl.matchElementWithContext(namedElement, this.place)) {
                return null;
            }
        }
        boolean isIndexAccess = this.place instanceof JSIndexedPropertyAccessExpression;
        if (hasExoticName && isIndexAccess) {
            if (StringUtil.isQuotedString((String)name)) {
                name = JSStringUtil.unquoteAndUnescapeString(name);
            } else {
                return null;
            }
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(namedElement, name, priority, sameClass, this.isActionScript(), typeSubstitutor, hasExoticName && !isIndexAccess);
    }

    @Override
    public void startingParent(PsiElement parent, ResolveProcessor resolveProcessor) {
        if (parent instanceof JSClass) {
            int scopeBound;
            List<PsiElement> results = super.getResults();
            int n = results == null ? 0 : (scopeBound = !results.isEmpty() && results.get(results.size() - 1) == parent ? results.size() - 1 : results.size());
            if (scopeBound > 0 && !DialectDetector.isTypeScript(parent)) {
                ++this.myCurrentNestingLevel;
            }
            if (this.myThisClassVariantsStart == -1) {
                int n2 = this.myThisClassVariantsStart = results != null ? results.size() : 0;
                if (!resolveProcessor.isToProcessMembers()) {
                    this.flushMyThisClassVariantsEnd();
                }
            } else {
                this.flushMyThisClassVariantsEnd();
            }
        } else if (parent instanceof JSFunction) {
            ++this.myCurrentNestingLevel;
        }
    }

    @Override
    public boolean skipTopLevelItems() {
        return this.place instanceof JSReferenceExpression && !JSResolveUtil.isExprInTypeContext((JSReferenceExpression)this.place) && this.myPrefixMatcher != null && this.myPrefixMatcher.getPrefix().length() == 0 && !(this.place.getContainingFile() instanceof PsiCodeFragment);
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        return this.myPrefixMatcher == null || this.myPrefixMatcher.prefixMatches(name);
    }

    @Override
    public int getNestingLevel() {
        return this.myCurrentNestingLevel;
    }

    @Override
    public void setNestingLevel(int nestingLevel) {
        this.myCurrentNestingLevel = nestingLevel;
    }

    @Override
    public void startGlobalDeclarations() {
        List<PsiElement> results = this.getResults();
        this.myGlobalDeclarationsStart = results != null ? results.size() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFilter";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/CompletionResultSink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processorResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedCandidateNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeScriptCompleteMatches";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/CompletionResultSink";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSimpleCompletionFilter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toLookupElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptOnlyClasses";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toLookupElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceQuoteChar";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

