/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSGenericParameterApplierImpl
extends JSGenericParameterImpl {
    private final boolean myWidenLiterals;

    public JSGenericParameterApplierImpl(@NotNull JSGenericParameterImpl type, boolean widenLiterals) {
        if (type == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(0);
        }
        super(type.getTypeText(), type.getSource(), type.getConstraintType());
        JSType constraintType = type.getConstraintType();
        this.myWidenLiterals = widenLiterals && !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType);
    }

    private JSGenericParameterApplierImpl(@NotNull String name, @NotNull JSTypeSource source, @Nullable JSType constraintType, boolean env, boolean widenLiterals) {
        if (name == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(2);
        }
        super(name, source, constraintType, env);
        this.myWidenLiterals = widenLiterals && !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType);
    }

    @Override
    @NotNull
    protected JSGenericParameterImpl createNewParameter(JSType newConstraint) {
        JSGenericParameterApplierImpl jSGenericParameterApplierImpl = new JSGenericParameterApplierImpl(this.getName(), this.getSource(), newConstraint, this.isCallEnvironment(), this.myWidenLiterals);
        if (jSGenericParameterApplierImpl == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(3);
        }
        return jSGenericParameterApplierImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            return true;
        }
        Boolean suspendEvaluation = (Boolean)processingContext.get(JSGenericTypesEvaluator.ourSuspendGenericEvaluation);
        if (suspendEvaluation == Boolean.TRUE) {
            return true;
        }
        MultiMap genericArgumentsMap = (MultiMap)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        if (genericArgumentsMap != null && !super.isEquivalentToImpl(elementType, processingContext, true)) {
            genericArgumentsMap.putValue((Object)this.getTypeText(), (Object)(this.myWidenLiterals ? JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(elementType)) : elementType));
            if (this.isContravariant()) {
                processingContext.put(JSGenericTypesEvaluator.ourHadContravariantGenerics, (Object)true);
            }
        }
        return true;
    }

    private boolean isContravariant() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (!(sourceElement instanceof TypeScriptType)) {
            return true;
        }
        return PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{TypeScriptFunctionType.class}) != null;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        boolean areEqual;
        if (type == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(5);
        }
        if (!allowResolve) {
            return false;
        }
        if (type instanceof JSGenericParameterImpl && (areEqual = super.isEquivalentToImpl(type, processingContext, true))) {
            return true;
        }
        if (processingContext == null) {
            return false;
        }
        Boolean suspendEvaluation = (Boolean)processingContext.get(JSGenericTypesEvaluator.ourSuspendGenericEvaluation);
        if (suspendEvaluation == Boolean.TRUE) {
            return false;
        }
        MultiMap genericArgumentsMap = (MultiMap)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        if (genericArgumentsMap != null) {
            genericArgumentsMap.putValue((Object)this.getTypeText(), (Object)type);
            if (this.isContravariant()) {
                processingContext.put(JSGenericTypesEvaluator.ourHadContravariantGenerics, (Object)true);
            }
        }
        return false;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return ((Object)((Object)this)).hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

