/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTopLevelNamespace;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeInfo {
    private static final JSContextLevel GLOBAL_CONTEXT_LEVEL = new JSContextLevel(new JSTopLevelNamespace(JSTypeSource.EMPTY, false, JSContext.STATIC), 0);
    private static final int MAX_POSSIBLE_RELATIVE_LEVEL = 30;
    @NotNull
    public final List<JSContextLevel> myContextLevels;
    @Nullable
    public Collection<JSRecordType> myRecordTypes;
    private boolean myTypeWasProcessed;
    @NotNull
    private final GlobalStatusHint myContextGlobalStatusHint;
    private boolean myForcedUnknownContext;

    public JSTypeInfo(@NotNull GlobalStatusHint contextGlobalStatusHint) {
        if (contextGlobalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(0);
        }
        this.myContextLevels = new ArrayList<JSContextLevel>();
        this.myContextGlobalStatusHint = contextGlobalStatusHint;
        if (contextGlobalStatusHint == GlobalStatusHint.GLOBAL) {
            this.addGlobalType();
        }
    }

    protected void addType(String[] qualifiedTypeNameComponents) {
        this.addType(qualifiedTypeNameComponents, false, JSContext.UNKNOWN, true);
    }

    protected void addType(String[] qualifiedTypeNameComponents, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (qualifiedTypeNameComponents.length == 0) {
            return;
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromComponents(Arrays.asList(qualifiedTypeNameComponents));
        this.addType(JSNamedTypeFactory.createNamespace(qualifiedName, staticOrInstance, null, isExplicitlyDeclared), isTopClassInHierarchy);
    }

    public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(1);
        }
        this.addType(namespace, isTopClassInHierarchy, null);
    }

    public void addType(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiElement localScope) {
        JSQualifiedName qualifiedName;
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(2);
        }
        if ((qualifiedName = namespace.getQualifiedName()) == null && !namespace.isExplicitlyDeclared()) {
            return;
        }
        if (qualifiedName == null) {
            if (localScope == null) {
                this.addGlobalType();
            }
            return;
        }
        if (qualifiedName.getParent() == null && BaseJSSymbolProcessor.isNamedGlobalType(qualifiedName.getName(), namespace.getJSContext())) {
            this.addGlobalType();
        }
        int relativeLevel = this.getRelativeLevel(isTopClassInHierarchy, qualifiedName);
        this.myContextLevels.add(new JSContextLevel(namespace, relativeLevel, localScope));
    }

    private int getRelativeLevel(boolean isTopClassInHierarchy, @NotNull JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            JSTypeInfo.$$$reportNull$$$0(3);
        }
        if (qualifiedName.getParent() == null && "Object".equals(qualifiedName.getName())) {
            return 30;
        }
        if (qualifiedName.getParent() == null && "Function".equals(qualifiedName.getName())) {
            return 29;
        }
        return isTopClassInHierarchy || this.myContextLevels.isEmpty() ? 0 : this.myContextLevels.get((int)(this.myContextLevels.size() - 1)).myRelativeLevel + 1;
    }

    public void addGlobalType() {
        this.myContextLevels.add(GLOBAL_CONTEXT_LEVEL);
    }

    public void addBaseObjectType() {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.create("Object", null);
        JSNamespace namespace = JSNamedTypeFactory.createNamespace(name, JSContext.INSTANCE, null, false);
        this.myContextLevels.add(new JSContextLevel(namespace, 30));
    }

    public boolean isEmpty() {
        return this.myContextLevels.isEmpty();
    }

    public void setTypeWasProcessed() {
        this.myTypeWasProcessed = true;
    }

    public boolean typeWasProcessed() {
        return !this.myContextLevels.isEmpty() || this.myTypeWasProcessed;
    }

    public boolean hasExplicitNamespace() {
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (contextLevel.myRelativeLevel != 0 || !contextLevel.myNamespace.isExplicitlyDeclared()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchedNamespace(@Nullable JSQualifiedName namespace, @NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSTypeInfo.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            return this.myContextLevels.size() == 0 || this.getGlobalStatusHint() == GlobalStatusHint.GLOBAL;
        }
        for (JSContextLevel contextLevel : this.myContextLevels) {
            if (!ComparatorUtil.equalsNullable((Object)namespace, (Object)contextLevel.myNamespace.getQualifiedName()) || !jsContext.isCompatibleWith(contextLevel.myNamespace.getJSContext())) continue;
            return true;
        }
        return false;
    }

    public void addRecordType(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            JSTypeInfo.$$$reportNull$$$0(5);
        }
        if (this.myRecordTypes == null) {
            this.myRecordTypes = new SmartList();
        }
        this.myRecordTypes.add(recordType);
    }

    public void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, @Nullable PsiElement localScope) {
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(6);
        }
        this.addType(namespace, isTopClassInHierarchy, localScope);
    }

    public final void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            JSTypeInfo.$$$reportNull$$$0(7);
        }
        this.addNamespace(namespace, isTopClassInHierarchy, null);
    }

    public final void addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared, @Nullable PsiFile jsModule) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(8);
        }
        JSQualifiedNameImpl qualifiedName = StringUtil.isQuotedString((String)type) ? JSQualifiedNameImpl.create(type, null) : JSQualifiedNameImpl.fromNamepath(type);
        JSNamespace namespace = JSNamedTypeFactory.createNamespace(qualifiedName, staticOrInstance, null, isExplicitlyDeclared);
        this.addNamespace(namespace, isTopClassInHierarchy, (PsiElement)jsModule);
    }

    public final void addNamespace(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance, boolean isExplicitlyDeclared) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(9);
        }
        this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, isExplicitlyDeclared, null);
    }

    public final void buildIndexListFromQNameAndCorrectQName(@NotNull String type, boolean isTopClassInHierarchy, JSContext staticOrInstance) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(10);
        }
        this.addNamespace(type, isTopClassInHierarchy, staticOrInstance, true);
    }

    public final void buildIndexListFromQNameAndCorrectQName(@NotNull String type) {
        if (type == null) {
            JSTypeInfo.$$$reportNull$$$0(11);
        }
        this.buildIndexListFromQNameAndCorrectQName(type, false, JSContext.UNKNOWN);
    }

    final void addAllParentScopes(@NotNull String qName) {
        if (qName == null) {
            JSTypeInfo.$$$reportNull$$$0(12);
        }
        int lastIndexOfDot = qName.length();
        while (lastIndexOfDot > 0) {
            qName = qName.substring(0, lastIndexOfDot);
            this.buildIndexListFromQNameAndCorrectQName(qName);
            lastIndexOfDot = qName.lastIndexOf(".");
        }
        this.addGlobalType();
    }

    public boolean isGlobalStatusHint() {
        return this.getGlobalStatusHint() == GlobalStatusHint.GLOBAL;
    }

    public boolean isNonGlobalStatusHint() {
        return this.getGlobalStatusHint() == GlobalStatusHint.NONGLOBAL;
    }

    @NotNull
    private GlobalStatusHint getGlobalStatusHint() {
        if (this.myForcedUnknownContext) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(13);
            }
            return globalStatusHint;
        }
        boolean onlyGlobal = true;
        boolean onlyNonGlobal = true;
        boolean hasGlobal = false;
        boolean hasNonGlobal = false;
        boolean topLevelIsGlobal = false;
        for (JSContextLevel level : this.myContextLevels) {
            GlobalStatusHint contextLevelHint = JSTypeInfo.getContextLevelGlobalStatusHint(level);
            onlyGlobal &= contextLevelHint == GlobalStatusHint.GLOBAL || topLevelIsGlobal && level.myRelativeLevel > 0;
            onlyNonGlobal &= contextLevelHint == GlobalStatusHint.NONGLOBAL;
            hasGlobal |= contextLevelHint == GlobalStatusHint.GLOBAL;
            hasNonGlobal |= contextLevelHint == GlobalStatusHint.NONGLOBAL;
            if (level.myRelativeLevel != 0) continue;
            topLevelIsGlobal = contextLevelHint == GlobalStatusHint.GLOBAL;
        }
        if (onlyGlobal && (hasGlobal || this.getContextGlobalStatusHint() == GlobalStatusHint.GLOBAL)) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(14);
            }
            return globalStatusHint;
        }
        if (hasNonGlobal && onlyNonGlobal || this.getContextGlobalStatusHint() == GlobalStatusHint.NONGLOBAL && !hasGlobal) {
            GlobalStatusHint globalStatusHint = GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                JSTypeInfo.$$$reportNull$$$0(15);
            }
            return globalStatusHint;
        }
        GlobalStatusHint globalStatusHint = GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(16);
        }
        return globalStatusHint;
    }

    @NotNull
    public GlobalStatusHint getContextGlobalStatusHint() {
        GlobalStatusHint globalStatusHint = this.myContextGlobalStatusHint;
        if (globalStatusHint == null) {
            JSTypeInfo.$$$reportNull$$$0(17);
        }
        return globalStatusHint;
    }

    private static GlobalStatusHint getContextLevelGlobalStatusHint(@NotNull JSContextLevel level) {
        if (level == null) {
            JSTypeInfo.$$$reportNull$$$0(18);
        }
        if (level == GLOBAL_CONTEXT_LEVEL) {
            return GlobalStatusHint.GLOBAL;
        }
        JSQualifiedName qName = level.myNamespace.getQualifiedName();
        if (qName != null) {
            if (qName.getParent() == null && BaseJSSymbolProcessor.isNamedGlobalType(qName.getName(), level.myNamespace.getJSContext())) {
                return GlobalStatusHint.GLOBAL;
            }
            return GlobalStatusHint.NONGLOBAL;
        }
        return GlobalStatusHint.UNKNOWN;
    }

    public void setForcedUnknownContext() {
        this.myForcedUnknownContext = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextGlobalStatusHint";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeInfo";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalStatusHint";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextGlobalStatusHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchedNamespace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRecordType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildIndexListFromQNameAndCorrectQName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAllParentScopes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContextLevelGlobalStatusHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum GlobalStatusHint {
        GLOBAL,
        NONGLOBAL,
        UNKNOWN;

    }
}

