/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSCoreLibraryElementsCollector;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSVariantRecordTypeConverter;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNamespaceWithGenerics;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsProcessor
extends BaseJSSymbolProcessor
implements JSCompletionProcessor {
    private static final Key<Boolean> ALL_ELEMENTS_ARE_FUNCTIONS = Key.create((String)"js.all.elements.are.functions");
    private static final Key<Boolean> ALL_FUNCTIONS_HAS_NO_PARAMETERS = Key.create((String)"js.all.functions.has.no.parameters");
    private static final Key<Boolean> HAS_BOLD_ELEMENT = Key.create((String)"js.has.bold.element");
    private static final Key<Boolean> CONTEXT_MATCHES = Key.create((String)"js.lookup.element.context.matches");
    private final MultiMap<String, LookupElement> myResults;
    private final Set<JSQualifiedName> myNeighbourReferences;
    private final Set<String> myPopulatedResultsNames;
    private final boolean hasSomeSmartnessAvailable;
    private final boolean myProcessOnlyProperties;
    private final boolean myProcessOnlyTypes;
    private final JSCompletionPlaceFilter myPlaceFilter;
    private final int myLimit;
    @Nullable
    private final String myReferencedParameterName;
    @Nullable
    private final PsiElement myOriginalElement;
    private final boolean myContextIsPropertyOfConstructorParameter;
    private final PrefixMatcher myPrefixMatcher;
    @Nullable
    private final JSCoreLibraryElementsCollector<LookupElement> myCoreLibraryElementsCollector;

    @Deprecated
    public VariantsProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context, boolean forcedOnlyTypeBased, @NotNull CompletionResultSet resultSet) {
        if (targetFile == null) {
            VariantsProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            VariantsProcessor.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(2);
        }
        this(targetFile, context, forcedOnlyTypeBased, null, resultSet);
    }

    public VariantsProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context, boolean forcedOnlyTypeBased, CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        if (targetFile == null) {
            VariantsProcessor.$$$reportNull$$$0(3);
        }
        if (context == null) {
            VariantsProcessor.$$$reportNull$$$0(4);
        }
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(5);
        }
        super(targetFile.getOriginalFile(), context);
        this.myResults = MultiMap.create();
        this.myNeighbourReferences = new THashSet();
        this.myPopulatedResultsNames = new THashSet();
        this.myLimit = Registry.intValue((String)"ide.completion.variant.limit") / 2;
        this.myContextIsPropertyOfConstructorParameter = VariantsProcessor.initContextIsPropertyOfConstructorParameter(context);
        this.myPrefixMatcher = resultSet.getPrefixMatcher();
        this.myCoreLibraryElementsCollector = !this.ecmal4 && !this.typescript ? new JSCoreLibraryElementsCollector() : null;
        boolean processOnlyTypes = false;
        this.myCurrentFile = targetFile.getOriginalFile() == targetFile ? null : targetFile.getOriginalFile().getVirtualFile();
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
        if (forcedOnlyTypeBased || JSRootConfiguration.getInstance(targetFile.getProject()).isOnlyTypeBasedCompletion() && (parameters == null || !parameters.isExtendedCompletion())) {
            this.forceSetAddOnlyCompleteMatches();
        }
        String referencedParameterName = null;
        if (context instanceof JSReferenceExpression) {
            JSExpression qualifier;
            JSParameterItem parameter;
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)refExpr, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            if ((qualifier = refExpr.getQualifier()) != null) {
                JSNamespace namespace;
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
                    if (qualifier instanceof JSThisExpression) {
                        JSNamespace ns = JSContextResolver.resolveContext((PsiElement)qualifier);
                        this.updateTypeInfoFromThis(ns);
                    }
                    if (jsClass != null) {
                        this.forceSetAddOnlyCompleteMatches();
                        this.updateCanUseOnlyCompleteMatches(jsClass);
                    } else if (JSResolveUtil.getTypeFromTagNameInMxml(this.myTargetFile.getContext()) != null) {
                        this.forceSetAddOnlyCompleteMatches();
                    }
                }
                JSExpression originalQualifier = VariantsProcessor.getOriginalQualifier(qualifier);
                CompletionTypeProcessor processor = new CompletionTypeProcessor((PsiElement)originalQualifier);
                JSTypeEvaluator.evaluateTypes(originalQualifier, processor);
                if (processor.isStrictlyTyped()) {
                    this.forceSetAddOnlyCompleteMatches();
                }
                if (!processor.getAllTypesResolved() && (namespace = JSSymbolUtil.evaluateNamespaceLocally(qualifier)) != null) {
                    this.myTypeInfo.addNamespace(namespace, false);
                }
            } else if (JSResolveUtil.isExprInTypeContext(refExpr) || this.ecmal4 && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion((PsiElement)refExpr)) {
                this.forceSetAddOnlyCompleteMatches();
                processOnlyTypes = true;
                this.addPackageScope(jsClass, (PsiElement)refExpr);
            }
        } else if (context instanceof JSProperty) {
            String qName;
            JSRecordType recordType;
            JSObjectLiteralExpression objLiteral = (JSObjectLiteralExpression)context.getParent();
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)objLiteral);
            if (expectedType instanceof JSTypeImpl) {
                expectedType = JSTypeUtils.getValuableType(expectedType);
            }
            if ((recordType = JSVariantRecordTypeConverter.getTypeAsRecord(expectedType, context)) != null) {
                this.myTypeInfo.addRecordType(recordType);
                this.forceSetAddOnlyCompleteMatches();
            } else if (expectedType instanceof JSNamedType && (qName = JSTypeUtils.getQualifiedNameMatchingType(expectedType, true)) != null) {
                this.myTypeInfo.addType((JSNamedType)expectedType, true);
            }
            JSNamespace guessedNs = VariantsProcessor.guessNamespaceFromProperty((JSProperty)context);
            if (guessedNs != null) {
                this.addTypeHierarchy(guessedNs, null);
            }
        } else if (context instanceof JSDocTagValue) {
            processOnlyTypes = true;
        } else if (context instanceof JSDestructuringProperty) {
            PsiElement parent = context.getParent();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(this.myTargetFile, new CompletionTypeProcessor(parent), parent, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        }
        this.myProcessOnlyTypes = processOnlyTypes;
        this.myPlaceFilter = JSCompletionPlaceFilter.forPlace(context);
        boolean bl = this.myProcessOnlyProperties = context instanceof JSProperty && !this.myContextIsPropertyOfConstructorParameter || context instanceof JSDestructuringProperty;
        if (this.myTypeInfo.typeWasProcessed() && !this.myContextIsPropertyOfConstructorParameter && !this.myProcessOnlyProperties && !this.myTypeInfo.isGlobalStatusHint()) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.hasSomeSmartnessAvailable = this.myTypeInfo.hasExplicitNamespace();
        this.myOriginalElement = CompletionUtil.getOriginalElement((PsiElement)context);
        this.myReferencedParameterName = referencedParameterName;
        this.initCheckFileLevelAccess();
    }

    private static boolean initContextIsPropertyOfConstructorParameter(PsiElement context) {
        if (!(context instanceof JSProperty)) {
            return false;
        }
        PsiElement argList = context.getParent().getParent();
        if (!(argList instanceof JSArgumentList)) {
            return false;
        }
        PsiElement callExpr = argList.getParent();
        if (!(callExpr instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpr).getMethodExpression();
        return methodExpression instanceof JSReferenceExpression;
    }

    @Override
    @NotNull
    protected JSTypeInfo createTypeInfo(@NotNull JSTypeInfo.GlobalStatusHint globalStatusHint) {
        if (globalStatusHint == null) {
            VariantsProcessor.$$$reportNull$$$0(6);
        }
        JSTypeInfo jSTypeInfo = new JSTypeInfo(globalStatusHint){

            @Override
            public void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, PsiElement localScope) {
                if (namespace == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VariantsProcessor.this.myContextIsPropertyOfConstructorParameter) {
                    JSParameterItem matchedParameter;
                    PsiElement grandParent;
                    JSQualifiedName qualifiedName = namespace.getQualifiedName();
                    qualifiedName = JSQualifiedNameImpl.create("options", qualifiedName);
                    namespace = JSNamedTypeFactory.createNamespace(qualifiedName, namespace.getJSContext(), VariantsProcessor.this.myContext, namespace.isSourceStrict());
                    PsiElement parent = VariantsProcessor.this.myContext.getParent();
                    if (parent instanceof JSExpression && (grandParent = parent.getParent()) instanceof JSArgumentList && (matchedParameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)parent, (JSArgumentList)grandParent)) != null && matchedParameter.getName() != null) {
                        qualifiedName = JSQualifiedNameImpl.create(matchedParameter.getName(), qualifiedName);
                        JSNamespace paramNs = JSNamedTypeFactory.createNamespace(qualifiedName, namespace.getJSContext(), matchedParameter instanceof PsiElement ? (PsiElement)matchedParameter : null, namespace.isSourceStrict());
                        super.addNamespace(paramNs, isTopClassInHierarchy, localScope);
                    }
                }
                super.addNamespace(namespace, isTopClassInHierarchy, localScope);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$1", "addNamespace"));
            }
        };
        if (jSTypeInfo == null) {
            VariantsProcessor.$$$reportNull$$$0(7);
        }
        return jSTypeInfo;
    }

    private void updateCanUseOnlyCompleteMatches(JSClass jsClass) {
        JSAttributeList attributeList;
        JSAttributeList jSAttributeList = attributeList = jsClass != null ? jsClass.getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
            this.setAddOnlyCompleteMatches(false, true);
        }
    }

    public void addPushedVariants(@NotNull Set<String> pushedVariants) {
        if (pushedVariants == null) {
            VariantsProcessor.$$$reportNull$$$0(8);
        }
        this.myPopulatedResultsNames.addAll(pushedVariants);
    }

    public void populateCompletionList(Collection<? extends LookupElement> resultsAsObjects, boolean keepOverloads, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(9);
        }
        if (resultsAsObjects == null) {
            return;
        }
        for (LookupElement lookupElement : resultsAsObjects) {
            if (!this.myPopulatedResultsNames.add(lookupElement.getLookupString()) && !keepOverloads) continue;
            resultSet.addElement(lookupElement);
        }
    }

    public void collectReferencesUsedInCurrentScope(final PsiElement reference, final boolean qualified) {
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)reference, JSExecutionScope.class);
        assert (scope != null) : reference.getContainingFile().getName();
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSQualifiedName name;
                if (node != reference && node.getQualifier() != null == qualified && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)node)) != null) {
                    VariantsProcessor.this.myNeighbourReferences.add(name);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visitElement((PsiElement)scope);
    }

    @Override
    protected boolean isStrictTypingPossible(PsiElement source, @NotNull JSType type) {
        if (type == null) {
            VariantsProcessor.$$$reportNull$$$0(10);
        }
        if (type.getSource().isStrict()) {
            source = JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT;
        }
        return super.isStrictTypingPossible(source, type);
    }

    @Override
    @NotNull
    protected List<JSNamespace> addGenericArgumentsForParentClasses(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        JSTypeSubstitutor genericArguments;
        if (namespace == null) {
            VariantsProcessor.$$$reportNull$$$0(11);
        }
        if (parentClasses == null) {
            VariantsProcessor.$$$reportNull$$$0(12);
        }
        if ((genericArguments = JSNamespaceWithGenerics.getGenericArguments(namespace)) == null || genericArguments.isEmpty()) {
            List<JSNamespace> list = parentClasses;
            if (list == null) {
                VariantsProcessor.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<JSNamespace> list = parentClasses.stream().map(parentClass -> {
            if (namespace == null) {
                VariantsProcessor.$$$reportNull$$$0(44);
            }
            JSQualifiedName parentClassQName = parentClass.getQualifiedName();
            assert (parentClassQName != null);
            JSQualifiedName namespaceQName = namespace.getQualifiedName();
            assert (namespaceQName != null);
            JSTypeSubstitutor parentClassTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(namespaceQName.getQualifiedName(), parentClassQName.getQualifiedName(), this.myContext, genericArguments);
            return new JSNamespaceWithGenerics((JSNamespace)parentClass, parentClassTypeSubstitutor);
        }).collect(Collectors.toList());
        if (list == null) {
            VariantsProcessor.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void addNeighbourReferences(boolean onlyApplyPriority) {
        for (JSQualifiedName neighbourReference : this.myNeighbourReferences) {
            if (!this.myTypeInfo.hasMatchedNamespace(neighbourReference.getParent(), JSContext.STATIC)) continue;
            String name = neighbourReference.getName();
            Collection elements = this.myResults.get((Object)name);
            if (!elements.isEmpty()) {
                ArrayList newElements = ContainerUtil.newArrayListWithCapacity((int)elements.size());
                boolean hadNeighbours = false;
                for (LookupElement element : elements) {
                    int neighborPriority = JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY.getPriorityValue();
                    double itemPriority = JSCompletionUtil.getLookupElementPriority(element);
                    int neighborProximity = JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY.getProximityValue();
                    Integer itemProximity = (Integer)element.getUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY);
                    if ((double)neighborPriority > itemPriority || (double)neighborPriority == itemPriority && itemProximity != null && neighborProximity > itemProximity) {
                        newElements.add(JSCompletionUtil.withJSLookupPriority(element, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY));
                        hadNeighbours = true;
                        continue;
                    }
                    newElements.add(element);
                }
                if (!hadNeighbours) continue;
                this.myResults.put((Object)name, (Collection)newElements);
                continue;
            }
            if (onlyApplyPriority) continue;
            LookupElementBuilder element = LookupElementBuilder.create((String)name);
            element = JSCompletionUtil.withJSLookupPriority((LookupElement)element, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY);
            this.myResults.putValue((Object)name, (Object)element);
        }
    }

    private void buildSeveralDefinitionsElements() {
        for (Map.Entry entry : this.myResults.entrySet()) {
            Boolean function;
            Collection value = (Collection)entry.getValue();
            LookupElement element = value.isEmpty() ? null : (LookupElement)value.iterator().next();
            if (!(element instanceof LookupElementBuilder)) continue;
            Integer priority = (Integer)element.getUserData(JSCompletionUtil.PRIORITY);
            Integer proximity = (Integer)element.getUserData(JSCompletionUtil.PROXIMITY);
            if (priority == null || proximity == null) continue;
            LookupElementBuilder lookupItem = (LookupElementBuilder)element;
            Boolean bold = (Boolean)element.getUserData(HAS_BOLD_ELEMENT);
            if (bold != null && bold.booleanValue()) {
                lookupItem = lookupItem.withBoldness(true);
            }
            if (Boolean.TRUE.equals(function = (Boolean)element.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS))) {
                lookupItem = lookupItem.withInsertHandler(JSInsertHandler.DEFAULT).withTailText("()");
                JSInsertHandler.ForcedCompleteFunctionType completeFunctionType = Boolean.TRUE.equals(element.getUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS)) ? JSInsertHandler.ForcedCompleteFunctionType.EMPTY_PARAMETERS : JSInsertHandler.ForcedCompleteFunctionType.WITH_PARAMETERS;
                lookupItem.putUserData(JSInsertHandler.FORCED_COMPLETE_FUNCTION, (Object)completeFunctionType);
            }
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupItem, (double)priority.intValue());
            lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)lookupElement, (int)proximity);
            entry.setValue(Collections.singleton(lookupElement));
        }
    }

    private boolean useOrUpdateStoredCoreLibraryElement(@NotNull String name, @NotNull LookupElement newLookupElement, @NotNull Collection<LookupElement> elements) {
        PsiElement psiElement;
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(15);
        }
        if (newLookupElement == null) {
            VariantsProcessor.$$$reportNull$$$0(16);
        }
        if (elements == null) {
            VariantsProcessor.$$$reportNull$$$0(17);
        }
        if ((psiElement = newLookupElement.getPsiElement()) != null && this.myCoreLibraryElementsCollector != null && this.myCoreLibraryElementsCollector.isLibraryElement(psiElement)) {
            LookupElement storedLookup = this.myCoreLibraryElementsCollector.getValue(psiElement);
            if (this.myCoreLibraryElementsCollector.addElement(psiElement, newLookupElement)) {
                if (storedLookup == null || elements.isEmpty()) {
                    return false;
                }
                this.myResults.put((Object)name, (Collection)ContainerUtil.newArrayList((Iterable)ContainerUtil.map(elements, e -> {
                    if (newLookupElement == null) {
                        VariantsProcessor.$$$reportNull$$$0(43);
                    }
                    return e == storedLookup ? newLookupElement : e;
                })));
            }
            return true;
        }
        return false;
    }

    private boolean addResult(@NotNull String name, @NotNull LookupElement newElement) {
        LookupElement firstStoredElement;
        Collection elements;
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(18);
        }
        if (newElement == null) {
            VariantsProcessor.$$$reportNull$$$0(19);
        }
        if (this.useOrUpdateStoredCoreLibraryElement(name, newElement, elements = this.myResults.get((Object)name))) {
            return true;
        }
        LookupElement lookupElement = firstStoredElement = elements.isEmpty() ? null : (LookupElement)elements.iterator().next();
        if (firstStoredElement == null) {
            this.myResults.putValue((Object)name, (Object)newElement);
            return this.checkLimit();
        }
        boolean keepCompleteMatchedOverloads = this.typescript;
        double itemPriority = JSCompletionUtil.getLookupElementPriority(newElement);
        int itemProximity = JSCompletionUtil.getLookupElementProximity(newElement);
        if (keepCompleteMatchedOverloads && VariantsProcessor.wasCompleteMatch(itemPriority)) {
            this.myResults.putValue((Object)name, (Object)newElement);
            return this.checkLimit();
        }
        PsiElement lookupItemElement = newElement.getPsiElement();
        PsiElement storedLookupItemElement = firstStoredElement.getPsiElement();
        double storedItemPriority = JSCompletionUtil.getLookupElementPriority(firstStoredElement);
        int storedItemProximity = JSCompletionUtil.getLookupElementProximity(firstStoredElement);
        if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
            boolean currentIsProperty = VariantsProcessor.isPropertyWithFunctionInitializer(lookupItemElement);
            boolean storedIsProperty = VariantsProcessor.isPropertyWithFunctionInitializer(storedLookupItemElement);
            if (currentIsProperty && !storedIsProperty) {
                storedItemPriority -= 1.0;
            } else if (!currentIsProperty && storedIsProperty) {
                itemPriority -= 1.0;
            }
            boolean currentContextMatches = Boolean.TRUE.equals(newElement.getUserData(CONTEXT_MATCHES));
            boolean storedContextMatches = Boolean.TRUE.equals(firstStoredElement.getUserData(CONTEXT_MATCHES));
            if (currentContextMatches && !storedContextMatches) {
                storedItemPriority -= 1.0;
            } else if (!currentContextMatches && storedContextMatches) {
                itemPriority -= 1.0;
            }
        }
        if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
            EnumSet<JSTaggedResolveResult.ResolveResultTag> itemTags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
            this.addResolveResultTags(itemTags, lookupItemElement);
            EnumSet<JSTaggedResolveResult.ResolveResultTag> storedItemTags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
            this.addResolveResultTags(storedItemTags, storedLookupItemElement);
            itemPriority -= (double)JSTaggedResolveResult.comparePriorities(itemTags, storedItemTags);
        }
        if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
            if (newElement.equals(firstStoredElement)) {
                return true;
            }
            boolean itemIsBold = JSLookupUtilImpl.isBold(newElement);
            LookupElementBuilder mergedElement = LookupElementBuilder.create((String)name).withTypeText(JSBundle.message((String)"javascript.completion.several.definitions", (Object[])new Object[0]), true);
            mergedElement.putUserData(JSCompletionUtil.PRIORITY, (Object)((int)itemPriority));
            mergedElement.putUserData(JSCompletionUtil.PROXIMITY, (Object)itemProximity);
            mergedElement.putUserData(HAS_BOLD_ELEMENT, (Object)(itemIsBold || JSLookupUtilImpl.isBold(firstStoredElement) ? 1 : 0));
            JSFunction firstPossibleFunction = JSPsiImplUtils.getPossibleFunction(lookupItemElement);
            JSFunction secondPossibleFunction = JSPsiImplUtils.getPossibleFunction(storedLookupItemElement);
            boolean bothAreFunctions = firstPossibleFunction != null && (secondPossibleFunction != null || firstStoredElement.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS) == Boolean.TRUE);
            mergedElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)bothAreFunctions);
            if (bothAreFunctions) {
                mergedElement.putUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS, (Object)(firstPossibleFunction.getParameters().length == 0 && (secondPossibleFunction != null && secondPossibleFunction.getParameters().length == 0 || firstStoredElement.getUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS) == Boolean.TRUE) ? 1 : 0));
            }
            this.myResults.remove((Object)name);
            this.myResults.putValue((Object)name, (Object)mergedElement);
            if (storedLookupItemElement == null) {
                if (firstStoredElement.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS) == Boolean.TRUE) {
                    JSFunction possibleFunction = JSPsiImplUtils.getPossibleFunction(lookupItemElement);
                    if (possibleFunction == null) {
                        firstStoredElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)Boolean.FALSE);
                    } else if (possibleFunction.getParameters().length > 0) {
                        firstStoredElement.putUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS, (Object)Boolean.FALSE);
                    }
                }
                if (firstStoredElement.getUserData(HAS_BOLD_ELEMENT) != Boolean.TRUE && itemIsBold) {
                    firstStoredElement.putUserData(HAS_BOLD_ELEMENT, (Object)Boolean.TRUE);
                }
            }
        } else if (itemPriority > storedItemPriority || itemPriority == storedItemPriority && itemProximity > storedItemProximity) {
            this.myResults.remove((Object)name);
            this.myResults.putValue((Object)name, (Object)newElement);
        }
        return this.checkLimit();
    }

    @NotNull
    public Collection<LookupElement> getCurrentResults() {
        this.postProcessElements(true);
        Collection collection = this.myResults.values();
        if (collection == null) {
            VariantsProcessor.$$$reportNull$$$0(20);
        }
        return collection;
    }

    public void postProcessElements(boolean onlyApplyPriority) {
        this.addNeighbourReferences(onlyApplyPriority);
        this.buildSeveralDefinitionsElements();
    }

    @NotNull
    public Collection<LookupElement> getFinalResults() {
        List<LookupElement> recordTypesElements = this.createElementsFromRecordTypes();
        for (LookupElement recordTypesElement : recordTypesElements) {
            this.addResult(recordTypesElement.getLookupString(), recordTypesElement);
        }
        this.postProcessElements(false);
        Collection collection = this.myResults.values();
        if (collection == null) {
            VariantsProcessor.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    private List<LookupElement> createElementsFromRecordTypes() {
        if (this.myTypeInfo.myRecordTypes == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                VariantsProcessor.$$$reportNull$$$0(22);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        for (JSRecordType recordType : this.myTypeInfo.myRecordTypes) {
            Collection elements;
            JSElementIndexingData indexingData;
            PsiElement element = recordType.getSource().getSourceElement();
            THashMap implicitElements = new THashMap();
            if (element instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)element).getIndexingData()) != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement implicitElement : elements) {
                    JSQualifiedName parentNamespace;
                    JSQualifiedName namespace = implicitElement.getNamespace();
                    if (namespace == null || (parentNamespace = namespace.getParent()) == null || !"options".equals(parentNamespace.getName())) continue;
                    implicitElements.put(implicitElement.getName(), implicitElement);
                }
            }
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                Icon icon;
                if (!(member instanceof JSRecordType.PropertySignature)) continue;
                JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                String name = JSSymbolUtil.handleSpecialPropertyNames(propertySignature.getMemberName(), JSCodeStyleSettings.getQuoteChar((PsiElement)this.myTargetFile));
                JSType type = propertySignature.getType();
                String typeString = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
                JSRecordType.MemberSource source = propertySignature.getMemberSource();
                PsiElement sourceElement = source.getSingleElement();
                if (sourceElement == null) {
                    implicitElements.get(name);
                }
                if (sourceElement == null) {
                    sourceElement = element;
                }
                LookupElementBuilder builder = LookupElementBuilder.create((Object)(sourceElement != null ? sourceElement : name), (String)name).withBoldness(true).withTypeText(typeString);
                Icon icon2 = icon = sourceElement == null ? null : sourceElement.getIcon(3);
                if (icon != null && !(icon instanceof EmptyIcon)) {
                    builder = builder.withIcon(icon);
                }
                result2.add(JSCompletionUtil.withJSLookupPriority((LookupElement)builder, JSLookupPriority.MAX_PRIORITY));
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            VariantsProcessor.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    @Override
    public String getRequiredName() {
        return null;
    }

    @Override
    public boolean doAdd(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(24);
        }
        return this.doAdd(element, null);
    }

    public boolean doAdd(@NotNull JSPsiElementBase element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSDocComment comment;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(25);
        }
        ProgressManager.checkCanceled();
        String name = element.getName();
        if (name == null || !JSNamesValidation.isUnqualifiedType(name) || !this.myPrefixMatcher.prefixMatches(name)) {
            return true;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (this.isOriginalElement(element)) {
            return true;
        }
        if (this.myPopulatedResultsNames.contains(name)) {
            return true;
        }
        if (this.isAcceptable(element) != null) {
            return true;
        }
        boolean seemsToBePrivateSymbol = JSVisibilityUtil.seemsToBePrivateSymbol(name);
        boolean isClassMember = element.getContext() instanceof JSClass;
        if (isClassMember && JSResolveUtil.isConstructorFunction((PsiElement)element)) {
            return true;
        }
        if (element instanceof JSProperty && (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element)) != null && comment.hasConstructsTag()) {
            return true;
        }
        if (seemsToBePrivateSymbol && accessType == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            accessType = JSAttributeList.AccessType.PRIVATE;
        }
        if (isClassMember && accessType == JSAttributeList.AccessType.PRIVATE) {
            return true;
        }
        boolean fromTheSameFile = this.myCurrentFile != null && this.myCurrentFile.equals(this.myTargetVirtualFile);
        boolean elementIsVisible = JSVisibilityUtil.isAccessible(element, accessType, this.getContextScopeNames(), this.myContext, fromTheSameFile);
        if (element instanceof JSClass && !elementIsVisible) {
            return true;
        }
        if (this.myProcessOnlyProperties && !this.isPropertyCandidate(element)) {
            return true;
        }
        Ref typeHierarchyLevel = new Ref((Object)-1);
        BaseJSSymbolProcessor.MatchType matchType = this.calcMatchType(element, accessType, elementIsVisible, (Ref<Integer>)typeHierarchyLevel);
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL || !elementIsVisible && VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            return this.addPartialMatch((PsiElement)element, name);
        }
        if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            return this.addCompleteMatch((PsiElement)element, name, matchType, (Integer)typeHierarchyLevel.get(), typeSubstitutor);
        }
        return true;
    }

    protected boolean isOriginalElement(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(26);
        }
        return element.isEquivalentTo(this.myOriginalElement);
    }

    public boolean isPropertyCandidate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(27);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Property) {
            return true;
        }
        if (element instanceof JSDefinitionExpression) {
            return true;
        }
        return element instanceof JSProperty || element instanceof TypeScriptTypeMember && JSUtils.getMemberContainingClass((PsiElement)element) instanceof TypeScriptInterface;
    }

    @NotNull
    private BaseJSSymbolProcessor.MatchType calcMatchType(@NotNull JSPsiElementBase element, @NotNull JSAttributeList.AccessType accessType, boolean elementIsVisible, @NotNull Ref<Integer> typeHierarchyLevel) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(28);
        }
        if (accessType == null) {
            VariantsProcessor.$$$reportNull$$$0(29);
        }
        if (typeHierarchyLevel == null) {
            VariantsProcessor.$$$reportNull$$$0(30);
        }
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, typeHierarchyLevel);
        if (!this.myPlaceFilter.isAcceptable(element)) {
            BaseJSSymbolProcessor.MatchType matchType2 = BaseJSSymbolProcessor.MatchType.NOMATCH;
            if (matchType2 == null) {
                VariantsProcessor.$$$reportNull$$$0(31);
            }
            return matchType2;
        }
        if (accessType == JSAttributeList.AccessType.PRIVATE && this.myProcessOnlyTypes) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType) && this.myPlaceFilter.isPartialResult(element)) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE && (Integer)typeHierarchyLevel.get() > 0 && !elementIsVisible) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        BaseJSSymbolProcessor.MatchType matchType3 = matchType;
        if (matchType3 == null) {
            VariantsProcessor.$$$reportNull$$$0(32);
        }
        return matchType3;
    }

    @Nullable
    private LookupElement createLookupElement(@Nullable PsiElement element, @NotNull String name, @NotNull JSLookupPriority priority, boolean isBold, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(33);
        }
        if (priority == null) {
            VariantsProcessor.$$$reportNull$$$0(34);
        }
        if (!JSLookupUtilImpl.willCreateLookupElement(priority)) {
            return null;
        }
        if (!JSLookupUtilImpl.matchElementWithContext(element, this.myContext)) {
            return null;
        }
        LookupElement lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(element, name, priority, isBold, this.ecmal4, typeSubstitutor);
        return lookupItem;
    }

    @Nullable
    private static JSNamespace guessNamespaceFromProperty(@NotNull JSProperty element) {
        JSExpression methodExpr;
        PsiElement grandGrandParent;
        PsiElement grandParent;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(35);
        }
        if ((grandParent = element.getParent().getParent()) instanceof JSArgumentList && (grandGrandParent = grandParent.getParent()) instanceof JSCallExpression && (methodExpr = ((JSCallExpression)grandGrandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            ArrayList<String> names = new ArrayList<String>(3);
            JSExpression qualifyingExpression = JSSymbolUtil.getFirstLiteralOrExprArg((JSArgumentList)grandParent);
            String method = qualifyingExpression != null ? StringUtil.unquoteString((String)qualifyingExpression.getText()) : methodExpr.getText();
            BaseJSSymbolProcessor.addIndexListFromQName(method, names);
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromComponents(names), JSContext.UNKNOWN, (PsiElement)element, true);
        }
        return null;
    }

    private boolean addCompleteMatch(@NotNull PsiElement element, @Nullable String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel, @Nullable JSTypeSubstitutor typeSubstitutor) {
        boolean isBold;
        JSLookupPriority priority;
        LookupElement lookupItem;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(36);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(37);
        }
        if (name == null) {
            return true;
        }
        if (element instanceof JSPsiElementBase && this.myPlaceFilter.isLoweredPriority((JSPsiElementBase)element)) {
            ++nestingLevel;
        }
        if ((lookupItem = this.createLookupElement(element, name, priority = this.getPriority(name, matchType, nestingLevel), isBold = VariantsProcessor.isCompleteOrWithContextMatchType(matchType) && nestingLevel == 0, typeSubstitutor)) != null && matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT) {
            lookupItem.putUserData(CONTEXT_MATCHES, (Object)Boolean.TRUE);
        }
        if (lookupItem != null) {
            return this.addResult(name, lookupItem);
        }
        return true;
    }

    private JSLookupPriority getPriority(@NotNull String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(38);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(39);
        }
        if (this.myTypeInfo.isGlobalStatusHint()) {
            nestingLevel += 5;
        }
        return this.myTypeInfo.isGlobalStatusHint() && !this.myProcessOnlyTypes ? JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false) : JSLookupPriority.getSameTypeValue(name.equals(this.myReferencedParameterName), matchType, nestingLevel);
    }

    private boolean addPartialMatch(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(40);
        }
        if (name == null || this.myAddOnlyCompleteMatches) {
            return true;
        }
        boolean fromRelevantFileOrDirectory = this.isFromRelevantFileOrDirectory();
        JSLookupPriority priority = JSLookupPriority.getLookupPriority(null, fromRelevantFileOrDirectory, this.hasSomeSmartnessAvailable);
        LookupElement lookupElement = this.createLookupElement(element, name, priority, false, null);
        if (lookupElement != null) {
            return this.addResult(name, lookupElement);
        }
        return true;
    }

    private static boolean isPropertyWithFunctionInitializer(PsiElement lookupItemElement) {
        return lookupItemElement instanceof JSProperty && ((JSProperty)lookupItemElement).tryGetFunctionInitializer() != null;
    }

    static boolean wasCompleteMatch(double priority) {
        return priority > (double)JSLookupPriority.MAX_PRIORITY.getPriorityValue();
    }

    private boolean checkLimit() {
        return this.myResults.size() <= this.myLimit;
    }

    @Override
    @NotNull
    public PsiFile getTargetFile() {
        PsiFile psiFile = this.myTargetFile;
        if (psiFile == null) {
            VariantsProcessor.$$$reportNull$$$0(41);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myPrefixMatcher;
        if (prefixMatcher == null) {
            VariantsProcessor.$$$reportNull$$$0(42);
        }
        return prefixMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalStatusHint";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedVariants";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 15: 
            case 18: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLookupElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentResults";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalResults";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementsFromRecordTypes";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMatchType";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTypeInfo";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPushedVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateCompletionList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "useOrUpdateStoredCoreLibraryElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doAdd";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isOriginalElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyCandidate";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "calcMatchType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "guessNamespaceFromProperty";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addCompleteMatch";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addPartialMatch";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$useOrUpdateStoredCoreLibraryElement$1";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addGenericArgumentsForParentClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CompletionTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private boolean hasUnknownElement;
        private ThreeState strictlyTyped = ThreeState.UNSURE;
        @Nullable
        private final PsiElement myOriginalQualifier;

        public CompletionTypeProcessor(PsiElement qualifier) {
            this.myOriginalQualifier = qualifier;
        }

        private boolean isStrictlyTyped() {
            return this.strictlyTyped != ThreeState.UNSURE && this.strictlyTyped.toBoolean();
        }

        @Override
        public void processNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext context, PsiElement source) {
            if (namespace == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(1);
            }
            if (context.ensureProcessed((JSType)namespace, context)) {
                return;
            }
            if (!JSTypeUtils.processExpandedType(this, (JSType)namespace, context, source)) {
                return;
            }
            if (namespace.getQualifiedName() == null) {
                return;
            }
            boolean isExportNamespace = CommonJSUtil.isExportNamespace(namespace);
            PsiElement localScope = context.getLocalScope();
            if (localScope == null && isExportNamespace) {
                localScope = VariantsProcessor.this.myTargetFile;
            }
            if (localScope == null && namespace.isLocal() && source != null) {
                localScope = JSPsiImplUtils.getExecutionScope(source, false);
            }
            JSNamespace ns = JSNamedTypeFactory.createNamespace(namespace.getQualifiedName(), namespace.getJSContext(), namespace.getSource().getSourceElement(), true, true, namespace.isLocal());
            VariantsProcessor.this.addTypeHierarchy(ns, localScope);
            if (this.strictlyTyped != ThreeState.NO) {
                this.strictlyTyped = ThreeState.fromBoolean((namespace.isExplicitlyDeclared() || isExportNamespace ? 1 : 0) != 0);
            }
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(2);
            }
            if (evaluateContext == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(3);
            }
            JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)candidate -> {
                if (evaluateContext == null) {
                    CompletionTypeProcessor.$$$reportNull$$$0(5);
                }
                this.processCandidate((JSType)candidate, evaluateContext, source);
                return true;
            }), type, false, true, false);
            this.processCandidate(type, evaluateContext, source);
            this.addFullQualifierAsNamespace(this.myOriginalQualifier, type, this.isStrictlyTyped());
        }

        @Override
        protected void applyTypeToState(JSType type, PsiElement source) {
            super.applyTypeToState(type, source);
            if (type instanceof JSRecordType) {
                if (type.getSource().isStrict()) {
                    VariantsProcessor.this.setAddOnlyCompleteMatches(true);
                }
                return;
            }
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, true);
            if (namespace == null || namespace.getQualifiedName() == null) {
                return;
            }
            if (this.strictlyTyped != ThreeState.NO) {
                this.strictlyTyped = ThreeState.fromBoolean((boolean)VariantsProcessor.this.isStrictTypingPossible(source, type));
            }
        }

        @Override
        protected boolean isMakeAddedNamespaceStrict() {
            return true;
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(4);
            }
            super.setUnknownElement(element);
            this.hasUnknownElement = true;
        }

        private boolean getAllTypesResolved() {
            return !this.hasUnknownElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUnknownElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$process$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

